/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.mapper.BpmInfoMapper;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.utils.BillState;
import com.ejianc.zatopbpm.utils.UpdateBillStateUtils;
import com.ejianc.zatopbpm.vo.BpmInfoVO;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bpmInfoService")
public class BpmInfoServiceImpl
extends BaseServiceImpl<BpmInfoMapper, BpmInfoEntity>
implements IBpmInfoService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UpdateBillStateUtils updateBillStateUtils;

    @Override
    public BpmInfoEntity selectByBpmId(String bpmId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"bpm_id", (Object)bpmId);
        List list = this.list((Wrapper)wrapper);
        if (list != null && list.size() > 0) {
            return (BpmInfoEntity)((Object)list.get(0));
        }
        return null;
    }

    @Override
    public CommonResponse<String> regainFree(BpmInfoVO vo) {
        CommonResponse<String> afterAbstainingResponse;
        CommonResponse<String> beforeAbstainingResponse = this.updateBillStateUtils.beforeAbstainingProcessor(vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
        if (!beforeAbstainingResponse.isSuccess()) {
            this.logger.error("\u5f03\u5ba1\u524d\u4e8b\u4ef6\u56de\u8c03\u62a5\u9519\uff0c \u8bf7\u68c0\u67e5\u5bf9\u5e94\u670d\u52a1\u662f\u5426\u6b63\u5e38\uff01");
            throw new BusinessException(beforeAbstainingResponse.getMsg());
        }
        CommonResponse<String> oldData = this.updateBillStateUtils.updateBillState(vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
        if (oldData.isSuccess() && !(afterAbstainingResponse = this.updateBillStateUtils.afterAbstainingProcessor(vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE)).isSuccess()) {
            CommonResponse<String> resu;
            String oldBillState = (String)oldData.getData();
            if (StringUtils.isNotBlank((CharSequence)oldBillState) && !(resu = this.updateBillStateUtils.updateBillState(vo.getBillId(), vo.getBillTypeCode(), Integer.parseInt(oldBillState))).isSuccess()) {
                this.updateBillStateUtils.updateBillState(vo.getBillId(), vo.getBillTypeCode(), Integer.parseInt(oldBillState));
            }
            this.logger.error("\u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03\u62a5\u9519\uff0c \u8bf7\u68c0\u67e5\u5bf9\u5e94\u670d\u52a1\u662f\u5426\u6b63\u5e38\uff01");
            throw new BusinessException(afterAbstainingResponse.getMsg());
        }
        vo.setType("withdraw");
        BpmInfoEntity entity = (BpmInfoEntity)((Object)BeanMapper.map((Object)((Object)vo), BpmInfoEntity.class));
        this.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u5f03\u5ba1\u6210\u529f\uff01");
    }
}

