/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdkcg.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdkcg.bean.WebsiteNewsEntity;
import com.ejianc.business.zdkcg.service.IWebsiteNewsService;
import com.ejianc.business.zdkcg.vo.WebsiteNewsVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"news"})
public class WebsiteNewsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWebsiteNewsService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WebsiteNewsVO> saveOrUpdate(@RequestBody WebsiteNewsVO saveorUpdateVO) {
        WebsiteNewsEntity entity = (WebsiteNewsEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, WebsiteNewsEntity.class));
        if (entity.getId() == null) {
            entity.setShelvesFlag(0);
            entity.setTopFlag(0);
        }
        this.service.saveOrUpdate((Object)entity, false);
        WebsiteNewsVO vo = (WebsiteNewsVO)BeanMapper.map((Object)((Object)entity), WebsiteNewsVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WebsiteNewsVO> queryDetail(Long id) {
        WebsiteNewsEntity entity = (WebsiteNewsEntity)((Object)this.service.selectById(id));
        WebsiteNewsVO vo = (WebsiteNewsVO)BeanMapper.map((Object)((Object)entity), WebsiteNewsVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WebsiteNewsVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WebsiteNewsVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        page.getRecords().forEach(e -> e.setContent(null));
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WebsiteNewsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/change"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> change(@RequestParam Long id, @RequestParam Integer newState, @RequestParam String field) {
        String msg = "";
        WebsiteNewsEntity entity = (WebsiteNewsEntity)((Object)this.service.selectById(id));
        if (field.equals("shelvesFlag")) {
            if (newState == 1) {
                msg = "\u4e0a\u67b6";
                if (entity.getBillState() != 1 && entity.getBillState() != 3) {
                    return CommonResponse.error((String)"\u672a\u5ba1\u6279\u901a\u8fc7\u4e0d\u80fd\u4e0a\u67b6");
                }
            } else {
                msg = "\u4e0b\u67b6";
            }
            entity.setShelvesFlag(newState);
        } else if (field.equals("topFlag")) {
            msg = newState == 1 ? "\u7f6e\u9876" : "\u53d6\u6d88\u7f6e\u9876";
            entity.setTopFlag(newState);
        }
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)(msg + "\u6210\u529f"));
    }
}

