package com.ejianc.business.zdkcg.bean;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 咨询动态、招标公告、党的建设、关于我们
 * 
 * @author liyj
 * 
 */
 @TableName("ejc_zdkwebsite_news")
public class WebsiteNewsEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

	@TableField(value = "title")
	private String title; // 新闻标题

	@TableField(value = "org_id")
	private Long orgId; // 发布组织ID

	@TableField(value = "shelves_flag")
	private Integer shelvesFlag; // 是否上架 ， 1：上架 ， 0：下架（审批完成后自动上架）

	@TableField(value = "publish_user")
	private String publishUser; // 发布人

	@TableField(value = "publish_time")
	private Date publishTime; // 发布时间

	@TableField(value = "introduce")
	private String introduce; // 简介

	@TableField(value = "top_flag")
	private Integer topFlag; // 是否置顶, 1:置顶 ， 0： 取消置顶

	@TableField(value = "content")
	private String content; // 内容

	@TableField(value = "author")
	private String author; // 作者

	@TableField(value = "bill_state")
	private Integer billState; // 单据状态

	/**
	 * 类型（资讯动态:(info-info：资讯动态，info-industry：行业资讯，info-company：公司动态);
	 * 		招标公告: (bidding-change:变更公告，bidding-error：招标异常，bidding-bidcandidate：中标候选人公示，bidding-bid：中标公示，bidding-announcement：招标公告)
	 * 		党的建设（party-special:党建专题,party-trends:党建动态,party-cultural:文化园地）
	 * 		关于我们（aboutus）
	 * ）
	 */
	@TableField(value = "type")
	private String type; //
	/**
	 * @Description 浏览次数
	 */
	@TableField(value = "view_num")
	private Integer viewNum = 0; //

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Integer getShelvesFlag() {
		return shelvesFlag;
	}

	public void setShelvesFlag(Integer shelvesFlag) {
		this.shelvesFlag = shelvesFlag;
	}

	public String getPublishUser() {
		return publishUser;
	}

	public void setPublishUser(String publishUser) {
		this.publishUser = publishUser;
	}

	public Date getPublishTime() {
		return publishTime;
	}

	public void setPublishTime(Date publishTime) {
		this.publishTime = publishTime;
	}

	public String getIntroduce() {
		return introduce;
	}

	public void setIntroduce(String introduce) {
		this.introduce = introduce;
	}

	public Integer getTopFlag() {
		return topFlag;
	}

	public void setTopFlag(Integer topFlag) {
		this.topFlag = topFlag;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		this.author = author;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Integer getViewNum() {
		return viewNum;
	}

	public void setViewNum(Integer viewNum) {
		this.viewNum = viewNum;
	}
}
