package com.ejianc.business.zdkcg.controller;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.zdkcg.bean.ApplyDetailEntity;
import com.ejianc.business.zdkcg.service.IApplyDetailService;
import com.ejianc.business.zdkcg.vo.ApplyDetailVO;

/**
 * 采购申请详情实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("applyDetail")
public class ApplyDetailController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IApplyDetailService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ApplyDetailVO> saveOrUpdate(@RequestBody ApplyDetailVO saveorUpdateVO) {
    	ApplyDetailEntity entity = BeanMapper.map(saveorUpdateVO, ApplyDetailEntity.class);
    	service.saveOrUpdate(entity, false);
    	ApplyDetailVO vo = BeanMapper.map(entity, ApplyDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ApplyDetailVO> queryDetail(Long id) {
    	ApplyDetailEntity entity = service.selectById(id);
    	ApplyDetailVO vo = BeanMapper.map(entity, ApplyDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplyDetailVO> vos) {
        service.removeByIds(vos.stream().map(ApplyDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ApplyDetailVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<ApplyDetailEntity> page = service.queryPage(param,false);
        IPage<ApplyDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ApplyDetailVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * 采购合同申请详情列表参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/applyDetailRef")
    @ResponseBody
    public CommonResponse<IPage<ApplyDetailVO>> applyDetailRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                               @RequestParam(defaultValue = "10") Integer pageSize,
                                                               @RequestParam(value = "condition", required = false) String condition,
                                                               @RequestParam(value = "searchText", required = false) String searchText) {

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("materialName");
        queryParam.getOrderMap().put("create_time", QueryParam.DESC);
        Long applyId = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("applyId")) {
                applyId = Long.valueOf(conditionMap.get("applyId").toString());
                queryParam.getParams().put("applyId", new Parameter(QueryParam.EQ, applyId));
            }
        }
        IPage<ApplyDetailEntity> pageData = service.queryPage(queryParam, false);
        IPage<ApplyDetailVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), ApplyDetailVO.class));
        return CommonResponse.success("采购申请参照查询成功！", result);
    }

}
