package com.ejianc.business.zdkcg.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.zdkcg.bean.ApplyEntity;
import com.ejianc.business.zdkcg.vo.ApplyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.zdkcg.bean.TenderPublishEntity;
import com.ejianc.business.zdkcg.service.ITenderPublishService;
import com.ejianc.business.zdkcg.vo.TenderPublishVO;

import javax.servlet.http.HttpServletResponse;

/**
 * 招标需求发布
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("publish")
public class TenderPublishController implements Serializable {
	private static final long serialVersionUID = 1L;
    private static final String EJC_ZDKCG_PUBLISH_BILL_CODE = "EJC_ZDKCG_PUBLISH";

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ITenderPublishService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TenderPublishVO> saveOrUpdate(@RequestBody TenderPublishVO saveorUpdateVO) {
    	TenderPublishEntity entity = BeanMapper.map(saveorUpdateVO, TenderPublishEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(EJC_ZDKCG_PUBLISH_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	TenderPublishVO vo = BeanMapper.map(entity, TenderPublishVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TenderPublishVO> queryDetail(Long id) {
    	TenderPublishEntity entity = service.selectById(id);
    	TenderPublishVO vo = BeanMapper.map(entity, TenderPublishVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TenderPublishVO> vos) {
        service.removeByIds(vos.stream().map(TenderPublishVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TenderPublishVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgAgencyName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<TenderPublishEntity> page = service.queryPage(param,false);
        IPage<TenderPublishVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TenderPublishVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgAgencyName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<TenderPublishEntity> pageData = service.queryPage(param, false);
        List<TenderPublishVO> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), TenderPublishVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                if (vo.getPurchaseType() == 0) {
                    vo.setPurchaseTypeName("生产科研类");
                }
                if (vo.getPurchaseType() == 1) {
                    vo.setPurchaseTypeName("固定资产投资类");
                }
                if (vo.getPurchaseType() == 2) {
                    vo.setPurchaseTypeName("企业经营消耗类");
                }
                if (vo.getPurchaseType() == 3) {
                    vo.setPurchaseTypeName("科研外协外包");
                }
//                招标方式:0-公开招标、1-邀请招标、2-询价、3-应急采购、4-单一来源
                if (vo.getZbType() == 0) {
                    vo.setZbTypeName("公开招标");
                }
                if (vo.getZbType() == 1) {
                    vo.setZbTypeName("邀请招标");
                }
                if (vo.getZbType() == 2) {
                    vo.setZbTypeName("询价");
                }
                if (vo.getZbType() == 3) {
                    vo.setZbTypeName("应急采购");
                }
                if (vo.getZbType() == 4) {
                    vo.setZbTypeName("单一来源");
                }
            });

        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("publishExport.xlsx", beans, response);
    }
}
