package com.ejianc.business.zdkcg.controller;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdkcg.bean.WebsiteHelpEntity;
import com.ejianc.business.zdkcg.bean.WebsiteHomedataEntity;
import com.ejianc.business.zdkcg.service.IWebsiteHomedataService;
import com.ejianc.business.zdkcg.vo.WebsiteHelpVO;
import com.ejianc.business.zdkcg.vo.WebsiteHomedataVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 
 * @author 
 * 
 */
@Controller
@RequestMapping("homedata")
public class WebsiteHomedataController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IWebsiteHomedataService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WebsiteHomedataVO> saveOrUpdate(@RequestBody List<WebsiteHomedataVO> saveorUpdateVOs) {
    	List<WebsiteHomedataEntity> entitys = BeanMapper.mapList(saveorUpdateVOs, WebsiteHomedataEntity.class);
    	service.saveOrUpdateBatch(entitys, entitys.size(), false);
    	return CommonResponse.success("保存或修改单据成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/getData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<WebsiteHomedataVO>> getData() {
    	QueryParam param = new QueryParam();
        LinkedHashMap<String,String> orderMap = new LinkedHashMap<>();
        orderMap.put("sequence", "asc");
        
        List<WebsiteHomedataEntity> page = service.queryList(param,false);
        List<WebsiteHomedataVO> result = BeanMapper.mapList(page, WebsiteHomedataVO.class);
        return CommonResponse.success("查询列表数据成功！",result);
    }

}
