package com.ejianc.business.zdkcg.controller;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdkcg.bean.WebsiteNewsEntity;
import com.ejianc.business.zdkcg.bean.WebsiteNewsEntity;
import com.ejianc.business.zdkcg.service.IWebsiteNewsService;
import com.ejianc.business.zdkcg.vo.WebsiteNewsVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;

/**
 * 
 * @author 
 * 
 */
@Controller
@RequestMapping("news")
public class WebsiteNewsController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IWebsiteNewsService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WebsiteNewsVO> saveOrUpdate(@RequestBody WebsiteNewsVO saveorUpdateVO) {
    	WebsiteNewsEntity entity = BeanMapper.map(saveorUpdateVO, WebsiteNewsEntity.class);
    	if(entity.getId()==null){
    		//新增时默认是否发布、置顶为false（0）
    		entity.setShelvesFlag(0);
    		entity.setTopFlag(0);
    	}
    	service.saveOrUpdate(entity, false);
    	WebsiteNewsVO vo = BeanMapper.map(entity, WebsiteNewsVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WebsiteNewsVO> queryDetail(Long id) {
    	WebsiteNewsEntity entity = service.selectById(id);
    	WebsiteNewsVO vo = BeanMapper.map(entity, WebsiteNewsVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WebsiteNewsVO> vos) {
        service.removeByIds(vos.stream().map(WebsiteNewsVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WebsiteNewsVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<WebsiteNewsEntity> page = service.queryPage(param,false);
        IPage<WebsiteNewsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        page.getRecords().forEach(e -> {
        	e.setContent(null);
        });
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WebsiteNewsVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

	/**
	 * 改变状态信息（是否发布/是否上架
	 * 
	 * @param orgVO
	 * @return
	 */
	@RequestMapping(value = "/change", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> change(@RequestParam Long id,@RequestParam Integer newState, @RequestParam String field) {
		String msg = "";
    	WebsiteNewsEntity entity = service.selectById(id);
		if(field.equals("shelvesFlag")){
			if(newState==1){
				msg = "上架";
				if(!(entity.getBillState()==1||entity.getBillState()==3)){
					//审批通过的才能上架
					return CommonResponse.error("未审批通过不能上架");
				}
			}else{
				msg = "下架";
			}
			entity.setShelvesFlag(newState);
		}else if(field.equals("topFlag")){
			if(newState==1){
				msg = "置顶";
			}else{
				msg = "取消置顶";
			}
			entity.setTopFlag(newState);
		}
		service.saveOrUpdate(entity, false);
		return CommonResponse.success(msg+"成功");
	}
}
