package com.ejianc.business.zdkcg.service.impl;

import java.util.Date;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdkcg.bean.WebsiteNewsEntity;
import com.ejianc.business.zdkcg.service.IWebsiteNewsService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;

@Service("websiteNews")
public class WebsiteNewsBpmService implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IWebsiteNewsService websiteNewsService;
    
	/**
	 * 审批节点审批中时节点审批后回调
	 * 
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
    @Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};
	
    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
    	//保存发布人
    	WebsiteNewsEntity entity = websiteNewsService.selectById(billId);
    	entity.setPublishTime(new Date());
    	Long userId = InvocationInfoProxy.getUserid();
    	String userName = userId.toString();
    	try {
			if(userId!=null){
				JSONArray jArray = ReferObjectUtil.getReferEntityValue(userId.toString(), "idm-user");
				if(jArray!=null&&jArray.size()>0){
					JSONObject json = (JSONObject) jArray.get(0);
					userName = json.get("name").toString();
				}
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	entity.setPublishUser(userName);
    	entity.setOrgId(InvocationInfoProxy.getOrgId());
    	websiteNewsService.saveOrUpdate(entity, false);
        return CommonResponse.success();
    }

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
    @Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
    	//取消发布人
    	WebsiteNewsEntity entity = websiteNewsService.selectById(billId);
    	entity.setPublishTime(null);
    	entity.setPublishUser(null);
    	entity.setOrgId(null);
    	websiteNewsService.saveOrUpdate(entity, false);
		return CommonResponse.success();
	};

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
    	if(state==1){
    		//直审回写保存发布人
        	WebsiteNewsEntity entity = websiteNewsService.selectById(billId);
        	entity.setPublishTime(new Date());
        	Long userId = InvocationInfoProxy.getUserid();
        	String userName = userId.toString();
        	try {
    			if(userId!=null){
    				JSONArray jArray = ReferObjectUtil.getReferEntityValue(userId.toString(), "idm-user");
    				if(jArray!=null&&jArray.size()>0){
    					JSONObject json = (JSONObject) jArray.get(0);
    					userName = json.get("name").toString();
    				}
    			}
    		} catch (Exception e) {
    			// TODO Auto-generated catch block
    			e.printStackTrace();
    		}
        	entity.setPublishUser(userName);
        	entity.setOrgId(InvocationInfoProxy.getOrgId());
        	websiteNewsService.saveOrUpdate(entity, false);
    	}
    	return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
    	//取消发布人
    	WebsiteNewsEntity entity = websiteNewsService.selectById(billId);
    	entity.setPublishTime(null);
    	entity.setPublishUser(null);
    	entity.setOrgId(null);
    	websiteNewsService.saveOrUpdate(entity, false);
        return CommonResponse.success();
    }

}
