package com.ejianc.business.zdscost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.consts.ChangTypeConst;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.QuoteParamsVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("budgetProject")
public class BudgetProjectBpmServiceImpl implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IBudgetProjectService service;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }



    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }



    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }



    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }



    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetProjectEntity changeEntity = service.selectById(billId);
        Map<Long, BudgetProjectDetailEntity> detailDelMap = changeEntity.getBudgetProjectDetailList().stream().filter(t -> ChangTypeConst.DELETE.equals(t.getChangeType()))
                .collect(Collectors.toMap(BudgetProjectDetailEntity::getId, student -> student));
        if (MapUtils.isNotEmpty(detailDelMap)) {
            QuoteParamsVO quoteParamsVO = new QuoteParamsVO();
            quoteParamsVO.setBillTypeCode("EJCBT202508000001");
            quoteParamsVO.setBillIds(new ArrayList<>(detailDelMap.keySet()));
            CommonResponse<List<Long>> resp = billTypeApi.checkQuotesAndReturnQuoteBillIds(quoteParamsVO);
            logger.info("================beforeAbstainingProcessor 校验参数：{}，结果:{}", JSONObject.toJSONString(quoteParamsVO), JSONObject.toJSONString(resp));
            if (resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())) {
                for (Long detailId : resp.getData()) {
                    BudgetProjectDetailEntity detailEntity = detailDelMap.get(detailId);
                    if (detailEntity != null) {
                        return CommonResponse.error("清单明细：项目编码【" + detailEntity.getCode() + "】项目名称【" + detailEntity.getName() + "】已被下游采购计划/总控计划引用，不允许撤回！");
                    }
                }
            }
        }
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        return CommonResponse.success();
    }

}
