/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdscost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.QuoteParamsVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetProject")
public class BudgetProjectBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBudgetProjectService service;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetProjectEntity changeEntity = (BudgetProjectEntity)((Object)this.service.selectById(billId));
        Map<Long, BudgetProjectDetailEntity> detailDelMap = changeEntity.getBudgetProjectDetailList().stream().filter(t -> "2".equals(t.getChangeType())).collect(Collectors.toMap(BaseEntity::getId, student -> student));
        if (MapUtils.isNotEmpty(detailDelMap)) {
            QuoteParamsVO quoteParamsVO = new QuoteParamsVO();
            quoteParamsVO.setBillTypeCode("EJCBT202508000001");
            quoteParamsVO.setBillIds(new ArrayList<Long>(detailDelMap.keySet()));
            CommonResponse resp = this.billTypeApi.checkQuotesAndReturnQuoteBillIds(quoteParamsVO);
            this.logger.info("================beforeAbstainingProcessor \u6821\u9a8c\u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)quoteParamsVO), (Object)JSONObject.toJSONString((Object)resp));
            if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
                for (Long detailId : (List)resp.getData()) {
                    BudgetProjectDetailEntity detailEntity = detailDelMap.get(detailId);
                    if (detailEntity == null) continue;
                    return CommonResponse.error((String)("\u6e05\u5355\u660e\u7ec6\uff1a\u9879\u76ee\u7f16\u7801\u3010" + detailEntity.getCode() + "\u3011\u9879\u76ee\u540d\u79f0\u3010" + detailEntity.getName() + "\u3011\u5df2\u88ab\u4e0b\u6e38\u91c7\u8d2d\u8ba1\u5212/\u603b\u63a7\u8ba1\u5212\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff01"));
                }
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

