package com.ejianc.business.zdscost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.zdscost.bean.*;
import com.ejianc.business.zdscost.consts.ChangTypeConst;
import com.ejianc.business.zdscost.service.IBudgetProjectChangeService;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailService;
import com.ejianc.business.zdscost.service.IBudgetProjectRecordService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.vo.BudgetProjectVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.QuoteParamsVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;

@Service("budgetProjectChange")
public class BudgetProjectChangeBpmServiceImpl implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IBudgetProjectChangeService changeService;

    @Autowired
    private IBudgetProjectService service;

    @Autowired
    private IBudgetProjectDetailService detailService;

    @Autowired
    private IBudgetProjectRecordService recordService;

    @Autowired
    private HttpServletRequest request;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IBillTypeApi billTypeApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetProjectChangeEntity changeEntity = changeService.selectById(billId);
        Map<Long, BudgetProjectDetailChangeEntity> detailDelMap = changeEntity.getBudgetProjectDetailList().stream().filter(t -> ChangTypeConst.DELETE.equals(t.getChangeType()) && t.getChangeBid() != null)
                .collect(Collectors.toMap(BudgetProjectDetailChangeEntity::getChangeBid, student -> student));
        if (MapUtils.isNotEmpty(detailDelMap)) {
            QuoteParamsVO quoteParamsVO = new QuoteParamsVO();
            quoteParamsVO.setBillTypeCode("EJCBT202508000001");
            quoteParamsVO.setBillIds(new ArrayList<>(detailDelMap.keySet()));
            CommonResponse<List<Long>> resp = billTypeApi.checkQuotesAndReturnQuoteBillIds(quoteParamsVO);
            logger.info("================beforeSubmitProcessor 校验参数：{}，结果:{}", JSONObject.toJSONString(quoteParamsVO), JSONObject.toJSONString(resp));
            if (resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())) {
                for (Long detailId : resp.getData()) {
                    BudgetProjectDetailChangeEntity detailChangeEntity = detailDelMap.get(detailId);
                    if (detailChangeEntity != null) {
                        return CommonResponse.error("清单明细：项目编码【" + detailChangeEntity.getCode() + "】项目名称【" + detailChangeEntity.getName() + "】已被下游采购计划/总控计划引用，不允许删除！");
                    }
                }
            }
        }
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        /**更新变更的审批时间  begin */
        BudgetProjectChangeEntity changeEntity = changeService.selectById(billId);
        LambdaUpdateWrapper<BudgetProjectChangeEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(BudgetProjectChangeEntity::getEffectiveTime, new Date());
        updateWrapper.eq(BudgetProjectChangeEntity::getId, changeEntity.getId());
        changeService.update(updateWrapper);
        /**更新变更的审批时间  end */

        BudgetProjectEntity contractChangeEntity = BeanMapper.map(changeEntity, BudgetProjectEntity.class);
        List<BudgetProjectDetailEntity> budgetProjectDetailList = contractChangeEntity.getBudgetProjectDetailList();
        List<Long> sourceItemIds = budgetProjectDetailList.stream().filter(t -> t.getChangeBid() != null).map(BudgetProjectDetailEntity::getChangeBid).collect(Collectors.toList());

        /**复制合同表数据到记录表 begin */
        BudgetProjectEntity budgetProjectEntity = service.selectById(changeEntity.getChangeId());
        Map<Long, Integer> contIdVersionMap = new HashMap<>();
        BudgetProjectRecordEntity recordEntity = BeanMapper.map(budgetProjectEntity, BudgetProjectRecordEntity.class);
        recordEntity.setBillCode(budgetProjectEntity.getBillCode() + "-" + budgetProjectEntity.getChangeVersion());
        recordEntity.setChangeId(changeEntity.getId());
        recordEntity.setChangeCode(changeEntity.getBillCode());
        recordEntity.setChangeReason(changeEntity.getChangeReason());
        recordEntity.setEffectiveTime(new Date());
        recordEntity.setCreateTime(changeEntity.getCreateTime());
        recordEntity.setId(null);
        recordEntity.setOriginBudgetId(budgetProjectEntity.getId());
        recordEntity.setOptType(changeEntity.getOptType());

        Set<String> engineeringPackNum = new HashSet();
        Set<String> materialPackNum = new HashSet<>();
        if (CollectionUtils.isNotEmpty(recordEntity.getBudgetProjectDetailList())) {
            recordEntity.getBudgetProjectDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                if (!sourceItemIds.contains(vo.getId())) {
                    if (StringUtils.isNotBlank(vo.getMaterialPackCode())) {
                        materialPackNum.add(vo.getMaterialPackCode());
                    }
                    if (StringUtils.isNotBlank(vo.getEngineeringPackCode())) {
                        engineeringPackNum.add(vo.getEngineeringPackCode());
                    }
                }
                vo.setChangeBid(vo.getId());
                vo.setChangeId(vo.getBudgetId());
                vo.setId(null);
                vo.setVersion(null);
            });
        }
        recordService.saveOrUpdate(recordEntity, false);
        /**复制合同表数据到记录表 end */


        /**复制合同子表数据 begin */
        List<Long> delIds = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(budgetProjectDetailList)) {
            budgetProjectDetailList.forEach(contractDetailEntity -> {
                //记录虚拟父子关系
                Long changeBid = contractDetailEntity.getChangeBid();
                contractDetailEntity.setBudgetId(changeEntity.getChangeId());
                contractDetailEntity.setChangeBid(contractDetailEntity.getId());
                contractDetailEntity.setChangeId(contractDetailEntity.getId());
                contractDetailEntity.setId(changeBid);
                contractDetailEntity.setVersion(contIdVersionMap.get(changeBid));
                if (ChangTypeConst.DELETE.equals(contractDetailEntity.getChangeType())) {
                    if (changeBid != null) {
                        delIds.add(changeBid);
                    }
                } else {
                    if (StringUtils.isNotBlank(contractDetailEntity.getMaterialPackCode())) {
                        materialPackNum.add(contractDetailEntity.getMaterialPackCode());
                    }
                    if (StringUtils.isNotBlank(contractDetailEntity.getEngineeringPackCode())) {
                        engineeringPackNum.add(contractDetailEntity.getEngineeringPackCode());
                    }
                }
            });
            detailService.saveOrUpdateBatch(budgetProjectDetailList, budgetProjectDetailList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(delIds)) {
            detailService.removeByIds(delIds);
        }


        /**更新变更表表头数据到合同 begin */
        LambdaQueryWrapper<BudgetProjectChangeEntity> changeQueryWrapper = new LambdaQueryWrapper<>();
        changeQueryWrapper.eq(BudgetProjectChangeEntity::getChangeId, changeEntity.getChangeId());
        changeQueryWrapper.ne(changeEntity.getId() == null, BudgetProjectChangeEntity::getId, changeEntity.getId());
        changeQueryWrapper.notIn(BudgetProjectChangeEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        changeQueryWrapper.orderByDesc(BudgetProjectChangeEntity::getCreateTime);
        List<BudgetProjectChangeEntity> list = changeService.list(changeQueryWrapper);
        LambdaUpdateWrapper<BudgetProjectEntity> updateWr = new LambdaUpdateWrapper<>();
        updateWr.eq(BudgetProjectEntity::getId, budgetProjectEntity.getId());
        if (CollectionUtils.isNotEmpty(list)) {
            updateWr.set(BudgetProjectEntity::getChangeId, list.get(0).getId());
            updateWr.set(BudgetProjectEntity::getChangeCode, list.get(0).getBillCode());
            updateWr.set(BudgetProjectEntity::getChangeStatus, BudgetProjectVO.CHANGE_STATE_CHANGING);
        } else {
            updateWr.set(BudgetProjectEntity::getChangeId, null);
            updateWr.set(BudgetProjectEntity::getChangeCode, null);
            updateWr.set(BudgetProjectEntity::getChangeStatus, BudgetProjectVO.CHANGE_STATE_CHANGED);
        }
        updateWr.set(BudgetProjectEntity::getChangeVersion, changeEntity.getChangeVersion());
        updateWr.set(BudgetProjectEntity::getEffectiveTime, new Date());
        updateWr.set(BudgetProjectEntity::getMaterialPackNum, materialPackNum.size());
        updateWr.set(BudgetProjectEntity::getEngineeringPackNum, engineeringPackNum.size());
        service.update(updateWr);
        /**更新变更表表头数据到合同 end */

        String result = null;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("projectDepartmentId", budgetProjectEntity.getOrgId());
        Map<String, String> headers = new HashMap<>();
        String authority = request.getHeader("authority");
        headers.put("authority", authority);
        try {
            result = HttpTookit.get(baseHost + "/ejc-share-web/projectTeam/queryList?=", jsonObject, headers);
        } catch (Exception e) {
            logger.error("获取项目人员任职失败：" + e.getMessage());
            e.printStackTrace();
            throw new BusinessException("获取项目人员任职失败!");
        }
        CommonResponse<List<Map<String, Object>>> resp = JSONObject.parseObject(result, new TypeReference<CommonResponse<List<Map<String, Object>>>>() {
        });
        if (resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())) {
            List<String> reccIds = new ArrayList<>();
            for (Map<String, Object> datum : resp.getData()) {
                Object projectPost = datum.get("projectPost");
                if (projectPost != null && "项目商务工程师、项目商务经理、项目经理".contains(projectPost.toString())) {
                    Object userId = datum.get("userId");
                    if (userId != null) {
                        reccIds.add(userId.toString());
                    }
                }
            }
            logger.info("切包清单变更id-{},发送消息接收人：{}！", changeEntity.getId().toString(), JSONObject.toJSONString(reccIds, SerializerFeature.PrettyFormat,
                    SerializerFeature.WriteMapNullValue));
            if (!reccIds.isEmpty()) {
                PushMsgParameter pushMsgParameter = new PushMsgParameter();
                String subject = "切包清单【" + budgetProjectEntity.getBillCode() + "】于" + DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date()) + "发生了变更，需要您查看和处理！";
                pushMsgParameter.setSubject(subject);
                StringBuilder content = new StringBuilder();
                content.append("【" + budgetProjectEntity.getBillCode() + "】，【"
                        + budgetProjectEntity.getProjectCode() + "，" + budgetProjectEntity.getProjectName() + "】，项目清单发生变化，请及时对费用包预算进行调整，以保证限价与询价范围一致。\n");

                pushMsgParameter.setContent(content.toString());
                pushMsgParameter.setPcUrl(baseHost + "ejc-zdscost-frontend/#/budgetProject/card?id=" + changeEntity.getId().toString());
                pushMsgParameter.setReceivers(reccIds.toArray(new String[reccIds.size()]));
                pushMsgParameter.setSaveFlag(true);
                pushMsgParameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
                pushMsgParameter.setMsgType("notice");
                pushMsgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_EMAIL});
                JSONObject params = new JSONObject();
                params.put("comeFrom", "工程管理中心 " + DateFormatUtil.formatDate("yyyy/MM/dd", new Date()));
                pushMsgParameter.setZdsExtEmailParams(params);
                CommonResponse<String> sendResp = pushMessageApi.pushMessage(pushMsgParameter);
                if (!sendResp.isSuccess()) {
                    logger.error("切包清单变更id-{},发送消息失败，{}", changeEntity.getId().toString(), JSONObject.toJSONString(sendResp, SerializerFeature.PrettyFormat,
                            SerializerFeature.WriteMapNullValue));
                } else {
                    logger.info("切包清单变更id-{},发送消息成功！", changeEntity.getId().toString());
                }
            }

        }

        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error("变更单暂不支持回退功能!");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        return CommonResponse.success();
    }

}
