package com.ejianc.business.zdscost.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailPackageVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 切包清单-明细
 *
 * @author generator
 *
 */
@Mapper
public interface BudgetProjectDetailMapper extends BaseCrudMapper<BudgetProjectDetailEntity> {

    List<Map> queryPackageList(Page page, @Param("projectSid") String projectSid, @Param("packageFlag") String packageFlag
            , @Param("packageCode") String packageCode, @Param("packageName") String packageName);

    List<BudgetProjectDetailPackageVO> queryPackageTree(@Param("budgetId") Long budgetId);

    List<BudgetProjectDetailPackageVO> queryPackageDetailList(Page<BudgetProjectDetailPackageVO> page, @Param("budgetId") Long budgetId, @Param(Constants.WRAPPER) QueryWrapper qw);

    List<BudgetProjectDetailPackageVO> queryDianLiangPackCode(@Param("budgetId") Long budgetId);

    List<String> queryItemCodeList(@Param("budgetId")Long budgetId, @Param("changeId") Long changeId);
}
