/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdscost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.bean.BudgetProjectChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectRecordEntity;
import com.ejianc.business.zdscost.controller.AiMaterialThread;
import com.ejianc.business.zdscost.service.IBudgetProjectChangeService;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailChangeService;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailService;
import com.ejianc.business.zdscost.service.IBudgetProjectRecordService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.util.CostExcelReader;
import com.ejianc.business.zdscost.util.ZDSTreeNodeBUtil;
import com.ejianc.business.zdscost.vo.BudgetProjectChangeVO;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailChangeVO;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailPackageVO;
import com.ejianc.business.zdscost.vo.BudgetProjectVO;
import com.ejianc.business.zdscost.vo.query.PackageQueryVO;
import com.ejianc.business.zdsmaterial.erp.api.IZDSSubTypeApi;
import com.ejianc.business.zdsmaterial.material.api.IZDSMaterialCategoryApi;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.api.IZDSMaterialConjectureApi;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.QuoteParamsVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.cache.redissonlock.RedissonLocker;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.fieldCompare.CompareDifferenceUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"budgetProjectChange"})
@Api(value="\u5207\u5305\u6e05\u5355\u53d8\u66f4", tags={"\u5207\u5305\u6e05\u5355\u53d8\u66f4"})
public class BudgetProjectChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "BUDGET_PROJECT_CHANGE_CODE";
    @Autowired
    private IZDSSubTypeApi subTypeApi;
    @Autowired
    private IZDSMaterialCategoryApi materialCategoryApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBudgetProjectChangeService service;
    @Autowired
    private IBudgetProjectService budgetProjectService;
    @Autowired
    private IBudgetProjectDetailChangeService detailChangeService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBudgetProjectRecordService recordService;
    @Autowired
    private IZDSMaterialConjectureApi materialConjectureApi;
    @Autowired
    private RedissonLocker redissonLocker;
    @Autowired
    private IBudgetProjectDetailService detailService;
    @Autowired
    private IBillTypeApi billTypeApi;
    private static BigDecimal PER_SEQ = new BigDecimal("0.001");

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetProjectChangeVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody BudgetProjectChangeVO saveOrUpdateVO) {
        int c;
        boolean isBG = "BG".equals(saveOrUpdateVO.getOptType());
        Long changeId = saveOrUpdateVO.getChangeId();
        LambdaQueryWrapper changeQueryWrapper = new LambdaQueryWrapper();
        changeQueryWrapper.eq(BudgetProjectChangeEntity::getChangeId, (Object)changeId);
        if (!isBG) {
            changeQueryWrapper.eq(BudgetProjectChangeEntity::getOptType, (Object)"BG");
            changeQueryWrapper.ne(saveOrUpdateVO.getId() == null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
            changeQueryWrapper.notIn(BudgetProjectChangeEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            c = this.service.count((Wrapper)changeQueryWrapper);
            if (c > 0) {
                throw new BusinessException("\u5f53\u524d\u5355\u636e\u6b63\u5728\u53d8\u66f4\u4e2d\uff0c\u4e0d\u5141\u8bb8\u4e8c\u6b21\u70b9\u91cf\uff01");
            }
        } else {
            changeQueryWrapper.eq(BudgetProjectChangeEntity::getOptType, (Object)"DL");
            changeQueryWrapper.ne(saveOrUpdateVO.getId() == null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
            changeQueryWrapper.notIn(BudgetProjectChangeEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            c = this.service.count((Wrapper)changeQueryWrapper);
            if (c > 0) {
                throw new BusinessException("\u5f53\u524d\u5355\u636e\u5b58\u5728\u6b63\u5728\u4e8c\u6b21\u70b9\u91cf\u4e2d\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\uff01");
            }
        }
        BudgetProjectChangeEntity entity = (BudgetProjectChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BudgetProjectChangeEntity.class));
        List<BudgetProjectDetailChangeEntity> detailList = entity.getBudgetProjectDetailList();
        Map<Long, BudgetProjectDetailChangeEntity> detailDelMap = detailList.stream().filter(t -> "2".equals(t.getChangeType()) && t.getChangeBid() != null).collect(Collectors.toMap(BudgetProjectDetailChangeEntity::getChangeBid, student -> student));
        this.logger.info("================saveOrUpdate detailDelMap\uff1a{}", (Object)JSONObject.toJSONString(detailDelMap));
        if (MapUtils.isNotEmpty(detailDelMap)) {
            QuoteParamsVO quoteParamsVO = new QuoteParamsVO();
            quoteParamsVO.setBillTypeCode("EJCBT202508000001");
            quoteParamsVO.setBillIds(new ArrayList<Long>(detailDelMap.keySet()));
            CommonResponse resp = this.billTypeApi.checkQuotesAndReturnQuoteBillIds(quoteParamsVO);
            this.logger.info("================saveOrUpdate \u6821\u9a8c\u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)quoteParamsVO), (Object)JSONObject.toJSONString((Object)resp));
            if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
                for (Long detailId : (List)resp.getData()) {
                    BudgetProjectDetailChangeEntity detailChangeEntity = detailDelMap.get(detailId);
                    if (detailChangeEntity == null) continue;
                    return CommonResponse.error((String)("\u6e05\u5355\u660e\u7ec6\uff1a\u9879\u76ee\u7f16\u7801\u3010" + detailChangeEntity.getCode() + "\u3011\u9879\u76ee\u540d\u79f0\u3010" + detailChangeEntity.getName() + "\u3011\u5df2\u88ab\u4e0b\u6e38\u91c7\u8d2d\u8ba1\u5212/\u603b\u63a7\u8ba1\u5212\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01"));
                }
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setChangeStatus(2);
            entity.setBillDate(new Date());
            entity.setIdentificationState(0);
        }
        HashMap<String, Long> packUpMap = new HashMap<String, Long>();
        HashSet<String> itemCodeSet = new HashSet<String>();
        if (!isBG) {
            List<String> list = this.detailService.queryItemCodeList(entity.getChangeId(), entity.getId());
            itemCodeSet = new HashSet(list);
        }
        for (BudgetProjectDetailChangeEntity t2 : detailList) {
            String code = t2.getCode();
            if (t2.getPackUpId() != null) {
                packUpMap.put(code, t2.getPackUpId());
            }
            if (StringUtils.isNotBlank((CharSequence)t2.getItemCode()) && StringUtils.isNotBlank((CharSequence)code) && !t2.getItemCode().startsWith(code)) {
                t2.setItemCode(null);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)t2.getItemCode())) continue;
            itemCodeSet.add(t2.getItemCode());
        }
        HashSet<String> engineeringPackNum = new HashSet<String>();
        HashSet<String> materialPackNum = new HashSet<String>();
        BigDecimal dlPreSeq = null;
        for (int i = 0; i < detailList.size(); ++i) {
            BudgetProjectDetailChangeEntity detailEntity = detailList.get(i);
            if (!"del".equals(detailEntity.getRowState())) {
                if (isBG) {
                    detailEntity.setSequen(ComputeUtil.safeAdd((BigDecimal)ComputeUtil.toBigDecimal((Integer)i), (BigDecimal)BigDecimal.ONE));
                } else if (detailEntity.getSequen() == null) {
                    detailEntity.setSequen(ComputeUtil.safeAdd((BigDecimal)dlPreSeq, (BigDecimal)PER_SEQ));
                }
                dlPreSeq = detailEntity.getSequen();
            }
            if ("del".equals(detailEntity.getRowState()) || "2".equals(detailEntity.getChangeType())) continue;
            String code = detailEntity.getCode();
            if (StringUtils.isNotBlank((CharSequence)code)) {
                detailEntity.setPackUpFlag(1);
                Long packUpId = (Long)packUpMap.get(code);
                if (packUpId == null) {
                    packUpId = IdWorker.getId();
                    packUpMap.put(code, packUpId);
                }
                detailEntity.setPackUpId(packUpId);
            } else {
                detailEntity.setPackUpFlag(0);
                detailEntity.setPackUpId(null);
                detailEntity.setCode(null);
                code = null;
            }
            if (StringUtils.isBlank((CharSequence)detailEntity.getItemCode())) {
                int number = 2;
                String itemCode = Optional.ofNullable(code).orElse("") + String.format("%02d", number);
                while (itemCodeSet.contains(itemCode) && itemCodeSet.contains(itemCode = Optional.ofNullable(code).orElse("") + String.format("%02d", ++number))) {
                }
                detailEntity.setItemCode(itemCode);
                itemCodeSet.add(itemCode);
            }
            if (detailEntity.getMaterialPackId() != null) {
                materialPackNum.add(detailEntity.getMaterialPackCode());
                detailEntity.setMaterialListFlag(1);
                if (detailEntity.getMaterialListId() == null) {
                    detailEntity.setMaterialListId(IdWorker.getId());
                }
            } else {
                detailEntity.setMaterialListFlag(0);
                detailEntity.setMaterialListId(null);
            }
            if (detailEntity.getEngineeringPackId() != null) {
                engineeringPackNum.add(detailEntity.getEngineeringPackCode());
                detailEntity.setEngineeringListFlag(1);
                if (detailEntity.getEngineeringListId() != null) continue;
                detailEntity.setEngineeringListId(IdWorker.getId());
                continue;
            }
            detailEntity.setEngineeringListFlag(0);
            detailEntity.setEngineeringListId(null);
        }
        entity.setEngineeringPackNum(engineeringPackNum.size());
        entity.setMaterialPackNum(materialPackNum.size());
        this.service.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BaseEntity::getId, (Object)entity.getChangeId());
        wrapper.set(BudgetProjectEntity::getChangeId, (Object)entity.getId());
        wrapper.set(BudgetProjectEntity::getChangeCode, (Object)entity.getBillCode());
        wrapper.set(BudgetProjectEntity::getChangeStatus, (Object)BudgetProjectVO.CHANGE_STATE_CHANGING);
        this.budgetProjectService.update((Wrapper)wrapper);
        BudgetProjectChangeVO vo = (BudgetProjectChangeVO)BeanMapper.map((Object)((Object)entity), BudgetProjectChangeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(vo.getId()).getData());
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetProjectChangeVO> queryDetail(@RequestParam Long id) {
        BudgetProjectChangeEntity entity = (BudgetProjectChangeEntity)((Object)this.service.selectById(id));
        BudgetProjectChangeVO vo = (BudgetProjectChangeVO)BeanMapper.map((Object)((Object)entity), BudgetProjectChangeVO.class);
        vo.getBudgetProjectDetailList().sort(Comparator.comparing(BudgetProjectDetailChangeVO::getSequen, Comparator.nullsLast(BigDecimal::compareTo)));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryPackageTree"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<BudgetProjectDetailPackageVO>> queryPackageTree(@RequestParam Long id) {
        List<BudgetProjectDetailPackageVO> packageTreeList = this.detailChangeService.queryPackageTree(id);
        List budgetProjectDetailPackageVOS = ZDSTreeNodeBUtil.buildTree(packageTreeList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)budgetProjectDetailPackageVOS);
    }

    @RequestMapping(value={"/queryDetailList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<BudgetProjectDetailChangeVO>> queryDetailList(@RequestBody BudgetProjectDetailPackageVO packageVO) {
        String code;
        String packageFlag;
        Long budgetId = packageVO.getBudgetId();
        if (budgetId == null) {
            budgetId = 1L;
        }
        QueryParam queryParam = new QueryParam();
        List fuzzyFields = queryParam.getFuzzyFields();
        Map params = queryParam.getParams();
        params.put("budgetId", new Parameter("eq", (Object)packageVO.getBudgetId()));
        params.put("changeType", new Parameter("ne", (Object)"2"));
        queryParam.setSearchText(packageVO.getSearchText());
        Long bigPackId = packageVO.getBigPackId();
        if (bigPackId != null) {
            params.put("bigPackId", new Parameter("eq", (Object)bigPackId));
        }
        if (StringUtils.isNotBlank((CharSequence)(packageFlag = packageVO.getPackageFlag()))) {
            if ("material".equals(packageFlag)) {
                params.put("materialListFlag", new Parameter("eq", (Object)1));
            } else {
                params.put("engineeringListFlag", new Parameter("eq", (Object)1));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(code = packageVO.getCode()))) {
            if ("material".equals(packageFlag)) {
                params.put("materialPackCode", new Parameter("eq", (Object)code));
            } else {
                params.put("engineeringPackCode", new Parameter("eq", (Object)code));
            }
        }
        List budgetProjectDetailEntities = this.detailChangeService.queryList(queryParam);
        budgetProjectDetailEntities.sort(Comparator.comparing(BudgetProjectDetailChangeEntity::getSequen, Comparator.nullsLast(BigDecimal::compareTo)));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)budgetProjectDetailEntities, BudgetProjectDetailChangeVO.class));
    }

    @RequestMapping(value={"/addByBudgetId"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetProjectChangeVO> addByBudgetId(@RequestBody PackageQueryVO packageQueryVO) {
        BudgetProjectChangeVO vo = this.service.addByBudgetId(packageQueryVO);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectChangeVO> vos) {
        BudgetProjectChangeVO changeVo = vos.get(0);
        BudgetProjectChangeEntity entity = (BudgetProjectChangeEntity)((Object)this.service.getById(changeVo.getId()));
        Long id = entity.getChangeId();
        LambdaQueryWrapper changeQueryWrapper = new LambdaQueryWrapper();
        changeQueryWrapper.eq(BudgetProjectChangeEntity::getChangeId, (Object)changeVo.getChangeId());
        changeQueryWrapper.ne(BaseEntity::getId, (Object)id);
        changeQueryWrapper.notIn(BudgetProjectChangeEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        changeQueryWrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.service.list((Wrapper)changeQueryWrapper);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BaseEntity::getId, (Object)id);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            wrapper.set(BudgetProjectEntity::getChangeId, (Object)((BudgetProjectChangeEntity)((Object)list.get(0))).getId());
            wrapper.set(BudgetProjectEntity::getChangeCode, (Object)((BudgetProjectChangeEntity)((Object)list.get(0))).getBillCode());
            wrapper.set(BudgetProjectEntity::getChangeStatus, (Object)BudgetProjectVO.CHANGE_STATE_CHANGING);
        } else {
            LambdaQueryWrapper recordEntityLambdaUpdateWrapper = new LambdaQueryWrapper();
            recordEntityLambdaUpdateWrapper.eq(BudgetProjectRecordEntity::getOriginBudgetId, (Object)id);
            int count = this.recordService.count((Wrapper)recordEntityLambdaUpdateWrapper);
            wrapper.set(BudgetProjectEntity::getChangeId, null);
            wrapper.set(BudgetProjectEntity::getChangeCode, null);
            wrapper.set(BudgetProjectEntity::getChangeStatus, (Object)(count == 0 ? BudgetProjectVO.CHANGE_STATE_UNCHANGED : BudgetProjectVO.CHANGE_STATE_CHANGED));
        }
        this.budgetProjectService.update((Wrapper)wrapper);
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetProjectChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "parentOrgName", "employeeName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("BudgetProject-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportDetail(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("changeType", new Parameter("ne", (Object)"2"));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Parameter budgetIdval = (Parameter)param.getParams().get("budgetId");
        Long budgetId = Long.valueOf(budgetIdval.getValue().toString());
        param.getParams().put("budgetId", new Parameter("eq", (Object)budgetId));
        List list = this.detailChangeService.queryList(param);
        list.sort(Comparator.comparing(BudgetProjectDetailChangeEntity::getSequen, Comparator.nullsLast(BigDecimal::compareTo)));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("budgetProjectDetail-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refBudgetProjectChangeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectChangeVO>> refBudgetProjectChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetProjectChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"budgetProjectDetail-import.xlsx", (String)"\u5207\u5305\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, @RequestParam Long id) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        int codeIndex = 0;
        int nameIndex = 1;
        int featureIndex = 2;
        int unitIndex = 3;
        int contractNumIndex = 10;
        int checkEngineeringNumIndex = 11;
        int materialPriceIndex = 17;
        int fixPriceIndex = 18;
        int bigPackNameIndex = 4;
        int puchaseFlagIndex = 5;
        int materialPackNameIndex = 6;
        int materialPackCodeIndex = 7;
        int engineeringPackNameIndex = 8;
        int engineeringPackCodeIndex = 9;
        int itemCodeIndex = 13;
        int itemNameIndex = 14;
        int itemFeatureIndex = 15;
        int itemUnitIndex = 16;
        int itemNumIndex = 12;
        int upperMaterialPriceIndex = 21;
        int upperFixPriceIndex = 22;
        int upperPriceIndex = 23;
        int upperMoneyIndex = 24;
        List result = CostExcelReader.readExcel((MultipartFile)mf);
        ArrayList<BudgetProjectDetailChangeVO> successList = new ArrayList<BudgetProjectDetailChangeVO>();
        ArrayList<BudgetProjectDetailChangeVO> errorList = new ArrayList<BudgetProjectDetailChangeVO>();
        ArrayList<BudgetProjectDetailChangeVO> delList = new ArrayList<BudgetProjectDetailChangeVO>();
        if (result != null && result.size() > 0) {
            List datas;
            Map<Object, Object> bigPakgMap = new HashMap();
            CommonResponse resp = this.defdocApi.getDefDocByDefCode("professional-package");
            if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
                bigPakgMap = ((List)resp.getData()).stream().collect(Collectors.toMap(DefdocDetailVO::getName, v -> v, (p1, p2) -> p1));
            }
            Map<Object, Object> subTypeCodeMap = new HashMap();
            CommonResponse subTypeList = this.subTypeApi.getSubTypeList();
            if (subTypeList.isSuccess() && subTypeList.getData() != null) {
                subTypeCodeMap = ((List)subTypeList.getData()).stream().collect(Collectors.toMap(SubTypeVO::getLongCode, v -> v, (p1, p2) -> p1));
            }
            Map<Object, Object> secondCategoryCodeMap = new HashMap();
            CommonResponse secondCategoryList = this.materialCategoryApi.getMaterialSecondCategoryList();
            if (secondCategoryList.isSuccess() && secondCategoryList.getData() != null) {
                secondCategoryCodeMap = ((List)secondCategoryList.getData()).stream().collect(Collectors.toMap(MaterialCategoryVO::getCode, v -> v, (p1, p2) -> p1));
            }
            BudgetProjectChangeEntity changeEntity = (BudgetProjectChangeEntity)((Object)this.service.getById(id));
            String optType = changeEntity.getOptType();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(BudgetProjectDetailChangeEntity::getBudgetId, (Object)id);
            List oldListen = this.detailChangeService.list((Wrapper)wrapper);
            List oldList = BeanMapper.mapList((Iterable)oldListen, BudgetProjectDetailChangeVO.class);
            oldList.sort(Comparator.comparing(BudgetProjectDetailChangeVO::getSequen, Comparator.nullsLast(BigDecimal::compareTo)));
            HashMap<String, BudgetProjectDetailChangeVO> codeMap = new HashMap<String, BudgetProjectDetailChangeVO>();
            HashMap<String, BudgetProjectDetailChangeVO> itemCodeOldDataMap = new HashMap<String, BudgetProjectDetailChangeVO>();
            HashMap<String, Long> packUpMap = new HashMap<String, Long>();
            for (BudgetProjectDetailChangeVO detailChangeVO : oldList) {
                itemCodeOldDataMap.put(detailChangeVO.getItemCode(), detailChangeVO);
                codeMap.put(detailChangeVO.getCode(), detailChangeVO);
                String code = detailChangeVO.getCode();
                if (detailChangeVO.getPackUpId() == null) continue;
                packUpMap.put(code, detailChangeVO.getPackUpId());
            }
            BigDecimal preSeq = ((BudgetProjectDetailChangeVO)oldList.get(0)).getSequen();
            if ("BG".equals(optType)) {
                for (int i = 0; i < result.size(); ++i) {
                    String itemCode;
                    String materialPackCode;
                    datas = (List)result.get(i);
                    StringBuilder errMsg = new StringBuilder();
                    BudgetProjectDetailChangeVO detailVO = new BudgetProjectDetailChangeVO();
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(codeIndex)))) {
                        detailVO.setCode(((String)datas.get(codeIndex)).trim());
                    } else {
                        detailVO.setCode(null);
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(nameIndex)))) {
                        detailVO.setName(((String)datas.get(nameIndex)).trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(featureIndex)))) {
                        detailVO.setFeature(((String)datas.get(featureIndex)).trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(unitIndex)))) {
                        detailVO.setUnit(((String)datas.get(unitIndex)).trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(contractNumIndex))) && StringUtils.isNotBlank((CharSequence)((String)datas.get(contractNumIndex)).trim())) {
                        detailVO.setContractNum(ComputeUtil.scale((BigDecimal)ComputeUtil.toBigDecimal((String)((String)datas.get(contractNumIndex)).replace(",", "")), (int)8));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(checkEngineeringNumIndex))) && StringUtils.isNotBlank((CharSequence)((String)datas.get(checkEngineeringNumIndex)).trim())) {
                        detailVO.setCheckEngineeringNum(ComputeUtil.scale((BigDecimal)ComputeUtil.toBigDecimal((String)((String)datas.get(checkEngineeringNumIndex)).replace(",", "")), (int)8));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(materialPriceIndex))) && StringUtils.isNotBlank((CharSequence)((String)datas.get(materialPriceIndex)).trim())) {
                        detailVO.setMaterialPrice(ComputeUtil.scale((BigDecimal)ComputeUtil.toBigDecimal((String)((String)datas.get(materialPriceIndex)).replace(",", "")), (int)8));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(fixPriceIndex))) && StringUtils.isNotBlank((CharSequence)((String)datas.get(fixPriceIndex)).trim())) {
                        detailVO.setFixPrice(ComputeUtil.scale((BigDecimal)ComputeUtil.toBigDecimal((String)((String)datas.get(fixPriceIndex)).replace(",", "")), (int)8));
                    }
                    detailVO.setPrice(ComputeUtil.safeAdd((BigDecimal)detailVO.getMaterialPrice(), (BigDecimal)detailVO.getFixPrice()));
                    detailVO.setMoney(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detailVO.getPrice(), (BigDecimal)detailVO.getContractNum())));
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(bigPackNameIndex)))) {
                        detailVO.setBigPackName(((String)datas.get(bigPackNameIndex)).trim());
                        DefdocDetailVO defdocDetailVO = (DefdocDetailVO)bigPakgMap.get(detailVO.getBigPackName());
                        if (defdocDetailVO == null) {
                            errMsg.append("`\u5927\u5305\u540d\u79f0\u672a\u5339\u914d`");
                        } else {
                            detailVO.setBigPackSid(defdocDetailVO.getAttrCode());
                            detailVO.setBigPackId(defdocDetailVO.getId());
                            detailVO.setBigPackCode(defdocDetailVO.getCode());
                        }
                    } else {
                        errMsg.append("`\u5927\u5305\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a`");
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(puchaseFlagIndex)))) {
                        detailVO.setPuchaseFlag((String)datas.get(puchaseFlagIndex));
                        if ("\u662f,\u5426".contains(detailVO.getPuchaseFlag())) {
                            detailVO.setPuchaseFlag("\u662f".equals(detailVO.getPuchaseFlag()) ? "Y" : "N");
                        }
                    } else {
                        errMsg.append("`\u662f\u5426\u516c\u53f8\u91c7\u8d2d\u4e0d\u80fd\u4e3a\u7a7a`");
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(materialPackCodeIndex)))) {
                        materialPackCode = ((String)datas.get(materialPackCodeIndex)).trim();
                        detailVO.setMaterialPackCode(materialPackCode);
                        MaterialCategoryVO materialCategoryVO = null;
                        materialCategoryVO = materialPackCode.contains("-") ? (MaterialCategoryVO)secondCategoryCodeMap.get(materialPackCode.split("-")[0]) : (MaterialCategoryVO)secondCategoryCodeMap.get(materialPackCode);
                        if (materialCategoryVO == null) {
                            errMsg.append("`\u6750\u6599\u5305\u4ee3\u7801\u672a\u5339\u914d`");
                        } else {
                            detailVO.setMaterialPackSid(materialCategoryVO.getSourceId());
                            detailVO.setMaterialPackId(materialCategoryVO.getId());
                            detailVO.setMaterialPackName(materialCategoryVO.getName());
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(engineeringPackCodeIndex)))) {
                        materialPackCode = ((String)datas.get(engineeringPackCodeIndex)).trim();
                        detailVO.setEngineeringPackCode(materialPackCode);
                        SubTypeVO subTypeVO = null;
                        subTypeVO = materialPackCode.contains("-") ? (SubTypeVO)subTypeCodeMap.get(materialPackCode.split("-")[0]) : (SubTypeVO)subTypeCodeMap.get(detailVO.getEngineeringPackCode());
                        if (subTypeVO == null) {
                            errMsg.append("`\u5de5\u7a0b\u5305\u4ee3\u7801\u672a\u5339\u914d`");
                        } else {
                            detailVO.setEngineeringPackSid(subTypeVO.getSourceId());
                            detailVO.setEngineeringPackId(subTypeVO.getId());
                            detailVO.setEngineeringPackName(subTypeVO.getName());
                        }
                    } else if (StringUtils.isBlank((CharSequence)detailVO.getMaterialPackCode())) {
                        errMsg.append("`\u6750\u6599\u5305\u4ee3\u7801\u548c\u5de5\u7a0b\u5305\u4ee3\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a`");
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(itemCodeIndex))) && StringUtils.isNotBlank((CharSequence)detailVO.getCode()) && StringUtils.isNotBlank((CharSequence)(itemCode = ((String)datas.get(itemCodeIndex)).trim())) && !itemCode.startsWith(detailVO.getCode())) {
                        detailVO.setItemCode(null);
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(itemCodeIndex)))) {
                        detailVO.setItemCode(((String)datas.get(itemCodeIndex)).trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(itemNameIndex)))) {
                        detailVO.setItemName(((String)datas.get(itemNameIndex)).trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(itemFeatureIndex)))) {
                        detailVO.setItemFeature(((String)datas.get(itemFeatureIndex)).trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(itemUnitIndex)))) {
                        detailVO.setItemUnit(((String)datas.get(itemUnitIndex)).trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(itemNumIndex)))) {
                        detailVO.setItemNum(ComputeUtil.scale((BigDecimal)ComputeUtil.toBigDecimal((String)((String)datas.get(itemNumIndex)).replace(",", "")), (int)8));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(upperMaterialPriceIndex)))) {
                        detailVO.setUpperMaterialPrice(ComputeUtil.scale((BigDecimal)ComputeUtil.toBigDecimal((String)((String)datas.get(upperMaterialPriceIndex)).replace(",", "")), (int)8));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(upperFixPriceIndex)))) {
                        detailVO.setUpperFixPrice(ComputeUtil.scale((BigDecimal)ComputeUtil.toBigDecimal((String)((String)datas.get(upperFixPriceIndex)).replace(",", "")), (int)8));
                    }
                    detailVO.setUpperPrice(ComputeUtil.safeAdd((BigDecimal)detailVO.getUpperMaterialPrice(), (BigDecimal)detailVO.getUpperFixPrice()));
                    detailVO.setUpperMoney(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detailVO.getUpperPrice(), (BigDecimal)Optional.ofNullable(detailVO.getItemNum()).orElse(detailVO.getCheckEngineeringNum()))));
                    if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                        detailVO.setErrorMessage(errMsg.toString());
                        errorList.add(detailVO);
                        continue;
                    }
                    String itemCode1 = detailVO.getItemCode();
                    if (StringUtils.isNotBlank((CharSequence)itemCode1) && itemCodeOldDataMap.containsKey(itemCode1)) {
                        BudgetProjectDetailChangeVO oldDetailChangeVO = (BudgetProjectDetailChangeVO)itemCodeOldDataMap.get(itemCode1);
                        detailVO.setId(oldDetailChangeVO.getId());
                        detailVO.setBudgetId(oldDetailChangeVO.getBudgetId());
                        detailVO.setVersion(oldDetailChangeVO.getVersion());
                        detailVO.setTenantId(oldDetailChangeVO.getTenantId());
                        detailVO.setCreateUserCode(oldDetailChangeVO.getCreateUserCode());
                        detailVO.setCreateTime(oldDetailChangeVO.getCreateTime());
                        detailVO.setUpdateUserCode(oldDetailChangeVO.getUpdateUserCode());
                        detailVO.setUpdateTime(oldDetailChangeVO.getUpdateTime());
                        detailVO.setPackUpId((Long)packUpMap.get(detailVO.getCode()));
                        detailVO.setPackUpFlag(oldDetailChangeVO.getPackUpFlag());
                        detailVO.setChangeId(oldDetailChangeVO.getChangeId());
                        detailVO.setChangeBid(oldDetailChangeVO.getChangeBid());
                        detailVO.setSequen(oldDetailChangeVO.getSequen());
                        detailVO.setChangeType(oldDetailChangeVO.getChangeType());
                        detailVO.setMaterialListId(oldDetailChangeVO.getMaterialListId());
                        detailVO.setEngineeringListId(oldDetailChangeVO.getEngineeringListId());
                        if ("0".equals(detailVO.getChangeType())) {
                            List fieldDifferences = CompareDifferenceUtil.compareObj((Object)oldDetailChangeVO, (Object)detailVO);
                            if ("update".equals(detailVO.getChangeFlag())) {
                                detailVO.setChangeType("3");
                            } else {
                                detailVO.setChangeType("0");
                            }
                            detailVO.setFieldDifferences(fieldDifferences);
                        }
                        if (detailVO.getMaterialPackId() != null) {
                            detailVO.setMaterialListId(oldDetailChangeVO.getMaterialListId());
                        }
                        if (detailVO.getEngineeringPackId() != null) {
                            detailVO.setEngineeringListId(oldDetailChangeVO.getEngineeringListId());
                        }
                        if (detailVO.getMaterialPackId() != null) {
                            detailVO.setMaterialListId(oldDetailChangeVO.getMaterialListId());
                        }
                        itemCodeOldDataMap.remove(itemCode1);
                    } else {
                        detailVO.setChangeType("1");
                        detailVO.setItemCode(null);
                        detailVO.setId(Long.valueOf(IdWorker.getId()));
                    }
                    if (detailVO.getSequen() == null) {
                        detailVO.setSequen(ComputeUtil.safeAdd((BigDecimal)preSeq, (BigDecimal)PER_SEQ));
                    }
                    preSeq = detailVO.getSequen();
                    successList.add(detailVO);
                }
                if (MapUtils.isNotEmpty(itemCodeOldDataMap)) {
                    for (BudgetProjectDetailChangeVO detailChangeVO : itemCodeOldDataMap.values()) {
                        detailChangeVO.setChangeType("2");
                        delList.add(detailChangeVO);
                    }
                }
            } else {
                for (int i = 0; i < result.size(); ++i) {
                    String materialPackCode;
                    datas = (List)result.get(i);
                    StringBuilder errMsg = new StringBuilder();
                    BudgetProjectDetailChangeVO detailVO = new BudgetProjectDetailChangeVO();
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(codeIndex)))) {
                        detailVO.setCode(((String)datas.get(codeIndex)).trim());
                    } else {
                        detailVO.setCode(null);
                    }
                    if (StringUtils.isNotBlank((CharSequence)detailVO.getCode()) && !codeMap.containsKey(detailVO.getCode())) {
                        errMsg.append("`\u4e0d\u80fd\u589e\u52a0\u65b0\u7684\u4e0a\u5305\u6e05\u5355\u9879\u76ee\u7f16\u7801`");
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(nameIndex)))) {
                        detailVO.setName(((String)datas.get(nameIndex)).trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(featureIndex)))) {
                        detailVO.setFeature(((String)datas.get(featureIndex)).trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(unitIndex)))) {
                        detailVO.setUnit(((String)datas.get(unitIndex)).trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(contractNumIndex))) && StringUtils.isNotBlank((CharSequence)((String)datas.get(contractNumIndex)).trim())) {
                        detailVO.setContractNum(ComputeUtil.scale((BigDecimal)ComputeUtil.toBigDecimal((String)((String)datas.get(contractNumIndex)).replace(",", "")), (int)8));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(checkEngineeringNumIndex))) && StringUtils.isNotBlank((CharSequence)((String)datas.get(checkEngineeringNumIndex)).trim())) {
                        detailVO.setCheckEngineeringNum(ComputeUtil.scale((BigDecimal)ComputeUtil.toBigDecimal((String)((String)datas.get(checkEngineeringNumIndex)).replace(",", "")), (int)8));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(materialPriceIndex))) && StringUtils.isNotBlank((CharSequence)((String)datas.get(materialPriceIndex)).trim())) {
                        detailVO.setMaterialPrice(ComputeUtil.scale((BigDecimal)ComputeUtil.toBigDecimal((String)((String)datas.get(materialPriceIndex)).replace(",", "")), (int)8));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(fixPriceIndex))) && StringUtils.isNotBlank((CharSequence)((String)datas.get(fixPriceIndex)).trim())) {
                        detailVO.setFixPrice(ComputeUtil.scale((BigDecimal)ComputeUtil.toBigDecimal((String)((String)datas.get(fixPriceIndex)).replace(",", "")), (int)8));
                    }
                    detailVO.setPrice(ComputeUtil.safeAdd((BigDecimal)detailVO.getMaterialPrice(), (BigDecimal)detailVO.getFixPrice()));
                    detailVO.setMoney(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detailVO.getPrice(), (BigDecimal)detailVO.getContractNum())));
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(bigPackNameIndex)))) {
                        detailVO.setBigPackName(((String)datas.get(bigPackNameIndex)).trim());
                        DefdocDetailVO defdocDetailVO = (DefdocDetailVO)bigPakgMap.get(detailVO.getBigPackName());
                        if (defdocDetailVO == null) {
                            errMsg.append("`\u5927\u5305\u540d\u79f0\u672a\u5339\u914d`");
                        } else {
                            detailVO.setBigPackSid(defdocDetailVO.getAttrCode());
                            detailVO.setBigPackId(defdocDetailVO.getId());
                            detailVO.setBigPackCode(defdocDetailVO.getCode());
                        }
                    } else {
                        errMsg.append("`\u5927\u5305\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a`");
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(puchaseFlagIndex)))) {
                        detailVO.setPuchaseFlag((String)datas.get(puchaseFlagIndex));
                    } else {
                        errMsg.append("`\u662f\u5426\u516c\u53f8\u91c7\u8d2d\u4e0d\u80fd\u4e3a\u7a7a`");
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(materialPackCodeIndex)))) {
                        materialPackCode = ((String)datas.get(materialPackCodeIndex)).trim();
                        detailVO.setMaterialPackCode(materialPackCode);
                        MaterialCategoryVO materialCategoryVO = null;
                        materialCategoryVO = materialPackCode.contains("-") ? (MaterialCategoryVO)secondCategoryCodeMap.get(materialPackCode.split("-")[0]) : (MaterialCategoryVO)secondCategoryCodeMap.get(materialPackCode);
                        if (materialCategoryVO == null) {
                            errMsg.append("`\u6750\u6599\u5305\u4ee3\u7801\u672a\u5339\u914d`");
                        } else {
                            detailVO.setMaterialPackSid(materialCategoryVO.getSourceId());
                            detailVO.setMaterialPackId(materialCategoryVO.getId());
                            detailVO.setMaterialPackName(materialCategoryVO.getName());
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(engineeringPackCodeIndex)))) {
                        materialPackCode = ((String)datas.get(engineeringPackCodeIndex)).trim();
                        detailVO.setEngineeringPackCode(materialPackCode);
                        SubTypeVO subTypeVO = null;
                        subTypeVO = materialPackCode.contains("-") ? (SubTypeVO)subTypeCodeMap.get(materialPackCode.split("-")[0]) : (SubTypeVO)subTypeCodeMap.get(detailVO.getEngineeringPackCode());
                        if (subTypeVO == null) {
                            errMsg.append("`\u5de5\u7a0b\u5305\u4ee3\u7801\u672a\u5339\u914d`");
                        } else {
                            detailVO.setEngineeringPackSid(subTypeVO.getSourceId());
                            detailVO.setEngineeringPackId(subTypeVO.getId());
                            detailVO.setEngineeringPackName(subTypeVO.getName());
                        }
                    } else if (StringUtils.isBlank((CharSequence)detailVO.getMaterialPackCode())) {
                        errMsg.append("`\u6750\u6599\u5305\u4ee3\u7801\u548c\u5de5\u7a0b\u5305\u4ee3\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a`");
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(itemCodeIndex)))) {
                        detailVO.setItemCode(((String)datas.get(itemCodeIndex)).trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(itemNameIndex)))) {
                        detailVO.setItemName(((String)datas.get(itemNameIndex)).trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(itemFeatureIndex)))) {
                        detailVO.setItemFeature(((String)datas.get(itemFeatureIndex)).trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(itemUnitIndex)))) {
                        detailVO.setItemUnit(((String)datas.get(itemUnitIndex)).trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(itemNumIndex)))) {
                        detailVO.setItemNum(ComputeUtil.scale((BigDecimal)ComputeUtil.toBigDecimal((String)((String)datas.get(itemNumIndex)).replace(",", "")), (int)8));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(upperMaterialPriceIndex)))) {
                        detailVO.setUpperMaterialPrice(ComputeUtil.scale((BigDecimal)ComputeUtil.toBigDecimal((String)((String)datas.get(upperMaterialPriceIndex)).replace(",", "")), (int)8));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(upperFixPriceIndex)))) {
                        detailVO.setUpperFixPrice(ComputeUtil.scale((BigDecimal)ComputeUtil.toBigDecimal((String)((String)datas.get(upperFixPriceIndex)).replace(",", "")), (int)8));
                    }
                    detailVO.setUpperPrice(ComputeUtil.safeAdd((BigDecimal)detailVO.getUpperMaterialPrice(), (BigDecimal)detailVO.getUpperFixPrice()));
                    detailVO.setUpperMoney(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detailVO.getUpperPrice(), (BigDecimal)Optional.ofNullable(detailVO.getItemNum()).orElse(detailVO.getCheckEngineeringNum()))));
                    if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                        detailVO.setErrorMessage(errMsg.toString());
                        errorList.add(detailVO);
                        continue;
                    }
                    String itemCode = detailVO.getItemCode();
                    if (StringUtils.isNotBlank((CharSequence)itemCode) && itemCodeOldDataMap.containsKey(itemCode)) {
                        BudgetProjectDetailChangeVO oldDetailChangeVO = (BudgetProjectDetailChangeVO)itemCodeOldDataMap.get(itemCode);
                        detailVO.setCode(oldDetailChangeVO.getCode());
                        detailVO.setName(oldDetailChangeVO.getName());
                        detailVO.setFeature(oldDetailChangeVO.getFeature());
                        detailVO.setUnit(oldDetailChangeVO.getUnit());
                        detailVO.setContractNum(oldDetailChangeVO.getContractNum());
                        detailVO.setCheckEngineeringNum(oldDetailChangeVO.getCheckEngineeringNum());
                        detailVO.setMaterialPrice(oldDetailChangeVO.getMaterialPrice());
                        detailVO.setFixPrice(oldDetailChangeVO.getFixPrice());
                        detailVO.setPrice(oldDetailChangeVO.getPrice());
                        detailVO.setMoney(oldDetailChangeVO.getMoney());
                        detailVO.setPackUpId(oldDetailChangeVO.getPackUpId());
                        detailVO.setPackUpFlag(oldDetailChangeVO.getPackUpFlag());
                        detailVO.setId(oldDetailChangeVO.getId());
                        detailVO.setBudgetId(oldDetailChangeVO.getBudgetId());
                        detailVO.setVersion(oldDetailChangeVO.getVersion());
                        detailVO.setTenantId(oldDetailChangeVO.getTenantId());
                        detailVO.setCreateUserCode(oldDetailChangeVO.getCreateUserCode());
                        detailVO.setCreateTime(oldDetailChangeVO.getCreateTime());
                        detailVO.setUpdateUserCode(oldDetailChangeVO.getUpdateUserCode());
                        detailVO.setUpdateTime(oldDetailChangeVO.getUpdateTime());
                        detailVO.setChangeId(oldDetailChangeVO.getChangeId());
                        detailVO.setChangeBid(oldDetailChangeVO.getChangeBid());
                        detailVO.setChangeType(oldDetailChangeVO.getChangeType());
                        detailVO.setSequen(oldDetailChangeVO.getSequen());
                        detailVO.setMaterialListId(oldDetailChangeVO.getMaterialListId());
                        detailVO.setEngineeringListId(oldDetailChangeVO.getEngineeringListId());
                        if (detailVO.getMaterialPackId() != null) {
                            detailVO.setMaterialListId(oldDetailChangeVO.getMaterialListId());
                        }
                        if (detailVO.getEngineeringPackId() != null) {
                            detailVO.setEngineeringListId(oldDetailChangeVO.getEngineeringListId());
                        }
                        if (detailVO.getMaterialPackId() != null) {
                            detailVO.setMaterialListId(oldDetailChangeVO.getMaterialListId());
                        }
                        if ("0".equals(detailVO.getChangeType())) {
                            List fieldDifferences = CompareDifferenceUtil.compareObj((Object)oldDetailChangeVO, (Object)detailVO);
                            detailVO.setFieldDifferences(fieldDifferences);
                            if ("update".equals(detailVO.getChangeFlag())) {
                                detailVO.setChangeType("3");
                            } else {
                                detailVO.setChangeType("0");
                            }
                        }
                        itemCodeOldDataMap.remove(itemCode);
                    } else {
                        detailVO.setChangeType("1");
                        if (StringUtils.isNotBlank((CharSequence)detailVO.getCode()) && itemCode.contains(detailVO.getCode())) {
                            BudgetProjectDetailChangeVO detailChangeVO = (BudgetProjectDetailChangeVO)codeMap.get(detailVO.getCode());
                            detailVO.setName(detailChangeVO.getName());
                            detailVO.setFeature(detailChangeVO.getFeature());
                            detailVO.setUnit(detailChangeVO.getUnit());
                            detailVO.setPackUpId(detailChangeVO.getPackUpId());
                            detailVO.setPackUpFlag(detailChangeVO.getPackUpFlag());
                        }
                        detailVO.setItemCode(null);
                        detailVO.setId(Long.valueOf(IdWorker.getId()));
                    }
                    if (detailVO.getSequen() == null) {
                        detailVO.setSequen(ComputeUtil.safeAdd((BigDecimal)preSeq, (BigDecimal)PER_SEQ));
                    }
                    preSeq = detailVO.getSequen();
                    if ("1".equals(detailVO.getChangeType()) && StringUtils.isBlank((CharSequence)detailVO.getCode())) {
                        detailVO.setErrorMessage("`\u4e0a\u5305\u6e05\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a`");
                        errorList.add(detailVO);
                        continue;
                    }
                    successList.add(detailVO);
                }
                if (MapUtils.isNotEmpty(itemCodeOldDataMap)) {
                    for (BudgetProjectDetailChangeVO detailChangeVO : itemCodeOldDataMap.values()) {
                        delList.add(detailChangeVO);
                    }
                }
            }
        }
        List allList = Stream.concat(successList.stream(), delList.stream()).collect(Collectors.toList());
        allList.sort(Comparator.comparing(BudgetProjectDetailChangeVO::getSequen, Comparator.nullsLast(BigDecimal::compareTo)));
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("delList", delList);
        json.put("allList", allList);
        return CommonResponse.success((Object)json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="ai\u7269\u6599\u8bc6\u522b")
    @RequestMapping(value={"/materialConjecture"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> materialConjecture(@RequestParam Long id, HttpServletRequest request) {
        String lockKey = "AiMaterialKey_" + id;
        boolean locked = this.redissonLocker.isLocked(lockKey);
        if (locked) {
            return CommonResponse.success((String)"\u6b63\u5728\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u540e...");
        }
        BudgetProjectChangeEntity entity = (BudgetProjectChangeEntity)((Object)this.service.selectById(id));
        List<BudgetProjectDetailChangeEntity> budgetProjectDetailList = entity.getBudgetProjectDetailList();
        Boolean isDL = "DL".equals(entity.getOptType());
        budgetProjectDetailList = isDL != false ? budgetProjectDetailList.stream().filter(t -> t.getMaterialPackId() != null && StringUtils.isNotBlank((CharSequence)t.getItemFeature()) && !"2".equals(t.getChangeType())).collect(Collectors.toList()) : budgetProjectDetailList.stream().filter(t -> t.getMaterialPackId() != null && StringUtils.isNotBlank((CharSequence)t.getFeature()) && !"2".equals(t.getChangeType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(budgetProjectDetailList)) {
            return CommonResponse.error((String)"\u6ca1\u6709\u9700\u8981\u8bc6\u522b\u7684\u7269\u6599\uff01");
        }
        String uuid = UUID.randomUUID().toString();
        ArrayList<MaterialConjectureVO> materialConjectureVOS = new ArrayList<MaterialConjectureVO>();
        MaterialConjectureVO materialConjectureVO = null;
        for (BudgetProjectDetailChangeEntity projectDetailEntity : budgetProjectDetailList) {
            materialConjectureVO = new MaterialConjectureVO();
            if (isDL.booleanValue()) {
                materialConjectureVO.setSourceMaterialName(projectDetailEntity.getItemFeature());
                materialConjectureVO.setSourceMaterialSpec(projectDetailEntity.getItemFeature());
            } else {
                materialConjectureVO.setSourceMaterialName(projectDetailEntity.getFeature());
                materialConjectureVO.setSourceMaterialSpec(projectDetailEntity.getFeature());
            }
            materialConjectureVO.setIdentificationId(uuid);
            materialConjectureVO.setMateType("4");
            materialConjectureVO.setIdentificationDate(new Date());
            materialConjectureVO.setBudgetDetailId(projectDetailEntity.getId());
            materialConjectureVO.setBillId(id);
            materialConjectureVO.setBillCode(entity.getBillCode());
            materialConjectureVOS.add(materialConjectureVO);
        }
        try {
            this.redissonLocker.lock(lockKey, materialConjectureVOS.size());
            AiMaterialThread aiMaterialThread = new AiMaterialThread();
            String authority = request.getHeader("authority");
            aiMaterialThread.setAuthority(authority);
            aiMaterialThread.setMaterialConjectureApi(this.materialConjectureApi);
            aiMaterialThread.setMaterialConjectureVOS(materialConjectureVOS);
            Thread thread = new Thread(aiMaterialThread);
            thread.start();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)id);
            updateWrapper.set(BudgetProjectChangeEntity::getIdentificationId, (Object)uuid);
            updateWrapper.set(BudgetProjectChangeEntity::getIdentificationState, (Object)1);
            this.service.update((Wrapper)updateWrapper);
        }
        catch (Exception e) {
            this.logger.info("ai\u7269\u6599\u8bc6\u522b\u5931\u8d25\uff0c", (Throwable)e);
            this.redissonLocker.unlock(lockKey);
            CommonResponse commonResponse = CommonResponse.error((String)"ai\u7269\u6599\u8bc6\u522b\u5931\u8d25");
            return commonResponse;
        }
        return CommonResponse.success((String)"AI\u7269\u6599\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u67e5\u770b\uff01");
    }
}

