package com.ejianc.business.zdscost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailPackageVO;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.consts.ChangTypeConst;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.vo.query.BudgetProjectDetailQueryVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zdscost.mapper.BudgetProjectDetailMapper;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 切包清单-明细
 *
 * @author generator
 *
 */
@Service("budgetProjectDetailService")
public class BudgetProjectDetailServiceImpl extends BaseServiceImpl<BudgetProjectDetailMapper, BudgetProjectDetailEntity> implements IBudgetProjectDetailService {
    @Autowired
    private IBudgetProjectService budgetProjectService;

    @Override
    public List queryPackageList(Page<Map> page, BudgetProjectDetailQueryVO queryVO) {
        String projectSid = queryVO.getProjectSid();
        String paramStr = queryVO.getParamStr();
        String packageFlag = "";
        String packageCode = "";
        String packageName = "";
        if (StringUtils.isNotEmpty(paramStr)) {
            String[] split = paramStr.split(",");
            packageFlag = split.length > 0 ? split[0] : null;
            packageCode = split.length > 1 ? split[1] : null;
            packageName = split.length > 2 ? split[2] : null;
        }
        return baseMapper.queryPackageList(page, projectSid, packageFlag, packageCode, packageName);
    }

    @Override
    public List<BudgetProjectDetailPackageVO> queryPackageTree(Long id) {
        return baseMapper.queryPackageTree(id);
    }


    @Override
    public JSONObject queryDetailNoAuth(String projectSid, String packageCode) {
        JSONObject result = new JSONObject();
        LambdaQueryWrapper<BudgetProjectEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BudgetProjectEntity::getProjectSid, projectSid);
        queryWrapper.in(BudgetProjectEntity::getBillState, "1,3");
        List<BudgetProjectEntity> list1 = budgetProjectService.list(queryWrapper);
        List<Long> ids = new ArrayList();
        if (CollectionUtils.isNotEmpty(list1)) {
            ids = list1.stream().map(BudgetProjectEntity::getId).collect(Collectors.toList());
        } else {
            ids.add(1l);
        }

        QueryParam queryParam = new QueryParam();
        Map<String, Parameter> params = queryParam.getParams();
        /** 租户隔离 */
        params.put("budgetId", new Parameter(QueryParam.IN, ids));
        params.put("changeType", new Parameter(QueryParam.NE, ChangTypeConst.DELETE));
        List<BudgetProjectDetailEntity> list = super.queryList(queryParam, false);
        result.put("budgetProjectDetailList", list);
        if (StringUtil.isNotBlank(packageCode)) {
            params.put("SQL", new Parameter(QueryParam.SQL, "(engineering_pack_code = '" + packageCode + "' or material_pack_code = '" + packageCode + "' )"));
            List<BudgetProjectDetailEntity> selfDetailList = super.queryList(queryParam, false);
            result.put("selfDetailList", selfDetailList);
        }
        return result;
    }

    @Override
    public IPage<BudgetProjectDetailEntity> refBudgetProjectDetailData(Page<BudgetProjectDetailEntity> page, QueryParam param) {
        QueryWrapper<BudgetProjectDetailEntity> qw = changeToQueryWrapper(param);
        qw.groupBy("material_pack_code");
        IPage<BudgetProjectDetailEntity> list = baseMapper.selectPage(page, qw);
        for (BudgetProjectDetailEntity detailVO : list.getRecords()) {
            detailVO.setMaterialPackName(null != detailVO.getMaterialPackCode() ?
                    detailVO.getMaterialPackName() + detailVO.getMaterialPackCode() : detailVO.getMaterialPackName());
            detailVO.setEngineeringPackName(null != detailVO.getEngineeringPackCode() ?
                    detailVO.getEngineeringPackName() + detailVO.getEngineeringPackCode() : detailVO.getEngineeringPackName());
        }
        return list;
    }

    @Override
    public List<BudgetProjectDetailPackageVO> queryPackageDetailList(Page<BudgetProjectDetailPackageVO> page, Long budgetId, QueryWrapper qw) {
        return baseMapper.queryPackageDetailList(page, budgetId, qw);
    }

    @Override
    public List<String> queryDianLiangPackCode(Long budgetId) {
        List<BudgetProjectDetailPackageVO> budgetProjectDetailPackageVOS = baseMapper.queryDianLiangPackCode(budgetId);
        return budgetProjectDetailPackageVOS.stream().map(BudgetProjectDetailPackageVO::getCode).collect(Collectors.toList());
    }

    @Override
    public List<String> queryItemCodeList(Long budgetId, Long changeId) {
        return baseMapper.queryItemCodeList(budgetId, changeId);
    }


}
