package com.ejianc.business.zdsmaterial.erp.vo;

import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 领航发票实体
 * 
 * @author generator
 * 
 */
public class ErpInvoiceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String typeCode; // 发票种类代码
    private String typeName; // 发票种类名称
    private String statusCode; // 发票状态代码
    private String statusName; // 发票状态名称
    private String code; // 发票代码
    private String number; // 发票号码
    private BigDecimal mny; // 发票金额
    private Date invoiceDate; // 开票日期
    private String saleTaxNumber; // 销方税号
    private String saleName; // 销方名称
    private String invoiceTitle; // 发票抬头
    private String memo; // 备注
    private String sourceId; //ERPId
    private String quoteFlag; //引用标识：0-未引用，1-已引用

    private String erpQuoteFlag;// ERP引用标记：0-未引用，1-已引用
    private String goodsName; //ERP引用发票物料名称
    private String erpRegisterName;//ERP引用发票注册人名称
    private String erpCreateTime;//ERP引用发票创建时间
    private String erpQuoteBillCode; //ERP引用发票单据编码

    private String usedFlag; //引用标识，参照显示使用，0-未引用，1-已引用

    private List<ErpInvoiceDetailVO> detailList = new ArrayList<>(); // 领航发票子实体

    public String getUsedFlag() {
        return PlanConstant.STRING_YES.equals(this.quoteFlag) || PlanConstant.STRING_YES.equals(this.erpQuoteFlag) ?
                PlanConstant.STRING_YES : PlanConstant.STRING_NO;
    }

    public void setUsedFlag(String usedFlag) {
        this.usedFlag = usedFlag;
    }

    public String getErpQuoteBillCode() {
        return erpQuoteBillCode;
    }

    public void setErpQuoteBillCode(String erpQuoteBillCode) {
        this.erpQuoteBillCode = erpQuoteBillCode;
    }

    public String getErpQuoteFlag() {
        return erpQuoteFlag;
    }

    public void setErpQuoteFlag(String erpQuoteFlag) {
        this.erpQuoteFlag = erpQuoteFlag;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getErpRegisterName() {
        return erpRegisterName;
    }

    public void setErpRegisterName(String erpRegisterName) {
        this.erpRegisterName = erpRegisterName;
    }

    public String getErpCreateTime() {
        return erpCreateTime;
    }

    public void setErpCreateTime(String erpCreateTime) {
        this.erpCreateTime = erpCreateTime;
    }

    public String getQuoteFlag() {
        return quoteFlag;
    }

    public void setQuoteFlag(String quoteFlag) {
        this.quoteFlag = quoteFlag;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }
    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
    public String getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }
    public String getStatusName() {
        return statusName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }
    public String getSaleTaxNumber() {
        return saleTaxNumber;
    }

    public void setSaleTaxNumber(String saleTaxNumber) {
        this.saleTaxNumber = saleTaxNumber;
    }
    public String getSaleName() {
        return saleName;
    }

    public void setSaleName(String saleName) {
        this.saleName = saleName;
    }
    public String getInvoiceTitle() {
        return invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<ErpInvoiceDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ErpInvoiceDetailVO> detailList) {
        this.detailList = detailList;
    }
}
