package com.ejianc.business.zdsmaterial.sub.fee.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 分包费用申请实体
 * 
 * @author generator
 * 
 */
public class SubFeeApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long contractId; // 合同主键
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private String sourceContractId; // 合同来源主键
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 单据组织id
    private String orgCode; // 单据组织编码
    private String orgName; // 单据组织名称
    private Long parentOrgId; // 上级组织id
    private String parentOrgCode; // 上级组织编码
    private String parentOrgName; // 上级组织名称
    private Long supplierId; // 供应商id
    private String supplierCode; // 供应商编码
    private String supplierName; // 供应商名称
    private Long compileId; // 编制人
    private String compileCode; // 编制人编码
    private String compileName; // 编制人名称
    private String billCode; // 单据编码
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 单据日期
    private Integer billState; // 单据状态（审批必须字段）
    private Long createUserId; // 制单人Id
    private BigDecimal fuJiaMoney; // 附加合同额
    private BigDecimal settleSumMoney; // 分包结算金额
    private BigDecimal appearMoney; // 累积已批金额
    private Long partyContactsId; // 乙方联系人主键
    private String partyContacts; // 乙方联系人
    private Long auditWorkerId; // 审核工程师id
    private String auditWorkerName; // 审核工程师
    private Long projectManagerId; // 项目经理主键
    private String projectManagerName; // 项目经理名称
    private Long customerId; // 合同甲方
    private String customerName; // 合同甲方名称
    private BigDecimal contractMoney; // 合同金额
    private Long bankId; // 银行主键
    private String bankName; // 银行名称
    private String bankCode; // 银行账号
    private String payType; // 付款类型 0-预付款、1-进度款、2-完工款、3-结算款、4-质保金、5-调整项
    private String applyType; // 申请状态 0-待提交,1-待审核,2-分包未打印,3-分包已打印,4-已驳回,5-已报审,6-审批通过
    private BigDecimal sumMny; // 累计申请金额
    private BigDecimal applyMny; // 本期申请金额
    private BigDecimal deductMny; // 本期扣款金额
    private BigDecimal payMny; // 本期支付金额
    private BigDecimal corporateMny; // 对公付款
    private BigDecimal migrantMny; // 农民工专项付款
    private BigDecimal approveMny; // 本期审核金额
    private Long sourceId; // 来源主键ID
    private Integer sourceType; // 来源方式，1-项目发起,2-供方发起
    private String systemId; // 来源系统主键
    private String billPushFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    private String supOperatorUserCode; // 
    private String supOperatorPhone; // 
    private String supOperatorName; //
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date supOperateTime; //
    private BigDecimal applyNum; // 本期完工量
    private String createUserName;// 编制者名称
    private String billStateName; // 单据状态名称
    
    private List<SubFeeApplyDetailVO> detailList = new ArrayList<>(); // 分包费用申请清单
    private List<SubFeeApplyDeductVO> deductList = new ArrayList<>(); // 分包费用申请扣款
    private List<SubFeeApplyApproveVO> approveList = new ArrayList<>(); // 分包费用申请暂缓审批

    @ReferSerialTransfer(referCode="sub-contract-ref")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getSourceContractId() {
        return sourceContractId;
    }

    public void setSourceContractId(String sourceContractId) {
        this.sourceContractId = sourceContractId;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    @ReferSerialTransfer(referCode="zds-sub-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getCompileId() {
        return compileId;
    }

    @ReferDeserialTransfer
    public void setCompileId(Long compileId) {
        this.compileId = compileId;
    }

    public String getCompileCode() {
        return compileCode;
    }

    public void setCompileCode(String compileCode) {
        this.compileCode = compileCode;
    }
    public String getCompileName() {
        return compileName;
    }

    public void setCompileName(String compileName) {
        this.compileName = compileName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public BigDecimal getFuJiaMoney() {
        return fuJiaMoney;
    }

    public void setFuJiaMoney(BigDecimal fuJiaMoney) {
        this.fuJiaMoney = fuJiaMoney;
    }
    public BigDecimal getSettleSumMoney() {
        return settleSumMoney;
    }

    public void setSettleSumMoney(BigDecimal settleSumMoney) {
        this.settleSumMoney = settleSumMoney;
    }
    public BigDecimal getAppearMoney() {
        return appearMoney;
    }

    public void setAppearMoney(BigDecimal appearMoney) {
        this.appearMoney = appearMoney;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getPartyContactsId() {
        return partyContactsId;
    }

    @ReferDeserialTransfer
    public void setPartyContactsId(Long partyContactsId) {
        this.partyContactsId = partyContactsId;
    }

    public String getPartyContacts() {
        return partyContacts;
    }

    public void setPartyContacts(String partyContacts) {
        this.partyContacts = partyContacts;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getAuditWorkerId() {
        return auditWorkerId;
    }

    @ReferDeserialTransfer
    public void setAuditWorkerId(Long auditWorkerId) {
        this.auditWorkerId = auditWorkerId;
    }

    public String getAuditWorkerName() {
        return auditWorkerName;
    }

    public void setAuditWorkerName(String auditWorkerName) {
        this.auditWorkerName = auditWorkerName;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectManagerId() {
        return projectManagerId;
    }

    @ReferDeserialTransfer
    public void setProjectManagerId(Long projectManagerId) {
        this.projectManagerId = projectManagerId;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public BigDecimal getContractMoney() {
        return contractMoney;
    }

    public void setContractMoney(BigDecimal contractMoney) {
        this.contractMoney = contractMoney;
    }

    @ReferSerialTransfer(referCode="sub-supplier-bank")
    public Long getBankId() {
        return bankId;
    }

    @ReferDeserialTransfer
    public void setBankId(Long bankId) {
        this.bankId = bankId;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }
    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }
    public String getApplyType() {
        return applyType;
    }

    public void setApplyType(String applyType) {
        this.applyType = applyType;
    }
    public BigDecimal getSumMny() {
        return sumMny;
    }

    public void setSumMny(BigDecimal sumMny) {
        this.sumMny = sumMny;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public BigDecimal getDeductMny() {
        return deductMny;
    }

    public void setDeductMny(BigDecimal deductMny) {
        this.deductMny = deductMny;
    }
    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }
    public BigDecimal getCorporateMny() {
        return corporateMny;
    }

    public void setCorporateMny(BigDecimal corporateMny) {
        this.corporateMny = corporateMny;
    }
    public BigDecimal getMigrantMny() {
        return migrantMny;
    }

    public void setMigrantMny(BigDecimal migrantMny) {
        this.migrantMny = migrantMny;
    }
    public BigDecimal getApproveMny() {
        return approveMny;
    }

    public void setApproveMny(BigDecimal approveMny) {
        this.approveMny = approveMny;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }
    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }
    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }
    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }
    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public BigDecimal getApplyNum() {
        return applyNum;
    }

    public void setApplyNum(BigDecimal applyNum) {
        this.applyNum = applyNum;
    }

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<SubFeeApplyDetailVO> getDetailList() {
        return detailList;
     }

     public void setDetailList(List<SubFeeApplyDetailVO> detailList) {
        this.detailList = detailList;
     }
     public List<SubFeeApplyDeductVO> getDeductList() {
        return deductList;
     }

     public void setDeductList(List<SubFeeApplyDeductVO> deductList) {
        this.deductList = deductList;
     }
     public List<SubFeeApplyApproveVO> getApproveList() {
        return approveList;
     }

     public void setApproveList(List<SubFeeApplyApproveVO> approveList) {
        this.approveList = approveList;
     }
}
