package com.ejianc.business.zdsmaterial.erp.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 订单
 * 
 * @author generator
 * 
 */
public class OrderVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String sourceOrderId; // ERP订单主键, 来源于总价合同时为空
    private String sourceOrderCode; // ERP订单编码
    private String billCode; // 单据编码
    private Long contractId; // 合同id
    private String contractName; // 合同
    private String contractCode; // 合同编码
    private String sourceContractId; // ERP合同主键
    private Integer contractPriceType; // 计价方式：1-单价合同，2-总价合同；备注：总价合同订单由合同自动生成
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 单据组织id
    private String orgName; // 单据组织名称
    private String orgCode; // 单据组织编码
    private Long parentOrgId; // 上级组织id
    private String parentOrgName; // 上级组织名称
    private String parentOrgCode; // 上级组织编码
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商
    private String supplierCode; // 供应商编码
    private String supplierLinkName; // 供应商联系人
    private String supplierLinkPhone; // 供应商联系人手机号
    private Long supplierManagerSupId; //乙方联系人供方用户Id
    private String supplierLinkerSid;//乙方联系人Sid;
    private Long acceptorId; // 接收人id
    private String acceptorName; // 接收人名称
    private String acceptorSid; // 接收人ERP主键
    private String acceptorCode; // 接收人编码
    private String acceptorLinkPhone; // 接收人电话
    private Long purchaseUserId; // 采购人id
    private String purchaseUserSid; // 采购人ERP主键
    private String purchaseUserName; // 采购人名称
    private String purchaseUserCode; // 采购人编码
    private String purchaseUserLinkPhone; // 采购人电话
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date deliveryDate; // 交货日期
    private BigDecimal orderTaxMny; // 订单金额（含税）
    private BigDecimal orderMny; // 订单金额
    private BigDecimal deliveredTaxMny; // 已发货金额（含税）
    private BigDecimal deliveredMny; // 已发货金额
    private BigDecimal totalAcceptTaxMny; // 订单验收金额（含税）
    private BigDecimal totalAcceptMny; // 订单验收金额
    private BigDecimal handAcceptTaxMny; // 自制验收金额（含税）
    private BigDecimal handAcceptMny; // 自制验收金额
    private Integer deliveryStatus; // 订单发货状态：0-待发货，1-部分发货，2-全部发货 ?自制验收
    private Integer enableStatus; // 订单停启用状态：1-启用，2-停用
    private String memo; // 备注
    private String signUserId; // 确认人id
    private String signUserName; // 确认人名称
    private String signUserPhone; // 确认人手机号
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date signTime; // 确认时间
    private Integer signatureStatus; // 确认状态 0:未确认;1:已确认; 
    private Long supplierTenantId; // 供方租户主键

    private String deliveryAddress; //送货地址
    private String deliveryRemark; //送货要求

    private String remark; //备注
    private Long projectManagementId; // 项目经理
    private List<OrderDetailVO> detailList = new ArrayList<>(); // 订单明细

    private List<DeliveryVO> deliveriedList = new ArrayList<>();

    private BigDecimal approvedTaxMny; //已审金额
    private BigDecimal balanceTaxMny; //订单余额  采购订单的余额=订单金额-已批准的采购费用金额之和

    private String sysLastUpd; //ERP最后更新时间

    private String isOfficialSeal;//是否盖章

    public String getIsOfficialSeal() {
        return isOfficialSeal;
    }

    public void setIsOfficialSeal(String isOfficialSeal) {
        this.isOfficialSeal = isOfficialSeal;
    }

    public String getAcceptorSid() {
        return acceptorSid;
    }

    public void setAcceptorSid(String acceptorSid) {
        this.acceptorSid = acceptorSid;
    }

    public String getPurchaseUserSid() {
        return purchaseUserSid;
    }

    public void setPurchaseUserSid(String purchaseUserSid) {
        this.purchaseUserSid = purchaseUserSid;
    }

    public String getSupplierLinkerSid() {
        return supplierLinkerSid;
    }

    public void setSupplierLinkerSid(String supplierLinkerSid) {
        this.supplierLinkerSid = supplierLinkerSid;
    }

    public String getSysLastUpd() {
        return sysLastUpd;
    }

    public void setSysLastUpd(String sysLastUpd) {
        this.sysLastUpd = sysLastUpd;
    }

    /**
     * 来源业务单据Id
     */
    private String sourceId;

    /**
     * 来源业务系统id
     */
    private String sourceSystemId;
    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    private String billPushFlag;

    private Integer freezeStatus;//1-正常 2-暂停

    public Long getSupplierManagerSupId() {
        return supplierManagerSupId;
    }

    public void setSupplierManagerSupId(Long supplierManagerSupId) {
        this.supplierManagerSupId = supplierManagerSupId;
    }

    public BigDecimal getApprovedTaxMny() {
        return approvedTaxMny;
    }

    public void setApprovedTaxMny(BigDecimal approvedTaxMny) {
        this.approvedTaxMny = approvedTaxMny;
    }

    public BigDecimal getBalanceTaxMny() {
        return balanceTaxMny;
    }

    public void setBalanceTaxMny(BigDecimal balanceTaxMny) {
        this.balanceTaxMny = balanceTaxMny;
    }

    public Long getProjectManagementId() {
        return projectManagementId;
    }

    public void setProjectManagementId(Long projectManagementId) {
        this.projectManagementId = projectManagementId;
    }

    public Integer getFreezeStatus() {
        return freezeStatus;
    }

    public void setFreezeStatus(Integer freezeStatus) {
        this.freezeStatus = freezeStatus;
    }

    public List<DeliveryVO> getDeliveriedList() {
        return deliveriedList;
    }

    public void setDeliveriedList(List<DeliveryVO> deliveriedList) {
        this.deliveriedList = deliveriedList;
    }

    public BigDecimal getTotalAcceptTaxMny() {
        return totalAcceptTaxMny;
    }

    public void setTotalAcceptTaxMny(BigDecimal totalAcceptTaxMny) {
        this.totalAcceptTaxMny = totalAcceptTaxMny;
    }

    public BigDecimal getTotalAcceptMny() {
        return totalAcceptMny;
    }

    public void setTotalAcceptMny(BigDecimal totalAcceptMny) {
        this.totalAcceptMny = totalAcceptMny;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public String getSourceOrderId() {
        return sourceOrderId;
    }

    public void setSourceOrderId(String sourceOrderId) {
        this.sourceOrderId = sourceOrderId;
    }
    public String getSourceOrderCode() {
        return sourceOrderCode;
    }

    public void setSourceOrderCode(String sourceOrderCode) {
        this.sourceOrderCode = sourceOrderCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getSourceContractId() {
        return sourceContractId;
    }

    public void setSourceContractId(String sourceContractId) {
        this.sourceContractId = sourceContractId;
    }
    public Integer getContractPriceType() {
        return contractPriceType;
    }

    public void setContractPriceType(Integer contractPriceType) {
        this.contractPriceType = contractPriceType;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
    public String getSupplierLinkName() {
        return supplierLinkName;
    }

    public void setSupplierLinkName(String supplierLinkName) {
        this.supplierLinkName = supplierLinkName;
    }
    public String getSupplierLinkPhone() {
        return supplierLinkPhone;
    }

    public void setSupplierLinkPhone(String supplierLinkPhone) {
        this.supplierLinkPhone = supplierLinkPhone;
    }
    public Long getAcceptorId() {
        return acceptorId;
    }

    public void setAcceptorId(Long acceptorId) {
        this.acceptorId = acceptorId;
    }
    public String getAcceptorName() {
        return acceptorName;
    }

    public void setAcceptorName(String acceptorName) {
        this.acceptorName = acceptorName;
    }
    public String getAcceptorCode() {
        return acceptorCode;
    }

    public void setAcceptorCode(String acceptorCode) {
        this.acceptorCode = acceptorCode;
    }
    public String getAcceptorLinkPhone() {
        return acceptorLinkPhone;
    }

    public void setAcceptorLinkPhone(String acceptorLinkPhone) {
        this.acceptorLinkPhone = acceptorLinkPhone;
    }
    public Long getPurchaseUserId() {
        return purchaseUserId;
    }

    public void setPurchaseUserId(Long purchaseUserId) {
        this.purchaseUserId = purchaseUserId;
    }
    public String getPurchaseUserName() {
        return purchaseUserName;
    }

    public void setPurchaseUserName(String purchaseUserName) {
        this.purchaseUserName = purchaseUserName;
    }
    public String getPurchaseUserCode() {
        return purchaseUserCode;
    }

    public void setPurchaseUserCode(String purchaseUserCode) {
        this.purchaseUserCode = purchaseUserCode;
    }
    public String getPurchaseUserLinkPhone() {
        return purchaseUserLinkPhone;
    }

    public void setPurchaseUserLinkPhone(String purchaseUserLinkPhone) {
        this.purchaseUserLinkPhone = purchaseUserLinkPhone;
    }
    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }
    public BigDecimal getOrderTaxMny() {
        return orderTaxMny;
    }

    public void setOrderTaxMny(BigDecimal orderTaxMny) {
        this.orderTaxMny = orderTaxMny;
    }
    public BigDecimal getOrderMny() {
        return orderMny;
    }

    public void setOrderMny(BigDecimal orderMny) {
        this.orderMny = orderMny;
    }
    public BigDecimal getDeliveredTaxMny() {
        return deliveredTaxMny;
    }

    public void setDeliveredTaxMny(BigDecimal deliveredTaxMny) {
        this.deliveredTaxMny = deliveredTaxMny;
    }
    public BigDecimal getDeliveredMny() {
        return deliveredMny;
    }

    public void setDeliveredMny(BigDecimal deliveredMny) {
        this.deliveredMny = deliveredMny;
    }
    public BigDecimal getHandAcceptTaxMny() {
        return handAcceptTaxMny;
    }

    public void setHandAcceptTaxMny(BigDecimal handAcceptTaxMny) {
        this.handAcceptTaxMny = handAcceptTaxMny;
    }
    public BigDecimal getHandAcceptMny() {
        return handAcceptMny;
    }

    public void setHandAcceptMny(BigDecimal handAcceptMny) {
        this.handAcceptMny = handAcceptMny;
    }
    public Integer getDeliveryStatus() {
        return deliveryStatus;
    }

    public void setDeliveryStatus(Integer deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }
    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getSignUserId() {
        return signUserId;
    }

    public void setSignUserId(String signUserId) {
        this.signUserId = signUserId;
    }
    public String getSignUserName() {
        return signUserName;
    }

    public void setSignUserName(String signUserName) {
        this.signUserName = signUserName;
    }
    public String getSignUserPhone() {
        return signUserPhone;
    }

    public void setSignUserPhone(String signUserPhone) {
        this.signUserPhone = signUserPhone;
    }
    public Date getSignTime() {
        return signTime;
    }

    public void setSignTime(Date signTime) {
        this.signTime = signTime;
    }
    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }
    public Long getSupplierTenantId() {
        return supplierTenantId;
    }

    public void setSupplierTenantId(Long supplierTenantId) {
        this.supplierTenantId = supplierTenantId;
    }
    
     public List<OrderDetailVO> getDetailList() {
        return detailList;
     }

     public void setDetailList(List<OrderDetailVO> detailList) {
        this.detailList = detailList;
     }

    public String getDeliveryAddress() {
        return deliveryAddress;
    }

    public void setDeliveryAddress(String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public String getDeliveryRemark() {
        return deliveryRemark;
    }

    public void setDeliveryRemark(String deliveryRemark) {
        this.deliveryRemark = deliveryRemark;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
