package com.ejianc.business.zdsmaterial.erp.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 发货单
 *
 * @author generator
 *
 */
public class DeliveryVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long contractId; // 合同id
    private String contractName; // 合同
    private String contractCode; // 合同编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 单据组织id
    private String orgName; // 单据组织名称
    private String orgCode; // 单据组织编码
    private Long parentOrgId; // 上级组织id
    private String parentOrgName; // 上级组织名称
    private String parentOrgCode; // 上级组织编码
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商
    private String supplierCode; // 供应商编码
    private String supplierLinkName; // 供应商联系人
    private String supplierLinkPhone; // 供应商联系人手机号
    private Long supplierDeliveryId; // 发货人id
    private String supplierDeliveryName; // 发货人名称
    private String supplierDeliveryCode; // 发货人编码
    private String supplierDeliveryPhone; // 发货人手机号
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date supplierDeliveryDate; // 发货时间
    private Long siteAcceptorId; // 现场验收人id
    private String siteAcceptorName; // 现场验收人name
    private String siteAcceptorCode; // 现场验收人编码
    private String siteAcceptorLinkPhone; //现场验收人电话
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date predictArrivalDate; // 预计到货日期
    private String carCode; // 车牌号
    private String deliveryDriverName; // 发货司机名称
    private String deliveryDriverPhone; // 送货司机电话
    private Integer acceptStatus; // 验收状态 1:待验收;2:验收中;3部分验收，4全部验收;
    private BigDecimal deliveryTaxMny; // 本次发货金额（含税）
    private BigDecimal deliveryMny; // 本次发货金额
    private String orderCode; // 订单编码
    private Long orderId; // 订单id
    private String billCode; // 单据编码
    private String deliveryCode; //单据编码；数据库字段，订单显示使用
    private Integer billState; // 单据提交状态：0-暂存,1-提交
    private String memo; // 备注
    private Long supplierTenantId; // 供方租户主键

    private Integer closeStatus; //关闭状态:0-未关闭，1-已关闭
    private String acceptContent; // 发货单内容
    private String deliveryAddress; // 送货地址

    private String acceptStatusStr;
    /**
     * 来源业务单据Id
     */
    private String sourceId;

    /**
     * 来源业务系统id
     */
    private String sourceSystemId;

    private String changePorterSid; // 转签ERP接货人SID
    private Long changePorterId; // 转签ERP接货人主键
    private String changePorterName; // 转签ERP接货人名称
    private String changePorterCode; // 转签ERP接货人编码

    private List<DeliveryDetailVO> detailList = new ArrayList<>(); // 发货单-物资清单
    private List<TransmitVO> transmitList = new ArrayList<>(); // 发货单-验收转签记录

    public String getDeliveryCode() {
        return this.billCode;
    }

    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }

    public String getDeliveryDriverPhone() {
        return deliveryDriverPhone;
    }

    public void setDeliveryDriverPhone(String deliveryDriverPhone) {
        this.deliveryDriverPhone = deliveryDriverPhone;
    }

    public String getSiteAcceptorLinkPhone() {
        return siteAcceptorLinkPhone;
    }

    public void setSiteAcceptorLinkPhone(String siteAcceptorLinkPhone) {
        this.siteAcceptorLinkPhone = siteAcceptorLinkPhone;
    }

    public String getAcceptStatusStr() {
        return acceptStatusStr;
    }

    public void setAcceptStatusStr(String acceptStatusStr) {
        this.acceptStatusStr = acceptStatusStr;
    }

    public String getDeliveryAddress() {
        return deliveryAddress;
    }

    public void setDeliveryAddress(String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public String getAcceptContent() {
        return acceptContent;
    }

    public void setAcceptContent(String acceptContent) {
        this.acceptContent = acceptContent;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public Integer getCloseStatus() {
        return closeStatus;
    }

    public void setCloseStatus(Integer closeStatus) {
        this.closeStatus = closeStatus;
    }


    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
    public String getSupplierLinkName() {
        return supplierLinkName;
    }

    public void setSupplierLinkName(String supplierLinkName) {
        this.supplierLinkName = supplierLinkName;
    }
    public String getSupplierLinkPhone() {
        return supplierLinkPhone;
    }

    public void setSupplierLinkPhone(String supplierLinkPhone) {
        this.supplierLinkPhone = supplierLinkPhone;
    }
    public Long getSupplierDeliveryId() {
        return supplierDeliveryId;
    }

    public void setSupplierDeliveryId(Long supplierDeliveryId) {
        this.supplierDeliveryId = supplierDeliveryId;
    }
    public String getSupplierDeliveryName() {
        return supplierDeliveryName;
    }

    public void setSupplierDeliveryName(String supplierDeliveryName) {
        this.supplierDeliveryName = supplierDeliveryName;
    }
    public String getSupplierDeliveryCode() {
        return supplierDeliveryCode;
    }

    public void setSupplierDeliveryCode(String supplierDeliveryCode) {
        this.supplierDeliveryCode = supplierDeliveryCode;
    }
    public String getSupplierDeliveryPhone() {
        return supplierDeliveryPhone;
    }

    public void setSupplierDeliveryPhone(String supplierDeliveryPhone) {
        this.supplierDeliveryPhone = supplierDeliveryPhone;
    }
    public Date getSupplierDeliveryDate() {
        return supplierDeliveryDate;
    }

    public void setSupplierDeliveryDate(Date supplierDeliveryDate) {
        this.supplierDeliveryDate = supplierDeliveryDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSiteAcceptorId() {
        return siteAcceptorId;
    }
    @ReferDeserialTransfer
    public void setSiteAcceptorId(Long siteAcceptorId) {
        this.siteAcceptorId = siteAcceptorId;
    }
    public String getSiteAcceptorName() {
        return siteAcceptorName;
    }

    public void setSiteAcceptorName(String siteAcceptorName) {
        this.siteAcceptorName = siteAcceptorName;
    }
    public String getSiteAcceptorCode() {
        return siteAcceptorCode;
    }

    public void setSiteAcceptorCode(String siteAcceptorCode) {
        this.siteAcceptorCode = siteAcceptorCode;
    }
    public Date getPredictArrivalDate() {
        return predictArrivalDate;
    }

    public void setPredictArrivalDate(Date predictArrivalDate) {
        this.predictArrivalDate = predictArrivalDate;
    }
    public String getCarCode() {
        return carCode;
    }

    public void setCarCode(String carCode) {
        this.carCode = carCode;
    }
    public String getDeliveryDriverName() {
        return deliveryDriverName;
    }

    public void setDeliveryDriverName(String deliveryDriverName) {
        this.deliveryDriverName = deliveryDriverName;
    }
    public Integer getAcceptStatus() {
        return acceptStatus;
    }

    public void setAcceptStatus(Integer acceptStatus) {
        this.acceptStatus = acceptStatus;
    }
    public BigDecimal getDeliveryTaxMny() {
        return deliveryTaxMny;
    }

    public void setDeliveryTaxMny(BigDecimal deliveryTaxMny) {
        this.deliveryTaxMny = deliveryTaxMny;
    }
    public BigDecimal getDeliveryMny() {
        return deliveryMny;
    }

    public void setDeliveryMny(BigDecimal deliveryMny) {
        this.deliveryMny = deliveryMny;
    }
    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }
    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getSupplierTenantId() {
        return supplierTenantId;
    }

    public void setSupplierTenantId(Long supplierTenantId) {
        this.supplierTenantId = supplierTenantId;
    }

    public String getChangePorterSid() {
        return changePorterSid;
    }

    public void setChangePorterSid(String changePorterSid) {
        this.changePorterSid = changePorterSid;
    }

    public Long getChangePorterId() {
        return changePorterId;
    }

    public void setChangePorterId(Long changePorterId) {
        this.changePorterId = changePorterId;
    }

    public String getChangePorterName() {
        return changePorterName;
    }

    public void setChangePorterName(String changePorterName) {
        this.changePorterName = changePorterName;
    }

    public String getChangePorterCode() {
        return changePorterCode;
    }

    public void setChangePorterCode(String changePorterCode) {
        this.changePorterCode = changePorterCode;
    }

    public List<DeliveryDetailVO> getDetailList() {
        return detailList;
     }

     public void setDetailList(List<DeliveryDetailVO> detailList) {
        this.detailList = detailList;
     }

    public List<TransmitVO> getTransmitList() {
        return transmitList;
    }

    public void setTransmitList(List<TransmitVO> transmitList) {
        this.transmitList = transmitList;
    }
}
