package com.ejianc.business.zdsmaterial.erp.api;

import com.ejianc.business.zdsmaterial.erp.hystrix.ZDSContractHystrix;
import com.ejianc.business.zdsmaterial.erp.vo.ContractVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author CJ
 * @Description:
 * @date 2024/1/26 13:45
 */
@FeignClient(name = "ejc-zdsmaterial-web", url = "${common.env.feign-client-url}", path = "ejc-zdsmaterial-web", fallback = ZDSContractHystrix.class)
public interface IZDSContractApi {

    @GetMapping(value = "/api/zdscontract/getContractDetail")
    CommonResponse<ContractVO> getContractDetail(@RequestParam Long contractId);

}
