package com.ejianc.business.zdsmaterial.erp.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 品牌申请主实体
 * 
 * @author generator
 * 
 */
public class BrandApplyVO extends BaseVO {

    private static final long serialVersionUID = 9198584014358599921L;
    private String billCode; // 编码
    private Long applyUserId; // 申请人id
    private String applyUserSid; // 申请人名称
    private String applyUserName; // 申请人名称
    private String applyUserCode; // 申请人账号
    private String memo; // 申请说明
    private Long secOrgId; // 申请人所属二级单位id
    private String secOrgName; // 申请人所属二级单位名称
    private String secOrgCode; // 申请人所属二级单位编码
    private Integer billState; // 单据状态
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人编码
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveDate; // 生效日期
    private String brandNames; //品牌名称

    private String billStateStr;

    private List<BrandApplyDetailVO> detailList = new ArrayList<>(); // 品牌申请字表-品牌明细

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public String getBrandNames() {
        return brandNames;
    }

    public void setBrandNames(String brandNames) {
        this.brandNames = brandNames;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getApplyUserId() {
        return applyUserId;
    }

    @ReferDeserialTransfer
    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }
    public String getApplyUserSid() {
        return applyUserSid;
    }

    public void setApplyUserSid(String applyUserSid) {
        this.applyUserSid = applyUserSid;
    }
    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }
    public String getApplyUserCode() {
        return applyUserCode;
    }

    public void setApplyUserCode(String applyUserCode) {
        this.applyUserCode = applyUserCode;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getSecOrgId() {
        return secOrgId;
    }

    @ReferDeserialTransfer
    public void setSecOrgId(Long secOrgId) {
        this.secOrgId = secOrgId;
    }
    public String getSecOrgName() {
        return secOrgName;
    }

    public void setSecOrgName(String secOrgName) {
        this.secOrgName = secOrgName;
    }
    public String getSecOrgCode() {
        return secOrgCode;
    }

    public void setSecOrgCode(String secOrgCode) {
        this.secOrgCode = secOrgCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public List<BrandApplyDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<BrandApplyDetailVO> detailList) {
        this.detailList = detailList;
    }
}
