package com.ejianc.business.zdsmaterial.erp.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.Date;

/**
 * ERP同步任务执行记录
 *
 * @author CJ
 * @Description:
 * @date 2024/8/15 10:45
 */
public class SyncJobExecRecordsVO extends BaseVO {

    private static final long serialVersionUID = -1489485272889711654L;

    public static final String QUEUE_NAME = "el_sync_erp_data_job";

    private String reqUrl; //请求URL
    private String reqParam; //请求参数
    private String execResult;//失败类型：0-同步任务执行失败，1-任务执行成功
    private Date execTime; //任务执行时间
    private String erpErrResult;//ERP接口返回失败信息
    private String exceptionMsg;//处理异常信息

    public SyncJobExecRecordsVO() {
    }

    public SyncJobExecRecordsVO(String reqUrl, String reqParam, String execResult) {
        this(reqUrl, reqParam, execResult, new Date(), null, null);
    }

    public SyncJobExecRecordsVO(String reqUrl, String reqParam, String execResult, String erpErrResult, String exceptionMsg) {
        this(reqUrl, reqParam, execResult, new Date(), erpErrResult, exceptionMsg);
    }

    public SyncJobExecRecordsVO(String reqUrl, String reqParam, String execResult, Date execTime, String erpErrResult, String exceptionMsg) {
        this.reqUrl = reqUrl;
        this.reqParam = reqParam;
        this.execResult = execResult;
        this.execTime = execTime;
        this.erpErrResult = erpErrResult;
        this.exceptionMsg = exceptionMsg;
    }

    public String getReqUrl() {
        return reqUrl;
    }

    public void setReqUrl(String reqUrl) {
        this.reqUrl = reqUrl;
    }

    public String getReqParam() {
        return reqParam;
    }

    public void setReqParam(String reqParam) {
        this.reqParam = reqParam;
    }

    public String getExecResult() {
        return execResult;
    }

    public void setExecResult(String execResult) {
        this.execResult = execResult;
    }

    public Date getExecTime() {
        return execTime;
    }

    public void setExecTime(Date execTime) {
        this.execTime = execTime;
    }

    public String getErpErrResult() {
        return erpErrResult;
    }

    public void setErpErrResult(String erpErrResult) {
        this.erpErrResult = erpErrResult;
    }

    public String getExceptionMsg() {
        return exceptionMsg;
    }

    public void setExceptionMsg(String exceptionMsg) {
        this.exceptionMsg = exceptionMsg;
    }
}
