package com.ejianc.business.zdsmaterial.plan.purchase.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 采购计划详情
 * 
 * @author generator
 * 
 */
public class PurchasePlanDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long planId; // 计划id
    private Integer sourceType; // 来源： 0：参照总控计划清单； 1：参照常用材料库  该为总计划
    private Integer excessDetailFlag; // 是否超量明细 1：是； 0：否
    private Integer excessResidueDetailFlag; // 是否超剩余总量明细 1：是； 0：否
    private Integer workPlanFlag; // 是否有对应总工计划 1：是； 0：否
    private String part; // 部位
    private Long sourceId; // 来源单据主键
    private Long sourceDetailId; // 来源明细主键
    private String materialTypeName; // 物资分类名称
    private Long materialTypeId; // 物资分类id
    private String materialTypeSid; // 物资分类来源id
    private String materialCode; // 物资编码
    private String materialName; // 物资编码
    private Long materialTypePId; //物资分类上级分类Id
    private String materialTypePName;//物资分类上级分类名称
    private String materialTypePCode;//物资分类上级分类编码
    private Long materialId; // 物资id
    private String propertyValue; // 属性值
    private String propertyShowName; // 属性列表展示名称
    private String unitName; // 计量单位
    private Long unitId; // 计量单位
    private BigDecimal num; // 总控量
    private BigDecimal residueNum; // 总控量剩余量
    private BigDecimal requirementNum; // 需求量
    private BigDecimal totalRequirementNum; // 累计需求量
    private BigDecimal exceedNum; // 超总控量数量
    private Integer hasNewPropertyVal;
    private BigDecimal localAssignableNum; // 可调拨物资量(本大区)
    private BigDecimal otherAssignableNum; // 可调拨物资量(其他大区)
    private String excessCause; // 超量原因
    private String costCodingName; // 费用包
    private String costCodingCode; // 费用包编码
    private String costCodingId; // 费用包id
    private String memo; // 备注
    private String productCode; // 产品代码
    private String materialSerialNo; // 物资流水号
    private String materialTypeCode; // 物资分类编码
    private Long brandId; //品牌主键
    private String brandName; // 品牌名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planInDate;//计划到场日期
    private String property; // 属性
    private Integer detailIndex; // 序号

    private String detailAdditive;//添加剂
    private String detailDeliveryMode;//输送方式
    /**
     * 切包改造====
     */
    private Long materialPackId; // 切包情况-材料包id，二级物料类别
    private String materialPackCode; // 切包情况-材料包编码
    private String materialPackName; // 切包情况-材料包名称
    private String itemCode; // 清单编码
    private String itemName; // 清单名称
    private String budgetType; // 1:切包请单内2：切包清单外
    private Long budgetDetailId; // 清单子表ID

    /**
     * 切包改造end=====
     */

    public Long getMaterialPackId() {
        return materialPackId;
    }

    public void setMaterialPackId(Long materialPackId) {
        this.materialPackId = materialPackId;
    }

    public String getMaterialPackCode() {
        return materialPackCode;
    }

    public void setMaterialPackCode(String materialPackCode) {
        this.materialPackCode = materialPackCode;
    }

    public String getMaterialPackName() {
        return materialPackName;
    }

    public void setMaterialPackName(String materialPackName) {
        this.materialPackName = materialPackName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getBudgetType() {
        return budgetType;
    }

    public void setBudgetType(String budgetType) {
        this.budgetType = budgetType;
    }

    public Long getBudgetDetailId() {
        return budgetDetailId;
    }

    public void setBudgetDetailId(Long budgetDetailId) {
        this.budgetDetailId = budgetDetailId;
    }

    public Long getMaterialTypePId() {
        return materialTypePId;
    }

    public void setMaterialTypePId(Long materialTypePId) {
        this.materialTypePId = materialTypePId;
    }

    public String getMaterialTypePName() {
        return materialTypePName;
    }

    public void setMaterialTypePName(String materialTypePName) {
        this.materialTypePName = materialTypePName;
    }

    public String getMaterialTypePCode() {
        return materialTypePCode;
    }

    public void setMaterialTypePCode(String materialTypePCode) {
        this.materialTypePCode = materialTypePCode;
    }

    public String getDetailAdditive() {
        return detailAdditive;
    }

    public void setDetailAdditive(String detailAdditive) {
        this.detailAdditive = detailAdditive;
    }

    public String getDetailDeliveryMode() {
        return detailDeliveryMode;
    }

    public void setDetailDeliveryMode(String detailDeliveryMode) {
        this.detailDeliveryMode = detailDeliveryMode;
    }

    public Integer getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(Integer detailIndex) {
        this.detailIndex = detailIndex;
    }

    public String getMaterialTypeSid() {
        return materialTypeSid;
    }

    public void setMaterialTypeSid(String materialTypeSid) {
        this.materialTypeSid = materialTypeSid;
    }

    public String getProperty() {
        return property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Date getPlanInDate() {
        return planInDate;
    }

    public void setPlanInDate(Date planInDate) {
        this.planInDate = planInDate;
    }
    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    @ReferSerialTransfer(referCode="ref-zdsBrand")
    public Long getBrandId() {
        return brandId;
    }
    @ReferDeserialTransfer
    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }
    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public String getMaterialSerialNo() {
        return materialSerialNo;
    }

    public void setMaterialSerialNo(String materialSerialNo) {
        this.materialSerialNo = materialSerialNo;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public BigDecimal getTotalRequirementNum() {
        return totalRequirementNum;
    }

    public void setTotalRequirementNum(BigDecimal totalRequirementNum) {
        this.totalRequirementNum = totalRequirementNum;
    }

    public Integer getHasNewPropertyVal() {
        return hasNewPropertyVal;
    }

    public void setHasNewPropertyVal(Integer hasNewPropertyVal) {
        this.hasNewPropertyVal = hasNewPropertyVal;
    }

    public String getPropertyShowName() {
        return propertyShowName;
    }

    public void setPropertyShowName(String propertyShowName) {
        this.propertyShowName = propertyShowName;
    }

    public Integer getExcessResidueDetailFlag() {
        return excessResidueDetailFlag;
    }

    public void setExcessResidueDetailFlag(Integer excessResidueDetailFlag) {
        this.excessResidueDetailFlag = excessResidueDetailFlag;
    }

    public BigDecimal getExceedNum() {
        return exceedNum;
    }

    public void setExceedNum(BigDecimal exceedNum) {
        this.exceedNum = exceedNum;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    public Integer getExcessDetailFlag() {
        return excessDetailFlag;
    }

    public void setExcessDetailFlag(Integer excessDetailFlag) {
        this.excessDetailFlag = excessDetailFlag;
    }
    public Integer getWorkPlanFlag() {
        return workPlanFlag;
    }

    public void setWorkPlanFlag(Integer workPlanFlag) {
        this.workPlanFlag = workPlanFlag;
    }
    public String getPart() {
        return part;
    }

    public void setPart(String part) {
        this.part = part;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getPropertyValue() {
        return propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getResidueNum() {
        return residueNum;
    }

    public void setResidueNum(BigDecimal residueNum) {
        this.residueNum = residueNum;
    }
    public BigDecimal getRequirementNum() {
        return requirementNum;
    }

    public void setRequirementNum(BigDecimal requirementNum) {
        this.requirementNum = requirementNum;
    }
    public BigDecimal getLocalAssignableNum() {
        return localAssignableNum;
    }

    public void setLocalAssignableNum(BigDecimal localAssignableNum) {
        this.localAssignableNum = localAssignableNum;
    }
    public BigDecimal getOtherAssignableNum() {
        return otherAssignableNum;
    }

    public void setOtherAssignableNum(BigDecimal otherAssignableNum) {
        this.otherAssignableNum = otherAssignableNum;
    }
    public String getExcessCause() {
        return excessCause;
    }

    public void setExcessCause(String excessCause) {
        this.excessCause = excessCause;
    }
    public String getCostCodingName() {
        return costCodingName;
    }

    public void setCostCodingName(String costCodingName) {
        this.costCodingName = costCodingName;
    }
    public String getCostCodingCode() {
        return costCodingCode;
    }

    public void setCostCodingCode(String costCodingCode) {
        this.costCodingCode = costCodingCode;
    }
    public String getCostCodingId() {
        return costCodingId;
    }
    public void setCostCodingId(String costCodingId) {
        this.costCodingId = costCodingId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
