package com.ejianc.business.zdsmaterial.erp.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 发货单-物资清单
 * 
 * @author generator
 * 
 */
public class DeliveryDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long deliveryId; // 发货单Id
    private Long sourceDetailId; // 订单子表id
    private Long materialId; // 物资id
    private String materialName; // 物资名称
    private String materialCode; // 物资编码
    private String materialTypeName; // 物资分类名称
    private Long materialTypeId; // 物资分类id
    private String materialSerialNo; // 物资流水号
    private Long contractId; // 所属合同id
    private Long contractDetailId; // 合同明细id
    private BigDecimal contractNum; // 合同量
    private BigDecimal orderNum; // 订单量
    private BigDecimal deliveryNum; // 本次发货数量
    private BigDecimal alreadyNum; // 已验收量
    private BigDecimal releaseNum; // 未验收释放量（发货单全部验收时，=发货量-已验收量，释放订单发货量）
    private BigDecimal detailTaxPrice; // 单价（含税）
    private BigDecimal detailPrice; // 单价
    private BigDecimal detailTaxRate; // 税率
    private BigDecimal detailTaxMny; // 金额（含税）
    private BigDecimal detailMny; // 金额
    private BigDecimal detailTax; // 税额
    private String detailUnitName; // 计量单位
    private Long detailUnitId; // 计量单位id
    private String propertyValue; // 属性
    private String memo; // 备注
    private String productCode; //产品代码
    private Long brandId; //品牌主键
    private String brandName; // 品牌名称
    private String materialTypeCode; // 物资分类编码
    private BigDecimal canUseNum; // 未验收数量
    /**
     * 来源业务单据Id
     */
    private String sourceId;

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public BigDecimal getCanUseNum() {
        return canUseNum;
    }

    public void setCanUseNum(BigDecimal canUseNum) {
        this.canUseNum = canUseNum;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }
    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    @ReferSerialTransfer(referCode="ref-zdsBrand")
    public Long getBrandId() {
        return brandId;
    }
    @ReferDeserialTransfer
    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }
    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public Long getDeliveryId() {
        return deliveryId;
    }

    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialSerialNo() {
        return materialSerialNo;
    }

    public void setMaterialSerialNo(String materialSerialNo) {
        this.materialSerialNo = materialSerialNo;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }
    public BigDecimal getContractNum() {
        return contractNum;
    }

    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }
    public BigDecimal getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(BigDecimal orderNum) {
        this.orderNum = orderNum;
    }
    public BigDecimal getDeliveryNum() {
        return deliveryNum;
    }

    public void setDeliveryNum(BigDecimal deliveryNum) {
        this.deliveryNum = deliveryNum;
    }
    public BigDecimal getAlreadyNum() {
        return alreadyNum;
    }

    public void setAlreadyNum(BigDecimal alreadyNum) {
        this.alreadyNum = alreadyNum;
    }
    public BigDecimal getReleaseNum() {
        return releaseNum;
    }

    public void setReleaseNum(BigDecimal releaseNum) {
        this.releaseNum = releaseNum;
    }
    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }
    public BigDecimal getDetailPrice() {
        return detailPrice;
    }

    public void setDetailPrice(BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }
    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }
    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    public String getDetailUnitName() {
        return detailUnitName;
    }

    public void setDetailUnitName(String detailUnitName) {
        this.detailUnitName = detailUnitName;
    }
    public Long getDetailUnitId() {
        return detailUnitId;
    }

    public void setDetailUnitId(Long detailUnitId) {
        this.detailUnitId = detailUnitId;
    }
    public String getPropertyValue() {
        return propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
