/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cloudstore.constants.CommonConstants;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.bean.TransmitEntity;
import com.ejianc.business.zdsmaterial.erp.enums.DeliveryAcceptStatusEnums;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.erp.vo.DeliveryDetailVO;
import com.ejianc.business.zdsmaterial.erp.vo.DeliveryVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"delivery"})
public class DeliveryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    private static final String BILL_CODE = "ZDS-ADL";
    @Autowired
    private IDeliveryService service;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IPushMessageApi pushMessageApi;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<DeliveryVO> saveOrUpdate(@RequestBody DeliveryVO saveOrUpdateVO) {
        DeliveryEntity entity = (DeliveryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DeliveryEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
            Long siteAcceptorId = deliveryEntity.getSiteAcceptorId();
            if (!saveOrUpdateVO.getSiteAcceptorId().equals(siteAcceptorId)) {
                String siteAcceptorName = deliveryEntity.getSiteAcceptorName();
                String siteAcceptorCode = deliveryEntity.getSiteAcceptorCode();
                TransmitEntity transmitEntity = new TransmitEntity();
                transmitEntity.setDeliveryId(saveOrUpdateVO.getId());
                transmitEntity.setSiteAcceptorId(siteAcceptorId);
                transmitEntity.setSiteAcceptorName(siteAcceptorName);
                transmitEntity.setSiteAcceptorCode(siteAcceptorCode);
                transmitEntity.setSiteAcceptorLinkPhone(deliveryEntity.getSiteAcceptorLinkPhone());
                transmitEntity.setOperatorId(saveOrUpdateVO.getSiteAcceptorId());
                transmitEntity.setOperatorName(saveOrUpdateVO.getSiteAcceptorName());
                transmitEntity.setOperatorCode(saveOrUpdateVO.getSiteAcceptorCode());
                transmitEntity.setOperatorLinkPhone(saveOrUpdateVO.getSiteAcceptorLinkPhone());
                entity.getTransmitList().add(transmitEntity);
                this.logger.info("\u9a8c\u6536\u5355\u8f6c\u7b7e\u5411\u88ab\u8f6c\u7b7e\u4ebaid-{}\u53d1\u9001\u6d88\u606f", (Object)entity.getSiteAcceptorId().toString());
                PushMsgParameter parameter = new PushMsgParameter();
                parameter.setSubject("\u3010\u8ba2\u5355\u8f6c\u7b7e\u3011\uff1a\u3010" + entity.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u5df2\u53d1\u8d27\uff0c\u8bf7\u5c3d\u5feb\u9a8c\u6536\uff01");
                StringBuilder content = new StringBuilder();
                content.append("\u3010").append(entity.getBillCode()).append("\u3011\uff0c\u3010").append(entity.getProjectName()).append("\u3011\uff0c\u3010").append(entity.getContractName()).append("\u3011\uff0c\u3010").append(entity.getSupplierName()).append("\u3011\u7684\u8ba2\u5355\u5df2\u53d1\u8d27");
                parameter.setContent(content.toString());
                parameter.setPcUrl(this.BASE_HOST + CommonConstants.\u7269\u8d44\u9a8c\u6536PC\u8be6\u60c5 + entity.getId().toString());
                parameter.setMobileUrl(this.BASE_HOST + CommonConstants.\u7269\u8d44\u9a8c\u6536\u79fb\u52a8\u7aef\u8be6\u60c5 + entity.getId().toString());
                String[] recIds = new String[]{entity.getSiteAcceptorId().toString()};
                parameter.setReceivers(recIds);
                this.sendMsg(parameter, entity.getId(), "\u9a8c\u6536\u5355\u8f6c\u7b7e\u5411\u88ab\u8f6c\u7b7e\u4eba\u53d1\u9001\u4fe1\u606f");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{"sys", "email"});
        CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("{}-\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u5355\u636eId-{}\uff0c\u53d1\u9001\u6d88\u606f\u7ed3\u679c-{}", new Object[]{oprMsg, billId, JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        } else {
            this.logger.info("{}-\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01", (Object)oprMsg);
        }
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List records = new ArrayList();
        CommonResponse<IPage<DeliveryVO>> iPageCommonResponse = this.queryList(param);
        if (iPageCommonResponse.isSuccess()) {
            records = ((IPage)iPageCommonResponse.getData()).getRecords();
        }
        HashMap beans = new HashMap();
        records.forEach(vo -> {
            switch (vo.getAcceptStatus()) {
                case 1: {
                    vo.setAcceptStatusStr(DeliveryAcceptStatusEnums.\u5f85\u9a8c\u6536.getName());
                    break;
                }
                case 2: {
                    vo.setAcceptStatusStr(DeliveryAcceptStatusEnums.\u9a8c\u6536\u4e2d.getName());
                    break;
                }
                case 3: {
                    vo.setAcceptStatusStr(DeliveryAcceptStatusEnums.\u5206\u6279\u9a8c\u6536.getName());
                    break;
                }
                case 4: {
                    vo.setAcceptStatusStr(DeliveryAcceptStatusEnums.\u9a8c\u6536\u5b8c\u6210.getName());
                    break;
                }
                default: {
                    vo.setAcceptStatusStr(DeliveryAcceptStatusEnums.\u90e8\u5206\u9000\u56de.getName());
                }
            }
        });
        beans.put("records", records);
        ExcelExport.getInstance().export("Delivery-export.xlsx", beans, response);
    }

    @GetMapping(value={"/queryDetail"})
    public CommonResponse<DeliveryVO> queryDetail(Long id) {
        DeliveryEntity entity = (DeliveryEntity)((Object)this.service.selectById(id));
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<DeliveryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DeliveryVO deliveryVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/queryList"})
    public CommonResponse<IPage<DeliveryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("acceptContent");
        fuzzyFields.add("billCode");
        Map params = param.getParams();
        params.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("queryCoverage")) {
            if ("1".equals(((Parameter)param.getParams().get("queryCoverage")).getValue())) {
                params.put("siteAcceptorId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
            }
            param.getParams().remove("queryCoverage");
        }
        if (null == params.get("acceptStatus")) {
            params.put("acceptStatus", new Parameter("in", Arrays.asList(DeliveryAcceptStatusEnums.\u5f85\u9a8c\u6536.getCode(), DeliveryAcceptStatusEnums.\u5206\u6279\u9a8c\u6536.getCode())));
        }
        List orgVOList = null;
        if (null == params.get("projectId")) {
            Long orgId = InvocationInfoProxy.getOrgId();
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DeliveryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @GetMapping(value={"/refDeliveryData"})
    public CommonResponse<IPage<DeliveryVO>> refDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Map params = param.getParams();
        params.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (null == params.get("acceptStatus")) {
            params.put("acceptStatus", new Parameter("in", Arrays.asList(DeliveryAcceptStatusEnums.\u5f85\u9a8c\u6536.getCode(), DeliveryAcceptStatusEnums.\u5206\u6279\u9a8c\u6536.getCode())));
        }
        params.put("siteAcceptorId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
        List orgVOList = null;
        if (null == params.get("projectId")) {
            Long orgId = InvocationInfoProxy.getOrgId();
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DeliveryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/syncDelivery"})
    public CommonResponse<DeliveryVO> syncDelivery(HttpServletRequest request) {
        String billData = request.getParameter("billData");
        this.logger.info("\u63a5\u6536\u5230\u53d1\u8d27\u5355\u4fe1\u606f\uff1a{}", (Object)billData);
        if (StringUtils.isBlank((CharSequence)billData)) {
            return CommonResponse.error((String)"\u5355\u636e\u540c\u6b65\u5931\u8d25\uff0c\u5355\u636e\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        DeliveryVO deliveryVO = (DeliveryVO)JSONObject.parseObject((String)billData, DeliveryVO.class);
        DeliveryVO resp = this.service.saveSupDelivery(deliveryVO);
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"/billDel"})
    public CommonResponse<String> billDel(@RequestBody String sourceId) {
        DeliveryEntity delivery = this.service.getBySourceId(sourceId);
        String msg = this.service.billDel(delivery);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"/addFromOrder"})
    public CommonResponse<DeliveryVO> addFromOrder(@RequestBody Long orderId) {
        QueryWrapper countQuery = new QueryWrapper();
        countQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        int count = this.service.count((Wrapper)countQuery);
        OrderEntity order = (OrderEntity)((Object)this.orderService.selectById(orderId));
        DeliveryVO d = new DeliveryVO();
        d.setBillCode("test-delivery-" + (count += 10));
        d.setId(Long.valueOf(IdWorker.getId()));
        d.setBillState(Integer.valueOf(1));
        d.setCarCode("\u8c6bA1000" + count);
        d.setContractId(order.getContractId());
        d.setContractCode(order.getContractCode());
        d.setContractName(order.getContractName());
        d.setProjectId(order.getProjectId());
        d.setProjectCode(order.getProjectCode());
        d.setProjectName(order.getProjectName());
        d.setOrgName(order.getOrgName());
        d.setOrgId(order.getOrgId());
        d.setOrgCode(order.getOrgCode());
        d.setParentOrgId(order.getParentOrgId());
        d.setParentOrgName(order.getParentOrgName());
        d.setParentOrgCode(order.getParentOrgCode());
        d.setOrderId(order.getId());
        d.setOrderCode(order.getBillCode());
        d.setDeliveryDriverName("\u4f9b\u5e94\u5546\u6d4b\u8bd5\u4e13\u5458\u5218\u5cf0");
        d.setSupplierId(Long.valueOf(589112141802405909L));
        d.setSupplierCode("SUPPLY-2022060700004");
        d.setSupplierName("\u7269\u8d44\u4f9b\u5e94\u5546");
        d.setSupplierDeliveryId(Long.valueOf(1L));
        d.setSupplierDeliveryCode("xz002");
        d.setSupplierDeliveryName("\u4f9b\u5e94\u5546\u53d1\u8d27\u4e13\u5458\u94c1\u67f1");
        d.setSupplierDeliveryPhone("15588963352");
        d.setSupplierDeliveryDate(new Date());
        d.setSupplierLinkName("\u4f9b\u5e94\u5546\u6d4b\u8bd5\u4e13\u5458\u5218\u5cf0");
        d.setSupplierLinkPhone("15589635596");
        d.setSiteAcceptorId(Long.valueOf(1247777316689256450L));
        d.setSiteAcceptorCode("xz001");
        d.setSiteAcceptorName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        d.setPredictArrivalDate(DateUtil.addDays((Date)new Date(), (int)3));
        d.setSupplierTenantId(Long.valueOf(8888888L));
        BigDecimal mny = BigDecimal.ZERO;
        BigDecimal taxMny = BigDecimal.ZERO;
        Random rd = new Random();
        for (OrderDetailEntity dd : order.getDetailList()) {
            DeliveryDetailVO detail = new DeliveryDetailVO();
            detail.setDeliveryId(d.getId());
            detail.setAlreadyNum(BigDecimal.ZERO);
            detail.setId(Long.valueOf(IdWorker.getId()));
            detail.setContractId(order.getContractId());
            detail.setContractDetailId(dd.getContractDetailId());
            detail.setContractNum(dd.getContractNum());
            detail.setOrderNum(dd.getDetailNum());
            detail.setDeliveryNum(new BigDecimal("" + rd.nextInt(dd.getDetailNum().intValue())));
            detail.setMaterialId(dd.getMaterialId());
            detail.setMaterialCode(dd.getMaterialCode());
            detail.setMaterialName(dd.getMaterialName());
            detail.setMaterialSerialNo(dd.getMaterialSerialNo());
            detail.setMaterialTypeId(dd.getMaterialTypeId());
            detail.setMaterialTypeName(dd.getMaterialTypeName());
            detail.setMaterialTypeCode(dd.getMaterialTypeCode());
            detail.setPropertyValue(dd.getPropertyValue());
            detail.setProductCode(dd.getProductCode());
            detail.setDetailTaxPrice(dd.getDetailTaxPrice());
            detail.setDetailPrice(dd.getDetailPrice());
            detail.setDetailTaxRate(dd.getDetailTaxRate());
            detail.setDetailMny(ComputeUtil.safeMultiply((BigDecimal)detail.getDeliveryNum(), (BigDecimal)detail.getDetailPrice()));
            detail.setDetailTaxMny(ComputeUtil.safeMultiply((BigDecimal)detail.getDeliveryNum(), (BigDecimal)detail.getDetailTaxPrice()));
            detail.setDetailTax(ComputeUtil.safeSub((BigDecimal)detail.getDetailTaxMny(), (BigDecimal)detail.getDetailMny()));
            detail.setSourceDetailId(dd.getId());
            detail.setDetailUnitId(dd.getDetailUnitId());
            detail.setDetailUnitName(dd.getDetailUnitName());
            detail.setBrandId(dd.getBrandId());
            detail.setBrandName(dd.getBrandName());
            d.getDetailList().add(detail);
            mny = ComputeUtil.safeAdd((BigDecimal)mny, (BigDecimal)detail.getDetailMny());
            taxMny = ComputeUtil.safeAdd((BigDecimal)taxMny, (BigDecimal)detail.getDetailTaxMny());
        }
        d.setDeliveryMny(mny);
        d.setDeliveryTaxMny(taxMny);
        DeliveryEntity entity = (DeliveryEntity)((Object)BeanMapper.map((Object)d, DeliveryEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), DeliveryVO.class));
    }
}

