/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.bean.BusinessContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.FeePackageEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBusinessContractService;
import com.ejianc.business.zdsmaterial.erp.service.IFeePackageService;
import com.ejianc.business.zdsmaterial.erp.vo.BusinessContractVO;
import com.ejianc.business.zdsmaterial.erp.vo.FeePackageVO;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/erpRef/"})
public class FeePackageController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${erp.appId}")
    private String appId;
    @Value(value="${erp.secret}")
    private String secret;
    @Value(value="${erp.reqHost}")
    private String reqHost;
    @Autowired
    private IFeePackageService feePackageService;
    @Autowired
    private IBusinessContractService businessContractService;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IMaterialCategoryService categoryService;
    private final String ERP_CACHE_PROJECT_PREFIX = "erp::project::";
    private final String FEE_PACKAGE_ERP_REQ_URL = "/cefoc/yql/getContractLimited_SubAList";
    private final String BUSINESS_CONTRACT_ERP_REQ_URL = "/cefoc/yql/getContractLimitedList";

    @PostMapping(value={"syncZDSFeePackage"})
    public CommonResponse<String> syncZDSFeePackage(@RequestBody Map<String, String> params) {
        Object reqResp;
        this.logger.info("*********************\u4e2d\u7535\u56db-\u8d39\u7528\u5305\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        HashMap<String, BusinessContractEntity> contractCache = new HashMap<String, BusinessContractEntity>();
        HashMap<String, Long> projectCache = new HashMap<String, Long>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/getContractLimited_SubAList";
        JSONObject reqJson = null;
        JSONArray pageData = null;
        Integer pageNum = null != params.get("pageNum") ? Integer.valueOf(params.get("pageNum")) : 0;
        Integer pageSize = null != params.get("pageSize") ? Integer.valueOf(params.get("pageSize")) : Integer.valueOf(ZDSInterfaceCommonUtil.getErpDataBatchSize());
        boolean noDate = null != params && null != params.get("noDate") ? "true".equals(params.get("noDate")) : false;
        String reqDateStr = null;
        boolean hasNext = true;
        Integer reqErrorTimes = null != params && null != params.get("reqErrorTimes") ? Integer.valueOf(params.get("reqErrorTimes")) : 0;
        if (!noDate) {
            reqDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)new Date());
            String startDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtils.addDays((Date)new Date(), (int)-2)) + " 00:00:00";
            String endDateStr = reqDateStr + " 23:59:59";
            param.put("BeginDateTime", startDateStr);
            param.put("EndDateTime", endDateStr);
        }
        if (null != params.get("projectCode") && StringUtils.isNotBlank((CharSequence)params.get("projectCode"))) {
            CommonResponse projectResp = this.projectPoolApi.getOneByCode(params.get("projectCode"));
            if (!projectResp.isSuccess()) {
                this.logger.error("\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6839\u636e\u9879\u76ee\u7f16\u7801-{}\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01", (Object)params.get("projectCode"));
                return CommonResponse.error((String)"\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6839\u636e\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (null == projectResp.getData()) {
                this.logger.error("\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6839\u636e\u9879\u76ee\u7f16\u7801-{}\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)params.get("projectCode"));
                return CommonResponse.error((String)"\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6839\u636e\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            reqUrl = reqUrl + "?ProjectOID=" + ((ProjectPoolSetVO)projectResp.getData()).getSourceId();
        }
        if (null != params.get("businessContractId") && StringUtils.isNotBlank((CharSequence)params.get("businessContractId"))) {
            Long businessContractId = Long.valueOf(params.get("businessContractId"));
            BusinessContractEntity businessContract = (BusinessContractEntity)((Object)this.businessContractService.selectById(businessContractId));
            if (null == businessContract) {
                this.logger.error("\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6839\u636e\u5546\u52a1\u5408\u540cid-{}\u67e5\u8be2\u5546\u52a1\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)businessContractId);
                return CommonResponse.error((String)"\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u67e5\u8be2\u5546\u52a1\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            reqUrl = reqUrl + (reqUrl.indexOf("?") > 0 ? "&" : "?") + "ContractLimitedOID=" + businessContract.getSourceId();
        }
        try {
            Map<String, String> headers = null;
            param.put("PageSize", pageSize);
            while (hasNext) {
                headers = ZDSInterfaceCommonUtil.getErpHeaders();
                pageNum = pageNum + 1;
                param.put("PageNum", pageNum);
                reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)60000, (Integer)60000);
                reqJson = JSONObject.parseObject((String)reqResp);
                if ("ok".equals(reqJson.getString("status"))) {
                    pageData = reqJson.getJSONArray("data");
                    if (null != pageData && pageData.size() > 0) {
                        this.logger.info("\u4e2d\u7535\u56db\u8d39\u7528\u5305\u540c\u6b65\uff0c\u5904\u7406\u7b2c{}\u9875, {}\u6761\u6570\u636e", (Object)pageNum, (Object)pageData.size());
                        this.handleFeePackageErpData(pageData, contractCache, projectCache);
                        continue;
                    }
                    this.logger.info("\u4e2d\u7535\u56db\u8d39\u7528\u5305\u540c\u6b65 \u5904\u7406\u6570\u636e\u5b8c\u6210\uff01\uff01\uff01\u603b\u5171{}\u9875\u6570\u636e\uff01", (Object)pageNum);
                    hasNext = false;
                    continue;
                }
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u8d39\u7528\u5305\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
                hasNext = false;
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u8d39\u7528\u5305\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{},e:", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            reqResp = reqErrorTimes;
            Integer n = reqErrorTimes = Integer.valueOf(reqErrorTimes + 1);
            if (reqErrorTimes >= 5) {
                return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u8d39\u7528\u5305\u4fe1\u606f\u5f02\u5e38");
            }
            try {
                this.logger.info("\u540c\u6b65\u4e2d\u7535\u56db\u8d39\u7528\u5305\u4fe1\u606f\u5f02\u5e38\uff0c5s\u540e\u91cd\u8bd5.........,\u5f53\u524d\u5df2\u540c\u6b65{}\u9875\u6570\u636e", (Object)(pageNum - 1));
                Thread.sleep(5000L);
                HashMap<String, String> reqParam = new HashMap<String, String>();
                reqParam.put("pageSize", pageSize + "");
                reqParam.put("pageNum", (pageNum < 1 ? pageNum : pageNum - 1) + "");
                reqParam.put("reqErrorTimes", reqErrorTimes + "");
                reqParam.put("noDate", noDate + "");
                return this.syncZDSFeePackage(reqParam);
            }
            catch (Exception e1) {
                this.logger.error("\u91cd\u542f\u4e2d\u7535\u56db\u94f6\u884c\u652f\u884c\u540c\u6b65\u63a5\u53e3\u5f02\u5e38,", (Throwable)e1);
                return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u94f6\u884c\u4fe1\u606f\u5f02\u5e38");
            }
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u8d39\u7528\u5305\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u4e2d\u7535\u56db\u8d39\u7528\u5305\u4efb\u52a1\u6267\u884c\u7ed3\u675f\uff01");
    }

    private void handleFeePackageErpData(JSONArray pageData, Map<String, BusinessContractEntity> contractCache, Map<String, Long> projectCache) {
        JSONObject tmp = null;
        FeePackageEntity tmpEntity = null;
        HashMap<String, FeePackageEntity> sourceIdMap = new HashMap<String, FeePackageEntity>();
        ArrayList<FeePackageEntity> saveList = new ArrayList<FeePackageEntity>();
        for (Object obj : pageData) {
            Object businessContractEntity;
            tmp = (JSONObject)obj;
            tmpEntity = new FeePackageEntity();
            tmpEntity.setSourceId(tmp.getString("C_PCM_ContractLimited_SubAOID"));
            tmpEntity.setProjectName(tmp.getString("Account_Project_shortname"));
            tmpEntity.setProjectCode(tmp.getString("Account_Project_id"));
            tmpEntity.setProjectSid(tmp.getString("C_CM_AccountingProjectSetOID"));
            tmpEntity.setBusinessContractName(tmp.getString("Title"));
            tmpEntity.setBusinessContractCode(tmp.getString("CommerceCode"));
            tmpEntity.setBusinessContractSid(tmp.getString("ContractLimited_FK"));
            tmpEntity.setMaterialPackageCode(tmp.getString("MaterialPackageCode"));
            tmpEntity.setInventoryClassifyName(tmp.getString("InventoryClassifyName"));
            tmpEntity.setChargeTypeName(tmp.getString("ChargeTypeName"));
            tmpEntity.setContractMoney(tmp.getString("ContractMoney"));
            tmpEntity.setExecuteLimited(tmp.getString("ExecuteLimited"));
            tmpEntity.setSystemClassifyName(tmp.getString("SystemClassifyName"));
            tmpEntity.setSystemClassifyCode(tmp.getString("SystemClassifyCode"));
            tmpEntity.setInventoryClassifySid(tmp.getString("InventoryClassifySid"));
            tmpEntity.setInventoryClassifyCode(tmp.getString("InventoryClassifyCode"));
            ProjectPoolSetVO projectVo = this.getProject(tmp.getString("C_CM_AccountingProjectSetOID"));
            if (null != projectVo) {
                tmpEntity.setProjectId(projectVo.getId());
            }
            if (null != (businessContractEntity = this.getBusinessContract(tmp.getString("ContractLimited_FK")))) {
                tmpEntity.setBusinessContractId(businessContractEntity.getId());
            }
            sourceIdMap.put(tmpEntity.getSourceId(), tmpEntity);
        }
        ArrayList<String> projectSourceIds = new ArrayList<String>();
        ArrayList<String> businessSourceIds = new ArrayList<String>();
        List<FeePackageEntity> dbListBySourceId = this.feePackageService.getAllBySourceIds(new ArrayList<String>(sourceIdMap.keySet()));
        if (CollectionUtils.isNotEmpty(dbListBySourceId)) {
            for (FeePackageEntity dbEntity : dbListBySourceId) {
                tmpEntity = (FeePackageEntity)((Object)sourceIdMap.get(dbEntity.getSourceId()));
                if (null == tmpEntity) {
                    this.logger.error("\u6ca1\u6709\u5339\u914d\u7684\u8d39\u7528\u5305\uff1a{}", (Object)dbEntity.getSourceId());
                    continue;
                }
                if (null == dbEntity.getProjectId() || !StringUtils.equals((CharSequence)tmpEntity.getProjectSid(), (CharSequence)dbEntity.getProjectSid())) {
                    projectSourceIds.add(dbEntity.getProjectSid());
                    dbEntity.setProjectSid(tmpEntity.getProjectSid());
                    dbEntity.setProjectCode(tmpEntity.getProjectCode());
                    dbEntity.setProjectName(tmpEntity.getProjectName());
                    dbEntity.setProjectId(null);
                }
                if (null == dbEntity.getBusinessContractId() || !StringUtils.equals((CharSequence)tmpEntity.getBusinessContractSid(), (CharSequence)dbEntity.getBusinessContractSid())) {
                    businessSourceIds.add(dbEntity.getBusinessContractSid());
                    dbEntity.setBusinessContractId(null);
                    dbEntity.setBusinessContractSid(tmpEntity.getBusinessContractSid());
                    dbEntity.setBusinessContractCode(tmpEntity.getBusinessContractCode());
                    dbEntity.setBusinessContractName(tmpEntity.getBusinessContractName());
                }
                dbEntity.setMaterialPackageCode(tmpEntity.getMaterialPackageCode());
                dbEntity.setInventoryClassifyName(tmpEntity.getInventoryClassifyName());
                dbEntity.setChargeTypeName(tmpEntity.getChargeTypeName());
                dbEntity.setContractMoney(tmpEntity.getContractMoney());
                dbEntity.setExecuteLimited(tmpEntity.getExecuteLimited());
                dbEntity.setSystemClassifyName(tmpEntity.getSystemClassifyName());
                dbEntity.setSystemClassifyCode(tmpEntity.getSystemClassifyCode());
                dbEntity.setInventoryClassifySid(tmpEntity.getInventoryClassifySid());
                dbEntity.setInventoryClassifyCode(tmpEntity.getInventoryClassifyCode());
                saveList.add(dbEntity);
                sourceIdMap.remove(dbEntity.getSourceId());
            }
        }
        if (!sourceIdMap.isEmpty()) {
            saveList.addAll(sourceIdMap.values());
        }
        if (CollectionUtils.isNotEmpty(projectSourceIds)) {
            QueryParam qm = new QueryParam();
            qm.getParams().put("sourceId", new Parameter("in", projectSourceIds));
            CommonResponse prjResp = this.projectPoolApi.getProjectPoolList(qm);
            if (!prjResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u9879\u76eesourceId\u5217\u8868-{}\uff0c\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString(projectSourceIds));
            }
            for (ProjectPoolSetVO project : JSONArray.parseArray((String)JSONObject.toJSONString((Object)prjResp.getData()), ProjectPoolSetVO.class)) {
                projectCache.put(project.getSourceId(), project.getId());
            }
        }
        ArrayList upBusinessList = new ArrayList();
        if (CollectionUtils.isNotEmpty(businessSourceIds)) {
            List<BusinessContractEntity> businessList = this.businessContractService.getAllBySourceIds(businessSourceIds);
            for (BusinessContractEntity business : businessList) {
                contractCache.put(business.getSourceId(), business);
            }
        }
        saveList.stream().forEach(item -> {
            if (null == item.getProjectId() && projectCache.containsKey(item.getProjectSid())) {
                item.setProjectId((Long)projectCache.get(item.getProjectSid()));
            }
            if (null == item.getBusinessContractId() && contractCache.containsKey(item.getBusinessContractSid())) {
                BusinessContractEntity businessContractEntity = (BusinessContractEntity)((Object)((Object)contractCache.get(item.getBusinessContractSid())));
                item.setBusinessContractId(businessContractEntity.getId());
                String contractMoney = item.getContractMoney();
                String executeLimited = item.getExecuteLimited();
                businessContractEntity.setContractMoney(contractMoney == null ? BigDecimal.ZERO : new BigDecimal(contractMoney));
                businessContractEntity.setExecuteLimited(executeLimited == null ? BigDecimal.ZERO : new BigDecimal(executeLimited));
                upBusinessList.add(businessContractEntity);
            }
        });
        this.feePackageService.saveOrUpdateBatch(saveList, saveList.size(), false);
        if (CollectionUtils.isNotEmpty(upBusinessList)) {
            this.businessContractService.saveOrUpdateBatch(upBusinessList, upBusinessList.size(), false);
        }
    }

    @PostMapping(value={"feePackage/pageList"})
    public CommonResponse<JSONObject> feePackagePageList(@RequestBody Map<String, Object> param) throws Exception {
        JSONObject resp = new JSONObject();
        StringBuilder reqUrl = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("PageSize", param.get("pageSize"));
        params.put("PageNum", param.get("pageNum"));
        reqUrl.append(this.reqHost).append("/cefoc/yql/getContractLimited_SubAList");
        String nowStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        if (param.containsKey("condition")) {
            JSONObject _con = JSONObject.parseObject((String)((String)param.get("condition")));
            if (_con.containsKey((Object)"projectId")) {
                reqUrl.append("?ProjectOID=").append(this.getProjectSid(Long.valueOf(_con.getString("projectId"))));
            }
            if (_con.containsKey((Object)"contractId")) {
                reqUrl.append("?ContractLimitedOID=").append(_con.getString("contractId"));
            }
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("appid", FeePackageController.toMD5(this.appId));
        headers.put("ticket", nowStr);
        headers.put("sign", FeePackageController.toMD5(this.secret + FeePackageController.toMD5(this.appId) + FeePackageController.toMD5(nowStr)));
        String feePackageResp = HttpTookit.postByJson((String)reqUrl.toString(), (String)JSONObject.toJSONString(params), headers, (Integer)10000, (Integer)10000);
        this.logger.info("url:{},params:{},headers:{},\u8d39\u7528\u5305\u6570\u636e\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(params), JSONObject.toJSONString(headers), feePackageResp});
        JSONObject result = JSONObject.parseObject((String)feePackageResp);
        if (!"ok".equals(result.getString("status"))) {
            return CommonResponse.error((String)"\u83b7\u53d6ERP\u8d39\u7528\u5305\u4fe1\u606f\u5931\u8d25");
        }
        resp.put("total", (Object)result.getString("allCount"));
        resp.put("current", param.get("pageNum"));
        resp.put("size", param.get("pageSize"));
        resp.put("records", (Object)result.getJSONArray("data"));
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"syncZDSBusinessContract"})
    public CommonResponse<String> syncZDSBusinessContract(@RequestBody Map<String, String> params) {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u8d39\u7528\u5305\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        HashMap<String, Long> projectCache = new HashMap<String, Long>();
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/getContractLimitedList";
        JSONObject reqJson = null;
        JSONArray pageData = null;
        Integer pageNum = null != params.get("pageNum") ? Integer.valueOf(params.get("pageNum").toString()) : 0;
        Integer pageSize = null != params.get("pageSize") ? Integer.valueOf(params.get("pageSize").toString()) : Integer.valueOf(ZDSInterfaceCommonUtil.getErpDataBatchSize());
        Object reqDateStr = null;
        boolean hasNext = true;
        if (null != params.get("projectCode") && StringUtils.isNotBlank((CharSequence)params.get("projectCode"))) {
            CommonResponse projectResp = this.projectPoolApi.getOneByCode(params.get("projectCode"));
            if (!projectResp.isSuccess()) {
                this.logger.error("\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6839\u636e\u9879\u76ee\u7f16\u7801-{}\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01", (Object)params.get("projectCode"));
                return CommonResponse.error((String)"\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6839\u636e\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (null == projectResp.getData()) {
                this.logger.error("\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6839\u636e\u9879\u76ee\u7f16\u7801-{}\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)params.get("projectCode"));
                return CommonResponse.error((String)"\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6839\u636e\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            reqUrl = reqUrl + "?ProjectOID=" + ((ProjectPoolSetVO)projectResp.getData()).getSourceId();
        }
        try {
            Map<String, String> headers = null;
            param.put("PageSize", pageSize);
            while (hasNext) {
                headers = ZDSInterfaceCommonUtil.getErpHeaders();
                pageNum = pageNum + 1;
                param.put("PageNum", pageNum);
                String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)60000, (Integer)60000);
                reqJson = JSONObject.parseObject((String)reqResp);
                if ("ok".equals(reqJson.getString("status"))) {
                    pageData = reqJson.getJSONArray("data");
                    if (null != pageData && pageData.size() > 0) {
                        this.logger.info("\u4e2d\u7535\u56db\u5546\u52a1\u5408\u540c\u540c\u6b65\uff0c\u5904\u7406\u7b2c{}\u9875, {}\u6761\u6570\u636e", (Object)pageNum, (Object)pageData.size());
                        this.handleBusinessErpData(pageData, projectCache);
                        if (pageData.size() >= pageSize) continue;
                        hasNext = false;
                        continue;
                    }
                    this.logger.info("\u4e2d\u7535\u56db\u5546\u52a1\u5408\u540c\u540c\u6b65 \u5904\u7406\u6570\u636e\u5b8c\u6210\uff01\uff01\uff01\u603b\u5171{}\u9875\u6570\u636e\uff01", (Object)pageNum);
                    hasNext = false;
                    continue;
                }
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u5546\u52a1\u5408\u540c\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
                hasNext = false;
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u5546\u52a1\u5408\u540c\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{},e:{}", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u5546\u52a1\u5408\u4fe1\u606f\u5f02\u5e38");
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u5546\u52a1\u5408\u540c\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u4e2d\u7535\u56db\u5546\u52a1\u5408\u540c\u4efb\u52a1\u6267\u884c\u7ed3\u675f\uff01");
    }

    private void handleBusinessErpData(JSONArray pageData, Map<String, Long> projectCache) {
        JSONObject tmp = null;
        BusinessContractEntity tmpEntity = null;
        HashMap<String, BusinessContractEntity> sourceIdMap = new HashMap<String, BusinessContractEntity>();
        ArrayList<BusinessContractEntity> saveList = new ArrayList<BusinessContractEntity>();
        HashSet<String> projectSourceIds = new HashSet<String>();
        for (Object obj : pageData) {
            tmp = (JSONObject)obj;
            tmpEntity = (BusinessContractEntity)((Object)BeanMapper.map((Object)tmp, BusinessContractEntity.class));
            tmpEntity.setPcmContractOid(tmp.getString("C_PCM_ContractLimitedOID"));
            tmpEntity.setSourceId(tmp.getString("ContractInfo_FK"));
            tmpEntity.setProjectName(tmp.getString("Account_Project_shortname"));
            tmpEntity.setProjectCode(tmp.getString("Account_Project_id"));
            tmpEntity.setProjectSid(tmp.getString("C_CM_AccountingProjectSetOID"));
            tmpEntity.setContractName(tmp.getString("ContractName"));
            tmpEntity.setContractCode(tmp.getString("CommerceCode"));
            tmpEntity.setContractFlag(tmp.getInteger("ContractFlag"));
            tmpEntity.setParentContractSid(tmp.getString("Contract_PrarentSid"));
            projectSourceIds.add(tmp.getString("C_CM_AccountingProjectSetOID"));
            sourceIdMap.put(tmpEntity.getSourceId(), tmpEntity);
        }
        List<BusinessContractEntity> dbListBySourceId = this.businessContractService.getAllBySourceIds(new ArrayList<String>(sourceIdMap.keySet()));
        if (CollectionUtils.isNotEmpty(dbListBySourceId)) {
            for (BusinessContractEntity dbEntity : dbListBySourceId) {
                tmpEntity = (BusinessContractEntity)((Object)sourceIdMap.get(dbEntity.getSourceId()));
                if (null == tmpEntity) continue;
                dbEntity.setPcmContractOid(tmpEntity.getPcmContractOid());
                dbEntity.setSourceId(tmpEntity.getSourceId());
                dbEntity.setContractFlag(tmpEntity.getContractFlag());
                if (StringUtils.isNotBlank((CharSequence)tmpEntity.getParentContractSid())) {
                    dbEntity.setParentContractSid(tmpEntity.getParentContractSid());
                }
                if (StringUtils.isBlank((CharSequence)dbEntity.getProjectSid())) {
                    dbEntity.setProjectSid(tmpEntity.getProjectSid());
                }
                if (null == dbEntity.getProjectId() || !tmpEntity.getProjectSid().equals(dbEntity.getProjectSid())) {
                    projectSourceIds.add(dbEntity.getProjectSid());
                    dbEntity.setProjectSid(tmpEntity.getProjectSid());
                    dbEntity.setProjectName(tmpEntity.getProjectName());
                    dbEntity.setProjectCode(tmpEntity.getProjectCode());
                    dbEntity.setProjectId(null);
                } else {
                    projectSourceIds.remove(dbEntity.getProjectSid());
                }
                dbEntity.setContractCode(tmpEntity.getContractCode());
                dbEntity.setContractName(tmpEntity.getContractName());
                saveList.add(dbEntity);
                sourceIdMap.remove(dbEntity.getSourceId());
            }
        }
        if (!sourceIdMap.isEmpty()) {
            saveList.addAll(sourceIdMap.values());
        }
        if (CollectionUtils.isNotEmpty(projectSourceIds)) {
            QueryParam qm = new QueryParam();
            qm.getParams().put("sourceId", new Parameter("in", new ArrayList(projectSourceIds)));
            CommonResponse prjResp = this.projectPoolApi.getProjectPoolList(qm);
            if (!prjResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u9879\u76eesourceId\u5217\u8868-{}\uff0c\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString(projectSourceIds));
            }
            for (ProjectPoolSetVO project : JSONArray.parseArray((String)JSONObject.toJSONString((Object)prjResp.getData()), ProjectPoolSetVO.class)) {
                projectCache.put(project.getSourceId(), project.getId());
            }
        }
        saveList.stream().forEach(item -> {
            if (null == item.getProjectId() && projectCache.containsKey(item.getProjectSid())) {
                item.setProjectId((Long)projectCache.get(item.getProjectSid()));
            }
        });
        this.logger.info("\u5f85\u4fdd\u5b58\u6570\u636e\uff1a{}", (Object)saveList.size());
        this.businessContractService.saveOrUpdateBatch(saveList, saveList.size(), false);
    }

    @PostMapping(value={"businessContract/pageList"})
    public CommonResponse<JSONObject> contractPageList(@RequestBody Map<String, Object> param) throws Exception {
        JSONObject _con;
        JSONObject resp = new JSONObject();
        StringBuilder reqUrl = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("PageSize", param.get("pageSize"));
        params.put("PageNum", param.get("pageNum"));
        reqUrl.append(this.reqHost).append("/cefoc/yql/getContractLimitedList");
        String nowStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        if (param.containsKey("condition") && (_con = JSONObject.parseObject((String)((String)param.get("condition")))).containsKey((Object)"projectId")) {
            reqUrl.append("?ProjectOID=").append(this.getProjectSid(Long.valueOf(_con.getString("projectId"))));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("appid", FeePackageController.toMD5(this.appId));
        headers.put("ticket", nowStr);
        headers.put("sign", FeePackageController.toMD5(this.secret + FeePackageController.toMD5(this.appId) + FeePackageController.toMD5(nowStr)));
        this.logger.info("\u5546\u52a1\u5408\u540c\u63a5\u53e3\uff1a{}", (Object)reqUrl);
        String feePackageResp = HttpTookit.postByJson((String)reqUrl.toString(), (String)JSONObject.toJSONString(params), headers, (Integer)10000, (Integer)10000);
        this.logger.info("\u5546\u52a1\u5408\u540c\u6570\u636e\uff1a{}", (Object)feePackageResp);
        this.logger.info("\u5546\u52a1\u5408\u540c\u6570\u636eurl\uff1a{},params:{},headers{}", new Object[]{reqUrl, JSONObject.toJSONString(params), JSONObject.toJSONString(headers)});
        JSONObject result = JSONObject.parseObject((String)feePackageResp);
        if (!"ok".equals(result.getString("status"))) {
            return CommonResponse.error((String)"\u83b7\u53d6ERP\u5546\u52a1\u5408\u540c\u4fe1\u606f\u5931\u8d25");
        }
        resp.put("total", (Object)result.getString("allCount"));
        resp.put("current", param.get("pageNum"));
        resp.put("size", param.get("pageSize"));
        resp.put("records", (Object)result.getJSONArray("data"));
        return CommonResponse.success((Object)resp);
    }

    private String getProjectSid(Long projectId) {
        String cachcKey = "erp::project::" + projectId.toString();
        if (null != this.cacheManager.get(cachcKey)) {
            return (String)((Object)this.cacheManager.get(cachcKey));
        }
        CommonResponse prjResp = this.projectPoolApi.queryProjectPoolById(projectId);
        if (!prjResp.isSuccess()) {
            throw new BusinessException("\u6839\u636e\u9879\u76eeId\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5f02\u5e38\uff01");
        }
        ProjectPoolSetVO vo = (ProjectPoolSetVO)((JSONArray)prjResp.getData()).getObject(0, ProjectPoolSetVO.class);
        this.cacheManager.set(cachcKey, (Serializable)((Object)vo.getSourceId()));
        return vo.getSourceId();
    }

    public static String toMD5(String plainText) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(plainText.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString().toLowerCase();
    }

    @RequestMapping(value={"/businessContract/refData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BusinessContractVO>> refContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"projectId")) {
                CommonResponse projectResp = this.projectPoolApi.getById(_con.getLong("projectId"));
                if (!projectResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u9879\u76ee\u7f16\u7801-{}\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01", (Object)_con.getLong("projectId"));
                    param.getParams().put("projectId", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"projectId"))));
                } else {
                    ComplexParam c1 = new ComplexParam();
                    c1.setLogic("and");
                    ComplexParam c2 = new ComplexParam();
                    c2.setLogic("or");
                    c2.getParams().put("projectId", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"projectId"))));
                    ComplexParam c3 = new ComplexParam();
                    c3.setLogic("or");
                    c3.getParams().put("projectSid", new Parameter("eq", (Object)((ProjectPoolSetVO)projectResp.getData()).getSourceId()));
                    c1.getComplexParams().add(c2);
                    c1.getComplexParams().add(c3);
                    param.getComplexParams().add(c1);
                }
            }
            if (_con.containsKey((Object)"contractFlag")) {
                param.getParams().put("contractFlag", new Parameter("eq", (Object)_con.getInteger("contractFlag")));
            }
        }
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.businessContractService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BusinessContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/feePackage/refData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FeePackageVO>> refFeePackageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"projectId")) {
                CommonResponse projectResp = this.projectPoolApi.getById(_con.getLong("projectId"));
                if (!projectResp.isSuccess() || null == projectResp.getData()) {
                    this.logger.error("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5f02\u5e38, {}", (Object)JSONObject.toJSONString((Object)projectResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    param.getParams().put("projectId", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"projectId"))));
                } else {
                    ProjectPoolSetVO project = (ProjectPoolSetVO)projectResp.getData();
                    if ("2".equals(project.getBudgetVer()) && _con.containsKey((Object)"categoryCode")) {
                        String categoryCode = _con.getString("categoryCode");
                        String code = this.categoryService.queryPidCodeByCode(categoryCode);
                        param.getParams().put("", new Parameter("sql", (Object)("( (material_package_code like '%" + code + "%' and charge_type_name = '\u91c7\u8d2d\u4e3b\u6750\u8d39' ) or material_package_code like '%F-LX-1%')")));
                    } else {
                        param.getParams().put("", new Parameter("sql", (Object)"(material_package_code like '%.3' or material_package_code like '%.4' or material_package_code like '%.5')"));
                    }
                    ComplexParam c1 = new ComplexParam();
                    c1.setLogic("and");
                    ComplexParam c2 = new ComplexParam();
                    c2.setLogic("or");
                    c2.getParams().put("projectId", new Parameter("eq", (Object)project.getId()));
                    ComplexParam c3 = new ComplexParam();
                    c3.setLogic("or");
                    c3.getParams().put("projectSid", new Parameter("eq", (Object)project.getSourceId()));
                    c1.getComplexParams().add(c2);
                    c1.getComplexParams().add(c3);
                    param.getComplexParams().add(c1);
                }
            }
            if (_con.containsKey((Object)"businessContractId")) {
                param.getParams().put("businessContractId", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"businessContractId"))));
            }
            if (_con.containsKey((Object)"contractId")) {
                List<BusinessContractEntity> contracts = this.businessContractService.getAllContractsBySourceId(_con.getString("contractId"));
                param.getParams().put("business_contract_sid", new Parameter("in", contracts.stream().map(BusinessContractEntity::getPcmContractOid).collect(Collectors.toList())));
            }
        }
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.feePackageService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FeePackageVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private ProjectPoolSetVO getProject(String projectSourceId) {
        String cacheKey = "ERP_CACHE_PROJECT_PREFIX" + projectSourceId;
        if (null != this.cacheManager.get(cacheKey)) {
            return (ProjectPoolSetVO)this.cacheManager.get(cacheKey);
        }
        CommonResponse projectResp = this.projectPoolApi.getOneBySourceId(projectSourceId);
        if (!projectResp.isSuccess()) {
            throw new BusinessException("\u6839\u636e\u9879\u76ee\u6765\u6e90Id{" + projectSourceId + "}\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5f02\u5e38\uff01");
        }
        ProjectPoolSetVO vo = (ProjectPoolSetVO)projectResp.getData();
        this.cacheManager.set(cacheKey, (Serializable)vo);
        return vo;
    }

    private BusinessContractEntity getBusinessContract(String contractId) {
        String cacheKey = "ERP_CACHE_BUSINESS_CONTRACT_PREFIX" + contractId;
        if (null != this.cacheManager.get(cacheKey)) {
            return (BusinessContractEntity)((Object)this.cacheManager.get(cacheKey));
        }
        BusinessContractEntity entity = this.businessContractService.getBySourceId(contractId);
        if (entity != null) {
            this.cacheManager.set(cacheKey, (Serializable)((Object)entity));
            return entity;
        }
        return null;
    }
}

