/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.bean.WorkSpecializeEntity;
import com.ejianc.business.zdsmaterial.erp.service.IWorkSpecializeService;
import com.ejianc.business.zdsmaterial.erp.vo.WorkSpecializeVo;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/specialize/"})
public class WorkSpecializeController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String ENGINEER_CONTRACT_ERP_REQ_URL = "/cefoc/yql/getEngineerBaseList";
    @Autowired
    private IWorkSpecializeService service;

    @RequestMapping(value={"/refData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WorkSpecializeVo>> refData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("name");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            // empty if block
        }
        param.getOrderMap().put("sort_ord", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkSpecializeVo.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"syncZDSWorkSpecialize"})
    public CommonResponse<String> syncZDSWorkSpecialize(@RequestBody Map<String, String> params) {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u5de5\u4f5c\u4e13\u4e1a\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/getEngineerBaseList";
        JSONObject reqJson = null;
        JSONArray pageData = null;
        Integer pageNum = 0;
        Integer pageSize = Integer.valueOf(ZDSInterfaceCommonUtil.getErpDataBatchSize());
        Object reqDateStr = null;
        try {
            Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();
            param.put("PageSize", pageSize);
            pageNum = pageNum + 1;
            param.put("PageNum", pageNum);
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)60000, (Integer)60000);
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                pageData = reqJson.getJSONArray("data");
                if (null != pageData && pageData.size() > 0) {
                    this.logger.info("\u4e2d\u7535\u56db\u5de5\u4f5c\u4e13\u4e1a\u540c\u6b65\uff0c\u5904\u7406\u7b2c{}\u9875, {}\u6761\u6570\u636e", (Object)pageNum, (Object)pageData.size());
                    this.handleWorkSpecializeData(pageData);
                } else {
                    this.logger.info("\u4e2d\u7535\u56db\u5de5\u4f5c\u4e13\u4e1a\u540c\u6b65 \u5904\u7406\u6570\u636e\u5b8c\u6210\uff01\uff01\uff01\u603b\u5171{}\u9875\u6570\u636e\uff01", (Object)pageNum);
                }
            } else {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u5de5\u4f5c\u4e13\u4e1a\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u5de5\u4f5c\u4e13\u4e1a\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{},e:{}", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u5de5\u4f5c\u4e13\u4e1a\u4fe1\u606f\u5f02\u5e38");
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u5de5\u4f5c\u4e13\u4e1a\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u4e2d\u7535\u56db\u5de5\u4f5c\u4e13\u4e1a\u4efb\u52a1\u6267\u884c\u7ed3\u675f\uff01");
    }

    private void handleWorkSpecializeData(JSONArray pageData) {
        JSONObject tmp = null;
        WorkSpecializeEntity tmpEntity = null;
        HashMap<String, WorkSpecializeEntity> sourceIdMap = new HashMap<String, WorkSpecializeEntity>();
        ArrayList<WorkSpecializeEntity> saveList = new ArrayList<WorkSpecializeEntity>();
        for (Object obj : pageData) {
            tmp = (JSONObject)obj;
            tmpEntity = new WorkSpecializeEntity();
            tmpEntity.setBillCode(tmp.getString("C_AA_EngineerBaseOID"));
            tmpEntity.setName(tmp.getString("Title"));
            tmpEntity.setSortOrd(tmp.getString("Sort_ID"));
            tmpEntity.setMemo(tmp.getString("Memo"));
            tmpEntity.setIsEnable(tmp.getString("IsEnable"));
            sourceIdMap.put(tmpEntity.getBillCode(), tmpEntity);
        }
        List<WorkSpecializeEntity> dbListBySourceId = this.service.getAllBySourceIds(new ArrayList<String>(sourceIdMap.keySet()));
        if (CollectionUtils.isNotEmpty(dbListBySourceId)) {
            for (WorkSpecializeEntity dbEntity : dbListBySourceId) {
                tmpEntity = (WorkSpecializeEntity)((Object)sourceIdMap.get(dbEntity.getBillCode()));
                dbEntity.setName(tmpEntity.getName());
                dbEntity.setSortOrd(tmpEntity.getSortOrd());
                dbEntity.setMemo(tmpEntity.getMemo());
                dbEntity.setIsEnable(tmpEntity.getIsEnable());
                saveList.add(dbEntity);
                sourceIdMap.remove(dbEntity.getBillCode());
            }
        }
        if (!sourceIdMap.isEmpty()) {
            saveList.addAll(sourceIdMap.values());
        }
        this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
    }
}

