/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.cloudstore.constants.CommonConstants;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.enums.DeliveryAcceptStatusEnums;
import com.ejianc.business.zdsmaterial.erp.enums.DeliveryCloseStatusEnums;
import com.ejianc.business.zdsmaterial.erp.enums.OrderDeliveryStatusEnums;
import com.ejianc.business.zdsmaterial.erp.mapper.DeliveryMapper;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.erp.vo.DeliveryVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="deliveryService")
public class DeliveryServiceImpl
extends BaseServiceImpl<DeliveryMapper, DeliveryEntity>
implements IDeliveryService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    private final String OPERATE = "deliveryBill";
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private DeliveryMapper mapper;
    @Autowired
    private IPushMessageApi pushMessageApi;
    private final String UPDATE_SUPDELIVERY_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/supDelivery/syncBill";

    @Override
    public DeliveryVO saveSupDelivery(DeliveryVO deliveryVO) {
        OrderEntity order = null;
        order = (OrderEntity)((Object)this.orderService.selectById(deliveryVO.getOrderId()));
        Map<Long, OrderDetailEntity> orderDetail = order.getDetailList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        deliveryVO.getDetailList().stream().filter(item -> orderDetail.containsKey(item.getSourceDetailId())).forEach(detail -> ((OrderDetailEntity)((Object)((Object)orderDetail.get(detail.getSourceDetailId())))).setDeliveredNum(ComputeUtil.safeAdd((BigDecimal)((OrderDetailEntity)((Object)((Object)orderDetail.get(detail.getSourceDetailId())))).getDeliveredNum(), (BigDecimal)detail.getDeliveryNum())));
        order.setDeliveredMny(ComputeUtil.safeAdd((BigDecimal)deliveryVO.getDeliveryMny(), (BigDecimal)order.getDeliveredMny()));
        order.setDeliveredTaxMny(ComputeUtil.safeAdd((BigDecimal)deliveryVO.getDeliveryTaxMny(), (BigDecimal)order.getDeliveredTaxMny()));
        order.setDeliveryStatus(order.getOrderTaxMny().compareTo(order.getDeliveredTaxMny()) == 0 ? OrderDeliveryStatusEnums.\u5168\u90e8\u53d1\u8d27.getCode() : OrderDeliveryStatusEnums.\u90e8\u5206\u53d1\u8d27.getCode());
        this.orderService.saveOrUpdate((Object)order, false);
        deliveryVO.setAcceptStatus(DeliveryAcceptStatusEnums.\u5f85\u9a8c\u6536.getCode());
        DeliveryEntity saveEntity = (DeliveryEntity)((Object)BeanMapper.map((Object)deliveryVO, DeliveryEntity.class));
        saveEntity.setSourceId(saveEntity.getId().toString());
        this.clearInvalidData(saveEntity);
        saveEntity.getDetailList().stream().forEach(detail -> {
            detail.setSourceId(detail.getId().toString());
            this.clearInvalidData((BaseEntity)detail);
        });
        super.saveOrUpdate((Object)saveEntity, false);
        this.logger.info("\u8ba2\u5355\u53d1\u8d27\u5411\u5408\u540c\u9a8c\u6536\u4ebaid-{}\u53d1\u9001\u6d88\u606f", (Object)deliveryVO.getSiteAcceptorId().toString());
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setSubject("\u3010\u8ba2\u5355\u53d1\u8d27\u3011\uff1a\u3010" + deliveryVO.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u5df2\u53d1\u8d27\uff0c\u8bf7\u5c3d\u5feb\u9a8c\u6536\uff01");
        StringBuilder content = new StringBuilder();
        content.append("\u3010").append(deliveryVO.getBillCode()).append("\u3011\uff0c\u3010").append(deliveryVO.getProjectName()).append("\u3011\uff0c\u3010").append(deliveryVO.getContractName()).append("\u3011\uff0c\u3010").append(deliveryVO.getSupplierName()).append("\u3011\u7684\u8ba2\u5355\u5df2\u53d1\u8d27");
        parameter.setContent(content.toString());
        parameter.setPcUrl(this.BASE_HOST + CommonConstants.\u7269\u8d44\u9a8c\u6536PC\u8be6\u60c5 + saveEntity.getId().toString() + (null != saveEntity.getProjectId() ? "&projectId=" + saveEntity.getProjectId().toString() : ""));
        parameter.setMobileUrl(this.BASE_HOST + CommonConstants.\u7269\u8d44\u9a8c\u6536\u79fb\u52a8\u7aef\u8be6\u60c5 + saveEntity.getId().toString() + (null != saveEntity.getProjectId() ? "&projectId=" + saveEntity.getProjectId().toString() : ""));
        String[] recIds = new String[]{deliveryVO.getSiteAcceptorId().toString()};
        parameter.setReceivers(recIds);
        this.sendMsg(parameter, deliveryVO.getId(), "\u8ba2\u5355\u53d1\u8d27\u5411\u5408\u540c\u9a8c\u6536\u4eba\u53d1\u9001\u4fe1\u606f");
        return (DeliveryVO)BeanMapper.map((Object)((Object)saveEntity), DeliveryVO.class);
    }

    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{"sys", "email"});
        CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("{}-\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u5355\u636eId-{}\uff0c\u53d1\u9001\u6d88\u606f\u7ed3\u679c-{}", new Object[]{oprMsg, billId, JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        } else {
            this.logger.info("{}-\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01", (Object)oprMsg);
        }
    }

    private void clearInvalidData(BaseEntity entity) {
        entity.setCreateTime(null);
        entity.setUpdateTime(null);
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        entity.setUpdateUserCode(null);
        entity.setCreateUserCode(null);
    }

    @Override
    public void updateAcceptStatus(Long id, Integer acceptStatus) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)id);
        updateWrapper.set((Object)"accept_status", (Object)acceptStatus);
        Integer closeStatus = DeliveryCloseStatusEnums.\u672a\u5173\u95ed.getCode();
        if (acceptStatus.equals(DeliveryAcceptStatusEnums.\u9a8c\u6536\u5b8c\u6210.getCode()) || acceptStatus.equals(DeliveryAcceptStatusEnums.\u90e8\u5206\u9000\u56de.getCode())) {
            closeStatus = DeliveryCloseStatusEnums.\u5df2\u5173\u95ed.getCode();
        }
        updateWrapper.set((Object)"close_status", (Object)closeStatus);
        super.update((Wrapper)updateWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateSupDelivery(DeliveryEntity deliveryEntity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "deliveryBill::" + deliveryEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"deliveryBill", (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, "deliveryBill");
                String string = "\u53d1\u8d27\u5355\u72b6\u6001\u540c\u6b65\u77e5\u4f9b\u65b9\u5931\u8d25\uff0c\u83b7\u53d6\u9501\u5931\u8d25\uff01";
                return string;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("billData", JSONObject.toJSONString((Object)((Object)deliveryEntity)));
            CommonResponse writeBackResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/supDelivery/syncBill", params, deliveryEntity.getSupplierId().toString(), null);
            this.logger.error("\u53d1\u8d27\u5355\u72b6\u6001\u540c\u6b65\u77e5\u4f9b\u65b9\u5931\u8d25\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)JSONObject.toJSONString((Object)writeBackResp));
            if (!writeBackResp.isSuccess()) {
                this.releaseLock(jedis, true, key, "deliveryBill");
                this.logger.error("\u53d1\u8d27\u5355id-{}\u72b6\u6001\u540c\u6b65\u77e5\u4f9b\u65b9\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", (Object)deliveryEntity.getId(), (Object)writeBackResp.getMsg());
                String string = "\u53d1\u8d27\u5355\u72b6\u6001\u540c\u6b65\u4f9b\u65b9\u5931\u8d25";
                return string;
            }
            String operateRespStr = (String)writeBackResp.getData();
            CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                this.logger.error("\u53d1\u8d27\u5355id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\uff0c\u5e73\u53f0\u5904\u7406\u5931\u8d25\uff0c{}", (Object)deliveryEntity.getId(), (Object)operateResp.getMsg());
                this.releaseLock(jedis, true, key, "deliveryBill");
                String string = "\u53d1\u8d27\u5355\u72b6\u6001\u540c\u6b65\u4f9b\u65b9\u5931\u8d25";
                return string;
            }
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d27\u5355id-{}\u72b6\u6001\u540c\u6b65\u4f9b\u65b9\u5f02\u5e38\uff0c", (Object)deliveryEntity, (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u540c\u6b65\u4f9b\u65b9\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "deliveryBill");
        }
        return msg;
    }

    @Override
    public void returnDeliveryOrOrder(AcceptEntity entity, Boolean status) {
        this.deliveryDetailService.returnAlreadyNum(entity, status);
        if (status.booleanValue()) {
            this.updateAcceptStatus(entity.getDeliveryBillId(), DeliveryAcceptStatusEnums.\u9a8c\u6536\u4e2d.getCode());
        } else {
            this.deliveryDetailService.checkAcceptStatus(entity.getDeliveryBillId());
        }
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)super.selectById((Serializable)entity.getDeliveryBillId()));
        String s = this.updateSupDelivery(deliveryEntity);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            throw new BusinessException(s);
        }
    }

    @Override
    public List<DeliveryVO> getAllByOrderId(Long orderId) {
        ArrayList<DeliveryVO> resp = new ArrayList<DeliveryVO>();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"order_id", (Object)orderId);
        query.orderByDesc((Object)"create_time");
        List list = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return BeanMapper.mapList((Iterable)list, DeliveryVO.class);
        }
        return resp;
    }

    @Override
    public DeliveryEntity getBySourceId(String sourceId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_id", (Object)sourceId);
        DeliveryEntity e = (DeliveryEntity)((Object)super.getOne((Wrapper)query));
        if (null != e) {
            List<DeliveryDetailEntity> detailList = this.deliveryDetailService.getAllByDeliveryId(e.getId());
            e.setDetailList(detailList);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String billDel(DeliveryEntity delivery) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "deliveryBill::" + delivery.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"deliveryBill", (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, "deliveryBill");
                String string = "\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u6570\u636e\u5df2\u88ab\u4fee\u6539\uff01";
                return string;
            }
            boolean delResult = this.deleteByDeliveryId(delivery.getId());
            if (!delResult) {
                this.releaseLock(jedis, true, key, "deliveryBill");
                String string = "\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u5220\u9664\u5931\u8d25\uff01";
                return string;
            }
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d27\u5355id-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)delivery.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "deliveryBill");
        }
        return msg;
    }

    private boolean deleteByDeliveryId(Long deliveryId) {
        this.mapper.deleteByDeliveryId(deliveryId);
        this.deliveryDetailService.deleteByDeliveryId(deliveryId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

