/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.ErpInvoiceMapper;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceService;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="erpInvoiceService")
public class ErpInvoiceServiceImpl
extends BaseServiceImpl<ErpInvoiceMapper, ErpInvoiceEntity>
implements IErpInvoiceService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String MAT_INVOICE_ERP_REQ_URL = "/cefoc/yql/getMEBillSubList";
    private final String SUB_INVOICE_ERP_REQ_URL = "/cefoc/yql/getSubBillSubList";

    @Override
    public List<ErpInvoiceEntity> getAllBySourceIds(List<String> sourceIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"source_id", sourceIds);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    @Override
    public ErpInvoiceEntity getOneById(Long id) {
        return (ErpInvoiceEntity)((Object)super.selectById((Serializable)id));
    }

    @Override
    public ErpInvoiceEntity getOneBySourceId(String sourceId) {
        ErpInvoiceEntity resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_id", (Object)sourceId);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        resp = (ErpInvoiceEntity)((Object)super.getOne((Wrapper)query));
        if (null != resp) {
            return (ErpInvoiceEntity)((Object)super.selectById((Serializable)resp.getId()));
        }
        return resp;
    }

    @Override
    public List<ErpInvoiceEntity> getAllByIds(List<Long> ids) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return super.list((Wrapper)query);
    }

    @Override
    public List<ErpInvoiceEntity> getAllByInvoiceNums(List<String> invoiceNums) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"number", invoiceNums);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return super.list((Wrapper)query);
    }

    @Override
    public List<String> checkQuote(List<String> invoiceNums, String checkType) {
        ArrayList<String> resp = new ArrayList<String>();
        JSONArray jsonArr = this.syncTodayQuotedInvoice(checkType);
        JSONObject json = null;
        if (null != jsonArr && jsonArr.size() > 0) {
            for (Object obj : jsonArr) {
                json = (JSONObject)obj;
                if (!invoiceNums.contains(json.getString("FPHM")) || resp.contains(json.getString("FPHM"))) continue;
                resp.add(json.getString("FPHM"));
            }
        }
        return resp;
    }

    @Override
    public JSONArray syncTodayQuotedInvoice(String checkType) {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u53d1\u7968\u5f15\u7528\u4fe1\u606f\u67e5\u8be2 \u5f00\u59cb*********************");
        String url = ZDSInterfaceCommonUtil.getErpReqHost() + ("mat".equals(checkType) ? "/cefoc/yql/getMEBillSubList" : "/cefoc/yql/getSubBillSubList");
        Map<String, String> headers = null;
        JSONObject param = new JSONObject();
        String startDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)new Date()) + " 00:00:00";
        String endDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)new Date()) + " 23:59:59";
        param.put("BeginDateTime", (Object)startDateStr);
        param.put("EndDateTime", (Object)endDateStr);
        Integer PageSize = 100;
        Integer PageNum = 1;
        try {
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            param.put("PageSize", (Object)PageSize);
            JSONObject reqJson = null;
            param.put("PageNum", (Object)PageNum);
            String reqResp = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString((Object)param), headers, (Integer)60000, (Integer)60000);
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                this.logger.info("\u53d1\u7968\u5f15\u7528\u4fe1\u606f\u67e5\u8be2,\u8bf7\u6c42\u6210\u529f\uff0c\u5171{}\u6761\u6570\u636e", (Object)reqJson.getString("allCount"));
                return reqJson.getJSONArray("MEBillList");
            }
            this.logger.error("\u53d1\u7968\u5f15\u7528\u4fe1\u606f\u67e5\u8be2\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{url, JSONObject.toJSONString((Object)param), JSONObject.toJSONString(headers), reqResp});
            throw new BusinessException("\u5f15\u7528\u53d1\u7968\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u7968\u5f15\u7528\u4fe1\u606f\u67e5\u8be2, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{url, JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            throw new BusinessException("\u5f15\u7528\u53d1\u7968\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01");
        }
    }
}

