/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.controller.api;

import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/zdsMaterialApi/"})
public class MaterialApi {
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;

    @PostMapping(value={"queryExitFlag"})
    public CommonResponse<MaterialVO> queryExitFlag(@RequestBody MaterialVO materialVO) {
        MaterialVO vo = this.materialService.queryExitFlag(materialVO.getName(), materialVO.getPropertyShowName(), materialVO.getUnitName(), materialVO.getCategoryId());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"queryExcelFlag"})
    public CommonResponse<List<MaterialVO>> queryExcelFlag(@RequestBody MaterialVO materialVO) {
        List<MaterialVO> list = this.materialService.queryExcelFlag(materialVO.getName(), materialVO.getPropertyShowName(), materialVO.getUnitName(), materialVO.getCategoryName());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryCategoryByCode"})
    public CommonResponse<MaterialCategoryVO> queryCategoryByCode(@RequestParam(value="code") String code) {
        List<MaterialCategoryEntity> list = this.materialCategoryService.queryByCode(String.valueOf(code));
        MaterialCategoryVO vo = null;
        if (ListUtil.isNotEmpty(list)) {
            vo = (MaterialCategoryVO)BeanMapper.map((Object)((Object)list.get(0)), MaterialCategoryVO.class);
        }
        if (vo == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u7f16\u7801\u6240\u5c5e\u5206\u7c7b\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vo);
    }

    @GetMapping(value={"queryCategoryListByChildren"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByChildren(@RequestParam(value="ids") List<Long> ids) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryCategoryListByChildren(ids);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryCategoryListByPid"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByPid(@RequestParam(value="id") Long id) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryAllByPid(id, ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryCategoryAllListByPid"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryAllListByPid(@RequestParam(value="id") Long id) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryAllByPid(id, ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryMaterialByIds"})
    CommonResponse<List<MaterialVO>> queryMaterialByIds(@RequestParam(value="ids") List<Long> ids, @RequestParam(value="queryRelations", required=false, defaultValue="false") Boolean queryRelations) {
        List<MaterialVO> materialVOS = this.materialService.queryDetailList(ids, queryRelations);
        if (null != materialVOS && materialVOS.size() > 0) {
            return CommonResponse.success(materialVOS);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u7269\u8d44\u3002");
    }

    @GetMapping(value={"queryMaterialItemByIds"})
    CommonResponse<List<MaterialVO>> queryMaterialItemByIds(@RequestParam(value="ids") List<Long> ids, @RequestParam(value="queryRelations", required=false, defaultValue="false") Boolean queryRelations) {
        List<MaterialVO> materialVOS = this.materialService.queryDetailList(ids, queryRelations);
        if (null != materialVOS && materialVOS.size() > 0) {
            return CommonResponse.success(materialVOS);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u6570\u636e\u3002");
    }

    @GetMapping(value={"queryCategoryById"})
    public CommonResponse<MaterialCategoryVO> queryCategoryById(@RequestParam(value="id") Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.materialCategoryService.queryDetail(id));
    }

    @PostMapping(value={"queryMaterialByCategoryId"})
    public CommonResponse<List<MaterialVO>> queryMaterialByCategoryId(@RequestBody List<Long> ids) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.materialService.queryListByCategoryId(ids));
    }

    @GetMapping(value={"queryMaterialByCode"})
    public CommonResponse<MaterialVO> queryMaterialByCode(@RequestParam(value="code") String code) {
        List<MaterialVO> vos = this.materialService.getByCodes(Arrays.asList(String.valueOf(code)));
        if (CollectionUtils.isEmpty(vos)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u7f16\u7801\u5bf9\u5e94\u7684\u7269\u6599\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vos.get(0));
    }

    @GetMapping(value={"queryCategoryListByMaterialId"})
    public CommonResponse<Map<Long, List<MaterialCategoryVO>>> queryCategoryListByMaterialId(@RequestParam(value="ids") List<Long> ids) {
        Map<Long, List<MaterialCategoryVO>> map = this.materialCategoryService.queryCategoryListByMaterialId(ids);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", map);
    }

    @GetMapping(value={"queryCategoryListByIds"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByIds(@RequestParam(value="ids", required=false) List<Long> ids) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryCategoryListByIds(ids);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryMaterialListByCodes"})
    public CommonResponse<List<MaterialVO>> queryMaterialListByCodes(@RequestParam(value="codeList") List<String> codeList) {
        List<MaterialVO> list = this.materialService.getByCodes(codeList);
        if (CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u7f16\u7801\u5bf9\u5e94\u7684\u7269\u6599\uff01");
    }

    @PostMapping(value={"addNewMaterialsFromBill"})
    CommonResponse<List<MaterialVO>> addNewMaterialsFromBill(@RequestBody List<MaterialVO> saveList) {
        List<Long> typeIds = saveList.stream().map(MaterialVO::getCategoryId).distinct().collect(Collectors.toList());
        List<MaterialCategoryVO> typeList = this.materialCategoryService.queryCategoryListByIds(typeIds);
        Map<Long, MaterialCategoryVO> typeMap = typeList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        saveList.forEach(data -> data.setCategoryCode(((MaterialCategoryVO)typeMap.get(data.getCategoryId())).getCode()));
        return CommonResponse.success(this.materialService.addNewMaterialsFromBill(saveList));
    }

    @PostMapping(value={"deleteMaterialsFromBill"})
    CommonResponse<List<MaterialVO>> deleteMaterialsFromBill(@RequestBody List<Long> sourceIds) {
        return CommonResponse.success(this.materialService.deleteMaterialsFromBill(sourceIds));
    }
}

