/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.material.bean.InvalidMatExaminerEntity;
import com.ejianc.business.zdsmaterial.material.mapper.InvalidMatExaminerMapper;
import com.ejianc.business.zdsmaterial.material.service.IInvalidMatExaminerService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.InvalidMatExaminerVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invalidMatExaminerService")
public class InvalidMatExaminerServiceImpl
extends BaseServiceImpl<InvalidMatExaminerMapper, InvalidMatExaminerEntity>
implements IInvalidMatExaminerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired
    private InvalidMatExaminerMapper mapper;
    @Autowired
    private IUserApi userApi;
    private final String INVALID_MATERIAL_EXAMINER_SYNC_URL = "/cefoc/yql/ReceiveC_SD_GoodsTypeSubBList";

    @Override
    public List<InvalidMatExaminerVO> getByEmpIdsAndCategoryId(Long categoryId, List<Long> employeeIds) {
        List<Object> resp = new ArrayList<InvalidMatExaminerVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"employee_id", employeeIds);
        query.eq((Object)"category_id", (Object)categoryId);
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            resp = BeanMapper.mapList((Iterable)dbList, InvalidMatExaminerVO.class);
        }
        return resp;
    }

    @Override
    public List<Long> getLastCategoryIdsByEmpId(Long employeeId) {
        List<Long> resp = new ArrayList<Long>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"category_id"});
        query.eq((Object)"employee_id", (Object)employeeId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List categoryIds = super.listObjs((Wrapper)query, item -> Long.valueOf(item.toString()));
        if (CollectionUtils.isNotEmpty((Collection)categoryIds)) {
            resp = this.materialCategoryService.queryChildrenIdsByPIds(categoryIds);
        }
        return resp;
    }

    @Override
    public List<Map> getSyncList(Map<String, Object> params) {
        return this.mapper.getSyncList(params);
    }

    @Override
    public void syncToErp(Map<String, Object> queryParams) {
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/ReceiveC_SD_GoodsTypeSubBList";
        Map<String, String> headers = null;
        List<Map> syncList = null;
        String reqResp = null;
        try {
            syncList = this.getSyncList(queryParams);
            if (CollectionUtils.isEmpty(syncList)) {
                this.logger.info("\u5f85\u63a8\u9001ERP\u4e34\u65f6\u6863\u6848\u5ba1\u6838\u4eba\u4e3a\u7a7a\uff0c\u540c\u6b65\u4efb\u52a1\u6267\u884c\u7ed3\u675f\uff01\uff01\uff01");
                return;
            }
            String[] userIds = syncList.stream().map(item -> item.get("empId").toString()).collect(Collectors.toList()).toArray(new String[syncList.size()]);
            CommonResponse userResp = this.userApi.queryListByIds(userIds);
            if (!userResp.isSuccess()) {
                this.logger.error("\u4e34\u65f6\u6863\u6848\u5ba1\u6838\u4eba\u63a8\u9001\u4efb\u52a1\u6267\u884cERP\u5931\u8d25\uff0c\u6839\u636e\u7528\u6237Id\u5217\u8868-[{}]\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c", (Object)JSONObject.toJSONString((Object)userIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), (Object)JSONObject.toJSONString((Object)userResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                return;
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)userResp.getData()))) {
                this.logger.error("\u4e34\u65f6\u6863\u6848\u5ba1\u6838\u4eba\u63a8\u9001\u4efb\u52a1\u6267\u884cERP\u5931\u8d25\uff0c\u6839\u636e\u7528\u6237Id\u5217\u8868-[{}]\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c", (Object)JSONObject.toJSONString((Object)userIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                return;
            }
            Map<String, String> userSourceMap = ((List)userResp.getData()).stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item.getSourceId()));
            ArrayList<Map> syncDataList = new ArrayList<Map>();
            for (Map m : syncList) {
                if (userSourceMap.containsKey(m.get("empId").toString())) {
                    m.put("Title_Sid", userSourceMap.get(m.get("empId").toString()));
                    syncDataList.add(m);
                    continue;
                }
                this.logger.error("\u83b7\u53d6\u5ba1\u6838\u4ebaid-{}\u4fe1\u606f\u5931\u8d25\uff0c\u8df3\u8fc7\u63a8\u9001ERP\uff01", (Object)m.get("empId").toString());
            }
            if (CollectionUtils.isEmpty(syncDataList)) {
                this.logger.info("\u4e34\u65f6\u6863\u6848\u5ba1\u6838\u4eba\u63a8\u9001\u4efb\u52a1\u6267\u884cERP\u5b8c\u6210\uff0c\u53ef\u63a8\u9001ERP\u4e34\u65f6\u6863\u6848\u5ba1\u6838\u4eba\u4e3a\u7a7a\uff0c\u540c\u6b65\u4efb\u52a1\u6267\u884c\u7ed3\u675f\uff01\uff01\uff01");
                return;
            }
            this.logger.info("\u4e34\u65f6\u6863\u6848\u5ba1\u6838\u4eba\u63a8\u9001\u4efb\u52a1\u6267\u884cERP\uff0c\u672c\u6b21\u5f85\u63a8\u9001ERP\u7269\u6599\u6863\u6848\u6570\u636e\uff1a{}\u6761", (Object)syncDataList.size());
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(syncDataList), headers, (Integer)60000, (Integer)60000);
            JSONObject syncResultJson = JSONObject.parseObject((String)reqResp);
            if (!"ok".equals(syncResultJson.getString("Status"))) {
                this.logger.error("\u4e34\u65f6\u6863\u6848\u5ba1\u6838\u4eba\u63a8\u9001ERP\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(syncList), JSONObject.toJSONString(headers, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), reqResp});
                return;
            }
            this.logger.error("\u4e34\u65f6\u6863\u6848\u5ba1\u6838\u4eba\u63a8\u9001ERP\uff0c\u8bf7\u6c42\u7ed3\u679c\u8fd4\u56de\u6210\u529f\uff0c\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)syncResultJson.getString("info"));
        }
        catch (Exception e) {
            this.logger.error("\u4e34\u65f6\u6863\u6848\u5ba1\u6838\u4eba\u63a8\u9001ERP\u5f02\u5e38\uff0c\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(syncList), JSONObject.toJSONString(headers, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), reqResp, e});
        }
    }
}

