/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.material.bean.MatSupplierManagerEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MatSupplierManagerMapper;
import com.ejianc.business.zdsmaterial.material.service.IMatSupplierManagerService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="matSupplierManagerService")
public class MatSupplierManagerServiceImpl
extends BaseServiceImpl<MatSupplierManagerMapper, MatSupplierManagerEntity>
implements IMatSupplierManagerService {
    @Autowired
    private MatSupplierManagerMapper mapper;

    @Override
    public List<MatSupplierManagerEntity> getAllByUserId(Long userId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"manager_id", (Object)userId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return super.list((Wrapper)query);
    }

    @Override
    public JSONObject queryCategoryList(QueryParam param) {
        JSONObject jsonObject = new JSONObject();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : param.getParams().entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<MaterialCategoryVO> dataList = this.mapper.queryCategoryList(condition);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l -> {
            if (l.get("leafFlag").equals(false)) {
                l.put("children", new ArrayList());
            }
        });
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return jsonObject;
    }

    @Override
    public List<Long> getAllByCategoryIdAndEmpIds(Long categoryId, List<Long> empIds) {
        List<Long> resp = new ArrayList<Long>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"manager_id", empIds);
        query.eq((Object)"category_id", (Object)categoryId);
        List eList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            resp = eList.stream().map(MatSupplierManagerEntity::getManagerId).collect(Collectors.toList());
        }
        return resp;
    }

    @Override
    public List<MatSupplierManagerEntity> getAllByCategoryIds(List<Long> categoryIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"category_id", categoryIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return super.list((Wrapper)query);
    }

    @Override
    public List<MatSupplierManagerEntity> getAllByIds(List<Long> ids) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return super.list((Wrapper)query);
    }
}

