/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.out.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.zdsmaterial.cons.enums.BillPushStatusEnum;
import com.ejianc.business.zdsmaterial.out.bean.OutStoreEntity;
import com.ejianc.business.zdsmaterial.out.service.IOutStoreService;
import com.ejianc.business.zdsmaterial.out.vo.OutStoreVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outStore")
public class OutStoreBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOutStoreService service;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OutStoreEntity outStoreEntity = (OutStoreEntity)((Object)this.service.selectById(billId));
        this.service.inOutStore(outStoreEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        OutStoreEntity outStoreEntity = (OutStoreEntity)((Object)this.service.selectById(billId));
        this.service.inOutStoreRollback(outStoreEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutStoreEntity entity = (OutStoreEntity)((Object)this.service.selectById(billId));
        this.service.validateStoreNum((OutStoreVO)BeanMapper.map((Object)((Object)entity), OutStoreVO.class));
        this.service.validateOutNum((OutStoreVO)BeanMapper.map((Object)((Object)entity), OutStoreVO.class));
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutStoreEntity outStoreEntity = (OutStoreEntity)((Object)this.service.selectById(billId));
        outStoreEntity.setConfirmState("1");
        boolean pushFlag = this.service.pushBillToSupCenter(outStoreEntity);
        this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushFlag);
        if (!pushFlag) {
            outStoreEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        } else {
            outStoreEntity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        }
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
            this.service.inOutStore(outStoreEntity, false);
        }
        this.service.updateById((Object)outStoreEntity);
        return CommonResponse.success((String)"");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutStoreEntity outStoreEntity = (OutStoreEntity)((Object)this.service.selectById(billId));
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(outStoreEntity.getBillPushFlag())) {
            CommonResponse<String> commonResponse = this.service.updatePushBill(outStoreEntity);
            this.logger.info("\u4f9b\u65b9\u7ed3\u679c" + JSONObject.toJSONString(commonResponse));
            if (!commonResponse.isSuccess()) {
                return CommonResponse.error((String)("\u5f03\u5ba1\u63a8\u9001\u4f9b\u65b9\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + commonResponse.getMsg()));
            }
        }
        this.service.inOutStoreRollback(outStoreEntity, true);
        this.service.inOutStoreRollback(outStoreEntity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{outStoreEntity.getId()});
        updateWrapper.set(OutStoreEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }
}

