/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pick.service.impl;

import com.ejianc.business.zdsmaterial.accept.bean.AcceptDetailEntity;
import com.ejianc.business.zdsmaterial.accept.service.IAcceptDetailService;
import com.ejianc.business.zdsmaterial.accept.service.IAcceptService;
import com.ejianc.business.zdsmaterial.out.bean.OutStoreSubEntity;
import com.ejianc.business.zdsmaterial.out.service.IOutStoreService;
import com.ejianc.business.zdsmaterial.out.service.IOutStoreSubService;
import com.ejianc.business.zdsmaterial.pick.bean.ProPickSettingEntity;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubContractorEntity;
import com.ejianc.business.zdsmaterial.pick.bean.SubsetMaterialEntity;
import com.ejianc.business.zdsmaterial.pick.mapper.SubsetMaterialMapper;
import com.ejianc.business.zdsmaterial.pick.service.IProPickSettingService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubContractorService;
import com.ejianc.business.zdsmaterial.pick.service.ISubsetMaterialService;
import com.ejianc.business.zdsmaterial.pick.vo.SubsetMaterialVO;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumDetailService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subsetMaterialService")
public class SubsetMaterialServiceImpl
extends BaseServiceImpl<SubsetMaterialMapper, SubsetMaterialEntity>
implements ISubsetMaterialService {
    @Autowired
    private IControlPlanSumDetailService planDetailService;
    @Autowired
    private IOutStoreService outService;
    @Autowired
    private IOutStoreSubService outSubService;
    @Autowired
    private IAcceptService acceptService;
    @Autowired
    private IAcceptDetailService acceptDetailService;
    @Autowired
    private IProSubContractorService contractorService;
    @Autowired
    private IProPickSettingService settingService;

    @Override
    public void setPlanAndOutNum(List<SubsetMaterialVO> vos, Long contractId) {
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        List<Long> planDetailIds = vos.stream().map(SubsetMaterialVO::getPlanDetailId).distinct().collect(Collectors.toList());
        Map<Long, BigDecimal> planNumMap = this.getPlanNumMap(planDetailIds);
        List<Long> materialIds = vos.stream().map(SubsetMaterialVO::getMaterialId).distinct().collect(Collectors.toList());
        Map<Long, BigDecimal> outNumMap = this.getOutNumMap(contractId, materialIds);
        for (SubsetMaterialVO vo : vos) {
            if (planNumMap.containsKey(vo.getPlanDetailId())) {
                vo.setPlanNum(planNumMap.get(vo.getPlanDetailId()));
            }
            if (!outNumMap.containsKey(vo.getMaterialId())) continue;
            vo.setOutNum(outNumMap.get(vo.getMaterialId()));
        }
    }

    @Override
    public Map<Long, BigDecimal> getNumMap(Long projectId, Long contractId, List<Long> materialIds) {
        QueryParam queryParam = new QueryParam();
        if (CollectionUtils.isEmpty(materialIds)) {
            return new HashMap<Long, BigDecimal>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        List setList = this.settingService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)setList)) {
            return new HashMap<Long, BigDecimal>();
        }
        QueryParam cparam = new QueryParam();
        cparam.getParams().put("settingId", new Parameter("eq", (Object)((ProPickSettingEntity)((Object)setList.get(0))).getId()));
        if (null != contractId) {
            cparam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
            List contList = this.contractorService.queryList(cparam);
            if (CollectionUtils.isEmpty((Collection)contList)) {
                return new HashMap<Long, BigDecimal>();
            }
            queryParam.getParams().put("contractorId", new Parameter("eq", (Object)((ProSubContractorEntity)((Object)contList.get(0))).getId()));
        }
        queryParam.getParams().put("materialId", new Parameter("in", materialIds));
        List list = super.queryList(queryParam);
        Map<Long, BigDecimal> map = list.stream().collect(Collectors.toMap(x -> x.getMaterialId(), x -> x.getNum(), (v1, v2) -> v2));
        Map<Long, BigDecimal> outNumMap = this.getOutNumMap(contractId, materialIds);
        for (Long key : map.keySet()) {
            if (!outNumMap.containsKey(key)) continue;
            map.put(key, ComputeUtil.safeSub((BigDecimal)map.get(key), (BigDecimal)outNumMap.get(key)));
        }
        return map;
    }

    private Map<Long, BigDecimal> getPlanNumMap(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new HashMap<Long, BigDecimal>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", ids));
        List list = this.planDetailService.queryList(param);
        Map<Long, BigDecimal> map = list.stream().collect(Collectors.toMap(x -> x.getId(), x -> x.getNum()));
        return map;
    }

    private Map<Long, BigDecimal> getOutNumMap(Long contractId, List<Long> materialIds) {
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        if (CollectionUtils.isEmpty(materialIds)) {
            return map;
        }
        this.sumOutStoreNumMap(contractId, materialIds, map);
        this.sumCheckNumMap(contractId, materialIds, map);
        return map;
    }

    private void sumOutStoreNumMap(Long contractId, List<Long> materialIds, Map<Long, BigDecimal> map) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("subContractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("confirmState", new Parameter("eq", (Object)1));
        List dataList = this.outService.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return;
        }
        List ids = dataList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("outStoreId", new Parameter("in", ids));
        param.getParams().put("materialId", new Parameter("in", materialIds));
        List list = this.outSubService.queryList(param);
        for (OutStoreSubEntity vo : list) {
            BigDecimal num = BigDecimal.ZERO;
            if (map.containsKey(vo.getMaterialId())) {
                num = map.get(vo.getMaterialId());
            }
            num = ComputeUtil.safeAdd((BigDecimal)num, (BigDecimal)vo.getNum());
            map.put(vo.getMaterialId(), num);
        }
    }

    private void sumCheckNumMap(Long contractId, List<Long> materialIds, Map<Long, BigDecimal> map) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("acceptType", new Parameter("eq", (Object)1));
        List dataList = this.acceptService.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return;
        }
        List ids = dataList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("acceptId", new Parameter("in", ids));
        param.getParams().put("materialId", new Parameter("in", materialIds));
        List list = this.acceptDetailService.queryList(param);
        for (AcceptDetailEntity vo : list) {
            BigDecimal num = BigDecimal.ZERO;
            if (map.containsKey(vo.getMaterialId())) {
                num = map.get(vo.getMaterialId());
            }
            num = ComputeUtil.safeAdd((BigDecimal)num, (BigDecimal)vo.getDetailNum());
            map.put(vo.getMaterialId(), num);
        }
    }
}

