/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.accept.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptDetailEntity;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.accept.service.IAcceptService;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.enums.DeliveryAcceptStatusEnums;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.erp.vo.OrderVO;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="accept")
public class AcceptBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAcceptService service;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        AcceptEntity entity = (AcceptEntity)((Object)this.service.selectById(billId));
        if (CollectionUtils.isEmpty(entity.getDetailList())) {
            return CommonResponse.error((String)"\u660e\u7ec6\u4e3a\u7a7a\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u80fd\u63d0\u4ea4\uff01");
        }
        return CommonResponse.success();
    }

    public void returnDeliveryOrOrder(AcceptEntity entity, Integer sourceType, Boolean status) {
        for (AcceptDetailEntity detail : entity.getDetailList()) {
            detail.setCheckNum(detail.getDetailNum());
        }
        if (sourceType == 0) {
            if (null != entity.getId() && status.booleanValue()) {
                AcceptEntity accept = (AcceptEntity)((Object)this.service.selectById(entity.getId()));
                List<AcceptDetailEntity> detailList = accept.getDetailList();
                Map<Long, AcceptDetailEntity> collect = detailList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
                List<AcceptDetailEntity> detailList1 = entity.getDetailList();
                if (!collect.isEmpty()) {
                    for (AcceptDetailEntity detail : detailList1) {
                        if (!collect.containsKey(detail.getId()) || "del".equals(detail.getRowState())) continue;
                        BigDecimal detailNum = detail.getDetailNum();
                        BigDecimal detailNum1 = collect.get(detail.getId()).getDetailNum();
                        detail.setCheckNum(ComputeUtil.safeSub((BigDecimal)detailNum, (BigDecimal)detailNum1));
                    }
                }
            }
            this.deliveryService.returnDeliveryOrOrder(entity, status);
        } else if (sourceType == 1) {
            this.orderService.returnHandAcceptNum(entity, status);
        }
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        String s;
        AcceptEntity entity = (AcceptEntity)((Object)this.service.selectById(billId));
        if (null == entity) {
            // empty if block
        }
        if (entity.getSourceType() == 0) {
            if (0 == entity.getFinalAcceptFlag() && 0 == entity.getCloseDelivery()) {
                this.deliveryService.updateAcceptStatus(entity.getDeliveryBillId(), DeliveryAcceptStatusEnums.\u5206\u6279\u9a8c\u6536.getCode());
            } else if (1 == entity.getFinalAcceptFlag() && 1 == entity.getCloseDelivery()) {
                this.deliveryService.updateAcceptStatus(entity.getDeliveryBillId(), DeliveryAcceptStatusEnums.\u9a8c\u6536\u5b8c\u6210.getCode());
            } else if (0 == entity.getFinalAcceptFlag() && 1 == entity.getCloseDelivery()) {
                this.deliveryService.updateAcceptStatus(entity.getDeliveryBillId(), DeliveryAcceptStatusEnums.\u90e8\u5206\u9000\u56de.getCode());
                this.deliveryDetailService.updateDeliveryResNum(entity, true);
            }
        }
        if (entity.getSourceType() == 0 || entity.getSourceType() == 1) {
            DeliveryEntity deliveryEntity;
            String s2;
            if (entity.getSourceType() == 0 && StringUtils.isNotBlank((CharSequence)(s2 = this.deliveryService.updateSupDelivery(deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(entity.getDeliveryBillId())))))) {
                throw new BusinessException(s2);
            }
            OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(entity.getOrderBillId()));
            String supBusiness = this.orderService.pushToSupBusiness((OrderVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class));
            if (StringUtils.isNotBlank((CharSequence)supBusiness)) {
                throw new BusinessException(supBusiness);
            }
        }
        if (entity.getAcceptType() == 1 && entity.getSubcontractorId() != null ? StringUtils.isNotBlank((CharSequence)(s = this.service.pushSubReturn(entity))) : entity.getSupplierId() != null && StringUtils.isNotBlank((CharSequence)(s = this.service.pushSubAccept(entity)))) {
            throw new BusinessException(s);
        }
        if (entity.getAcceptType() == 1) {
            this.service.inToStore(entity, false);
        } else {
            this.service.inToStore(entity, true);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        AcceptEntity checkEntity = (AcceptEntity)((Object)this.service.selectById(billId));
        this.returnDeliveryOrOrder(checkEntity, checkEntity.getSourceType(), false);
        if (checkEntity.getSourceType() == 0 && checkEntity.getSourceType() == 1) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"contract_id", (Object)checkEntity.getContractId());
            queryWrapper.notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            int count = this.service.count((Wrapper)queryWrapper);
            if (count > 0) {
                throw new BusinessException("\u4e00\u4e2a\u5408\u540c\u53ea\u6709\u5b58\u5728\u4e00\u4e2a\u81ea\u7531\u6001\u7684\u9a8c\u6536\u5355!");
            }
            QueryWrapper queryWrapper1 = new QueryWrapper();
            if (checkEntity.getSourceType() == 0) {
                queryWrapper1.eq((Object)"order_bill_id", (Object)checkEntity.getOrderBillId());
            } else {
                queryWrapper1.eq((Object)"delivery_bill_id", (Object)checkEntity.getDeliveryBillId());
            }
            queryWrapper1.eq((Object)"source_type", (Object)checkEntity.getSourceType());
            queryWrapper1.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            queryWrapper1.orderByDesc((Object)"create_time");
            List list = this.service.list((Wrapper)queryWrapper1);
            if (!((AcceptEntity)((Object)list.get(0))).getId().equals(checkEntity.getId())) {
                throw new BusinessException("\u6700\u65b0\u7684\u5355\u636e\u624d\u53ef\u4ee5\u64a4\u56de!");
            }
        }
        if (checkEntity.getMaterialSignatureStatus() == 1) {
            return CommonResponse.error((String)"\u4f9b\u65b9\u5df2\u7b7e\u5b57,\u65e0\u6cd5\u64a4\u56de!");
        }
        String s = this.service.deletePickReturnBill(checkEntity);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            return CommonResponse.error((String)s);
        }
        if (checkEntity.getSignatureStatus() == 1) {
            return CommonResponse.error((String)"\u5206\u5305\u5546\u5df2\u7b7e\u5b57,\u65e0\u6cd5\u64a4\u56de!");
        }
        if (checkEntity.getSourceType() == 2 && StringUtils.isNotBlank((CharSequence)(s = this.service.deleteReturnBill(checkEntity)))) {
            return CommonResponse.error((String)s);
        }
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        AcceptEntity entity = (AcceptEntity)((Object)this.service.selectById(billId));
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(billId);
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setSourceId(entity.getId());
        storeManageVO.setStoreId(entity.getStoreId());
        if (entity.getAcceptType() == 0) {
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6536\u6599\u5165\u5e93);
        } else {
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93);
        }
        storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
        String stringInfo = JSONObject.toJSONString((Object)storeManageVO);
        this.logger.info("\u64a4\u56de\u53c2\u6570\uff1a" + stringInfo);
        CommonResponse response = this.storeManageApi.inOutStoreRollback(storeManageVO);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        this.logger.info("xhc\u63a8\u9001\u4ed3\u5e93\u6210\u529f:" + response.getMsg());
        if (entity.getSourceType() == 0) {
            if (0 == entity.getFinalAcceptFlag() && 0 == entity.getCloseDelivery()) {
                this.deliveryService.updateAcceptStatus(entity.getDeliveryBillId(), DeliveryAcceptStatusEnums.\u9a8c\u6536\u4e2d.getCode());
            } else if (1 == entity.getFinalAcceptFlag() && 1 == entity.getCloseDelivery()) {
                this.deliveryService.updateAcceptStatus(entity.getDeliveryBillId(), DeliveryAcceptStatusEnums.\u9a8c\u6536\u4e2d.getCode());
            } else if (0 == entity.getFinalAcceptFlag() && 1 == entity.getCloseDelivery()) {
                this.deliveryService.updateAcceptStatus(entity.getDeliveryBillId(), DeliveryAcceptStatusEnums.\u9a8c\u6536\u4e2d.getCode());
                this.deliveryDetailService.updateDeliveryResNum(entity, false);
            }
        }
        if (entity.getSourceType() == 0 || entity.getSourceType() == 1) {
            DeliveryEntity deliveryEntity;
            String s;
            if (entity.getSourceType() == 0 && StringUtils.isNotBlank((CharSequence)(s = this.deliveryService.updateSupDelivery(deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(entity.getDeliveryBillId())))))) {
                throw new BusinessException(s);
            }
            OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(entity.getOrderBillId()));
            String supBusiness = this.orderService.pushToSupBusiness((OrderVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class));
            if (StringUtils.isNotBlank((CharSequence)supBusiness)) {
                throw new BusinessException(supBusiness);
            }
        }
        return CommonResponse.success();
    }
}

