/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.accept.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.accept.AcceptVO;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptDetailEntity;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.accept.enums.BillPushStatusEnum;
import com.ejianc.business.zdsmaterial.accept.enums.SignatureStatusEnum;
import com.ejianc.business.zdsmaterial.accept.mapper.AcceptMapper;
import com.ejianc.business.zdsmaterial.accept.service.IAcceptDetailService;
import com.ejianc.business.zdsmaterial.accept.service.IAcceptService;
import com.ejianc.business.zdsmaterial.cloudstore.constants.CommonConstants;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryEntity;
import com.ejianc.business.zdsmaterial.erp.service.IContractService;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="acceptService")
public class AcceptServiceImpl
extends BaseServiceImpl<AcceptMapper, AcceptEntity>
implements IAcceptService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZDS-ACC";
    private static final String OTHER_BILL_CODE = "ZDS-OTH-ACC";
    private static final String BILL_TYPE_CODE = "EJCBT202312000001";
    private static final String OTHER_BILL_TYPE_CODE = "EJCBT202312000020";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAcceptDetailService acceptDetailService;
    @Autowired
    private IOrderService orderService;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAttachmentApi attachmentApi;
    private final String OPERATE = "ACCEPT_TO_SUB";
    private final String PUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/accept/pushSubAccept";
    private final String PUSH_BILL_RETURN_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/outRecord/saveAcceptOutStore";
    private final String BILL_DEL_PM_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/accept/billDel";
    private final String DELPUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/outRecord/delAcceptOutStore";
    private static final String SOURCE_TYPE_004 = "type004";
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;

    @Override
    public AcceptVO saveOrUpdate(AcceptVO saveOrUpdateVO) {
        AcceptEntity entity = (AcceptEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AcceptEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam;
            CommonResponse billCode;
            int count;
            QueryWrapper queryWrapper;
            if (null != entity.getDeliveryBillId() && 0 == entity.getSourceType()) {
                queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"delivery_bill_id", (Object)entity.getDeliveryBillId());
                queryWrapper.notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
                count = super.count((Wrapper)queryWrapper);
                if (count > 0) {
                    throw new BusinessException("\u4e00\u4e2a\u53d1\u8d27\u5355\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u81ea\u7531\u6001\u7684\u9a8c\u6536\u5355!");
                }
            }
            if (null != entity.getContractId()) {
                queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"order_bill_id", (Object)entity.getOrderBillId());
                queryWrapper.notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
                count = super.count((Wrapper)queryWrapper);
                if (count > 0) {
                    throw new BusinessException("\u4e00\u4e2a\u8ba2\u5355\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u81ea\u7531\u6001\u7684\u9a8c\u6536\u5355!");
                }
            }
            entity.getDeliveryBillId();
            String type = BILL_CODE;
            if (entity.getSourceType() == 2) {
                type = OTHER_BILL_CODE;
            }
            if (!(billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)type, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u5b57.getStatus());
            entity.setMaterialSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u5b57.getStatus());
            entity.setSubSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u5b57.getStatus());
            entity.setSignatureUserId(this.sessionManager.getUserContext().getUserId());
            entity.setSignatureUserName(this.sessionManager.getUserContext().getUserName());
            entity.setSignatureUserPhone(this.sessionManager.getUserContext().getUserMobile());
        }
        if (CollectionUtils.isNotEmpty(entity.getDetailList()) && (entity.getSourceType() == 1 || entity.getSourceType() == 0)) {
            this.saveCheckDetailList(entity);
        } else {
            entity.setFinalAcceptFlag(0);
        }
        if ((entity.getSourceType() == 0 || entity.getSourceType() == 1) && CollectionUtils.isNotEmpty(entity.getDetailList())) {
            this.returnDeliveryOrOrder(entity, entity.getSourceType(), true);
        }
        if (entity.getSourceType() == 0) {
            this.checkFinalAcceptFlag(entity);
        }
        if (entity.getSourceType() == 1) {
            entity.setFinalAcceptFlag(0);
            entity.setCloseDelivery(entity.getFinalAcceptFlag());
        }
        entity.setCloseDelivery(entity.getFinalAcceptFlag());
        String materialNames = entity.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty((CharSequence)x.getMaterialTypeName())).map(AcceptDetailEntity::getMaterialName).distinct().collect(Collectors.joining(","));
        entity.setMaterialNames(materialNames);
        String materialTypeNames = entity.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty((CharSequence)x.getMaterialTypeName())).map(AcceptDetailEntity::getMaterialTypeName).collect(Collectors.toSet()).stream().distinct().collect(Collectors.joining(","));
        entity.setAcceptContent(materialTypeNames);
        super.saveOrUpdate((Object)entity, false);
        return (AcceptVO)BeanMapper.map((Object)((Object)entity), AcceptVO.class);
    }

    public void returnDeliveryOrOrder(AcceptEntity entity, Integer sourceType, Boolean status) {
        for (AcceptDetailEntity detail : entity.getDetailList()) {
            detail.setCheckNum(detail.getDetailNum());
        }
        if (sourceType == 0) {
            if (null != entity.getId() && status.booleanValue()) {
                AcceptEntity accept = (AcceptEntity)((Object)super.selectById((Serializable)entity.getId()));
                List<AcceptDetailEntity> detailList = accept.getDetailList();
                Map<Long, AcceptDetailEntity> collect = detailList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
                List<AcceptDetailEntity> detailList1 = entity.getDetailList();
                if (!collect.isEmpty()) {
                    for (AcceptDetailEntity detail : detailList1) {
                        if (!collect.containsKey(detail.getId()) || "del".equals(detail.getRowState())) continue;
                        BigDecimal detailNum = detail.getDetailNum();
                        BigDecimal detailNum1 = collect.get(detail.getId()).getDetailNum();
                        detail.setCheckNum(ComputeUtil.safeSub((BigDecimal)detailNum, (BigDecimal)detailNum1));
                    }
                }
            }
            this.deliveryService.returnDeliveryOrOrder(entity, status);
        } else if (sourceType == 1) {
            this.orderService.returnHandAcceptNum(entity, status);
        }
    }

    @Override
    public Map<Long, BigDecimal> getAlreadyDetailNum(List<Long> detailIds, List<Long> ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_detail_id", detailIds);
        queryWrapper.in((Object)"source_type", Arrays.asList("1", "0"));
        if (CollectionUtils.isNotEmpty(ids)) {
            queryWrapper.notIn((Object)"id", ids);
        }
        List list = this.acceptDetailService.list((Wrapper)queryWrapper);
        Map<Long, BigDecimal> contractDetailBigDecimalList = list.stream().collect(Collectors.groupingBy(AcceptDetailEntity::getSourceDetailId, Collectors.reducing(BigDecimal.ZERO, AcceptDetailEntity::getDetailNum, BigDecimal::add)));
        return contractDetailBigDecimalList;
    }

    public Map<Long, BigDecimal> getDetailNum(List<Long> detailIds, List<Long> ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_detail_id", detailIds);
        queryWrapper.eq((Object)"source_type", (Object)"0");
        if (CollectionUtils.isNotEmpty(ids)) {
            queryWrapper.notIn((Object)"id", ids);
        }
        List list = this.acceptDetailService.list((Wrapper)queryWrapper);
        Map<Long, BigDecimal> contractDetailBigDecimalList = list.stream().collect(Collectors.groupingBy(AcceptDetailEntity::getSourceDetailId, Collectors.reducing(BigDecimal.ZERO, AcceptDetailEntity::getDetailNum, BigDecimal::add)));
        return contractDetailBigDecimalList;
    }

    @Override
    public void delete(List<AcceptVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AcceptVO entity : vos) {
                AcceptEntity entity1 = (AcceptEntity)((Object)super.selectById((Serializable)entity.getId()));
                if (entity1.getSourceType() == 2 || !CollectionUtils.isNotEmpty(entity1.getDetailList())) continue;
                this.returnDeliveryOrOrder(entity1, entity1.getSourceType(), false);
            }
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    public ParamsCheckVO checkParams(AcceptVO acceptVO) {
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList paramsCheckVOList = new ArrayList();
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0 && null != e.getWarnType()).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for (ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }

    @Override
    public void inToStore(AcceptEntity entity, Boolean outEffectiveON) {
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            Integer acceptType = entity.getAcceptType();
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setOutEffectiveON(outEffectiveON);
            storeManageVO.setSourceId(entity.getId());
            ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
            if (acceptType == 0) {
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6536\u6599\u5165\u5e93);
                for (int i = 0; i < entity.getDetailList().size(); ++i) {
                    FlowVO flowVO = new FlowVO();
                    flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u6536\u6599\u5165\u5e93, (Integer)0);
                    this.getFlow(entity, entity.getDetailList().get(i), flowVO);
                    flowVOS.add(flowVO);
                }
            } else {
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93);
                for (int i = 0; i < entity.getDetailList().size(); ++i) {
                    FlowVO flowVO = new FlowVO();
                    flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93, (Integer)0);
                    this.getFlow(entity, entity.getDetailList().get(i), flowVO);
                    flowVOS.add(flowVO);
                }
                ArrayList<FlowVO> flowOutS = new ArrayList<FlowVO>();
                for (int i = 0; i < entity.getDetailList().size(); ++i) {
                    FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u51fa\u5e93, (Integer)0);
                    this.getFlow(entity, entity.getDetailList().get(i), flowVO);
                    flowOutS.add(flowVO);
                }
                storeManageVO.setStraightOutFlowVOList(flowOutS);
            }
            storeManageVO.setFlowVOList(flowVOS);
            this.logger.info("\u5e93\u5b58\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)storeManageVO));
            CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
            if (!response.isSuccess()) {
                this.logger.info("\u6d4b\u8bd5\u62a5\u951901");
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f" + response.getMsg());
            }
        }
    }

    private void getFlow(AcceptEntity entity, AcceptDetailEntity t, FlowVO flowVO) {
        flowVO.setBrandId(t.getBrandId());
        flowVO.setBrandName(t.getBrandName());
        flowVO.setLicensePlate(entity.getCarCode());
        flowVO.setSupplierId(entity.getSupplierId());
        flowVO.setSupplierName(entity.getSupplierName());
        flowVO.setEmployeeId(entity.getSiteAcceptorId());
        flowVO.setEmployeeName(entity.getSiteAcceptorName());
        flowVO.setOrgId(entity.getOrgId());
        flowVO.setOrgName(entity.getOrgName());
        flowVO.setParentOrgId(entity.getParentOrgId());
        flowVO.setParentOrgName(entity.getParentOrgName());
        flowVO.setProjectId(entity.getProjectId());
        flowVO.setProjectName(entity.getProjectName());
        flowVO.setPurchaseContractId(entity.getContractId());
        flowVO.setPurchaseContractName(entity.getContractName());
        flowVO.setSupplierId(entity.getSupplierId());
        flowVO.setSupplierName(entity.getSupplierName());
        flowVO.setBillCode(entity.getBillCode());
        flowVO.setMaterialCategoryCode(t.getMaterialTypeCode());
        flowVO.setSourceType(StoreCommonConsts.ZERO);
        if (entity.getAcceptType() == 1) {
            flowVO.setInOutType(InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93.getInOutType());
            flowVO.setInOutTypeName(InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93.getInOutTypeName());
            flowVO.setSourceBillTypeName("\u76f4\u5165\u76f4\u51fa\u5165\u5e93");
            flowVO.setPickContractId(entity.getPickContractId());
            flowVO.setPickContractName(entity.getPickContractName());
        } else {
            flowVO.setInOutType(InOutTypeEnum.\u6536\u6599\u5165\u5e93.getInOutType());
            flowVO.setInOutTypeName(InOutTypeEnum.\u6536\u6599\u5165\u5e93.getInOutTypeName());
            flowVO.setSourceBillTypeName("\u6536\u6599\u5165\u5e93");
        }
        if (null != entity.getContractId()) {
            flowVO.setPurchaseContractId(entity.getContractId());
            flowVO.setPurchaseContractName(entity.getContractName());
        }
        flowVO.setStoreId(entity.getStoreId());
        flowVO.setStoreName(entity.getStoreName());
        flowVO.setSourceBillDate(entity.getPickupDate());
        flowVO.setBillDate(entity.getPickupDate());
        flowVO.setMaterialCategoryName(t.getMaterialTypeName());
        flowVO.setMaterialCategoryId(t.getMaterialTypeId());
        flowVO.setMaterialTypeName(t.getMaterialTypeName());
        flowVO.setMaterialName(t.getMaterialName());
        flowVO.setMaterialId(t.getMaterialId());
        flowVO.setMaterialCode(t.getMaterialCode());
        flowVO.setMaterialSpec(t.getPropertyValue());
        flowVO.setMaterialUnitId(t.getDetailUnitId());
        flowVO.setMaterialUnitName(t.getDetailUnitName());
        flowVO.setNum(t.getDetailNum());
        flowVO.setPrice(t.getDetailPrice());
        flowVO.setTaxPrice(t.getDetailTaxPrice());
        flowVO.setTax(t.getDetailTax());
        flowVO.setTaxRate(t.getDetailTaxRate());
        flowVO.setMny(t.getDetailMny());
        flowVO.setTaxMny(t.getDetailTaxMny());
        flowVO.setSourceId(entity.getId());
        flowVO.setSourceDetailId(t.getId());
        flowVO.setSourceBillCode(entity.getBillCode());
        flowVO.setSourceBillDate(entity.getPickupDate());
        flowVO.setSourceBillRemark(entity.getMemo());
        flowVO.setSourceBillDetailRemark(t.getMemo());
        if (entity.getSourceType() == 2) {
            flowVO.setSourceBillTypeCode(OTHER_BILL_TYPE_CODE);
        } else {
            flowVO.setSourceBillTypeCode(BILL_TYPE_CODE);
        }
        flowVO.setLicensePlate(entity.getCarCode());
        flowVO.setProductCode(t.getProductCode());
        if (null != entity.getContractId()) {
            flowVO.setContractTaxPrice(t.getDetailTaxPrice());
            flowVO.setContractPrice(t.getDetailPrice());
        }
        flowVO.setRowState(t.getRowState());
    }

    public void saveCheckDetailList(AcceptEntity entity) {
        BigDecimal decimal;
        BigDecimal alreadyNum;
        BigDecimal detailNum;
        List<AcceptDetailEntity> detailList = entity.getDetailList();
        List collect = detailList.stream().filter(e -> !"del".equals(e.getRowState())).collect(Collectors.toList());
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        Integer priceType = contractEntity.getPriceType();
        for (AcceptDetailEntity detail : collect) {
            detailNum = detail.getDetailNum();
            alreadyNum = detail.getAlreadyNum();
            decimal = ComputeUtil.safeAdd((BigDecimal)detailNum, (BigDecimal)alreadyNum);
            if (entity.getSourceType() == 0 && ComputeUtil.isGreaterThan((BigDecimal)detailNum, (BigDecimal)detail.getResDeliveryNum())) {
                throw new BusinessException("\u7269\u6599\u660e\u7ec6[" + detail.getMaterialName() + ":" + detail.getMaterialCode() + "]\u672c\u6b21\u9a8c\u6536\u91cf\u5927\u4e8e\u5269\u4f59\u53ef\u9a8c\u6536\u91cf");
            }
            if (priceType == 1 || !ComputeUtil.isGreaterThan((BigDecimal)decimal, (BigDecimal)detail.getContractNum())) continue;
            throw new BusinessException("\u7269\u6599\u660e\u7ec6[" + detail.getMaterialName() + ":" + detail.getMaterialCode() + "]\u660e\u7ec6\u7d2f\u8ba1\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5408\u540c\u7b7e\u8ba2\u6570\u91cf");
        }
        if (entity.getSourceType() == 1) {
            for (AcceptDetailEntity detail : collect) {
                detailNum = detail.getDetailNum();
                alreadyNum = detail.getResOrderNum();
                decimal = ComputeUtil.safeAdd((BigDecimal)detailNum, (BigDecimal)alreadyNum);
                if (!ComputeUtil.isGreaterThan((BigDecimal)(decimal = ComputeUtil.safeAdd((BigDecimal)decimal, (BigDecimal)detail.getDeliveryNum())), (BigDecimal)detail.getOrderNum())) continue;
                throw new BusinessException("\u7269\u6599\u660e\u7ec6[" + detail.getMaterialName() + ":" + detail.getMaterialCode() + "]\u81ea\u5236\u9a8c\u6536\u91cf+\u53d1\u8d27\u91cf \u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u91cf\uff01");
            }
        }
    }

    @Override
    public void checkFinalAcceptFlag(AcceptEntity entity) {
        Integer sourceType = entity.getSourceType();
        if (sourceType == 0 || sourceType == 1) {
            List<AcceptDetailEntity> detailList = entity.getDetailList();
            entity.setFinalAcceptFlag(1);
            for (AcceptDetailEntity detail : detailList) {
                BigDecimal deliveryNum;
                BigDecimal detailNum = detail.getDetailNum();
                BigDecimal alreadyNum = detail.getAlreadyNum();
                BigDecimal totalNum = ComputeUtil.safeAdd((BigDecimal)detailNum, (BigDecimal)alreadyNum);
                if (sourceType != 0 || ComputeUtil.equals((BigDecimal)totalNum, (BigDecimal)(deliveryNum = detail.getDeliveryNum()))) continue;
                entity.setFinalAcceptFlag(0);
                break;
            }
            if (sourceType == 0) {
                Long deliveryBillId = entity.getDeliveryBillId();
                DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(deliveryBillId));
                for (DeliveryDetailEntity detail : deliveryEntity.getDetailList()) {
                    detail.getAlreadyNum();
                    if (ComputeUtil.equals((BigDecimal)detail.getAlreadyNum(), (BigDecimal)detail.getDeliveryNum())) continue;
                    entity.setFinalAcceptFlag(0);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String pushSubReturn(AcceptEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "EJCBT202312000001::" + entity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u9a8c\u6536\u5355-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return "\u63a8\u9001\u9a8c\u6536\u5355\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25";
        }
        entity.setSourceSystemId((String)ejcCloudSystemCode.getData());
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            entity.getDetailList().forEach(item -> item.setTenantId(null));
        }
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"ACCEPT_TO_SUB", (int)600);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transData", JSONObject.toJSONString((Object)((Object)entity)));
            this.logger.info("\u5411\u4f9b\u5e94\u5546\u9886\u6599\u51fa\u5e93-{}\u63a8\u9001\u9a8c\u6536\u5355\u636e\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/outRecord/saveAcceptOutStore", paramMap, entity.getSubcontractorId().toString(), null);
            if (syncReqResp.isSuccess()) {
                CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                } else {
                    this.logger.error("\u9886\u6599\u51fa\u5e93id-{}\u5904\u7406\u63a8\u9001\u9a8c\u6536id-{}\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), billPushResp.getMsg()});
                    msg = "\u63a8\u9001\u9a8c\u6536\u5355\u5931\u8d25\uff0c\u4f9b\u65b9\u9886\u6599\u51fa\u5e93\u5904\u7406\u63a8\u9001\u9a8c\u5355\u5931\u8d25";
                }
            } else {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u7ed3\u7b97\u5355\u636eid-{}\u7ed9\u4f9b\u65b9\u9886\u6599\u51fa\u5e93id-{}\u5931\u8d25, {}", new Object[]{entity.getId(), entity.getSupplierId(), syncReqResp.getMsg()});
                msg = "\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u9a8c\u6536\u5355\u5931\u8d25";
            }
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u6536\u5355id-{}\u63a8\u9001\u4f9b\u65b9\u9886\u6599\u51fa\u5e93\u5931\u8d25\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u9a8c\u6536\u5355\u63a8\u9001\u4f9b\u65b9\u9886\u6599\u51fa\u5e93\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, BILL_TYPE_CODE);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String pushSubAccept(AcceptEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "EJCBT202312000001::" + entity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u9a8c\u6536\u5355-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return "\u63a8\u9001\u9a8c\u6536\u5355\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25";
        }
        entity.setSourceSystemId((String)ejcCloudSystemCode.getData());
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            entity.getDetailList().forEach(item -> item.setTenantId(null));
        }
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"ACCEPT_TO_SUB", (int)600);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transData", JSONObject.toJSONString((Object)((Object)entity)));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), null, null, null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u9a8c\u6536\u5355\u636e\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/accept/pushSubAccept", paramMap, entity.getSupplierId().toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                    } else {
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u9a8c\u6536id-{}\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), billPushResp.getMsg()});
                        msg = "\u63a8\u9001\u9a8c\u6536\u5355\u5931\u8d25\uff0c\u4f9b\u65b9\u5904\u7406\u63a8\u9001\u9a8c\u5355\u5931\u8d25";
                    }
                } else {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u7ed3\u7b97\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{entity.getId(), entity.getSupplierId(), syncReqResp.getMsg()});
                    msg = "\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u9a8c\u6536\u5355\u5931\u8d25";
                }
            } else {
                this.logger.error("\u83b7\u53d6\u9a8c\u6536id-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)entity.getId(), (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u6536\u5355id-{}\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u9a8c\u6536\u5355\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, BILL_TYPE_CODE);
        }
        return msg;
    }

    @Override
    public void updateSignatureStatus(Long acceptId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)acceptId);
        updateWrapper.set((Object)"signature_status", (Object)1);
        super.update((Wrapper)updateWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String deletePickReturnBill(AcceptEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "ACCEPT_TO_SUB::" + entity.getId().toString() + "::sup";
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"ACCEPT_TO_SUB", (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, "ACCEPT_TO_SUB");
                String string = "\u6750\u6599\u9a8c\u6536\u4f5c\u5e9f\u5931\u8d25\uff0c\u52a0\u9501\u5931\u8d25\uff01";
                return string;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sourceId", entity.getId().toString());
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                this.logger.error("\u63a8\u9001\u9a8c\u6536-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
                String string = "\u63a8\u9001\u9a8c\u6536\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25";
                return string;
            }
            this.logger.info("\u6750\u6599\u9a8c\u6536\u4f5c\u5e9f\u901a\u77e5\u4f9b\u65b9\u5e73\u53f0: url-{}, \u6750\u6599\u9000\u5e93\uff1a{}", (Object)"/ejc-zdssupbusiness-web/openapi/accept/billDel", (Object)JSONObject.toJSONString((Object)((Object)entity)));
            CommonResponse writeBackResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/accept/billDel", params, entity.getSupplierId().toString(), null);
            this.logger.error("\u6750\u6599\u9a8c\u6536\u4f5c\u5e9f\u901a\u77e5\u4f9b\u65b9\u5e73\u53f0\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)JSONObject.toJSONString((Object)writeBackResp));
            if (!writeBackResp.isSuccess()) {
                this.releaseLock(jedis, true, key, "ACCEPT_TO_SUB");
                this.logger.error("\u6750\u6599\u9a8c\u6536id-{}\u4f5c\u5e9f\u901a\u77e5\u4f9b\u65b9\u5e73\u53f0\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)writeBackResp.getMsg());
                String string = "\u9a8c\u6536\u4f5c\u5e9f\u901a\u77e5\u4f9b\u65b9\u5e73\u53f0\u5931\u8d25";
                return string;
            }
            String operateRespStr = (String)writeBackResp.getData();
            CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                this.logger.error("\u6750\u6599\u9a8c\u6536id-{}\u63a8\u9001\u4f9b\u65b9\uff0c\u5e73\u53f0\u5904\u7406\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)operateResp.getMsg());
                this.releaseLock(jedis, true, key, "ACCEPT_TO_SUB");
                String string = "\u6750\u6599\u9a8c\u6536\u4f5c\u5e9f\u901a\u77e5\u4f9b\u65b9\u5e73\u53f0\u5931\u8d25";
                return string;
            }
        }
        catch (Exception e) {
            this.logger.error("\u6750\u6599\u9a8c\u6536id-{}\u4f5c\u5e9f\u901a\u77e5\u4f9b\u65b9\u5e73\u53f0\u5931\u8d25\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u6750\u6599\u9a8c\u6536\u4f5c\u5e9f\u901a\u77e5\u4f9b\u65b9\u5e73\u53f0\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "ACCEPT_TO_SUB");
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String deleteReturnBill(AcceptEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "ACCEPT_TO_SUB::" + entity.getId().toString() + "::sup";
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"ACCEPT_TO_SUB", (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, "ACCEPT_TO_SUB");
                String string = "\u6750\u6599\u9a8c\u6536\u4f5c\u5e9f\u5931\u8d25\uff0c\u52a0\u9501\u5931\u8d25\uff01";
                return string;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", entity.getId().toString());
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                this.logger.error("\u63a8\u9001\u9a8c\u6536-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
                String string = "\u63a8\u9001\u9a8c\u6536\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25";
                return string;
            }
            params.put("systemId", ((String)ejcCloudSystemCode.getData()).toString());
            this.logger.info("\u6750\u6599\u9a8c\u6536\u4f5c\u5e9f\u901a\u77e5\u5206\u5305\u5546\u5e73\u53f0: url-{}, \u6750\u6599\u9000\u5e93\uff1a{}", (Object)"/ejc-zdssupbusiness-web/openapi/outRecord/delAcceptOutStore", (Object)JSONObject.toJSONString((Object)((Object)entity)));
            CommonResponse writeBackResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/accept/billDel", params, entity.getSupplierId().toString(), null);
            this.logger.error("\u6750\u6599\u9a8c\u6536\u4f5c\u5e9f\u901a\u77e5\u5206\u5305\u5546\u5e73\u53f0\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)JSONObject.toJSONString((Object)writeBackResp));
            if (!writeBackResp.isSuccess()) {
                this.releaseLock(jedis, true, key, "ACCEPT_TO_SUB");
                this.logger.error("\u6750\u6599\u9a8c\u6536id-{}\u4f5c\u5e9f\u901a\u77e5\u5206\u5305\u5546\u5e73\u53f0\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)writeBackResp.getMsg());
                String string = "\u9a8c\u6536\u4f5c\u5e9f\u901a\u77e5\u5206\u5305\u5546\u5e73\u53f0\u5931\u8d25";
                return string;
            }
            String operateRespStr = (String)writeBackResp.getData();
            CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                this.logger.error("\u6750\u6599\u9a8c\u6536id-{}\u63a8\u9001\u5206\u5305\u5546\uff0c\u5e73\u53f0\u5904\u7406\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)operateResp.getMsg());
                this.releaseLock(jedis, true, key, "ACCEPT_TO_SUB");
                String string = "\u6750\u6599\u9a8c\u6536\u4f5c\u5e9f\u901a\u77e5\u5206\u5305\u5546\u5e73\u53f0\u5931\u8d25";
                return string;
            }
        }
        catch (Exception e) {
            this.logger.error("\u6750\u6599\u9a8c\u6536id-{}\u4f5c\u5e9f\u901a\u77e5\u5206\u5305\u5546\u5e73\u53f0\u5931\u8d25\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u6750\u6599\u9a8c\u6536\u4f5c\u5e9f\u901a\u77e5\u5206\u5305\u5546\u5e73\u53f0\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "ACCEPT_TO_SUB");
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String subsignatureUserId = request.getParameter("subsignatureUserId");
        String subsignatureUserName = request.getParameter("subsignatureUserName");
        String subsignatureUserPhone = request.getParameter("subsignatureUserPhone");
        String acceptType = request.getParameter("acceptType");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        AcceptEntity entity = (AcceptEntity)((Object)super.selectById((Serializable)((Object)billId)));
        String billType = BILL_TYPE_CODE;
        if (entity.getSourceType() == 2) {
            billType = OTHER_BILL_TYPE_CODE;
        }
        if (acceptType.equals("1")) {
            String s;
            entity.setSubSignatureUserId(Long.valueOf(subsignatureUserId));
            entity.setSubSignatureUserName(subsignatureUserName);
            entity.setSubSignatureUserPhone(subsignatureUserPhone);
            entity.setSubSignatureDate(new Date());
            entity.setSubSignatureStatus(1);
            if (entity.getAcceptType() == 1) {
                this.inToStore(entity, true);
            }
            if (StringUtils.isNotBlank((CharSequence)(s = this.pushSubAccept(entity)))) {
                throw new BusinessException(s);
            }
        } else {
            entity.setMaterialSignatureUserId(Long.valueOf(subsignatureUserId));
            entity.setMaterialSignatureUserName(subsignatureUserName);
            entity.setMaterialSignatureUserPhone(subsignatureUserPhone);
            entity.setMaterialSignatureDate(new Date());
            entity.setMaterialSignatureStatus(1);
        }
        String key = billType + "::" + entity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"ACCEPT_TO_SUB", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)entity.getId());
                this.releaseLock(jedis, false, key, "ACCEPT_TO_SUB");
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, billType, authority, entity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            entity.setAttachIds(attchIdsList);
            super.saveOrUpdate((Object)entity, false);
            this.logger.info("\u9a8c\u6536\u7ed3\u679c\u5411\u4e59\u65b9\u8054\u7cfb\u4ebaid-{}\u53d1\u9001\u6d88\u606f", (Object)entity.getSiteAcceptorId().toString());
            PushMsgParameter parameter = new PushMsgParameter();
            parameter.setSubject("\u3010\u9a8c\u6536\u7ed3\u679c\u3011\uff1a\u3010" + entity.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u53d1\u8d27\u5355\u5df2\u9a8c\u6536\uff0c\u8bf7\u67e5\u770b\uff01");
            StringBuilder content = new StringBuilder();
            content.append("\u3010").append(entity.getSupplierName()).append("\u3011\uff0c\u60a8\u5411\u3010").append(entity.getProjectName()).append("\u3011\uff0c\u3010").append(entity.getContractName()).append("\u3011\uff0c\u7684\u53d1\u8d27\u5355\uff0c\u3010").append(entity.getSupplierName()).append("\u3011\uff0c\u5df2\u88ab\u9a8c\u6536\uff0c\u8bf7\u67e5\u770b\u9a8c\u6536\u7ed3\u679c\u3002");
            parameter.setContent(content.toString());
            parameter.setPcUrl(this.BASE_HOST + CommonConstants.\u7269\u8d44\u9a8c\u6536PC\u8be6\u60c5 + entity.getId().toString());
            parameter.setMobileUrl(this.BASE_HOST + CommonConstants.\u7269\u8d44\u9a8c\u6536\u79fb\u52a8\u7aef\u8be6\u60c5 + entity.getId().toString());
            String[] recIds = new String[]{entity.getSiteAcceptorId().toString()};
            parameter.setReceivers(recIds);
            this.sendMsg(parameter, entity.getId(), "\u9a8c\u6536\u7ed3\u679c\u5411\u4e59\u65b9\u8054\u7cfb\u4eba\u53d1\u9001\u6d88\u606f");
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "ACCEPT_TO_SUB");
        }
        return null;
    }

    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{"sys", "email"});
        CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("{}-\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u5355\u636eId-{}\uff0c\u53d1\u9001\u6d88\u606f\u7ed3\u679c-{}", new Object[]{oprMsg, billId, JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        } else {
            this.logger.info("{}-\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01", (Object)oprMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    private void executeUpdate(Long id, Boolean flag) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)id);
        if (Boolean.TRUE.equals(flag)) {
            updateWrapper.set((Object)"bill_push_flag", (Object)BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            updateWrapper.set((Object)"bill_push_flag", (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        super.update((Wrapper)updateWrapper);
    }

    public void toNumErp(AcceptEntity entity, boolean flag) {
        List<AcceptDetailEntity> detailList;
        Integer sourceType = entity.getSourceType();
        if (sourceType == 0 && CollectionUtils.isNotEmpty(detailList = entity.getDetailList())) {
            Map<Long, AcceptDetailEntity> acceptDetailEntityMap = detailList.stream().collect(Collectors.toMap(e -> e.getSourceDetailId(), e -> e));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", acceptDetailEntityMap.keySet());
            List deliveryDetailList = this.deliveryDetailService.list((Wrapper)queryWrapper);
            for (DeliveryDetailEntity item : deliveryDetailList) {
                if (!flag) continue;
                BigDecimal deliveryNum = item.getDeliveryNum();
                AcceptDetailEntity acceptDetailEntity = acceptDetailEntityMap.get(item.getId());
            }
        }
    }
}

