/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/brand/"})
public class BrandController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBrandService service;
    @Value(value="${erp.appId}")
    private String appId;
    @Value(value="${erp.secret}")
    private String secret;
    @Value(value="${erp.reqHost}")
    private String reqHost;
    @Value(value="${erp.batchSize:100}")
    private String batchSize;
    private final String BRAND_ERP_REQ_URL = "/cefoc/yql/getBrandList";

    @GetMapping(value={"refBrandData"})
    public CommonResponse<IPage<BrandVO>> refDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("brandName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Map params = param.getParams();
        params.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sequence", "asc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BrandVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"syncErpBrands"})
    public CommonResponse<String> syncErpBrands() {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u54c1\u724c\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        Integer pageNum = 0;
        Integer pageSize = Integer.valueOf(this.batchSize);
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        String reqUrl = this.reqHost + "/cefoc/yql/getBrandList";
        boolean hasNext = true;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            String nowStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
            headers.put("appid", BrandController.toMD5(this.appId));
            headers.put("ticket", nowStr);
            headers.put("sign", BrandController.toMD5(this.secret + BrandController.toMD5(this.appId) + BrandController.toMD5(nowStr)));
            param.put("PageSize", pageSize);
            JSONObject reqJson = null;
            JSONArray pageData = null;
            pageNum = pageNum + 1;
            param.put("PageNum", pageNum);
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)60000, (Integer)60000);
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                pageData = reqJson.getJSONArray("data");
                if (null != pageData && pageData.size() > 0) {
                    this.logger.info("\u4e2d\u7535\u56db\u54c1\u724c\u540c\u6b65\uff0c\u5904\u7406\u7b2c{}\u9875, {}\u6761\u6570\u636e", (Object)pageNum, (Object)pageData.size());
                    this.handleBrandErpPage(pageData);
                } else {
                    this.logger.info("\u4e2d\u7535\u56db\u54c1\u724c\u540c\u6b65 \u5904\u7406\u6570\u636e\u5b8c\u6210\uff01\uff01\uff01\u603b\u5171{}\u9875\u6570\u636e\uff01", (Object)pageNum);
                }
            } else {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u54c1\u724c\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u54c1\u724c\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)reqUrl, (Object)JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u54c1\u724c\u4fe1\u606f\u5f02\u5e38");
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u54c1\u724c\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u4e2d\u7535\u56db\u54c1\u724c\u540c\u6b65\u5b8c\u6210\uff01");
    }

    private void handleBrandErpPage(JSONArray data) {
        JSONObject tmp = null;
        BrandEntity tmpBrand = null;
        HashMap<String, BrandEntity> brandSourceIdMap = new HashMap<String, BrandEntity>();
        ArrayList<BrandEntity> saveList = new ArrayList<BrandEntity>();
        for (Object obj : data) {
            tmp = (JSONObject)obj;
            tmpBrand = new BrandEntity();
            tmpBrand.setBrandName(tmp.getString("Title"));
            tmpBrand.setSourceId(tmp.getString("C_PS_BrandLibraryOID"));
            tmpBrand.setEnabled(StringUtils.isNotBlank((CharSequence)tmp.getString("IsEnable")) ? ("true".equals(tmp.getString("IsEnable").toLowerCase()) ? 1 : 0) : 1);
            tmpBrand.setSequence(null != tmp.get((Object)"Sort_ID") ? tmp.getInteger("Sort_ID") : 1);
            tmpBrand.setMemo(null != tmp.getString("Memo") ? tmp.getString("Memo") : null);
            brandSourceIdMap.put(tmpBrand.getSourceId(), tmpBrand);
        }
        List<BrandEntity> dbListBySourceId = this.service.getAllBySourceIds(new ArrayList<String>(brandSourceIdMap.keySet()));
        if (CollectionUtils.isNotEmpty(dbListBySourceId)) {
            for (BrandEntity dbEntity : dbListBySourceId) {
                tmpBrand = (BrandEntity)((Object)brandSourceIdMap.get(dbEntity.getSourceId()));
                dbEntity.setBrandName(tmpBrand.getBrandName());
                dbEntity.setEnabled(tmpBrand.getEnabled());
                dbEntity.setSequence(tmpBrand.getSequence());
                dbEntity.setMemo(tmpBrand.getMemo());
                saveList.add(dbEntity);
                brandSourceIdMap.remove(dbEntity.getSourceId());
            }
        }
        if (!brandSourceIdMap.isEmpty()) {
            saveList.addAll(brandSourceIdMap.values());
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58\u6570\u636e-{}\u6761", (Object)saveList.size());
        this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
    }

    public static String toMD5(String plainText) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(plainText.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString().toLowerCase();
    }
}

