/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryDetailService;
import com.ejianc.business.zdsmaterial.erp.vo.DeliveryDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/deliveryDetail/"})
public class DeliveryDetailController {
    @Autowired
    private IDeliveryDetailService service;

    @GetMapping(value={"refDeliveryData"})
    public CommonResponse<IPage<DeliveryDetailVO>> refDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("detailUnitName");
        fuzzyFields.add("propertyValue");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Map params = param.getParams();
        params.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (_con = JSONObject.parseObject((String)condition)).get((Object)"deliveryId")) {
            params.put("deliveryId", new Parameter("eq", (Object)_con.getLong("deliveryId")));
        }
        params.put("deliveryNum", new Parameter("sql", (Object)"delivery_num > already_num"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List deliveryDetailVOS = BeanMapper.mapList((Iterable)page.getRecords(), DeliveryDetailVO.class);
        for (DeliveryDetailVO detailVO : deliveryDetailVOS) {
            detailVO.setCanUseNum(ComputeUtil.safeSub((BigDecimal)detailVO.getDeliveryNum(), (BigDecimal)detailVO.getAlreadyNum()));
        }
        pageData.setRecords(deliveryDetailVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

