/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.enums.OrderDeliveryStatusEnums;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.service.IContractService;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.erp.vo.OrderVO;
import com.ejianc.business.zdsmaterial.erp.vo.SyncOrderDetailVO;
import com.ejianc.business.zdsmaterial.erp.vo.SyncOrderVO;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanDetailVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"order"})
public class OrderController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZDS-ORD";
    @Autowired
    private IOrderService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IPurchasePlanDetailService purchasePlanDetailService;
    @Autowired
    private IDeliveryService deliveryService;
    private final String PUR_MATERIAL_ORDER_ERP_REQ_URL = "/cefoc/yql/getMEOrderInfo";
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IBrandService brandService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderVO> saveOrUpdate(@RequestBody OrderVO saveOrUpdateVO) {
        OrderEntity entity = (OrderEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OrderEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        OrderVO vo = (OrderVO)BeanMapper.map((Object)((Object)entity), OrderVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/updateFreezeStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderVO> updateFreezeStatus(@RequestBody OrderVO saveOrUpdateVO) {
        OrderEntity orderEntity = this.service.updateFreezeStatus(saveOrUpdateVO);
        OrderVO orderVO = (OrderVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)orderVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(Long id) {
        OrderEntity entity = (OrderEntity)((Object)this.service.selectById(id));
        OrderVO vo = (OrderVO)BeanMapper.map((Object)((Object)entity), OrderVO.class);
        vo.setDeliveriedList(this.deliveryService.getAllByOrderId(vo.getId()));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailByContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> queryDetailByContractId(Long contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        List list = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() == 1) {
            OrderVO vo = (OrderVO)BeanMapper.map(list.get(0), OrderVO.class);
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", null);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OrderVO orderVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List orderVOS = BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class);
        List projectIds = orderVOS.stream().map(OrderVO::getProjectId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(projectIds)) {
            CommonResponse jsonArrayCommonResponse = this.projectPoolApi.queryProjectByIds(projectIds);
            if (!jsonArrayCommonResponse.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25");
            }
            JSONArray jsonProject = (JSONArray)jsonArrayCommonResponse.getData();
            List projectPoolSetVOS = JSONArray.parseArray((String)jsonProject.toString(), ProjectPoolSetVO.class);
            Map poolMap = projectPoolSetVOS.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
            for (OrderVO orderVO : orderVOS) {
                if (!poolMap.containsKey(orderVO.getProjectId())) continue;
                ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)poolMap.get(orderVO.getProjectId());
                orderVO.setProjectManagementId(projectPoolSetVO.getProjectManagementId());
            }
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/refOrderData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> refOrderData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"contractId")) {
            param.getParams().put("contractId", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"contractId"))));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/deleteOrder"})
    public CommonResponse<OrderVO> deleteOrder(@RequestBody String sourceOrderId) {
        OrderVO order = this.service.getOneBySourceContractId(sourceOrderId);
        if (null == order) {
            return CommonResponse.error((String)"\u8ba2\u5355\u5728\u4f9b\u5e94\u94fe\u5e73\u53f0\u4e0d\u5b58\u5728");
        }
        CommonResponse quoteResp = this.billTypeApi.checkQuote("EJCBT202312000006", order.getId());
        if (!quoteResp.isSuccess()) {
            return CommonResponse.error((String)(StringUtils.isNotBlank((CharSequence)quoteResp.getMsg()) ? quoteResp.getMsg() : "\u5220\u9664\u5931\u8d25, \u8ba2\u5355\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528"));
        }
        this.service.removeById(order.getId(), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f", (Object)order);
    }

    @Transactional(rollbackFor={Exception.class})
    public void checkSyncOrderInfo(List<OrderEntity> updateVos, List<SyncOrderVO> orderVOs, Set<String> brandNames, List<String> empSourceIds, List<String> materialSerialNos) {
        ArrayList<OrderEntity> saveList = new ArrayList<OrderEntity>();
        ArrayList<OrderDetailEntity> detailList = new ArrayList<OrderDetailEntity>();
        Map<Object, Object> contractSourceMap = new HashMap();
        if (CollectionUtils.isNotEmpty(orderVOs)) {
            List<ContractEntity> contracts = this.contractService.getBySourceIds(new ArrayList<String>(orderVOs.stream().map(item -> item.getSourceContractId()).collect(Collectors.toSet())));
            contractSourceMap = contracts.stream().collect(Collectors.toMap(item -> item.getSourceContractId(), item -> item));
        }
        Map<Object, Object> brandNameMap = new HashMap();
        if (CollectionUtils.isNotEmpty(brandNames)) {
            brandNameMap = this.brandService.getAllByNames(new ArrayList<String>(brandNames));
        }
        Map<Object, Object> planDetailMap = new HashMap();
        if (CollectionUtils.isNotEmpty(materialSerialNos)) {
            List<PurchasePlanDetailVO> planDetails = this.purchasePlanDetailService.findAllByMaterialNos(materialSerialNos);
            planDetailMap = planDetails.stream().collect(Collectors.toMap(item -> item.getMaterialSerialNo(), item -> item));
        }
        Map<Object, Object> empSourceMap = new HashMap();
        if (CollectionUtils.isNotEmpty(empSourceIds)) {
            CommonResponse empResp = this.employeeApi.getAllBySourceIds(empSourceIds);
            if (!empResp.isSuccess()) {
                throw new BusinessException("\u540c\u6b65\u5931\u8d25\uff0c\u6839\u636eERP\u63a5\u8d27\u4eba\u4e3b\u952e\u83b7\u53d6\u5339\u914d\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
            }
            empSourceMap = ((List)empResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));
        }
        OrderEntity saveOrder = null;
        ContractEntity contract = null;
        PurchasePlanDetailVO planDetailVO = null;
        for (SyncOrderVO orderVO : orderVOs) {
            saveOrder = new OrderEntity();
            saveOrder.setFreezeStatus(1);
            saveOrder.setContractPriceType(ZDSMaterialCommonEnums.\u5355\u4ef7\u5408\u540c.getCode());
            saveOrder.setId(IdWorker.getId());
            saveOrder.setEnableStatus(ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
            saveOrder.setDeliveryStatus(OrderDeliveryStatusEnums.\u5f85\u53d1\u8d27.getCode());
            saveOrder.setTotalAcceptTaxMny(BigDecimal.ZERO);
            saveOrder.setTotalAcceptMny(BigDecimal.ZERO);
            saveOrder.setDeliveredTaxMny(BigDecimal.ZERO);
            saveOrder.setDeliveredMny(BigDecimal.ZERO);
            saveOrder.setHandAcceptTaxMny(BigDecimal.ZERO);
            saveOrder.setHandAcceptMny(BigDecimal.ZERO);
            saveOrder.setSignatureStatus(0);
            saveOrder.setApprovedTaxMny(orderVO.getApprovedTaxMny());
            saveOrder.setBalanceTaxMny(orderVO.getBalanceTaxMny());
            saveOrder.setSysLastUpd(orderVO.getSysLastUpd());
            saveOrder.setSupplierLinkerSid(orderVO.getSupplierLinkerSid());
            saveOrder.setSourceOrderCode(orderVO.getSourceOrderCode());
            saveOrder.setAcceptorName(orderVO.getLinkName());
            saveOrder.setAcceptorLinkPhone(orderVO.getLinkPhone());
            saveOrder.setDeliveryAddress(orderVO.getDeliveryAddress());
            saveOrder.setDeliveryRemark(orderVO.getDeliveryRemark());
            contract = (ContractEntity)((Object)contractSourceMap.get(orderVO.getSourceContractId()));
            EmployeeVO purchaser = null;
            purchaser = (EmployeeVO)empSourceMap.get(orderVO.getPurchaseUserId());
            saveOrder.setBillCode(orderVO.getBillCode());
            saveOrder.setSourceId(orderVO.getSourceOrderId());
            saveOrder.setSourceOrderId(orderVO.getSourceOrderId());
            saveOrder.setPurchaseUserSid(orderVO.getPurchaseUserId());
            if (null != contract) {
                saveOrder.setContractId(contract.getId());
                saveOrder.setContractCode(contract.getContractCode());
                saveOrder.setContractName(contract.getContractName());
                saveOrder.setContractPriceType(contract.getPriceType());
                saveOrder.setOrgId(contract.getOrgId());
                saveOrder.setOrgCode(contract.getOrgCode());
                saveOrder.setOrgName(contract.getOrgName());
                saveOrder.setParentOrgCode(contract.getParentOrgCode());
                saveOrder.setParentOrgId(contract.getParentOrgId());
                saveOrder.setParentOrgName(contract.getParentOrgName());
                saveOrder.setProjectId(contract.getProjectId());
                saveOrder.setProjectCode(contract.getProjectCode());
                saveOrder.setProjectName(contract.getProjectName());
                saveOrder.setSupplierId(contract.getSupplierId());
                saveOrder.setSupplierCode(contract.getSupplierCode());
                saveOrder.setSupplierName(contract.getSupplierName());
                saveOrder.setSupplierLinkName(contract.getSupplierManagerName());
                saveOrder.setSupplierLinkPhone(contract.getSupplierManagerPhone());
                saveOrder.setSupplierLinkerId(contract.getSupplierManagerId());
                saveOrder.setSupplierManagerSupId(contract.getSupplierManagerSupId());
                saveOrder.setAcceptorId(contract.getMasterPorterId());
                saveOrder.setAcceptorCode(contract.getMasterPorterCode());
                saveOrder.setAcceptorName(contract.getMasterPorterName());
                saveOrder.setAcceptorLinkPhone(contract.getLinkPhone());
                saveOrder.setAcceptorSid(contract.getMasterPorterSid());
                if (StringUtils.isBlank((CharSequence)saveOrder.getDeliveryAddress())) {
                    saveOrder.setDeliveryAddress(contract.getDeliveryAddress());
                }
                if (StringUtils.isBlank((CharSequence)saveOrder.getDeliveryRemark())) {
                    saveOrder.setDeliveryRemark(contract.getDeliveryRemark());
                }
            }
            saveOrder.setSourceContractId(orderVO.getSourceContractId());
            saveOrder.setSupplierLinkerSid(orderVO.getSupplierLinkerSid());
            if (null != purchaser) {
                saveOrder.setPurchaseUserId(purchaser.getId());
                saveOrder.setPurchaseUserCode(purchaser.getCode());
                saveOrder.setPurchaseUserName(purchaser.getName());
                saveOrder.setCreateUserCode(purchaser.getUserCode());
            }
            saveOrder.setPurchaseUserLinkPhone(StringUtils.isNotBlank((CharSequence)orderVO.getPurchaseUserLinkPhone()) ? orderVO.getPurchaseUserLinkPhone() : (null != purchaser ? purchaser.getMobilePhone() : null));
            saveOrder.setDeliveryDate(orderVO.getReqArrivalDate());
            OrderDetailEntity saveDetailVo = null;
            HashMap materialSerialNoMap = new HashMap();
            for (SyncOrderDetailVO detail : orderVO.getDetailList()) {
                saveDetailVo = new OrderDetailEntity();
                saveDetailVo.setRowState("add");
                saveDetailVo.setId(IdWorker.getId());
                saveDetailVo.setOrderId(saveOrder.getId());
                saveDetailVo.setMaterialSerialNo(detail.getMaterialSerialNo());
                if (null == detail.getDetailTax()) {
                    detail.setDetailTax(ComputeUtil.safeSub((BigDecimal)detail.getDetailTaxMny(), (BigDecimal)detail.getDetailMny()));
                }
                saveDetailVo.setSourceOrderId(detail.getSourceOrderId());
                saveDetailVo.setSourceOrderDetailId(detail.getSourceContractId());
                saveDetailVo.setSourceContractId(detail.getSourceContractId());
                saveDetailVo.setSourceOrderDetailId(detail.getSourceContractId());
                saveDetailVo.setDetailNum(detail.getOrderNum());
                saveDetailVo.setDetailPrice(detail.getDetailPrice());
                saveDetailVo.setDetailTaxPrice(detail.getDetailTaxPrice());
                saveDetailVo.setDetailMny(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)saveDetailVo.getDetailPrice(), (BigDecimal)saveDetailVo.getDetailNum())));
                saveDetailVo.setDetailTaxMny(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)saveDetailVo.getDetailTaxPrice(), (BigDecimal)saveDetailVo.getDetailNum())));
                saveDetailVo.setDetailTaxRate(null != contract ? contract.getRate() : null);
                saveDetailVo.setDetailTax(ComputeUtil.safeSub((BigDecimal)saveDetailVo.getDetailTaxMny(), (BigDecimal)saveDetailVo.getDetailMny()));
                saveDetailVo.setProductCode(detail.getProductCode());
                saveDetailVo.setPropertyValue(detail.getPropertyValue());
                saveDetailVo.setBrandName(detail.getBrandName());
                saveDetailVo.setBrandSid(detail.getBrandSid());
                if (brandNameMap.containsKey(detail.getBrandName())) {
                    saveDetailVo.setBrandId(((BrandEntity)((Object)brandNameMap.get(detail.getBrandName()))).getId());
                }
                if (StringUtils.isNotBlank((CharSequence)saveDetailVo.getMaterialSerialNo()) && null != (planDetailVO = (PurchasePlanDetailVO)planDetailMap.get(saveDetailVo.getMaterialSerialNo()))) {
                    saveDetailVo.setMaterialId(planDetailVO.getMaterialId());
                    saveDetailVo.setMaterialCode(planDetailVO.getMaterialCode());
                    saveDetailVo.setMaterialName(planDetailVO.getMaterialName());
                    saveDetailVo.setMaterialTypeId(planDetailVO.getMaterialTypeId());
                    saveDetailVo.setMaterialTypeName(planDetailVO.getMaterialTypeName());
                    saveDetailVo.setMaterialTypeCode(planDetailVO.getMaterialTypeCode());
                    saveDetailVo.setDetailUnitId(planDetailVO.getUnitId());
                    saveDetailVo.setDetailUnitName(planDetailVO.getUnitName());
                    saveDetailVo.setPropertyValue(planDetailVO.getPropertyValue());
                    saveDetailVo.setProductCode(planDetailVO.getProductCode());
                }
                saveDetailVo.setHandAcceptNum(BigDecimal.ZERO);
                saveDetailVo.setDeliveredNum(BigDecimal.ZERO);
                saveDetailVo.setAcceptedNum(BigDecimal.ZERO);
                saveOrder.getDetailList().add(saveDetailVo);
            }
            if (CollectionUtils.isEmpty(saveOrder.getDetailList())) {
                this.logger.error("\u8ba2\u5355-code:{}\u53ef\u4fdd\u5b58\u660e\u7ec6\u4e3a\u7a7a\uff0c\u8ba2\u5355\u540c\u6b65\u5931\u8d25\uff01", (Object)saveOrder.getBillCode());
                continue;
            }
            BigDecimal mny = BigDecimal.ZERO;
            BigDecimal taxMny = BigDecimal.ZERO;
            for (OrderDetailEntity detail : saveOrder.getDetailList()) {
                mny = ComputeUtil.safeAdd((BigDecimal)mny, (BigDecimal)detail.getDetailMny());
                taxMny = ComputeUtil.safeAdd((BigDecimal)taxMny, (BigDecimal)detail.getDetailTaxMny());
                detailList.add(detail);
            }
            saveOrder.setOrderMny(mny);
            saveOrder.setOrderTaxMny(taxMny);
            if (CollectionUtils.isNotEmpty(saveOrder.getDetailList())) {
                String msg = this.service.pushToSupBusiness((OrderVO)BeanMapper.map((Object)((Object)saveOrder), OrderVO.class));
                saveOrder.setBillPushFlag(StringUtils.isBlank((CharSequence)msg) ? "sucPushed" : "unSucPush");
            }
            saveList.add(saveOrder);
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58/\u66f4\u65b0\u8ba2\u5355\u5b50\u8868\u6570\u636e\uff1a{}\u6761", (Object)detailList.size());
        if (CollectionUtils.isNotEmpty(detailList)) {
            this.orderDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);
        }
        this.logger.info("\u672c\u6b21\u66f4\u65b0\u8ba2\u5355\u4e3b\u8868\u6570\u636e\uff1a{}\u6761", (Object)updateVos.size());
        if (CollectionUtils.isNotEmpty(updateVos)) {
            this.service.saveOrUpdateBatch(updateVos, updateVos.size(), false);
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58\u8ba2\u5355\u4e3b\u8868\u6570\u636e\uff1a{}\u6761", (Object)saveList.size());
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
    }

    @PostMapping(value={"/supOrderSync"})
    public CommonResponse<String> supOrderSync(HttpServletRequest request) {
        String billData = request.getParameter("billData");
        this.logger.info("\u63a5\u6536\u5230\u4f9b\u65b9\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)billData);
        OrderVO orderVO = (OrderVO)JSONObject.parseObject((String)billData, OrderVO.class);
        this.service.supOrderSync(orderVO);
        return CommonResponse.success((String)"\u8ba2\u5355\u4fe1\u606f\u540c\u6b65\u6210\u529f\uff01");
    }

    @PostMapping(value={"/syncZDSPurOrder"})
    public CommonResponse<String> syncZDSPurOrder(@RequestBody JSONObject params) {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u7269\u8d44\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        ArrayList saveOrUpdateList = new ArrayList();
        HashMap<String, String> param = new HashMap<String, String>();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/getMEOrderInfo";
        JSONObject reqJson = null;
        Object pageData = null;
        String reqDateStr = null;
        String startDateStr = null;
        String endDateStr = null;
        if (null != params.get((Object)"startDate")) {
            startDateStr = params.getString("startDate");
            endDateStr = params.getString("endDate");
        } else {
            reqDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)new Date());
            startDateStr = reqDateStr + " 00:00:00";
            endDateStr = reqDateStr + " 23:59:59";
        }
        param.put("BeginDateTime", startDateStr);
        param.put("EndDateTime", endDateStr);
        try {
            Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)60000, (Integer)60000);
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u7269\u8d44\u91c7\u8d2d\u8ba2\u5355\u7ed3\u679c\u8fd4\u56de\u6210\u529f\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
                this.handleErpData(reqJson);
            } else {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u7269\u8d44\u91c7\u8d2d\u8ba2\u5355\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u7269\u8d44\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u7269\u8d44\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38");
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u7269\u8d44\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u8ba2\u5355\u4fe1\u606f\u540c\u6b65\u6210\u529f\uff01");
    }

    private List<OrderEntity> handleErpData(JSONObject dataJson) {
        ArrayList<OrderEntity> resp = new ArrayList<OrderEntity>();
        JSONArray pageData = dataJson.getJSONArray("MEOrderList");
        this.logger.info("\u7269\u8d44\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\uff1a{}\u6761", (Object)pageData.size());
        if (pageData.size() == 0) {
            this.logger.info("\u5f85\u5904\u7406\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\u4e3a\u7a7a\uff0c\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u3002\u3002\u3002\u3002");
            return new ArrayList<OrderEntity>();
        }
        HashSet<String> brandNames = new HashSet<String>();
        ArrayList syncList = new ArrayList();
        SyncOrderVO tmpSyncOrder = null;
        JSONObject tmpJson = null;
        JSONObject tmpDetailJson = null;
        SyncOrderDetailVO syncDetail = null;
        HashMap<String, SyncOrderVO> sourceMap = new HashMap<String, SyncOrderVO>();
        ArrayList contractSourceIds = new ArrayList();
        HashSet<String> empSourceIds = new HashSet<String>();
        HashSet<String> materialSerialNos = new HashSet<String>();
        for (Object obj : pageData) {
            tmpJson = (JSONObject)obj;
            tmpSyncOrder = new SyncOrderVO();
            tmpSyncOrder.setSourceOrderId(tmpJson.getString("C_PS_MEOrderInfoOID"));
            tmpSyncOrder.setBillCode(tmpJson.getString("Ma_id"));
            tmpSyncOrder.setSourceContractId(tmpJson.getString("MEContractInfo_Sid"));
            tmpSyncOrder.setPurchaseUserId(tmpJson.getString("sys_createdby"));
            tmpSyncOrder.setEnableStatus(ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
            tmpSyncOrder.setApprovedTaxMny(tmpJson.getBigDecimal("HaveApprMoney"));
            tmpSyncOrder.setBalanceTaxMny(tmpJson.getBigDecimal("ContractBalanceMoney"));
            tmpSyncOrder.setSupplierLinkerSid(tmpJson.getString("Company_ContactSid"));
            tmpSyncOrder.setSysLastUpd(tmpJson.getString("SYS_LAST_UPD"));
            tmpSyncOrder.setSourceOrderCode(tmpJson.getString("OrderContractID"));
            tmpSyncOrder.setSupplierName(tmpJson.getString("Contract_PartyB"));
            tmpSyncOrder.setContractName(tmpJson.getString("Contract_Title"));
            tmpSyncOrder.setContractCode(tmpJson.getString("ContractID"));
            tmpSyncOrder.setProjectName(tmpJson.getString("Project_Name"));
            tmpSyncOrder.setSupplierLinkName(tmpJson.getString("Company_Contact"));
            tmpSyncOrder.setLinkName(tmpJson.getString("Receiver"));
            tmpSyncOrder.setLinkPhone(tmpJson.getString("Receiver_Phone"));
            tmpSyncOrder.setDeliveryAddress(tmpJson.getString("DeliveryPlace"));
            tmpSyncOrder.setDeliveryRemark(tmpJson.getString("ArrivalArrangement"));
            if (StringUtils.isNotBlank((CharSequence)tmpSyncOrder.getPurchaseUserId())) {
                empSourceIds.add(tmpSyncOrder.getPurchaseUserId());
            }
            sourceMap.put(tmpSyncOrder.getSourceOrderId(), tmpSyncOrder);
        }
        JSONArray subArr = dataJson.getJSONArray("MEOrder_SubD");
        for (Object detailObj : subArr) {
            tmpDetailJson = (JSONObject)detailObj;
            tmpSyncOrder = (SyncOrderVO)sourceMap.get(tmpDetailJson.getString("MEOrderInfo_FK"));
            if (null == tmpSyncOrder) continue;
            syncDetail = new SyncOrderDetailVO();
            syncDetail.setSourceOrderDetailId(tmpDetailJson.getString("C_PS_MEOrderInfo_SubDOID"));
            syncDetail.setSourceOrderId(tmpDetailJson.getString("MEOrderInfo_FK"));
            syncDetail.setDetailPrice(tmpDetailJson.getBigDecimal("NoTaxPointPrice"));
            syncDetail.setDetailTaxPrice(tmpDetailJson.getBigDecimal("PurchasePrice"));
            syncDetail.setDetailMny(tmpDetailJson.getBigDecimal("NoTaxPointSum"));
            syncDetail.setDetailRemark(tmpDetailJson.getString("Memo"));
            syncDetail.setMaterialSerialNo(tmpDetailJson.getString("ListMaterialCode"));
            syncDetail.setBrandName(tmpDetailJson.getString("Brand"));
            syncDetail.setDetailTaxMny(tmpDetailJson.getBigDecimal("sumpoint"));
            syncDetail.setOrderNum(tmpDetailJson.getBigDecimal("PurchaseAmount"));
            syncDetail.setDetailTax(tmpDetailJson.getBigDecimal("TaxPointPrice"));
            syncDetail.setBrandSid(tmpDetailJson.getString("BrandSid"));
            if (StringUtils.isNotBlank((CharSequence)syncDetail.getBrandName())) {
                brandNames.add(syncDetail.getBrandName());
            }
            if (StringUtils.isNotBlank((CharSequence)syncDetail.getMaterialSerialNo())) {
                materialSerialNos.add(syncDetail.getMaterialSerialNo());
            }
            tmpSyncOrder.getDetailList().add(syncDetail);
        }
        List<OrderEntity> dbEntities = this.service.getBySourceIds(new ArrayList<String>(sourceMap.keySet()));
        if (CollectionUtils.isNotEmpty(dbEntities)) {
            boolean update = false;
            SyncOrderVO tmpOder = null;
            for (OrderEntity dbOrder : dbEntities) {
                update = false;
                tmpOder = (SyncOrderVO)sourceMap.get(dbOrder.getSourceId());
                if (StringUtils.isBlank((CharSequence)dbOrder.getSysLastUpd()) && StringUtils.isNotBlank((CharSequence)tmpOder.getSysLastUpd())) {
                    dbOrder.setSysLastUpd(tmpOder.getSysLastUpd());
                    update = true;
                }
                if (StringUtils.isBlank((CharSequence)dbOrder.getSupplierLinkerSid()) && StringUtils.isNotBlank((CharSequence)tmpOder.getSupplierLinkerSid())) {
                    dbOrder.setSupplierLinkerSid(tmpOder.getSupplierLinkerSid());
                    update = true;
                }
                if (StringUtils.isBlank((CharSequence)dbOrder.getAcceptorName()) && StringUtils.isNotBlank((CharSequence)tmpOder.getLinkName())) {
                    dbOrder.setAcceptorName(tmpOder.getLinkName());
                    update = true;
                }
                if (StringUtils.isBlank((CharSequence)dbOrder.getAcceptorLinkPhone()) && StringUtils.isNotBlank((CharSequence)tmpOder.getLinkPhone())) {
                    dbOrder.setAcceptorLinkPhone(tmpOder.getLinkPhone());
                    update = true;
                }
                if (StringUtils.isBlank((CharSequence)dbOrder.getSupplierLinkName()) && StringUtils.isNotBlank((CharSequence)tmpOder.getSupplierLinkName())) {
                    dbOrder.setSupplierLinkName(tmpOder.getSupplierLinkName());
                    update = true;
                }
                if (StringUtils.isBlank((CharSequence)dbOrder.getSupplierLinkPhone()) && StringUtils.isNotBlank((CharSequence)tmpOder.getSupplierLinkPhone())) {
                    dbOrder.setSupplierLinkPhone(tmpOder.getSupplierLinkPhone());
                    update = true;
                }
                if (StringUtils.isBlank((CharSequence)dbOrder.getDeliveryRemark()) && StringUtils.isNotBlank((CharSequence)tmpOder.getDeliveryRemark())) {
                    dbOrder.setDeliveryRemark(tmpOder.getDeliveryRemark());
                    update = true;
                }
                if (StringUtils.isBlank((CharSequence)dbOrder.getDeliveryAddress()) && StringUtils.isNotBlank((CharSequence)tmpOder.getDeliveryAddress())) {
                    dbOrder.setDeliveryAddress(tmpOder.getDeliveryAddress());
                    update = true;
                }
                if (StringUtils.isBlank((CharSequence)dbOrder.getProjectName()) && StringUtils.isNotBlank((CharSequence)tmpOder.getProjectName())) {
                    dbOrder.setProjectName(tmpOder.getProjectName());
                    update = true;
                }
                if (StringUtils.isBlank((CharSequence)dbOrder.getContractCode()) && StringUtils.isNotBlank((CharSequence)tmpOder.getContractCode())) {
                    dbOrder.setContractCode(tmpOder.getContractCode());
                    update = true;
                }
                if (StringUtils.isBlank((CharSequence)dbOrder.getContractName()) && StringUtils.isNotBlank((CharSequence)tmpOder.getContractName())) {
                    dbOrder.setContractName(tmpOder.getContractName());
                    update = true;
                }
                if (StringUtils.isBlank((CharSequence)dbOrder.getSupplierName()) && StringUtils.isNotBlank((CharSequence)tmpOder.getSupplierName())) {
                    dbOrder.setSupplierName(tmpOder.getSupplierName());
                    update = true;
                }
                if (StringUtils.isBlank((CharSequence)dbOrder.getSourceOrderCode()) && StringUtils.isNotBlank((CharSequence)tmpOder.getSourceOrderCode())) {
                    dbOrder.setSourceOrderCode(tmpOder.getSourceOrderCode());
                    update = true;
                }
                sourceMap.remove(dbOrder.getSourceId());
                if (!update) continue;
                resp.add(dbOrder);
            }
        }
        this.checkSyncOrderInfo(resp, new ArrayList<SyncOrderVO>(sourceMap.values()), brandNames, new ArrayList<String>(empSourceIds), new ArrayList<String>(materialSerialNos));
        return resp;
    }

    @PostMapping(value={"/syncToSupCenter"})
    public CommonResponse<List<String>> syncToSupCenter(@RequestBody List<Long> orderIds) {
        ArrayList<String> result = new ArrayList<String>();
        OrderEntity order = null;
        for (Long orderId : orderIds) {
            order = (OrderEntity)((Object)this.service.selectById(orderId));
            result.add(this.service.pushToSupBusiness((OrderVO)BeanMapper.map((Object)((Object)order), OrderVO.class)));
        }
        return CommonResponse.success(result);
    }

    @PostMapping(value={"/createOrderByContracts"})
    public CommonResponse<String> createOrderByContracts(@RequestBody Long contractId) {
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(contractId));
        if (null == contract) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u5408\u540c\uff01");
        }
        ArrayList<ContractEntity> contracts = new ArrayList<ContractEntity>();
        contracts.add(contract);
        this.service.saveByContracts(contracts);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

