/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.bean.SubTypeEntity;
import com.ejianc.business.zdsmaterial.erp.service.ISubTypeService;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"subType"})
public class SubTypeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISubTypeService service;
    @Autowired
    private SessionManager sessionManager;
    private final String SUB_TYPE_ERP_REQ_URL = "/cefoc/yql/getGoodTypeList";

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubTypeVO> queryDetail(Long id) {
        SubTypeEntity entity = (SubTypeEntity)((Object)this.service.selectById(id));
        SubTypeVO vo = (SubTypeVO)BeanMapper.map((Object)((Object)entity), SubTypeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubTypeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubTypeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubType-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSubTypeTreeData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refSubTypeData(@RequestParam(required=false) String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("longCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            param.setSearchText(searchText);
        }
        param.getParams().put("enabled", new Parameter("eq", (Object)1));
        param.getOrderMap().put("sequence", "asc");
        List list = this.service.queryList(param);
        List resultMapList = BeanMapper.mapList((Iterable)list, Map.class);
        return ResultAsTree.createTreeData((List)resultMapList);
    }

    @PostMapping(value={"querySubTypeTree"})
    public CommonResponse<JSONObject> querySubTypeTree(@RequestBody QueryParam param) {
        return CommonResponse.success((Object)this.service.querySubTypeTree(param));
    }

    @GetMapping(value={"syncErpSubTypes"})
    public CommonResponse<String> syncErpBrands() {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u5206\u5305\u7c7b\u578b\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        Integer pageNum = 0;
        Integer pageSize = Integer.valueOf(ZDSInterfaceCommonUtil.getErpDataBatchSize());
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/getGoodTypeList";
        boolean hasNext = true;
        Map<String, String> headers = null;
        try {
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            param.put("PageSize", pageSize);
            JSONObject reqJson = null;
            JSONArray pageData = null;
            while (hasNext) {
                pageNum = pageNum + 1;
                param.put("PageNum", pageNum);
                String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)60000, (Integer)60000);
                reqJson = JSONObject.parseObject((String)reqResp);
                if ("ok".equals(reqJson.getString("status"))) {
                    pageData = reqJson.getJSONArray("data");
                    if (null != pageData && pageData.size() > 0) {
                        this.logger.info("\u4e2d\u7535\u56db\u5206\u5305\u7c7b\u578b\u540c\u6b65\uff0c\u5904\u7406\u7b2c{}\u9875, {}\u6761\u6570\u636e", (Object)pageNum, (Object)pageData.size());
                        this.handleErpDataPage(pageData);
                        continue;
                    }
                    this.logger.info("\u4e2d\u7535\u56db\u5206\u5305\u7c7b\u578b\u540c\u6b65 \u5904\u7406\u6570\u636e\u5b8c\u6210\uff01\uff01\uff01\u603b\u5171{}\u9875\u6570\u636e\uff01", (Object)pageNum);
                    hasNext = false;
                    continue;
                }
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u5206\u5305\u7c7b\u578b\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
                hasNext = false;
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u5206\u5305\u7c7b\u578b\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u5206\u5305\u7c7b\u578b\u4fe1\u606f\u5f02\u5e38");
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u5206\u5305\u7c7b\u578b\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u4e2d\u7535\u56db\u5206\u5305\u7c7b\u578b\u540c\u6b65\u5b8c\u6210\uff01");
    }

    private void handleErpDataPage(JSONArray pageData) {
        JSONObject tmpJson = null;
        SubTypeEntity tmpEntity = null;
        ArrayList<SubTypeEntity> saveList = new ArrayList<SubTypeEntity>();
        HashMap<String, SubTypeEntity> pageSourceMap = new HashMap<String, SubTypeEntity>();
        HashSet<String> sourceIds = new HashSet<String>();
        for (Object obj : pageData) {
            tmpJson = (JSONObject)obj;
            tmpEntity = new SubTypeEntity();
            tmpEntity.setName(tmpJson.getString("Title"));
            tmpEntity.setViewName(tmpJson.getString("ViewTitle"));
            tmpEntity.setSourceId(tmpJson.getString("C_SD_GoodsTypeOID"));
            tmpEntity.setEnabled("True".equals(tmpJson.getString("IsEnable")) ? 1 : 0);
            tmpEntity.setSequence(null != tmpJson.get((Object)"Sort_ID") ? tmpJson.getInteger("Sort_ID") : 1);
            tmpEntity.setMemo(null != tmpJson.getString("Memo") ? tmpJson.getString("Memo") : null);
            tmpEntity.setLongCode(tmpJson.getString("Long_code"));
            tmpEntity.setShortCode(tmpJson.getString("Short_code"));
            tmpEntity.setParentSourceId(tmpJson.getString("ParentOID"));
            if ("00000000-0000-0000-0000-000000000000".equals(tmpEntity.getParentSourceId()) || StringUtils.isBlank((CharSequence)tmpEntity.getParentSourceId())) {
                tmpEntity.setParentSourceId(null);
            }
            pageSourceMap.put(tmpEntity.getSourceId(), tmpEntity);
            sourceIds.add(tmpEntity.getSourceId());
            if (!StringUtils.isNotBlank((CharSequence)tmpEntity.getParentSourceId())) continue;
            sourceIds.add(tmpEntity.getParentSourceId());
        }
        Map<Object, Object> dbSourceMap = new HashMap();
        List<SubTypeEntity> dbListBySourceId = this.service.getAllBySourceIds(new ArrayList<String>(sourceIds));
        if (CollectionUtils.isNotEmpty(dbListBySourceId)) {
            dbSourceMap = dbListBySourceId.stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));
        }
        SubTypeEntity parent = null;
        for (SubTypeEntity subType : pageSourceMap.values()) {
            if (dbSourceMap.containsKey(subType.getSourceId())) {
                tmpEntity = (SubTypeEntity)((Object)dbSourceMap.get(subType.getSourceId()));
                tmpEntity.setName(subType.getName());
                tmpEntity.setViewName(subType.getViewName());
                tmpEntity.setEnabled(subType.getEnabled());
                tmpEntity.setSequence(subType.getSequence());
                tmpEntity.setMemo(subType.getMemo());
                tmpEntity.setLongCode(subType.getLongCode());
                tmpEntity.setShortCode(subType.getShortCode());
            } else {
                tmpEntity = subType;
            }
            if (StringUtils.isNotBlank((CharSequence)subType.getParentSourceId())) {
                parent = (SubTypeEntity)((Object)dbSourceMap.get(subType.getParentSourceId()));
                if (null == parent) {
                    parent = (SubTypeEntity)((Object)pageSourceMap.get(subType.getParentSourceId()));
                }
                if (null == parent) {
                    this.logger.error("\u5206\u5305\u7c7b\u578b\uff1a\u540d\u79f0-{}\uff0csourceId-{}\uff0c\u4fdd\u5b58\u5931\u8d25\uff0c\u5bf9\u5e94\u7236\u7ea7[sid-{}]\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", new Object[]{tmpEntity.getName(), tmpEntity.getSourceId(), subType.getParentSourceId()});
                    continue;
                }
                tmpEntity.setParentId(parent.getId());
            }
            saveList.add(tmpEntity);
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58\u6570\u636e-{}\u6761", (Object)saveList.size());
        this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
    }
}

