/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.BrandMapper;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class BrandServiceImpl
extends BaseServiceImpl<BrandMapper, BrandEntity>
implements IBrandService {
    @Override
    public Map<String, BrandEntity> getAllByNames(List<String> brandNames) {
        Map<String, BrandEntity> resp = new HashMap<String, BrandEntity>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"brand_name", brandNames);
        List brandList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)brandList)) {
            resp = brandList.stream().collect(Collectors.toMap(item -> item.getBrandName(), item -> item));
        }
        return resp;
    }

    @Override
    public Map<String, BrandVO> getAllVoMapByNames(List<String> names) {
        Map<String, BrandVO> resp = new HashMap<String, BrandVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"brand_name", names);
        List brandList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)brandList)) {
            List vos = BeanMapper.mapList((Iterable)brandList, BrandVO.class);
            resp = vos.stream().collect(Collectors.toMap(item -> item.getBrandName(), item -> item));
        }
        return resp;
    }

    @Override
    public BrandEntity getOneByName(String name) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"brand_name", (Object)name);
        List brandList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)brandList)) {
            BrandEntity brandEntity = (BrandEntity)((Object)brandList.get(0));
            return brandEntity;
        }
        return null;
    }

    @Override
    public List<BrandEntity> getAllBySourceIds(List<String> sourceIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"source_id", sourceIds);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    @Override
    public List<BrandVO> getAllByIds(List<Long> ids) {
        List<Object> resp = new ArrayList<BrandVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            resp = BeanMapper.mapList((Iterable)dbList, BrandVO.class);
        }
        return resp;
    }
}

