/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.service.IOrderDetailService;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.material.vo.OrderQueryVo;
import com.ejianc.business.zdsmaterial.material.vo.PurchaseAnalysisVo;
import com.ejianc.business.zdsmaterial.out.bean.DisposeEntity;
import com.ejianc.business.zdsmaterial.out.service.IDisposeDetailService;
import com.ejianc.business.zdsmaterial.out.service.IDisposeService;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.business.zdsstore.api.IStoreFlowApi;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"purchaseAnalysis"})
public class PurchaseAnalysisController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IControlPlanSumDetailService planSumDetailService;
    @Autowired
    private IPurchasePlanDetailService planDetailService;
    @Autowired
    private IStoreFlowApi storeFlowApi;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDisposeDetailService disposeDetailService;
    @Autowired
    private IControlPlanService controlPlanService;
    @Autowired
    private IDisposeService disposeService;

    @GetMapping(value={"/queryMaterialList"})
    @ResponseBody
    public CommonResponse<List<PurchaseAnalysisVo>> queryMaterialList(@RequestParam(required=false) Map<String, Object> params) {
        BigDecimal outTaxMny;
        BigDecimal inMaterialNum;
        List childCategoryIds = null;
        HashMap<String, PurchaseAnalysisVo> vosByCategoryCode = new HashMap<String, PurchaseAnalysisVo>();
        HashMap<String, String> codeNameMap = new HashMap<String, String>();
        HashMap<Long, String> categoryCodeMap = new HashMap<Long, String>();
        PurchaseAnalysisVo tmp = null;
        String groupType = null != params.get("groupType") ? params.get("groupType").toString() : null;
        Long projectId = null;
        if (params.containsKey("projectId")) {
            projectId = params.get("projectId") == null ? null : Long.valueOf(params.get("projectId").toString());
        }
        ArrayList<Long> orgIds = null;
        HashMap<Long, Object> belongOrgMap = new HashMap<Long, Object>();
        HashMap<Long, Long> orgBelongMap = new HashMap<Long, Long>();
        if (params.containsKey("orgType") && params.containsKey("orgId")) {
            CommonResponse orgResp;
            if (!OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(params.get("orgType").toString()))) {
                orgResp = this.orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(), Arrays.asList(1, 2, 3, 5), null, Long.valueOf(params.get("orgId").toString()));
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u7ec4\u7ec7id-{}\u67e5\u8be2\u672c\u4e0b\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25", params.get("orgId"), (Object)JSONObject.toJSONString((Object)orgResp));
                    return CommonResponse.error((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                if (CollectionUtils.isNotEmpty((Collection)((Collection)orgResp.getData()))) {
                    orgIds = new ArrayList<Long>();
                    for (OrgVO org : (List)orgResp.getData()) {
                        if (Long.valueOf(params.get("orgId").toString()).equals(org.getParentId())) {
                            belongOrgMap.put(org.getId(), org);
                        }
                        if (!OrgVO.ORG_TYPE_DEPARTMENT.equals(org.getOrgType()) || orgIds.contains(org.getId())) continue;
                        orgIds.add(org.getId());
                        orgBelongMap.put(org.getId(), Long.valueOf(org.getInnerCode().substring(org.getInnerCode().indexOf(params.get("orgId").toString()) + (params.get("orgId").toString().length() + 1)).split("\\|")[0]));
                    }
                } else {
                    return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", new ArrayList());
                }
                List<ControlPlanEntity> controlPlanList = this.controlPlanService.getAllByOrgId(orgIds);
                if (CollectionUtils.isEmpty(controlPlanList)) {
                    return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", new ArrayList());
                }
                orgIds = new ArrayList(controlPlanList.stream().map(ControlPlanEntity::getOrgId).collect(Collectors.toSet()));
                params.put("orgIds", orgIds);
                this.logger.info("orgIds: {}", (Object)JSONObject.toJSONString(orgIds));
            } else {
                orgResp = this.orgApi.getOneById(Long.valueOf(params.get("orgId").toString()));
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u7ec4\u7ec7id-{}\u67e5\u8be2\u4fe1\u606f\u5931\u8d25", params.get("orgId"), (Object)JSONObject.toJSONString((Object)orgResp));
                    return CommonResponse.error((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                orgBelongMap.put(((OrgVO)orgResp.getData()).getId(), ((OrgVO)orgResp.getData()).getId());
                belongOrgMap.put(((OrgVO)orgResp.getData()).getId(), orgResp.getData());
                params.put("orgIds", Arrays.asList(Long.valueOf(params.get("orgId").toString())));
            }
            params.remove("orgType");
            params.remove("orgId");
        }
        if (null != params.get("categoryGroup")) {
            ArrayList<String> categoryCode = new ArrayList<String>();
            Map tmpMap = (Map)JSONObject.parseObject((String)params.get("categoryGroup").toString(), Map.class);
            HashMap<String, ArrayList<String>> typeNameGroupCodeMap = new HashMap<String, ArrayList<String>>();
            ArrayList<String> codes = null;
            for (String typeName : tmpMap.keySet()) {
                codes = new ArrayList<String>(Arrays.asList(((String)tmpMap.get(typeName)).split(",")));
                typeNameGroupCodeMap.put(typeName, codes);
                categoryCode.addAll(codes);
            }
            List<MaterialCategoryEntity> categorys = this.categoryService.queryByCodes(categoryCode);
            List<Long> parentCategoryIds = categorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<MaterialCategoryEntity> childCategorys = this.categoryService.getAllLeafByPids(parentCategoryIds, 1);
            childCategoryIds = childCategorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            block2: for (MaterialCategoryEntity materialCategoryEntity : childCategorys) {
                categoryCodeMap.put(materialCategoryEntity.getId(), materialCategoryEntity.getCode());
                for (String typeName : typeNameGroupCodeMap.keySet()) {
                    if (null == vosByCategoryCode.get(typeName)) {
                        if ("org".equals(groupType)) {
                            for (Long orgId : belongOrgMap.keySet()) {
                                tmp = new PurchaseAnalysisVo();
                                tmp.setMaterialTypeName(typeName);
                                tmp.setValidFlag(Boolean.valueOf(false));
                                vosByCategoryCode.put(typeName + "-" + orgId.toString(), tmp);
                            }
                        } else {
                            tmp = new PurchaseAnalysisVo();
                            tmp.setValidFlag(Boolean.valueOf(true));
                            tmp.setMaterialTypeName(typeName);
                            vosByCategoryCode.put(typeName, tmp);
                        }
                    }
                    for (String parentCategoryCode : (List)typeNameGroupCodeMap.get(typeName)) {
                        if (!materialCategoryEntity.getCode().contains(parentCategoryCode)) continue;
                        codeNameMap.put(materialCategoryEntity.getCode(), typeName);
                        continue block2;
                    }
                }
            }
            params.put("categoryIds", childCategoryIds);
        }
        List<Object> voList = new ArrayList<PurchaseAnalysisVo>();
        List<PurchaseAnalysisVo> list = this.planSumDetailService.getList(params);
        QueryParam queryParam = new QueryParam();
        if (null != projectId) {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        if (null != orgIds) {
            queryParam.getParams().put("orgId", new Parameter("in", orgIds));
        }
        queryParam.getParams().put("effectiveState", new Parameter("eq", (Object)1));
        if (null != childCategoryIds) {
            queryParam.getParams().put("materialCategoryId", new Parameter("in", childCategoryIds));
        }
        CommonResponse flowResp = this.storeFlowApi.getFlowList(queryParam);
        List flowVOList = (List)flowResp.getData();
        Map<Long, List<FlowVO>> flowMaps = flowVOList.stream().filter(item -> null != item.getMaterialId()).collect(Collectors.groupingBy(FlowVO::getMaterialId));
        OrgVO belongOrg = null;
        for (PurchaseAnalysisVo purchaseAnalysisVo : list) {
            belongOrg = (OrgVO)belongOrgMap.get(orgBelongMap.get(purchaseAnalysisVo.getOrgId()));
            if (null != belongOrg) {
                purchaseAnalysisVo.setBelongOrgCode(belongOrg.getCode());
                purchaseAnalysisVo.setBelongOrgId(belongOrg.getId());
                purchaseAnalysisVo.setBelongOrgName(belongOrg.getName());
                purchaseAnalysisVo.setBelongOrgType(belongOrg.getOrgType());
            } else {
                this.logger.error("\u65e0\u5339\u914d\u7684\u7ec4\u7ec7id-{}\u4fe1\u606f", orgBelongMap.get(purchaseAnalysisVo.getOrgId()));
            }
            if (flowMaps.containsKey(purchaseAnalysisVo.getMaterialId())) {
                List<FlowVO> list2 = flowMaps.get(purchaseAnalysisVo.getMaterialId());
                inMaterialNum = list2.stream().filter(e -> e.getInOutFlag() == 1).map(e -> e.getNum()).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal inTaxMny = list2.stream().filter(e -> e.getInOutFlag() == 1).map(e -> e.getTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal outMaterialNum = list2.stream().filter(e -> e.getInOutFlag() == 2).map(e -> e.getNum()).reduce(BigDecimal.ZERO, BigDecimal::add);
                outTaxMny = list2.stream().filter(e -> e.getInOutFlag() == 2).map(e -> e.getTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
                purchaseAnalysisVo.setAlreadyEntryNum(inMaterialNum);
                purchaseAnalysisVo.setAlreadyOutNum(outMaterialNum);
                purchaseAnalysisVo.setOutMny(outTaxMny);
                purchaseAnalysisVo.setEntryMny(inTaxMny);
            }
            voList.add(purchaseAnalysisVo);
        }
        List materialIds = list.stream().map(e -> e.getMaterialId()).collect(Collectors.toList());
        for (Map.Entry<Long, List<FlowVO>> entry : flowMaps.entrySet()) {
            if (materialIds.contains(entry.getKey())) continue;
            inMaterialNum = entry.getValue().stream().filter(e -> e.getInOutFlag() == 1).map(e -> e.getNum()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal outMaterialNum = entry.getValue().stream().filter(e -> e.getInOutFlag() == 2).map(e -> e.getNum()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal inTaxMny = entry.getValue().stream().filter(e -> e.getInOutFlag() == 1).map(e -> e.getTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            outTaxMny = entry.getValue().stream().filter(e -> e.getInOutFlag() == 2).map(e -> e.getTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            PurchaseAnalysisVo vo = new PurchaseAnalysisVo();
            FlowVO flowVO = entry.getValue().get(0);
            vo.setOutMny(outTaxMny);
            vo.setEntryMny(inTaxMny);
            vo.setMaterialId(flowVO.getMaterialId());
            vo.setMaterialName(flowVO.getMaterialName());
            vo.setMaterialCode(flowVO.getMaterialName());
            vo.setMaterialTypeId(flowVO.getMaterialCategoryId());
            vo.setMaterialTypeName(flowVO.getMaterialCategoryName());
            vo.setPropertyValue(flowVO.getMaterialSpec());
            vo.setProjectId(flowVO.getProjectId());
            vo.setProjectName(flowVO.getProjectName());
            vo.setAlreadyEntryNum(inMaterialNum);
            vo.setAlreadyOutNum(outMaterialNum);
            vo.setOrgName(flowVO.getOrgName());
            vo.setOrgId(flowVO.getOrgId());
            vo.setOrgCode(flowVO.getOrgName());
            belongOrg = (OrgVO)belongOrgMap.get(orgBelongMap.get(vo.getOrgId()));
            if (null != belongOrg) {
                vo.setBelongOrgCode(belongOrg.getCode());
                vo.setBelongOrgId(belongOrg.getId());
                vo.setBelongOrgName(belongOrg.getName());
                vo.setBelongOrgType(belongOrg.getOrgType());
            } else {
                this.logger.error("\u65e0\u5339\u914d\u7684\u7ec4\u7ec7id-{}\u4fe1\u606f", orgBelongMap.get(vo.getOrgId()));
            }
            vo.setValidFlag(Boolean.valueOf(null == params.get("categoryGroup")));
            voList.add(vo);
        }
        List<Long> list3 = voList.stream().map(e -> e.getMaterialId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(voList)) {
            List<MaterialVO> list4 = this.materialService.queryDetailList(list3, false);
            Map<Long, String> materialMap = list4.stream().collect(Collectors.toMap(item -> item.getId(), item -> item.getCategoryCode()));
            params.put("materialIds", list3);
            List<PurchaseAnalysisVo> changeNums = this.planSumDetailService.countChangeNum(params);
            List<PurchaseAnalysisVo> excessNums = this.planDetailService.countChangeNum(params);
            List<PurchaseAnalysisVo> ordersNums = this.orderDetailService.countNum(params);
            this.logger.info("ordersNums: {}", (Object)JSONObject.toJSONString(ordersNums));
            Map<Object, Object> changeNumMap = new HashMap();
            Map<Object, Object> excessMap = new HashMap();
            Map<Object, Object> orderMap = new HashMap();
            if (CollectionUtils.isNotEmpty(changeNums)) {
                changeNumMap = changeNums.stream().collect(Collectors.toMap(e -> e.getMaterialId(), e -> e.getChangeNum()));
            }
            if (CollectionUtils.isNotEmpty(excessNums)) {
                excessMap = excessNums.stream().collect(Collectors.toMap(e -> e.getMaterialId(), e -> e));
            }
            if (CollectionUtils.isNotEmpty(ordersNums)) {
                orderMap = null != orgIds ? ordersNums.stream().collect(Collectors.toMap(e -> e.getMaterialId().toString() + "-" + e.getOrgId().toString(), e -> e)) : ordersNums.stream().collect(Collectors.toMap(e -> e.getMaterialId().toString(), e -> e));
            }
            HashMap finalChangeNumMap = changeNumMap;
            HashMap finalExcessMap = excessMap;
            HashMap finalOrderMap = orderMap;
            if (null != projectId) {
                this.querySurplusNum(projectId, list3, voList);
            }
            if (null != orgIds) {
                this.queryOrgSurplusNum(orgIds, list3, voList, "org_id");
            }
            for (PurchaseAnalysisVo purchaseAnalysisVo : voList) {
                if (materialMap.containsKey(purchaseAnalysisVo.getMaterialId())) {
                    purchaseAnalysisVo.setMaterialTypeCode(materialMap.get(purchaseAnalysisVo.getMaterialId()));
                }
                if (StringUtils.isBlank((String)purchaseAnalysisVo.getMaterialTypeCode()) && categoryCodeMap.containsKey(purchaseAnalysisVo.getMaterialTypeId())) {
                    purchaseAnalysisVo.setMaterialTypeCode((String)categoryCodeMap.get(purchaseAnalysisVo.getMaterialTypeId()));
                }
                if (null != finalChangeNumMap && finalChangeNumMap.containsKey(purchaseAnalysisVo.getMaterialId())) {
                    purchaseAnalysisVo.setChangeNum((BigDecimal)finalChangeNumMap.get(purchaseAnalysisVo.getMaterialId()));
                }
                if (null != finalOrderMap) {
                    if (null != orgIds && finalOrderMap.containsKey(purchaseAnalysisVo.getMaterialId().toString() + "-" + purchaseAnalysisVo.getOrgId().toString())) {
                        purchaseAnalysisVo.setOrderNum(((PurchaseAnalysisVo)finalOrderMap.get(purchaseAnalysisVo.getMaterialId().toString() + "-" + purchaseAnalysisVo.getOrgId().toString())).getOrderNum());
                        purchaseAnalysisVo.setDeliveryNum(((PurchaseAnalysisVo)finalOrderMap.get(purchaseAnalysisVo.getMaterialId().toString() + "-" + purchaseAnalysisVo.getOrgId().toString())).getDeliveryNum());
                    } else if (finalOrderMap.containsKey(purchaseAnalysisVo.getMaterialId().toString())) {
                        purchaseAnalysisVo.setOrderNum(((PurchaseAnalysisVo)finalOrderMap.get(purchaseAnalysisVo.getMaterialId().toString())).getOrderNum());
                        purchaseAnalysisVo.setDeliveryNum(((PurchaseAnalysisVo)finalOrderMap.get(purchaseAnalysisVo.getMaterialId().toString())).getDeliveryNum());
                    }
                }
                if (null != finalExcessMap && finalExcessMap.containsKey(purchaseAnalysisVo.getMaterialId())) {
                    PurchaseAnalysisVo purchaseAnalysisVo2 = (PurchaseAnalysisVo)finalExcessMap.get(purchaseAnalysisVo.getMaterialId());
                    purchaseAnalysisVo.setExcessAmount(purchaseAnalysisVo2.getExcessAmount());
                    purchaseAnalysisVo.setExcessNum(purchaseAnalysisVo2.getExcessNum());
                }
                purchaseAnalysisVo.setPurchaseRate(ComputeUtil.bigDecimalPercent(purchaseAnalysisVo.getOrderNum(), purchaseAnalysisVo.getNum(), 2));
                purchaseAnalysisVo.setUnarchivedQuantityNum(ComputeUtil.safeSub(purchaseAnalysisVo.getOrderNum(), purchaseAnalysisVo.getAlreadyEntryNum()));
                purchaseAnalysisVo.setOutRate(ComputeUtil.bigDecimalPercent(purchaseAnalysisVo.getAlreadyOutNum(), purchaseAnalysisVo.getAlreadyEntryNum(), 2));
                if (null == purchaseAnalysisVo.getOutMny()) {
                    purchaseAnalysisVo.setOutMny(BigDecimal.ZERO);
                }
                if (null == purchaseAnalysisVo.getInventoryMny()) {
                    purchaseAnalysisVo.setInventoryMny(BigDecimal.ZERO);
                }
                if (null == purchaseAnalysisVo.getEntryMny()) {
                    purchaseAnalysisVo.setEntryMny(BigDecimal.ZERO);
                }
                if (codeNameMap.isEmpty() || null == (tmp = "org".equals(groupType) ? (PurchaseAnalysisVo)vosByCategoryCode.get((String)codeNameMap.get(purchaseAnalysisVo.getMaterialTypeCode()) + "-" + purchaseAnalysisVo.getBelongOrgId()) : (PurchaseAnalysisVo)vosByCategoryCode.get(codeNameMap.get(purchaseAnalysisVo.getMaterialTypeCode())))) continue;
                tmp.setValidFlag(Boolean.valueOf(true));
                if (null == tmp.getBelongOrgId() && null != purchaseAnalysisVo.getBelongOrgId()) {
                    tmp.setBelongOrgType(purchaseAnalysisVo.getBelongOrgType());
                    tmp.setBelongOrgName(purchaseAnalysisVo.getBelongOrgName());
                    tmp.setBelongOrgId(purchaseAnalysisVo.getBelongOrgId());
                    tmp.setBelongOrgCode(purchaseAnalysisVo.getBelongOrgCode());
                }
                if (null == tmp.getOrgId() && null != purchaseAnalysisVo.getOrgId()) {
                    tmp.setOrgCode(purchaseAnalysisVo.getOrgCode());
                    tmp.setOrgId(purchaseAnalysisVo.getOrgId());
                    tmp.setOrgName(purchaseAnalysisVo.getOrgName());
                    tmp.setParentOrgId(purchaseAnalysisVo.getParentOrgId());
                    if (OrgVO.ORG_TYPE_DEPARTMENT.equals(purchaseAnalysisVo.getBelongOrgType())) {
                        tmp.setProjectId(purchaseAnalysisVo.getProjectId());
                        tmp.setProjectName(purchaseAnalysisVo.getProjectName());
                        tmp.setProjectCode(purchaseAnalysisVo.getProjectCode());
                    }
                }
                tmp.setSumNum(ComputeUtil.safeAdd(tmp.getSumNum(), purchaseAnalysisVo.getSumNum()));
                tmp.setNum(ComputeUtil.safeAdd(tmp.getNum(), purchaseAnalysisVo.getNum()));
                tmp.setPlanNum(ComputeUtil.safeAdd(tmp.getPlanNum(), purchaseAnalysisVo.getPlanNum()));
                tmp.setOrderNum(ComputeUtil.safeAdd(tmp.getOrderNum(), purchaseAnalysisVo.getOrderNum()));
                tmp.setDeliveryNum(ComputeUtil.safeAdd(tmp.getDeliveryNum(), purchaseAnalysisVo.getDeliveryNum()));
                tmp.setAlreadyEntryNum(ComputeUtil.safeAdd(tmp.getAlreadyEntryNum(), purchaseAnalysisVo.getAlreadyEntryNum()));
                tmp.setAlreadyOutNum(ComputeUtil.safeAdd(tmp.getAlreadyOutNum(), purchaseAnalysisVo.getAlreadyOutNum()));
                tmp.setInventoryNum(ComputeUtil.safeAdd(tmp.getInventoryNum(), purchaseAnalysisVo.getInventoryNum()));
                tmp.setUnarchivedQuantityNum(ComputeUtil.safeAdd(tmp.getUnarchivedQuantityNum(), purchaseAnalysisVo.getUnarchivedQuantityNum()));
                tmp.setChangeNum(ComputeUtil.safeAdd(tmp.getChangeNum(), purchaseAnalysisVo.getChangeNum()));
                tmp.setExcessNum(ComputeUtil.safeAdd(tmp.getExcessNum(), purchaseAnalysisVo.getExcessNum()));
                tmp.setChangeAmount(ComputeUtil.safeAdd(tmp.getChangeAmount(), purchaseAnalysisVo.getChangeAmount()));
                tmp.setExcessAmount(ComputeUtil.safeAdd(tmp.getExcessAmount(), purchaseAnalysisVo.getExcessAmount()));
                tmp.setEntryMny(ComputeUtil.safeAdd(tmp.getEntryMny(), purchaseAnalysisVo.getEntryMny()));
                tmp.setOutMny(ComputeUtil.safeAdd(tmp.getOutMny(), purchaseAnalysisVo.getOutMny()));
                tmp.setInventoryMny(ComputeUtil.safeAdd(tmp.getInventoryMny(), purchaseAnalysisVo.getInventoryMny()));
                tmp.setOutRate(ComputeUtil.bigDecimalPercent(tmp.getAlreadyOutNum(), tmp.getAlreadyEntryNum(), 2));
                tmp.setPurchaseRate(ComputeUtil.bigDecimalPercent(tmp.getOrderNum(), tmp.getNum(), 2));
                if ("org".equals(groupType)) {
                    vosByCategoryCode.put((String)codeNameMap.get(purchaseAnalysisVo.getMaterialTypeCode()) + "-" + purchaseAnalysisVo.getBelongOrgId(), tmp);
                    continue;
                }
                vosByCategoryCode.put((String)codeNameMap.get(purchaseAnalysisVo.getMaterialTypeCode()), tmp);
            }
            if (codeNameMap.isEmpty()) {
                voList = voList.stream().filter(item -> !Boolean.FALSE.equals(item.getValidFlag())).sorted(Comparator.comparing(PurchaseAnalysisVo::getPurchaseRate, Comparator.nullsLast(BigDecimal::compareTo))).collect(Collectors.toList());
                return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", voList);
            }
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", new ArrayList(vosByCategoryCode.values().stream().filter(PurchaseAnalysisVo::getValidFlag).collect(Collectors.toList())));
        }
        if (codeNameMap.isEmpty()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", voList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", new ArrayList(vosByCategoryCode.values().stream().filter(PurchaseAnalysisVo::getValidFlag).collect(Collectors.toList())));
    }

    public void queryOrgSurplusNum(List<Long> orgIds, List<Long> materialIds, List<PurchaseAnalysisVo> list, String orgField) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put(orgField, new Parameter("in", orgIds));
        queryParam.getParams().put("material_id", new Parameter("in", materialIds));
        CommonResponse surplusResponse = this.storeManageApi.queryOrgSurplusBatch(queryParam);
        if (surplusResponse.isSuccess()) {
            List flowList = (List)surplusResponse.getData();
            this.logger.info("\u5e93\u5b58\u5269\u4f59\u91cf\uff1a{}", (Object)JSONObject.toJSONString((Object)flowList));
            if (CollectionUtils.isNotEmpty((Collection)flowList)) {
                Map<Long, List<SurplusVO>> materialMap = flowList.stream().collect(Collectors.groupingBy(e -> e.getMaterialId()));
                list.stream().forEach(e -> {
                    if (materialMap.containsKey(e.getMaterialId())) {
                        List surplusVOS = (List)materialMap.get(e.getMaterialId());
                        BigDecimal surplusNum = surplusVOS.stream().map(SurplusVO::getSurplusNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal surplusMny = surplusVOS.stream().map(SurplusVO::getSurplusMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        e.setInventoryNum(surplusNum);
                        e.setInventoryMny(surplusMny);
                    }
                });
            }
        } else {
            throw new BusinessException("\u67e5\u8be2\u5e93\u5b58\u6d41\u6c34\u51fa\u9519\uff01");
        }
    }

    public void querySurplusNum(Long projectId, List<Long> materialIds, List<PurchaseAnalysisVo> list) {
        ArrayList vos = new ArrayList();
        materialIds.stream().forEach(e -> {
            SurplusVO surplusVO = new SurplusVO();
            surplusVO.setMaterialId(e);
            surplusVO.setProjectId(projectId);
            vos.add(surplusVO);
        });
        CommonResponse surplusResponse = this.storeManageApi.querySurplusBatch(vos);
        if (surplusResponse.isSuccess()) {
            List flowList = (List)surplusResponse.getData();
            this.logger.info("\u5e93\u5b58\u5269\u4f59\u91cf\uff1a{}", (Object)JSONObject.toJSONString((Object)flowList));
            if (CollectionUtils.isNotEmpty((Collection)flowList)) {
                Map<Long, List<SurplusVO>> materialMap = flowList.stream().collect(Collectors.groupingBy(e -> e.getMaterialId()));
                list.stream().forEach(e -> {
                    if (materialMap.containsKey(e.getMaterialId())) {
                        List surplusVOS = (List)materialMap.get(e.getMaterialId());
                        BigDecimal surplusNum = surplusVOS.stream().map(SurplusVO::getSurplusNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal surplusMny = surplusVOS.stream().map(SurplusVO::getSurplusMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        e.setInventoryNum(surplusNum);
                        e.setInventoryMny(surplusMny);
                    }
                });
            }
        } else {
            throw new BusinessException("\u67e5\u8be2\u5e93\u5b58\u6d41\u6c34\u51fa\u9519\uff01");
        }
    }

    @RequestMapping(value={"/getPurchaseMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getPurchaseMny(@RequestParam(required=false) Long projectId, @RequestParam(required=false) Long orgId, @RequestParam(required=false) Integer orgType, @RequestParam(required=false) String categoryGroup) {
        CommonResponse surplusResponse;
        JSONObject json = new JSONObject();
        ArrayList<Long> allMaterialIds = new ArrayList<Long>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<Long> orgIds = null;
        if (null == projectId && null == orgId) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u9879\u76ee\u4fe1\u606f\u3001\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (null != projectId) {
            params.put("projectId", projectId);
        }
        if (null != orgId) {
            if (!OrgVO.ORG_TYPE_DEPARTMENT.equals(orgType)) {
                CommonResponse orgResp = this.orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(), Arrays.asList(OrgVO.ORG_TYPE_DEPARTMENT), null, orgId);
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u7ec4\u7ec7id-{}\u67e5\u8be2\u672c\u4e0b\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25", (Object)orgId, (Object)JSONObject.toJSONString((Object)orgResp));
                    return CommonResponse.error((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                if (!CollectionUtils.isNotEmpty((Collection)((Collection)orgResp.getData()))) {
                    json.put("entryMny", (Object)0);
                    json.put("outMny", (Object)0);
                    json.put("allInMny", (Object)0);
                    json.put("allOutMny", (Object)0);
                    json.put("surplusMny", (Object)0);
                    json.put("disposeMny", (Object)0);
                    return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)json);
                }
                orgIds = new ArrayList<Long>(((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toSet()));
                params.put("orgIds", orgIds);
                List<ControlPlanEntity> controlPlanList = this.controlPlanService.getAllByOrgId(orgIds);
                if (CollectionUtils.isEmpty(controlPlanList)) {
                    json.put("entryMny", (Object)0);
                    json.put("outMny", (Object)0);
                    json.put("allInMny", (Object)0);
                    json.put("allOutMny", (Object)0);
                    json.put("surplusMny", (Object)0);
                    json.put("disposeMny", (Object)0);
                    return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)json);
                }
                orgIds = new ArrayList(controlPlanList.stream().map(ControlPlanEntity::getOrgId).collect(Collectors.toSet()));
                params.put("orgIds", orgIds);
            } else {
                params.put("orgIds", Arrays.asList(orgId));
            }
            params.remove("orgType");
            params.remove("orgId");
        }
        List<Long> childCategoryIds = null;
        if (StringUtils.isNotBlank((String)categoryGroup)) {
            ArrayList<String> categoryCode = new ArrayList<String>();
            Map tmpMap = (Map)JSONObject.parseObject((String)categoryGroup, Map.class);
            HashMap<String, ArrayList<String>> typeNameGroupCodeMap = new HashMap<String, ArrayList<String>>();
            ArrayList<String> codes = null;
            for (String typeName : tmpMap.keySet()) {
                codes = new ArrayList<String>(Arrays.asList(((String)tmpMap.get(typeName)).split(",")));
                typeNameGroupCodeMap.put(typeName, codes);
                categoryCode.addAll(codes);
            }
            List<MaterialCategoryEntity> categorys = this.categoryService.queryByCodes(categoryCode);
            List<Long> parentCategoryIds = categorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<MaterialCategoryEntity> childCategorys = this.categoryService.getAllLeafByPids(parentCategoryIds, 1);
            childCategoryIds = childCategorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            params.put("categoryIds", childCategoryIds);
        }
        List<PurchaseAnalysisVo> purchaseAnalysis = this.planSumDetailService.getList(params);
        for (PurchaseAnalysisVo vo : purchaseAnalysis) {
            allMaterialIds.add(vo.getMaterialId());
        }
        QueryParam queryParam = new QueryParam();
        if (null != projectId) {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        if (null != orgIds) {
            queryParam.getParams().put("org_id", new Parameter("in", orgIds));
        }
        if (CollectionUtils.isNotEmpty(childCategoryIds)) {
            queryParam.getParams().put("materialCategoryId", new Parameter("in", childCategoryIds));
        }
        queryParam.getParams().put("effectiveState", new Parameter("eq", (Object)1));
        CommonResponse flowResp = this.storeFlowApi.getFlowList(queryParam);
        if (flowResp.isSuccess()) {
            List flowList = (List)flowResp.getData();
            if (CollectionUtils.isNotEmpty((Collection)flowList)) {
                BigDecimal entryMny = BigDecimal.ZERO;
                BigDecimal outMny = BigDecimal.ZERO;
                for (FlowVO e2 : flowList) {
                    if (!allMaterialIds.contains(e2.getMaterialId())) {
                        allMaterialIds.add(e2.getMaterialId());
                    }
                    if (e2.getInOutFlag() == 1) {
                        entryMny = ComputeUtil.safeAdd(entryMny, e2.getTaxMny());
                        continue;
                    }
                    outMny = ComputeUtil.safeAdd(outMny, e2.getTaxMny());
                }
                json.put("entryMny", (Object)entryMny);
                json.put("outMny", (Object)outMny);
                BigDecimal allInMny = flowList.stream().filter(e -> e.getInOutType() == 12).map(FlowVO::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                json.put("allInMny", (Object)allInMny);
                BigDecimal allOutMny = flowList.stream().filter(e -> e.getInOutType() == 22).map(FlowVO::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                json.put("allOutMny", (Object)allOutMny);
            } else {
                json.put("entryMny", (Object)0);
                json.put("outMny", (Object)0);
                json.put("allInMny", (Object)0);
                json.put("allOutMny", (Object)0);
            }
        } else {
            throw new BusinessException("\u67e5\u8be2\u5e93\u5b58\u6d41\u6c34\u51fa\u9519\uff01");
        }
        QueryParam surplusQuery = new QueryParam();
        surplusQuery.getParams().put("materialId", new Parameter("in", allMaterialIds));
        if (null != projectId) {
            surplusQuery.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        if (null != orgIds) {
            surplusQuery.getParams().put("orgId", new Parameter("in", orgIds));
        }
        if (CollectionUtils.isNotEmpty(childCategoryIds)) {
            surplusQuery.getParams().put("materialCategoryId", new Parameter("in", childCategoryIds));
        }
        if (!(surplusResponse = this.storeManageApi.queryOrgSurplusBatch(surplusQuery)).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5e93\u5b58\u6d41\u6c34\u51fa\u9519\uff01");
        }
        List flowList = (List)surplusResponse.getData();
        BigDecimal surplusMny = CollectionUtils.isNotEmpty((Collection)flowList) ? flowList.stream().map(SurplusVO::getSurplusMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd) : BigDecimal.ZERO;
        json.put("surplusMny", (Object)surplusMny);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null != projectId) {
            queryWrapper.eq((Object)"project_id", (Object)projectId);
        }
        if (null != orgIds) {
            queryWrapper.in((Object)"org_id", orgIds);
        }
        if (CollectionUtils.isNotEmpty(childCategoryIds)) {
            List<Long> disposeIds = this.disposeDetailService.getDispostIdsByCategoryIds(childCategoryIds);
            if (CollectionUtils.isNotEmpty(disposeIds)) {
                queryWrapper.in((Object)"id", disposeIds);
            } else {
                queryWrapper.eq((Object)"id", (Object)-999L);
            }
        }
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = this.disposeService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal disposeMny = list.stream().map(DisposeEntity::getActualDisposeTaxMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
            json.put("disposeMny", (Object)disposeMny);
        } else {
            json.put("disposeMny", (Object)0);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @GetMapping(value={"/queryOrderList"})
    @ResponseBody
    public CommonResponse<List<OrderQueryVo>> queryOrderList(@RequestParam(required=false) Map<String, Object> params) {
        if (null != params.get("categoryGroup")) {
            ArrayList<String> categoryCode = new ArrayList<String>();
            Map tmpMap = (Map)JSONObject.parseObject((String)params.get("categoryGroup").toString(), Map.class);
            HashMap<String, ArrayList<String>> typeNameGroupCodeMap = new HashMap<String, ArrayList<String>>();
            ArrayList<String> codes = null;
            for (String typeName : tmpMap.keySet()) {
                codes = new ArrayList<String>(Arrays.asList(((String)tmpMap.get(typeName)).split(",")));
                typeNameGroupCodeMap.put(typeName, codes);
                categoryCode.addAll(codes);
            }
            List<MaterialCategoryEntity> categorys = this.categoryService.queryByCodes(categoryCode);
            List<Long> parentCategoryIds = categorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<MaterialCategoryEntity> childCategorys = this.categoryService.getAllLeafByPids(parentCategoryIds, 1);
            List childCategoryIds = childCategorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            params.put("categoryIds", childCategoryIds);
        }
        List<OrderQueryVo> list = this.orderDetailService.orderList(params);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }
}

