/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertyEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertySubItemEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MaterialCategoryMapper;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertyService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertySubItemService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialCategoryService")
public class MaterialCategoryServiceImpl
extends BaseServiceImpl<MaterialCategoryMapper, MaterialCategoryEntity>
implements IMaterialCategoryService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MaterialCategoryMapper mapper;
    @Autowired
    private IMaterialCategoryPropertySubItemService materialCategoryPropertySubItemService;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryPropertyService propertyService;
    private final String MATERIAL_CATEGORY_SYNC_URL = "/cefoc/yql/ReceiveGoodTypeList";

    @Override
    public List<MaterialCategoryVO> queryList(Map<String, Object> params) {
        return this.mapper.queryList(params);
    }

    @Override
    public List<MaterialCategoryVO> queryListAndRuledFlag(Map<String, Object> params) {
        return this.mapper.queryListAndRuledFlag(params);
    }

    @Override
    public MaterialCategoryEntity selectByCode(String code) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"code", (Object)code);
        return (MaterialCategoryEntity)((Object)super.getOne((Wrapper)query));
    }

    @Override
    public MaterialCategoryVO saveOrUpdateCategory(MaterialCategoryEntity entity) {
        String newCategoryName = null;
        ArrayList propertyValueList = new ArrayList();
        boolean newPropertyFlag = false;
        Integer enabled = null;
        Integer blockFlag = null;
        ArrayList newNotEnabledProperty = new ArrayList();
        ArrayList<MaterialCategoryPropertyEntity> changedProperty = new ArrayList<MaterialCategoryPropertyEntity>();
        ArrayList<Long> delPropertyValueIds = new ArrayList<Long>();
        ArrayList<MaterialCategoryPropertySubItemEntity> changeNameValues = new ArrayList<MaterialCategoryPropertySubItemEntity>();
        ArrayList<Object> neweValues = new ArrayList<Object>();
        MaterialCategoryEntity dbEntity = null;
        if (null == entity.getId()) {
            entity.setId(IdWorker.getId());
            if (null != entity.getParentId()) {
                MaterialCategoryEntity parent = (MaterialCategoryEntity)((Object)super.selectById((Serializable)entity.getParentId()));
                entity.setInnerCode(parent.getInnerCode() + "|" + entity.getId());
                entity.setCoordinationFlag(parent.getCoordinationFlag());
            } else {
                entity.setCoordinationFlag(0);
                entity.setInnerCode(entity.getId().toString());
            }
        }
        if (entity.getPropertyFlag() == 1) {
            HashMap<Long, MaterialCategoryPropertyEntity> oldProperty = new HashMap<Long, MaterialCategoryPropertyEntity>();
            dbEntity = (MaterialCategoryEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (null != dbEntity) {
                if (!dbEntity.getName().equals(entity.getName())) {
                    newCategoryName = entity.getName();
                }
                if (CollectionUtils.isNotEmpty(dbEntity.getPropertyList())) {
                    oldProperty.putAll(dbEntity.getPropertyList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
                }
            }
            if (CollectionUtils.isNotEmpty(entity.getPropertyList())) {
                ArrayList newProperty = new ArrayList();
                ArrayList pList = new ArrayList();
                entity.getPropertyList().stream().forEach(item -> {
                    if (oldProperty.containsKey(item.getId()) && ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u505c\u7528.getCode().equals(((MaterialCategoryPropertyEntity)((Object)((Object)oldProperty.get(item.getId())))).getEnabled())) {
                        pList.add(oldProperty.get(item.getId()));
                    } else if ("del".equals(item.getRowState())) {
                        ((MaterialCategoryPropertyEntity)((Object)((Object)oldProperty.get(item.getId())))).setRowState("del");
                        pList.add(oldProperty.get(item.getId()));
                        delPropertyValueIds.addAll(item.getItemList().stream().map(BaseEntity::getId).collect(Collectors.toSet()));
                    } else if (ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u505c\u7528.getCode().equals(item.getEnabled())) {
                        if (oldProperty.containsKey(item.getId())) {
                            ((MaterialCategoryPropertyEntity)((Object)((Object)oldProperty.get(item.getId())))).setEnabled(ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u505c\u7528.getCode());
                            pList.add(oldProperty.get(item.getId()));
                            newNotEnabledProperty.add(item);
                        } else if (null == item.getId()) {
                            item.setId(IdWorker.getId());
                            item.setCode(item.getName());
                            newProperty.add(item);
                        }
                    } else {
                        if (item.getId() == null) {
                            item.setId(IdWorker.getId());
                            item.setCode(item.getName());
                            newProperty.add(item);
                        }
                        if (StringUtils.isNotBlank((CharSequence)item.getOldName()) && !item.getName().equals(item.getOldName()) || null != item.getOldSequence() && !item.getOldSequence().equals(item.getSequence()) || null != item.getOldProductCodeFlag() && !item.getOldProductCodeFlag().equals(item.getProductCodeFlag())) {
                            changedProperty.add((MaterialCategoryPropertyEntity)((Object)item));
                        }
                        pList.add(item);
                        propertyValueList.addAll(item.getItemList().stream().map(sub -> {
                            if (null == sub.getId()) {
                                sub.setCategoryId(entity.getId());
                                sub.setPropertyId(item.getId());
                            }
                            return sub;
                        }).collect(Collectors.toList()));
                    }
                });
                entity.setPropertyShowName(pList.stream().filter(item -> !"del".equals(item.getRowState())).sorted(new Comparator<MaterialCategoryPropertyEntity>(){

                    @Override
                    public int compare(MaterialCategoryPropertyEntity o1, MaterialCategoryPropertyEntity o2) {
                        return o1.getSequence() - o2.getSequence();
                    }
                }).map(item -> item.getName()).collect(Collectors.joining("-")));
                if (CollectionUtils.isNotEmpty(newProperty)) {
                    newPropertyFlag = true;
                }
            }
            if (CollectionUtils.isNotEmpty(propertyValueList)) {
                List<MaterialCategoryPropertySubItemVO> dbPropertyValues = this.materialCategoryPropertySubItemService.getAllByCategoryId(entity.getId());
                Map<Long, Map<String, MaterialCategoryPropertySubItemVO>> propertyValueMap = dbPropertyValues.stream().collect(Collectors.groupingBy(MaterialCategoryPropertySubItemVO::getPropertyId, Collectors.toMap(item -> item.getName(), item -> item)));
                HashSet<String> validPropertyValues = null;
                Map<Object, Object> propertySubItemNameMap = new HashMap();
                HashMap propertyValuesMap = new HashMap();
                for (MaterialCategoryPropertySubItemEntity item2 : propertyValueList) {
                    validPropertyValues = (HashSet<String>)propertyValuesMap.get(item2.getPropertyId());
                    if (null == validPropertyValues) {
                        validPropertyValues = new HashSet<String>();
                        propertyValuesMap.put(item2.getPropertyId(), validPropertyValues);
                    }
                    propertySubItemNameMap = propertyValueMap.get(item2.getPropertyId());
                    if ("del".equals(item2.getRowState())) {
                        delPropertyValueIds.add(item2.getId());
                        continue;
                    }
                    if (null != item2.getOldName() && !item2.getName().equals(item2.getOldName()) || null != item2.getOldProductCode() && !item2.getOldProductCode().equals(item2.getProductCode())) {
                        changeNameValues.add(item2);
                    } else {
                        neweValues.add((Object)item2);
                    }
                    if (validPropertyValues.contains(item2.getName())) {
                        throw new BusinessException("\u4fdd\u5b58\u5931\u8d25, \u5c5e\u6027\u503c\u91cd\u590d\uff01");
                    }
                    if (null != propertySubItemNameMap && propertySubItemNameMap.containsKey(item2.getName()) && !((MaterialCategoryPropertySubItemVO)propertySubItemNameMap.get(item2.getName())).getId().equals(item2.getId()) && ZDSMaterialCommonEnums.\u5206\u7c7b\u8bbe\u7f6e\u5c5e\u6027\u503c\u662f\u5426\u751f\u6548_\u5426.getCode().equals(((MaterialCategoryPropertySubItemVO)propertySubItemNameMap.get(item2.getName())).getValidFlag()) && neweValues.contains((Object)item2)) {
                        neweValues.remove((Object)item2);
                        ((MaterialCategoryPropertySubItemVO)propertySubItemNameMap.get(item2.getName())).setSequence(item2.getSequence());
                        ((MaterialCategoryPropertySubItemVO)propertySubItemNameMap.get(item2.getName())).setValidFlag(ZDSMaterialCommonEnums.\u5206\u7c7b\u8bbe\u7f6e\u5c5e\u6027\u503c\u662f\u5426\u751f\u6548_\u662f.getCode());
                        neweValues.add(BeanMapper.map((Object)propertySubItemNameMap.get(item2.getName()), MaterialCategoryPropertySubItemEntity.class));
                    }
                    validPropertyValues.add(item2.getName());
                }
                if (CollectionUtils.isNotEmpty(changeNameValues)) {
                    this.materialCategoryPropertySubItemService.saveOrUpdateBatch(changeNameValues, changeNameValues.size(), false);
                }
                if (CollectionUtils.isNotEmpty(delPropertyValueIds)) {
                    this.materialCategoryPropertySubItemService.removeByIds(delPropertyValueIds);
                }
                if (CollectionUtils.isNotEmpty(neweValues)) {
                    this.materialCategoryPropertySubItemService.saveOrUpdateBatch(neweValues, neweValues.size(), false);
                }
            }
            ArrayList<Long> excludeMaterialIds = new ArrayList<Long>();
            if (newPropertyFlag || newNotEnabledProperty.size() > 0) {
                enabled = ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u505c\u7528.getCode();
                blockFlag = ZDSMaterialCommonEnums.\u5c01\u5b58_\u5c01\u5b58.getCode();
            }
            if (changedProperty.size() > 0 || changeNameValues.size() > 0) {
                excludeMaterialIds.addAll(this.materialService.updatePropertyAndValues(changedProperty, changeNameValues, delPropertyValueIds, newCategoryName));
            } else if (delPropertyValueIds.size() > 0) {
                excludeMaterialIds.addAll(this.materialService.updateByPropertyValueDel(delPropertyValueIds));
            }
            if (null != enabled || null != blockFlag) {
                ArrayList<Long> categoryIds = new ArrayList<Long>();
                categoryIds.add(entity.getId());
                this.materialService.updateMaterialStatusByCategory(categoryIds, blockFlag, enabled, ZDSMaterialCommonEnums.\u5c01\u5b58_\u6b63\u5e38.getCode(), newCategoryName, excludeMaterialIds);
            } else if (StringUtils.isNotBlank((CharSequence)newCategoryName)) {
                this.materialService.updateCategoryName(entity.getId(), newCategoryName, excludeMaterialIds);
            }
        } else {
            entity.setPropertyShowName(null);
        }
        super.saveOrUpdate((Object)entity, false);
        HashedMap syncParams = new HashedMap();
        syncParams.put("categoryId", entity.getId());
        this.syncToErp((Map<String, Object>)syncParams);
        return (MaterialCategoryVO)BeanMapper.map((Object)((Object)entity), MaterialCategoryVO.class);
    }

    @Override
    public List<MaterialCategoryEntity> queryByCodes(List<String> codes) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"code", codes);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return super.list((Wrapper)query);
    }

    @Override
    public List<MaterialCategoryVO> queryAllByPid(Long categoryId, Integer enabledStatus) {
        List<Object> resp = new ArrayList<MaterialCategoryVO>();
        MaterialCategoryEntity parent = (MaterialCategoryEntity)((Object)super.selectById((Serializable)categoryId));
        if (null != parent) {
            QueryWrapper query = new QueryWrapper();
            query.likeRight((Object)"inner_code", (Object)parent.getInnerCode());
            query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            if (null != enabledStatus) {
                query.eq((Object)"enabled", (Object)enabledStatus);
            }
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            List children = super.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                resp = BeanMapper.mapList((Iterable)children, MaterialCategoryVO.class);
            }
        }
        return resp;
    }

    @Override
    public void updateEnabledStatus(MaterialCategoryEntity dbEntity) {
        ArrayList<MaterialCategoryEntity> updateList = new ArrayList<MaterialCategoryEntity>();
        MaterialCategoryEntity parent = null;
        if (ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u505c\u7528.getCode().equals(dbEntity.getEnabled())) {
            List<MaterialCategoryVO> childsByParent;
            List<MaterialCategoryVO> categoryVOS = this.queryAllByPid(dbEntity.getId(), ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
            List<Long> categoryIds = categoryVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            if (null != dbEntity.getParentId() && (CollectionUtils.isEmpty(childsByParent = this.queryAllByPid(dbEntity.getParentId(), ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode())) || childsByParent.size() <= 1)) {
                parent = (MaterialCategoryEntity)((Object)super.selectById((Serializable)dbEntity.getParentId()));
                parent.setEnabled(ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u505c\u7528.getCode());
            }
            this.materialService.updateMaterialStatusByCategory(categoryIds, null, ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u505c\u7528.getCode(), ZDSMaterialCommonEnums.\u5c01\u5b58_\u6b63\u5e38.getCode(), null, null);
        } else {
            List<MaterialCategoryVO> categoryVOS = this.queryAllByPid(dbEntity.getId(), ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u505c\u7528.getCode());
            List<Long> categoryIds = categoryVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            if (null != dbEntity.getParentId()) {
                parent = (MaterialCategoryEntity)((Object)super.selectById((Serializable)dbEntity.getParentId()));
                parent.setEnabled(ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
            }
            this.materialService.updateMaterialStatusByCategory(categoryIds, null, ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode(), ZDSMaterialCommonEnums.\u5c01\u5b58_\u6b63\u5e38.getCode(), null, null);
        }
        updateList.add(dbEntity);
        if (null != parent) {
            updateList.add(parent);
        }
        super.saveOrUpdateBatch(updateList, updateList.size(), false);
    }

    @Override
    public List<Long> queryChildrenIdsByPIds(List<Long> ids) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        query.orderByDesc((Object)"inner_code");
        List categorys = super.list((Wrapper)query);
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.select(new String[]{"id"});
        listQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        listQuery.and(q -> {
            for (MaterialCategoryEntity m : categorys) {
                q.or(iq -> (QueryWrapper)iq.likeRight((Object)"inner_code", (Object)m.getInnerCode()));
            }
            return q;
        });
        List idList = super.listObjs((Wrapper)listQuery);
        return idList.stream().map(item -> Long.valueOf(item.toString())).collect(Collectors.toList());
    }

    @Override
    public List<MaterialCategoryEntity> selectByName(String name, Long id) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"name", (Object)name);
        if (null != id) {
            query.ne((Object)"id", (Object)id);
        }
        return super.list((Wrapper)query);
    }

    @Override
    public String generateBillCode(String code) {
        QueryWrapper query = new QueryWrapper();
        query.likeRight((Object)"code", (Object)code);
        List codeList = super.list((Wrapper)query);
        String billCode = null;
        List codes = codeList.stream().map(MaterialCategoryEntity::getCode).collect(Collectors.toList());
        MaterialCategoryEntity codeEntity = this.selectByCode(code);
        long curSize = codeList.stream().filter(item -> item.getInnerCode().indexOf(codeEntity.getId().toString()) >= 0).count();
        billCode = code + (++curSize < 10L ? "0" + curSize : Long.valueOf(curSize));
        if (CollectionUtils.isNotEmpty(codes)) {
            List codeStr = codes.parallelStream().map(item -> item.toString()).collect(Collectors.toList());
            while (codeStr.contains(billCode)) {
                billCode = code + (++curSize < 10L ? "0" + curSize : Long.valueOf(curSize));
            }
        }
        return billCode;
    }

    @Override
    public List<MaterialCategoryEntity> queryByCode(String code) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"code", (Object)code);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    @Override
    public MaterialCategoryVO queryDetail(Long id) {
        MaterialCategoryVO resp = null;
        MaterialCategoryEntity e = (MaterialCategoryEntity)((Object)super.selectById((Serializable)id));
        if (null != e) {
            resp = (MaterialCategoryVO)BeanMapper.map((Object)((Object)e), MaterialCategoryVO.class);
        }
        return resp;
    }

    @Override
    public Map<Long, List<MaterialCategoryVO>> queryCategoryListByMaterialId(List<Long> ids) {
        List<MaterialVO> materials = this.materialService.queryDetailList(ids, false);
        HashMap resMap = new HashMap();
        HashMap params = new HashMap();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"enabled", (Object)ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
        List materialCategoryList = super.list((Wrapper)query);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            List materialCategoryVOS = BeanMapper.mapList((Iterable)materialCategoryList, MaterialCategoryVO.class);
            Map categoryVOMap = materialCategoryVOS.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key2));
            for (MaterialVO materialVO : materials) {
                Long categoryId = materialVO.getCategoryId();
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)categoryVOMap.get(categoryId);
                String innerCode = categoryVO.getInnerCode();
                String[] keyArray = innerCode.split("\\|");
                ArrayList result = new ArrayList();
                for (int i = keyArray.length - 1; i >= 0; --i) {
                    Long key = Long.valueOf(keyArray[i]);
                    if (!categoryVOMap.containsKey(key)) continue;
                    result.add(categoryVOMap.get(key));
                }
                resMap.put(materialVO.getId(), result);
            }
        }
        return null;
    }

    @Override
    public List<MaterialCategoryVO> queryCategoryListByIds(List<Long> ids) {
        List<Object> resp = new ArrayList<MaterialCategoryVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        List list = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resp = BeanMapper.mapList((Iterable)list, MaterialCategoryVO.class);
        }
        return resp;
    }

    @Override
    public List<MaterialCategoryVO> queryCategoryListByChildren(List<Long> ids) {
        ArrayList<MaterialCategoryVO> result = new ArrayList<MaterialCategoryVO>();
        HashMap params = new HashMap();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"enabled", (Object)ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
        List materialCategoryList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)materialCategoryList)) {
            HashSet<Long> keySet = new HashSet<Long>();
            List materialCategoryVOS = BeanMapper.mapList((Iterable)materialCategoryList, MaterialCategoryVO.class);
            Map categoryVOMap = materialCategoryVOS.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key2));
            for (Long id : ids) {
                String[] keyArray;
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)categoryVOMap.get(id);
                String innerCode = categoryVO.getInnerCode();
                for (String keyStr : keyArray = innerCode.split("\\|")) {
                    Long key = Long.valueOf(keyStr);
                    if (keySet.contains(key) || !categoryVOMap.containsKey(key)) continue;
                    keySet.add(key);
                    result.add((MaterialCategoryVO)categoryVOMap.get(key));
                }
            }
        }
        return result;
    }

    @Override
    public List<MaterialCategoryEntity> getAllCategoryByLeafNodeId(Long categoryId) {
        MaterialCategoryEntity category = (MaterialCategoryEntity)((Object)this.selectById(categoryId));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.likeRight((Object)"inner_code", (Object)category.getInnerCode().split("\\|")[0]);
        query.eq((Object)"enabled", (Object)ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
        query.orderByAsc((Object)"inner_code");
        return super.list((Wrapper)query);
    }

    @Override
    public long countCategory(Map<String, Object> params) {
        return this.mapper.countCategory(params);
    }

    @Override
    public List<Map> getSyncList(Map<String, Object> params) {
        return this.mapper.getSyncList(params);
    }

    @Override
    public void updateCoordination(MaterialCategoryVO materialCategoryVO) {
        MaterialCategoryEntity categoryEntity = (MaterialCategoryEntity)((Object)super.selectById((Serializable)materialCategoryVO.getId()));
        if (null != categoryEntity) {
            UpdateWrapper update = new UpdateWrapper();
            if (ZDSMaterialCommonEnums.\u534f\u540c\u9a8c\u6536_\u662f.getCode().equals(materialCategoryVO.getCoordinationFlag())) {
                update.likeRight((Object)"inner_code", (Object)categoryEntity.getInnerCode());
                update.eq((Object)"coordination_flag", (Object)ZDSMaterialCommonEnums.\u534f\u540c\u9a8c\u6536_\u5426.getCode());
                update.set((Object)"coordination_flag", (Object)ZDSMaterialCommonEnums.\u534f\u540c\u9a8c\u6536_\u662f.getCode());
            } else {
                update.in((Object)"id", (Collection)Arrays.asList(categoryEntity.getInnerCode().split("\\|")).stream().map(item -> Long.valueOf(item)).collect(Collectors.toList()));
                update.eq((Object)"coordination_flag", (Object)ZDSMaterialCommonEnums.\u534f\u540c\u9a8c\u6536_\u662f.getCode());
                update.set((Object)"coordination_flag", (Object)ZDSMaterialCommonEnums.\u534f\u540c\u9a8c\u6536_\u5426.getCode());
            }
            update.set((Object)"update_user_code", (Object)InvocationInfoProxy.getUsercode());
            update.set((Object)"update_time", (Object)new Date());
            super.update((Wrapper)update);
        }
    }

    @Override
    public List<MaterialCategoryEntity> getAllLeafByPids(List<Long> ids, Integer enabledStatus) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"enabled", (Object)enabledStatus);
        query.orderByDesc((Object)"inner_code");
        List categorys = super.list((Wrapper)query);
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        listQuery.eq((Object)"property_flag", (Object)ZDSMaterialCommonEnums.\u5206\u7c7b\u8bbe\u7f6e\u5c5e\u6027_\u662f.getCode());
        listQuery.and(q -> {
            for (MaterialCategoryEntity m : categorys) {
                q.or(iq -> (QueryWrapper)iq.likeRight((Object)"inner_code", (Object)m.getInnerCode()));
            }
            return q;
        });
        return super.list((Wrapper)listQuery);
    }

    @Override
    public void syncToErp(Map<String, Object> queryParams) {
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/ReceiveGoodTypeList";
        List<Map> syncList = this.getSyncList(queryParams);
        Map<String, String> headers = null;
        try {
            if (CollectionUtils.isEmpty(syncList)) {
                this.logger.info("\u5f85\u63a8\u9001ERP\u7269\u6599\u6863\u6848\u5206\u7c7b\u4e3a\u7a7a\uff0c\u540c\u6b65\u4efb\u52a1\u6267\u884c\u7ed3\u675f\uff01\uff01\uff01");
                return;
            }
            this.logger.info("\u672c\u6b21\u5f85\u63a8\u9001ERP\u7269\u6599\u6863\u6848\u6570\u636e\uff1a{}\u6761", (Object)syncList.size());
            String reqResp = null;
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(syncList), headers, (Integer)60000, (Integer)60000);
            this.logger.info("\u7269\u6599\u5206\u7c7b\u63a8\u9001 ERP\u7ed3\u679c\uff1a{}", (Object)reqResp);
            JSONObject syncResultJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(syncResultJson.getString("Status"))) {
                this.logger.error("\u7269\u6599\u5206\u7c7b\u63a8\u9001ERP\uff0c\u8bf7\u6c42\u7ed3\u679c\u8fd4\u56de\u6210\u529f\uff0c\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)syncResultJson.getString("info"));
            } else {
                this.logger.error("\u7269\u6599\u5206\u7c7b\u63a8\u9001ERP\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(syncList), JSONObject.toJSONString(headers, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), reqResp});
            }
        }
        catch (Exception e) {
            this.logger.error("\u7269\u6599\u6863\u6848\u63a8\u9001ERP\u5f02\u5e38\uff0c\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{}", new Object[]{reqUrl, JSONObject.toJSONString(syncList), JSONObject.toJSONString(headers, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
        }
    }

    @Override
    public List<MaterialCategoryVO> getAllByIds(List<Long> ids) {
        List<Object> resp = new ArrayList<MaterialCategoryVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            resp = BeanMapper.mapList((Iterable)dbList, MaterialCategoryVO.class);
        }
        return resp;
    }

    @Override
    public String queryPidCodeByCode(String code) {
        MaterialCategoryEntity codeEntity = this.selectByCode(code);
        MaterialCategoryEntity materialCategoryEntity = (MaterialCategoryEntity)((Object)super.selectById((Serializable)codeEntity.getParentId()));
        return materialCategoryEntity.getCode();
    }

    @Override
    public List<MaterialCategoryVO> getAllBySourceIds(List<String> sourceIds, Integer propertyFlag) {
        List<Object> resp = new ArrayList<MaterialCategoryVO>();
        if (CollectionUtils.isNotEmpty(sourceIds)) {
            List dbList;
            QueryWrapper query = new QueryWrapper();
            query.in((Object)"source_id", sourceIds);
            if (null != propertyFlag) {
                query.eq((Object)"property_flag", (Object)propertyFlag);
            }
            if (CollectionUtils.isNotEmpty((Collection)(dbList = super.list((Wrapper)query)))) {
                resp = BeanMapper.mapList((Iterable)dbList, MaterialCategoryVO.class);
            }
        }
        return resp;
    }
}

