/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.out.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.BillPushStatusEnum;
import com.ejianc.business.zdsmaterial.cons.enums.ClaimTypeEnum;
import com.ejianc.business.zdsmaterial.out.bean.OutStoreEntity;
import com.ejianc.business.zdsmaterial.out.bean.OutStoreSubEntity;
import com.ejianc.business.zdsmaterial.out.mapper.OutStoreMapper;
import com.ejianc.business.zdsmaterial.out.service.IOutStoreService;
import com.ejianc.business.zdsmaterial.out.vo.OutStoreSubVO;
import com.ejianc.business.zdsmaterial.out.vo.OutStoreVO;
import com.ejianc.business.zdsmaterial.out.vo.SupOutStoreSubVO;
import com.ejianc.business.zdsmaterial.out.vo.SupOutStoreVO;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubSignerEntity;
import com.ejianc.business.zdsmaterial.pick.service.IProPickSettingService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubContractorService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubSignerService;
import com.ejianc.business.zdsmaterial.pick.service.ISubsetMaterialService;
import com.ejianc.business.zdsstore.api.IStoreFlowApi;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import feign.Response;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="outStoreService")
public class OutStoreServiceImpl
extends BaseServiceImpl<OutStoreMapper, OutStoreEntity>
implements IOutStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String OPERATE = "ZDS_MATERIAL_OUT";
    private static final String BILL_TYPE = "EJCBT202312000011";
    private final String PUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/outRecord/saveOutStore";
    private final String DELPUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/outRecord/deleteOutStore";
    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/outRecord/supSignSync";
    private static final String BILL_CODE = "ZDS_MATERIAL_OUT";
    private static final String supSignFileSourceType = "stopMSupplier";
    private static final String BILL_NAME = "\u9886\u6599\u51fa\u5e93";
    private static final String noPower = "\u65e0\u6743\u9650\u8bbf\u95ee\u8be5\u670d\u52a1\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01";
    private static final String DEV_TEST_SUPPLIER_ID = "589112141802405909";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IStoreFlowApi storeFlowApi;
    @Autowired
    private ISubsetMaterialService subsetService;
    @Autowired
    private IProSubContractorService contractorService;
    @Autowired
    private IProSubSignerService signerService;
    @Autowired
    private IProPickSettingService settingService;

    @Override
    public CommonResponse<OutStoreVO> saveOrUpdate(OutStoreVO outStoreVO) {
        OutStoreEntity entity;
        CommonResponse orgResponse;
        List saveList = outStoreVO.getOutStoreSubList().stream().filter(x -> !"del".equals(x.getRowState())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(saveList)) {
            throw new BusinessException("\u6750\u6599\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.validateStoreNum(outStoreVO);
        this.validateOutNum(outStoreVO);
        if (StringUtils.isEmpty((CharSequence)outStoreVO.getParentOrgCode()) && outStoreVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(outStoreVO.getParentOrgId())).isSuccess()) {
            outStoreVO.setParentOrgCode(((OrgVO)orgResponse.getData()).getCode());
        }
        if (StringUtils.isEmpty((CharSequence)outStoreVO.getOrgCode()) && outStoreVO.getOrgId() != null && (orgResponse = this.iOrgApi.getOneById(outStoreVO.getOrgId())).isSuccess()) {
            outStoreVO.setOrgCode(((OrgVO)orgResponse.getData()).getCode());
        }
        if ((entity = (OutStoreEntity)((Object)BeanMapper.map((Object)outStoreVO, OutStoreEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)outStoreVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setSignStatus(0);
        entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        if (entity.getCreateUserId() == null) {
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(entity.getId()));
    }

    @Override
    public Boolean inOutStore(OutStoreEntity entity, Boolean outEffectiveON) {
        Map<Long, List<OutStoreSubEntity>> map = entity.getOutStoreSubList().stream().collect(Collectors.groupingBy(OutStoreSubEntity::getStoreId));
        if (map.values().stream().flatMap(Collection::stream).count() == 0L) {
            return true;
        }
        for (Long storeId : map.keySet()) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(storeId);
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u9886\u6599\u51fa\u5e93);
            storeManageVO.setOutEffectiveON(outEffectiveON);
            ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
            for (OutStoreSubEntity t : map.get(storeId)) {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u9886\u6599\u51fa\u5e93, (Integer)0);
                flowVO.setStoreId(t.getStoreId());
                flowVO.setStoreName(t.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setSupplierId(entity.getSubSupplierId());
                flowVO.setSupplierName(entity.getSubSupplierName());
                flowVO.setMaterialCategoryId(t.getMaterialTypeId());
                flowVO.setMaterialCategoryName(t.getMaterialTypeName());
                flowVO.setMaterialCategoryCode(t.getMaterialTypeCode());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialCode(t.getMaterialCode());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getPropertyValue());
                flowVO.setBrandId(t.getBrandId());
                flowVO.setBrandName(t.getBrandName());
                flowVO.setProductCode(t.getProductCode());
                flowVO.setMaterialUnitId(t.getUnitId());
                flowVO.setMaterialUnitName(t.getUnitName());
                flowVO.setSourceBillDetailRemark(t.getMemo());
                flowVO.setTaxRate(t.getTaxRate());
                flowVO.setTaxPrice(t.getTaxPrice());
                flowVO.setPrice(t.getPrice());
                flowVO.setNum(t.getNum());
                flowVO.setTaxMny(t.getTaxMoney());
                flowVO.setMny(t.getMoney());
                flowVO.setTax(t.getOutTax());
                flowVO.setUseFor(entity.getUseFor());
                flowVO.setSubEmployeeName(entity.getSubEmployeeName());
                flowVO.setPickUnitId(entity.getSubSupplierId());
                flowVO.setPickUnitName(entity.getSubSupplierName());
                flowVO.setPickContractId(entity.getSubContractId());
                flowVO.setPickContractName(entity.getSubContractName());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getOutDate());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceBillTypeCode(BILL_TYPE);
                flowVO.setSourceBillTypeName(BILL_NAME);
                flowVO.setSourceType(Integer.valueOf(1));
                flowVO.setSourceBillRemark(entity.getMemo());
                flowVO.setPickType(entity.getClaimType());
                flowVO.setPickTypeName(ClaimTypeEnum.getEnumByStateCode((Integer)entity.getClaimType()).getDescription());
                flowVOS.add(flowVO);
            }
            storeManageVO.setFlowVOList(flowVOS);
            this.logger.info("\u8c03\u7528\u5e93\u5b58\u53c2\u6570\uff1a\u2014\u2014\u2014\u2014" + JSONObject.toJSONString((Object)storeManageVO));
            CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
            if (response.isSuccess()) continue;
            throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
        }
        return true;
    }

    @Override
    public Boolean inOutStoreRollback(OutStoreEntity entity, Boolean outEffectiveON) {
        Map<Long, List<OutStoreSubEntity>> map = entity.getOutStoreSubList().stream().collect(Collectors.groupingBy(OutStoreSubEntity::getStoreId));
        for (Long storeId : map.keySet()) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(storeId);
            storeManageVO.setSourceIdsForRollBack(new ArrayList<Long>(Arrays.asList(entity.getId())));
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u9886\u6599\u51fa\u5e93);
            storeManageVO.setOutEffectiveON(outEffectiveON);
            this.logger.info("\u8c03\u7528\u5e93\u5b58\u53c2\u6570\uff1a\u2014\u2014\u2014\u2014" + JSONObject.toJSONString((Object)storeManageVO));
            CommonResponse response = this.storeManageApi.inOutStoreRollback(storeManageVO);
            if (response.isSuccess()) continue;
            throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
        }
        return true;
    }

    @Override
    public CommonResponse<String> del(List<OutStoreVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        super.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        OutStoreEntity outStoreEntity = (OutStoreEntity)((Object)super.selectById((Serializable)((Object)billId)));
        outStoreEntity.setSupOperateTime(supOperateTime);
        outStoreEntity.setSupOperatorName(supOperatorName);
        outStoreEntity.setSupOperatorPhone(supOperatorPhone);
        outStoreEntity.setSupOperatorUserCode(supOperatorUserCode);
        String key = "EJCBT202312000011::" + outStoreEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)BILL_CODE, (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)outStoreEntity.getId());
                this.releaseLock(jedis, false, key, BILL_CODE);
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, outStoreEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            outStoreEntity.setAttachIds(attchIdsList);
            outStoreEntity.setSignStatus(1);
            super.saveOrUpdate((Object)outStoreEntity, false);
            this.inOutStore(outStoreEntity, true);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)outStoreEntity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, BILL_CODE);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushBillToSupCenter(OutStoreEntity entity) {
        if (null != entity.getClaimType() && 2 == entity.getClaimType()) {
            return false;
        }
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = "EJCBT202312000011::" + entity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u8ba1\u91cf\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return false;
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)BILL_CODE, (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, BILL_CODE);
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            SupOutStoreVO supOutStoreVO = (SupOutStoreVO)BeanMapper.map((Object)((Object)entity), SupOutStoreVO.class);
            List subVOS = BeanMapper.mapList(entity.getOutStoreSubList(), SupOutStoreSubVO.class);
            supOutStoreVO.setOutStoreSubList(subVOS);
            paramMap.put("transData", JSONObject.toJSONString((Object)supOutStoreVO));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, null, null);
            HashMap files = new HashMap();
            if (fileResp.isSuccess()) {
                List fileList = (List)fileResp.getData();
                HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
            } else {
                this.logger.error("\u83b7\u53d6\u51fa\u5e93\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)entity.getId(), (Object)fileResp.getMsg());
            }
            this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)entity.getSubSupplierId(), (Object)JSONObject.toJSONString(paramMap));
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/outRecord/saveOutStore", paramMap, entity.getSubSupplierId().toString(), files);
            if (syncReqResp.isSuccess()) {
                CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                    syncFlag = true;
                } else {
                    this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{entity.getSubSupplierId(), entity.getId(), billPushResp.getMsg()});
                }
            } else {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{entity.getId(), entity.getSubSupplierId(), syncReqResp.getMsg()});
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u51fa\u5e93\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{entity.getId(), entity.getSubSupplierId(), e});
        }
        finally {
            this.releaseLock(jedis, locked, key, BILL_CODE);
        }
        return syncFlag;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CommonResponse<String> updatePushBill(OutStoreEntity entity) {
        locked = false;
        jedis = this.jedisPool.getResource();
        key = "EJCBT202312000011::" + entity.getId().toString();
        ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        entity.setSignStatus(0);
        ((OutStoreMapper)this.baseMapper).updateById((Object)entity);
        this.logger.info("\u4fee\u6539\u7b7e\u5b57\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)entity));
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"ZDS_MATERIAL_OUT", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "ZDS_MATERIAL_OUT");
                var6_6 = CommonResponse.error((String)"\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25!");
                return var6_6;
            }
            paramMap = new HashMap<String, String>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            this.logger.info("\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)entity.getSubSupplierId(), (Object)entity.getId());
            syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/outRecord/deleteOutStore", RequestMethod.POST, JSONObject.toJSONString(paramMap), entity.getSubSupplierId().toString());
            if (!syncReqResp.isSuccess()) ** GOTO lbl36
            supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
            if (supHandleResp.isSuccess()) {
                var9_11 = supHandleResp;
                return var9_11;
            }
            try {
                this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSubSupplierId(), entity.getId(), supHandleResp.getMsg()});
                throw new BusinessException(supHandleResp.getMsg());
lbl36:
                // 1 sources

                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSubSupplierId(), entity.getId(), syncReqResp.getMsg()});
                throw new BusinessException(syncReqResp.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
                throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
            }
        }
        finally {
            this.releaseLock(jedis, locked, key, "ZDS_MATERIAL_OUT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillConfirmState(OutStoreVO vo) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "EJCBT202312000011::" + vo.getId().toString() + "::sup";
        CommonResponse attachsResp = this.attachmentApi.queryListBySourceId(vo.getId(), BILL_TYPE, supSignFileSourceType, null);
        if (!attachsResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2id-{}\u5355\u636e\u7c7b\u578b-{}\u5f53\u524d\u7b7e\u5b57\u6587\u4ef6-{},\u4fe1\u606f\u5931\u8d25\uff0c {}", new Object[]{vo.getId(), BILL_TYPE, supSignFileSourceType, attachsResp.getMsg()});
            return "\u67e5\u8be2\u7b7e\u5b57\u6587\u4ef6\u4fe1\u606f\u5931\u8d25!";
        }
        AttachmentVO supSignFile = ((List)attachsResp.getData()).stream().findFirst().orElse(new AttachmentVO());
        CommonResponse userResp = this.userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if (!userResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u5f53\u524d\u7528\u6237id-{},\u4fe1\u606f\u5931\u8d25\uff0c {}", (Object)InvocationInfoProxy.getUserid(), (Object)userResp.getMsg());
            return "\u67e5\u8be2\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25!";
        }
        UserVO user = (UserVO)userResp.getData();
        this.logger.info("\u7528\u6237{}\u5bf9\u5355\u636eid-{}\u8fdb\u884c\u786e\u8ba4\u64cd\u4f5c\uff01", (Object)user.getUserName(), (Object)vo.getId());
        OutStoreEntity entity = (OutStoreEntity)((Object)super.selectById((Serializable)vo.getId()));
        this.validateStoreNum((OutStoreVO)BeanMapper.map((Object)((Object)entity), OutStoreVO.class));
        this.validateOutNum((OutStoreVO)BeanMapper.map((Object)((Object)entity), OutStoreVO.class));
        entity.setSupOperateTime(new Date());
        entity.setSupOperatorPhone(user.getUserMobile());
        entity.setSupOperatorName(user.getUserName());
        entity.setSupOperatorUserCode(user.getUserCode());
        entity.setSupOperateFileId(supSignFile.getId());
        entity.setConfirmState(vo.getConfirmState());
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)BILL_CODE, (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, BILL_CODE);
                String string = "\u5355\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01";
                return string;
            }
            Response fileResp = this.attachmentApi.downloadFileById(supSignFile.getId());
            HashMap<String, InputStream> signFile = new HashMap<String, InputStream>();
            HashMap<String, HashMap<String, InputStream>> files = new HashMap<String, HashMap<String, InputStream>>();
            HashMap<String, String> nameSourceTypeMapping = new HashMap<String, String>();
            if (supSignFile.getId() != null) {
                signFile.put(supSignFile.getFileName(), fileResp.body().asInputStream());
                files.put(supSignFile.getFileName(), signFile);
                nameSourceTypeMapping.put(supSignFile.getFileName(), supSignFile.getSourceType());
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("nameSourceTypeMapping", JSONObject.toJSONString(nameSourceTypeMapping));
            params.put("billId", entity.getSourceId());
            params.put("supOperatorName", entity.getSupOperatorName());
            params.put("supOperatorPhone", entity.getSupOperatorPhone());
            params.put("supOperatorUserCode", entity.getSupOperatorUserCode());
            params.put("supOperateTime", String.valueOf(entity.getSupOperateTime().getTime()));
            params.put("confirmState", entity.getConfirmState());
            this.logger.info("\u5355\u636e-{}id-{}\u5df2\u7b7e\u5b57\uff0c\u901a\u77e5\u5355\u636e\u63a8\u9001\u65b9systemId-{},\u53c2\u6570-{}", new Object[]{BILL_NAME, entity.getId(), entity.getSystemId(), JSONObject.toJSONString(params)});
            CommonResponse backResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_WITER_BACK_SERVER_URL, params, entity.getSubSupplierId().toString(), files);
            this.logger.error("\u5355\u636e-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)BILL_NAME, (Object)JSONObject.toJSONString((Object)backResp));
            if (!backResp.isSuccess()) {
                this.logger.error("\u5355\u636e-{}id-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", new Object[]{BILL_NAME, entity.getId(), backResp.getMsg()});
                String string = "\u9886\u6599\u51fa\u5e93\u786e\u8ba4\u4fe1\u606f\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u5931\u8d25";
                return string;
            }
            if (noPower.equals(backResp.getData())) {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42URL-{}\u7ed9\u7cfb\u7edf-{}\u5931\u8d25, {}", new Object[]{BILL_WITER_BACK_SERVER_URL, entity.getSystemId(), backResp.getData()});
                String string = (String)backResp.getData();
                return string;
            }
            CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)((String)backResp.getData()), CommonResponse.class);
            if (!operateResp.isSuccess()) {
                this.logger.error("\u5355\u636e-{}id-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u8c03\u5904\u7406\u5931\u8d25\uff0c{}", new Object[]{BILL_NAME, entity.getId(), operateResp.getMsg()});
                String string = "\u786e\u8ba4\u4fe1\u606f\u56de\u8c03\u5904\u7406\u5931\u8d25";
                return string;
            }
            super.saveOrUpdate((Object)entity, false);
            if ("1".equals(vo.getConfirmState())) {
                this.inOutStore(entity, true);
            } else if ("2".equals(vo.getConfirmState())) {
                this.inOutStoreRollback(entity, false);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636e-{}id-{}\u7b7e\u5b57\u5f02\u5e38\uff0c", new Object[]{BILL_NAME, entity.getId(), e});
            msg = "\u64cd\u4f5c\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, BILL_CODE);
        }
        return msg;
    }

    @Override
    public Map<Long, Boolean> queryConfirmEnable(List<Long> projectIds, List<Long> contractIds) {
        if (CollectionUtils.isEmpty(contractIds)) {
            return new HashMap<Long, Boolean>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("in", projectIds));
        List list = this.settingService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new HashMap<Long, Boolean>();
        }
        List settingIds = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam cparam = new QueryParam();
        cparam.getParams().put("settingId", new Parameter("in", settingIds));
        cparam.getParams().put("contractId", new Parameter("in", contractIds));
        List contList = this.contractorService.queryList(cparam);
        if (CollectionUtils.isEmpty((Collection)contList)) {
            return new HashMap<Long, Boolean>();
        }
        List ids = contList.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("in", contractIds));
        List userList = this.signerService.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)userList)) {
            return new HashMap<Long, Boolean>();
        }
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>();
        for (ProSubSignerEntity vo : userList) {
            if (!InvocationInfoProxy.getUserid().equals(vo.getSignEmpId())) continue;
            map.put(vo.getContractId(), true);
        }
        return map;
    }

    @Override
    public OutStoreVO queryDetail(Long id) {
        ArrayList<Long> contractIds;
        OutStoreEntity entity = (OutStoreEntity)((Object)super.selectById((Serializable)id));
        OutStoreVO vo = (OutStoreVO)BeanMapper.map((Object)((Object)entity), OutStoreVO.class);
        ArrayList<Long> projectIds = new ArrayList<Long>(Arrays.asList(vo.getProjectId()));
        Map<Long, Boolean> confirmMap = this.queryConfirmEnable(projectIds, contractIds = new ArrayList<Long>(Arrays.asList(vo.getSubContractId())));
        if (confirmMap.containsKey(vo.getSubContractId())) {
            vo.setConfirmEnable(confirmMap.get(vo.getSubContractId()));
        }
        if (BillStateEnum.COMMITED_STATE.equals((Object)entity.getBillState()) || BillStateEnum.PASSED_STATE.equals((Object)entity.getBillState())) {
            return vo;
        }
        Map<String, SurplusVO> storeMap = this.getStoreMap(vo);
        List detailList = vo.getOutStoreSubList();
        for (OutStoreSubVO detail : detailList) {
            String key = detail.getMaterialId() + "-" + detail.getBrandId();
            if (storeMap.containsKey(key)) {
                detail.setStoreNum(storeMap.get(key).getSurplusNum());
            } else {
                detail.setStoreNum(null);
            }
            detail.setStoreNum(ComputeUtil.safeAdd((BigDecimal)detail.getStoreNum(), (BigDecimal)detail.getNum()));
        }
        return vo;
    }

    private Map<String, SurplusVO> getStoreMap(OutStoreVO vo) {
        Map<Long, List<OutStoreSubVO>> map = vo.getOutStoreSubList().stream().filter(x -> x.getStoreId() != null).collect(Collectors.groupingBy(OutStoreSubVO::getStoreId));
        HashMap<String, SurplusVO> storeMap = new HashMap<String, SurplusVO>();
        if (map.values().stream().flatMap(Collection::stream).count() == 0L) {
            return storeMap;
        }
        for (Long storeId : map.keySet()) {
            ArrayList<SurplusVO> vos = new ArrayList<SurplusVO>();
            for (OutStoreSubVO t : map.get(storeId)) {
                SurplusVO surplusVO = new SurplusVO();
                surplusVO.setStoreId(t.getStoreId());
                surplusVO.setMaterialCategoryId(t.getMaterialTypeId());
                surplusVO.setMaterialId(t.getMaterialId());
                surplusVO.setBrandId(t.getBrandId());
                vos.add(surplusVO);
            }
            this.logger.info("\u8c03\u7528\u5e93\u5b58\u53c2\u6570\uff1a\u2014\u2014\u2014\u2014" + JSONObject.toJSONString(vos));
            CommonResponse response = this.storeFlowApi.getNewSurplusNum(vos);
            if (!response.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) continue;
            Map<String, SurplusVO> priceMap = ((List)response.getData()).stream().collect(Collectors.toMap(k -> k.getMaterialId() + "-" + k.getBrandId(), k -> k));
            storeMap.putAll(priceMap);
        }
        return storeMap;
    }

    @Override
    public Boolean validateStoreNum(OutStoreVO vo) {
        Map<String, SurplusVO> storeMap = this.getStoreMap(vo);
        List detailList = vo.getOutStoreSubList().stream().filter(x -> !"del".equals(x.getRowState())).collect(Collectors.toList());
        for (OutStoreSubVO detail : detailList) {
            String key = detail.getMaterialId() + "-" + detail.getBrandId();
            if (!storeMap.containsKey(key)) continue;
            detail.setStoreNum(storeMap.get(key).getSurplusNum());
            if (vo.getId() != null) {
                detail.setStoreNum(ComputeUtil.safeAdd((BigDecimal)detail.getStoreNum(), (BigDecimal)detail.getNum()));
            }
            if (!ComputeUtil.isLessThan((BigDecimal)detail.getStoreNum(), (BigDecimal)detail.getNum())) continue;
            throw new BusinessException("\u3010" + detail.getMaterialCode() + "\u3011\u51fa\u5e93\u6570\u91cf\u5c0f\u4e8e\u5e93\u5b58\u53ef\u7528\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u51fa\u5e93");
        }
        return true;
    }

    @Override
    public Boolean validateOutNum(OutStoreVO vo) {
        if (ClaimTypeEnum.\u5206\u5305\u9886\u6599.getCode().equals(vo.getClaimType())) {
            List detailList = vo.getOutStoreSubList().stream().filter(x -> !"del".equals(x.getRowState())).collect(Collectors.toList());
            List<Long> materialIds = detailList.stream().map(x -> x.getMaterialId()).collect(Collectors.toList());
            Map<Long, BigDecimal> numMap = this.subsetService.getNumMap(vo.getProjectId(), vo.getSubContractId(), materialIds);
            for (OutStoreSubVO detail : detailList) {
                if (!numMap.containsKey(detail.getMaterialId()) || !ComputeUtil.isGreaterThan((BigDecimal)detail.getNum(), (BigDecimal)numMap.get(detail.getMaterialId()))) continue;
                throw new BusinessException("\u3010" + detail.getMaterialCode() + "\u3011\u51fa\u5e93\u6570\u91cf\u5927\u4e8e\u9650\u989d\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u9886\u6599\u51fa\u5e93!");
            }
        }
        return true;
    }

    @Override
    public boolean saveOutStore(HttpServletRequest request) {
        List saveList;
        this.logger.info("\u8fdb\u5165\u9886\u6599\u51fa\u5e93\u4fdd\u5b58\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        this.logger.info("\u63a5\u6536\u5230\u6570\u636etransData\uff1a{}\uff0cnameSourceTypeMapping\uff1a{}", (Object)transData, (Object)nameSourceTypeMapping);
        OutStoreVO storeVO = (OutStoreVO)JSONObject.parseObject((String)transData, OutStoreVO.class);
        if (storeVO == null || storeVO.getId() == null) {
            throw new BusinessException("\u9886\u6599\u51fa\u5e93\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        OutStoreEntity checkEntity = (OutStoreEntity)((Object)super.selectById((Serializable)storeVO.getId()));
        if (checkEntity != null) {
            this.logger.info("\u5b58\u5728\u76f8\u540csourceID\u7684\u6570\u636e\uff0c\u539f\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)((Object)checkEntity)));
        }
        if (CollectionUtils.isEmpty(saveList = storeVO.getOutStoreSubList().stream().filter(x -> !"del".equals(x.getRowState())).collect(Collectors.toList()))) {
            throw new BusinessException("\u5904\u7f6e\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.validateStoreNum(storeVO);
        this.validateOutNum(storeVO);
        OutStoreEntity saveEntity = (OutStoreEntity)((Object)BeanMapper.map((Object)storeVO, OutStoreEntity.class));
        saveEntity.setTenantId(InvocationInfoProxy.getTenantid());
        saveEntity.setSourceId(String.valueOf(saveEntity.getId()));
        saveEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        saveEntity.setSignStatus(PlanConstant.SIGN_STATUS_NO);
        for (OutStoreSubEntity detail : saveEntity.getOutStoreSubList()) {
            detail.setSourceId(detail.getOutStoreId());
            detail.setSourceDetailId(detail.getId());
        }
        Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, null);
        ArrayList attchIdsList = new ArrayList();
        for (List attachIds : attachIdsMap.values()) {
            if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
            attchIdsList.addAll(attachIds);
        }
        saveEntity.setAttachIds(attchIdsList);
        boolean flag = super.saveOrUpdate((Object)saveEntity, false);
        this.inOutStore(saveEntity, false);
        this.logger.info("\u9886\u6599\u51fa\u5e93\u4fdd\u5b58\u63a5\u53e3\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    @Override
    public boolean delOutStore(OutStoreVO vo) {
        this.logger.info("\u8fdb\u5165\u9886\u6599\u51fa\u5e93\u5355\u64a4\u56de\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)vo));
        if (vo.getId() == null) {
            throw new BusinessException("\u9886\u6599\u51fa\u5e93\u5355\u4e0d\u5b58\u5728");
        }
        OutStoreEntity checkEntity = (OutStoreEntity)((Object)super.selectById((Serializable)vo.getId()));
        if (checkEntity == null) {
            throw new BusinessException("\u9886\u6599\u51fa\u5e93\u5355\u4e0d\u5b58\u5728");
        }
        if (vo.getSystemId() == null || !vo.getSystemId().equals(checkEntity.getSystemId())) {
            throw new BusinessException("\u7cfb\u7edf\u6765\u6e90\u4e0d\u5339\u914d");
        }
        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(checkEntity.getId(), BILL_TYPE, null, null);
        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)fileResp.getData()))) {
            this.logger.info("\u5220\u9664\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)fileResp.getData()));
            String ids = ((List)fileResp.getData()).stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
            this.attachmentApi.delete(ids);
        }
        this.inOutStoreRollback(checkEntity, false);
        boolean flag = ((OutStoreMapper)this.baseMapper).deleteOutStore(vo.getId());
        this.logger.info("\u9886\u6599\u51fa\u5e93\u5355\u64a4\u56de\u6210\u529f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    @Override
    public IPage<OutStoreVO> queryOutStoreList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("storeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = super.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutStoreVO.class));
        return pageData;
    }
}

