/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pick.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.pick.bean.ProPickSettingEntity;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubContractorEntity;
import com.ejianc.business.zdsmaterial.pick.service.IProPickSettingService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubContractorService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubPickerService;
import com.ejianc.business.zdsmaterial.pick.vo.ProPickSettingVO;
import com.ejianc.business.zdsmaterial.pick.vo.ProSubPickerVO;
import com.ejianc.business.zdssupplier.sub.api.ISubLinkerApi;
import com.ejianc.business.zdssupplier.sub.api.ISubSupplierApi;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"proPickSetting"})
public class ProPickSettingController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProSubPickerService pickerService;
    @Autowired
    private IProSubContractorService contractorService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProPickSettingService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISubLinkerApi subLinkerApi;
    @Autowired
    private ISubSupplierApi subSupplierApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProPickSettingVO> saveOrUpdate(@RequestBody ProPickSettingVO saveOrUpdateVO) {
        return this.service.saveOrUpdate(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProPickSettingVO> queryDetail(Long id) {
        ProPickSettingEntity entity = (ProPickSettingEntity)((Object)this.service.selectById(id));
        ProPickSettingVO vo = (ProPickSettingVO)BeanMapper.map((Object)((Object)entity), ProPickSettingVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/settingByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProPickSettingVO> settingByProjectId(Long projectId) {
        return this.service.settingByProjectId(projectId);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProPickSettingVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProPickSettingVO proPickSettingVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProPickSettingVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProPickSettingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProPickSetting-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProPickSettingData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProPickSettingVO>> refProPickSettingData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProPickSettingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refProSubPickerData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProSubPickerVO>> refProSubPickerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        List proSubContractorEntities;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        String supplierName = "";
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"supplierId")) {
                param.getParams().put("supplierId", new Parameter("eq", _con.get((Object)"supplierId")));
            }
            if (_con.containsKey((Object)"contractId")) {
                param.getParams().put("contractId", new Parameter("eq", _con.get((Object)"contractId")));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(proSubContractorEntities = this.contractorService.queryList(param, false)))) {
            supplierName = ((ProSubContractorEntity)((Object)proSubContractorEntities.get(0))).getSupplierName();
        }
        IPage page = this.pickerService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProSubPickerVO.class));
        }
        String finalSupplierName = supplierName;
        pageData.getRecords().forEach(item -> item.setSupplierName(finalSupplierName));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/queryContractIds"})
    @ResponseBody
    public CommonResponse<List<Long>> queryContractIds(@RequestBody JSONObject params) {
        Long supUserId = params.getLong("supUserId");
        Long supTenant = params.getLong("supTenant");
        if (null == supUserId) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u4f9b\u65b9\u7528\u6237id\u4e3a\u7a7a\uff01");
        }
        if (null == supTenant) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u4f9b\u65b9\u79df\u6237id\u4e3a\u7a7a\uff01");
        }
        Long supplierId = null;
        CommonResponse linkerResp = this.subLinkerApi.getSupUserIdAndTenant(supUserId, supTenant);
        if (!linkerResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u4f9b\u65b9\u79df\u6237Id-{},\u4f9b\u65b9\u7528\u6237id-{}\u67e5\u8be2\u5206\u5305\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25: {}!", new Object[]{supTenant, supUserId, JSONObject.toJSONString((Object)linkerResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat})});
            return CommonResponse.error((String)"\u67e5\u8be2\u5206\u5305\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25\uff01");
        }
        LinkerVO linker = (LinkerVO)linkerResp.getData();
        if (null == linker) {
            CommonResponse supplierResp = this.subSupplierApi.getByTenantId(supTenant);
            if (!supplierResp.isSuccess() || null == supplierResp.getData()) {
                this.logger.error("\u6839\u636e\u4f9b\u65b9\u79df\u6237Id-{}\u67e5\u8be2\u5206\u5305\u5546\u4fe1\u606f\u5931\u8d25: {}!", (Object)supTenant, (Object)JSONObject.toJSONString((Object)linkerResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                return CommonResponse.error((String)"\u67e5\u8be2\u5206\u5305\u5546\u4fe1\u606f\u5931\u8d25\uff01");
            }
            supplierId = ((SupplierVO)supplierResp.getData()).getId();
        } else {
            supplierId = linker.getSupplierId();
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("supplierId", supplierId);
        queryParams.put("supUserId", supUserId);
        if (null != linker) {
            queryParams.put("linkerId", linker.getId());
            queryParams.put("linkerSid", linker.getThirdSourceId());
        }
        return CommonResponse.success(this.service.queryContractIds(queryParams));
    }

    @RequestMapping(value={"/querySupByPhone"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProSubPickerVO> querySupByPhone(@RequestBody ProSubPickerVO proSubPickerVO) {
        return this.pickerService.querySupByPhone(proSubPickerVO);
    }

    @RequestMapping(value={"/checkSavePicker"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProSubPickerVO> checkSavePicker(@RequestBody ProSubPickerVO proSubPickerVO) {
        return this.pickerService.accCoordination(proSubPickerVO);
    }
}

