/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.control.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanDetailService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanImportService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanService;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanDetailVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"controlPlanDetail"})
public class ControlPlanDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IControlPlanService planService;
    @Autowired
    private IControlPlanDetailService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private IControlPlanImportService importService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ControlPlanDetailVO> saveOrUpdate(@RequestBody ControlPlanDetailVO saveOrUpdateVO) {
        ControlPlanDetailEntity entity = (ControlPlanDetailEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ControlPlanDetailEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        ControlPlanDetailVO vo = (ControlPlanDetailVO)BeanMapper.map((Object)((Object)entity), ControlPlanDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ControlPlanDetailVO> queryDetail(Long id) {
        ControlPlanDetailEntity entity = (ControlPlanDetailEntity)((Object)this.service.selectById(id));
        ControlPlanDetailVO vo = (ControlPlanDetailVO)BeanMapper.map((Object)((Object)entity), ControlPlanDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ControlPlanDetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ControlPlanDetailVO controlPlanDetailVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ControlPlanDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ControlPlanDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ControlPlanDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refControlPlanDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ControlPlanDetailVO>> refControlPlanDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ControlPlanDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"ControlPlan-material-import.xlsx", (String)"\u603b\u63a7\u8ba1\u5212\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @PostMapping(value={"/excelImport"})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        ArrayList<ControlPlanDetailVO> successList = new ArrayList<ControlPlanDetailVO>();
        ArrayList<ControlPlanDetailVO> errorList = new ArrayList<ControlPlanDetailVO>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            ControlPlanDetailVO vo = null;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                vo = new ControlPlanDetailVO();
                vo.setId(Long.valueOf(IdWorker.getId()));
                vo.setMaterialTypeName((String)datas.get(0));
                vo.setDescription((String)datas.get(1));
                vo.setNum(ComputeUtil.toBigDecimal((String)datas.get(2)));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    vo.setErrorMsg("\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setErrorMsg("\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setErrorMsg("\u603b\u63a7\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                vo.setSourceType(PlanConstant.SOURCE_TYPE_REF);
                vo.setHasNewPropertyVal(PlanConstant.INTEGER_NO);
                vo.setRowType(PlanConstant.ROW_TYPE_NEW);
                vo.setRowState("add");
                List<Object> matchList = new ArrayList();
                matchList = this.getMatchSameList(vo);
                if (!PlanConstant.MATCH_SAME.equals(vo.getMatchState())) {
                    matchList = this.getMatchHistoryList(vo);
                }
                if (!PlanConstant.MATCH_SAME.equals(vo.getMatchState()) && !PlanConstant.MATCH_HISTORY.equals(vo.getMatchState())) {
                    matchList = this.getMatchLikeList(vo);
                }
                vo.setMatchList(matchList);
                if (CollectionUtils.isEmpty(matchList)) {
                    QueryWrapper ew = new QueryWrapper();
                    ew.eq((Object)"enabled", (Object)1);
                    ew.eq((Object)"name", (Object)vo.getMaterialTypeName());
                    List list = this.categoryService.list((Wrapper)ew);
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        vo.setMatchState(PlanConstant.MATCH_LIKE);
                        MaterialCategoryEntity type = (MaterialCategoryEntity)((Object)list.get(0));
                        vo.setMaterialTypeId(type.getId());
                        vo.setMaterialTypeName(type.getName());
                        vo.setMaterialTypeCode(type.getCode());
                        successList.add(vo);
                        continue;
                    }
                    vo.setErrorMsg("\u672a\u67e5\u8be2\u5230\u5339\u914d\u4e14\u542f\u7528\u7684\u7269\u6599\u5206\u7c7b\uff01");
                    errorList.add(vo);
                    continue;
                }
                ControlPlanDetailVO match = (ControlPlanDetailVO)matchList.get(0);
                vo.setMaterialTypeId(match.getMaterialTypeId());
                vo.setMaterialTypeName(match.getMaterialTypeName());
                vo.setMaterialTypeCode(match.getMaterialTypeCode());
                vo.setMaterialId(match.getMaterialId());
                vo.setMaterialCode(match.getMaterialCode());
                vo.setMaterialName(match.getMaterialName());
                vo.setUnitId(match.getUnitId());
                vo.setUnitName(match.getUnitName());
                vo.setProductCode(match.getProductCode());
                vo.setPropertyValue(match.getPropertyValue());
                vo.setParentMaterialTypeId(match.getMaterialTypeId());
                vo.setParentMaterialTypeCode(match.getMaterialTypeCode());
                vo.setParentMaterialTypeName(match.getMaterialTypeName());
                successList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", (Object)successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    private List<ControlPlanDetailVO> getMatchSameList(ControlPlanDetailVO vo) {
        ArrayList<ControlPlanDetailVO> matchList = new ArrayList<ControlPlanDetailVO>();
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"enabled", (Object)1);
        ew.eq((Object)"category_name", (Object)vo.getMaterialTypeName());
        ew.and(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.eq((Object)"product_code", (Object)vo.getDescription())).or()).eq((Object)"property_show_name", (Object)vo.getDescription()));
        List list = this.materialService.list((Wrapper)ew);
        List<Long> materialTypeIds = list.stream().map(x -> x.getCategoryId()).distinct().collect(Collectors.toList());
        Map<Long, MaterialCategoryEntity> parentMap = this.planService.getParentMaterialTypeMap(materialTypeIds);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setMatchState(PlanConstant.MATCH_SAME);
            for (MaterialEntity material : list) {
                ControlPlanDetailVO match = new ControlPlanDetailVO();
                match.setId(material.getId());
                match.setMaterialTypeId(material.getCategoryId());
                match.setMaterialTypeName(material.getCategoryName());
                match.setMaterialTypeCode(material.getCategoryCode());
                match.setMaterialId(material.getId());
                match.setMaterialCode(material.getCode());
                match.setMaterialName(material.getName());
                match.setUnitId(material.getUnitId());
                match.setUnitName(material.getUnitName());
                match.setProductCode(material.getProductCode());
                match.setPropertyValue(material.getPropertyShowName());
                MaterialCategoryEntity parent = new MaterialCategoryEntity();
                if (parentMap.containsKey(material.getCategoryId())) {
                    parent = parentMap.get(material.getCategoryId());
                }
                match.setParentMaterialTypeId(parent.getId());
                match.setParentMaterialTypeCode(parent.getCode());
                match.setParentMaterialTypeName(parent.getName());
                match.setRowState("add");
                matchList.add(match);
            }
        }
        return matchList;
    }

    private List<ControlPlanDetailVO> getMatchHistoryList(ControlPlanDetailVO vo) {
        List<Object> matchList = new ArrayList<ControlPlanDetailVO>();
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"material_type_name", (Object)vo.getMaterialTypeName());
        ew.eq((Object)"description", (Object)vo.getDescription());
        List list = this.importService.list((Wrapper)ew);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setMatchState(PlanConstant.MATCH_HISTORY);
            matchList = BeanMapper.mapList((Iterable)list, ControlPlanDetailVO.class);
            for (ControlPlanDetailVO controlPlanDetailVO : matchList) {
                controlPlanDetailVO.setRowState("add");
            }
        }
        return matchList;
    }

    private List<ControlPlanDetailVO> getMatchLikeList(ControlPlanDetailVO vo) {
        ArrayList<ControlPlanDetailVO> matchList = new ArrayList<ControlPlanDetailVO>();
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"enabled", (Object)1);
        ew.eq((Object)"category_name", (Object)vo.getMaterialTypeName());
        ew.and(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.like((Object)"product_code", (Object)vo.getDescription())).or()).like((Object)"property_show_name", (Object)vo.getDescription()));
        List list = this.materialService.list((Wrapper)ew);
        List<Long> materialTypeIds = list.stream().map(x -> x.getCategoryId()).distinct().collect(Collectors.toList());
        Map<Long, MaterialCategoryEntity> parentMap = this.planService.getParentMaterialTypeMap(materialTypeIds);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setMatchState(PlanConstant.MATCH_LIKE);
            for (MaterialEntity material : list) {
                ControlPlanDetailVO match = new ControlPlanDetailVO();
                match.setId(material.getId());
                match.setMaterialTypeId(material.getCategoryId());
                match.setMaterialTypeName(material.getCategoryName());
                match.setMaterialTypeCode(material.getCategoryCode());
                match.setMaterialId(material.getId());
                match.setMaterialCode(material.getCode());
                match.setMaterialName(material.getName());
                match.setUnitId(material.getUnitId());
                match.setUnitName(material.getUnitName());
                match.setProductCode(material.getProductCode());
                match.setPropertyValue(material.getPropertyShowName());
                MaterialCategoryEntity parent = new MaterialCategoryEntity();
                if (parentMap.containsKey(material.getCategoryId())) {
                    parent = parentMap.get(material.getCategoryId());
                }
                match.setParentMaterialTypeId(parent.getId());
                match.setParentMaterialTypeCode(parent.getCode());
                match.setParentMaterialTypeName(parent.getName());
                match.setRowState("add");
                matchList.add(match);
            }
        }
        return matchList;
    }
}

