/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.invoice.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceEntity;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceService;
import com.ejianc.business.zdsmaterial.sub.invoice.bean.SubInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.sub.invoice.bean.SubInvoiceEntity;
import com.ejianc.business.zdsmaterial.sub.invoice.service.ISubInvoiceDetailService;
import com.ejianc.business.zdsmaterial.sub.invoice.service.ISubInvoiceService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subInvoice")
public class SubInvoiceBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ISubInvoiceService subInvoiceService;
    @Autowired
    private ISubInvoiceDetailService subInvoiceDetailService;
    @Autowired
    private IErpInvoiceService erpInvoiceService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return this.checkInvoiceState(billId);
    }

    private CommonResponse<String> checkInvoiceState(Long billId) {
        SubInvoiceEntity entity = (SubInvoiceEntity)((Object)this.subInvoiceService.selectById(billId));
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            LambdaUpdateWrapper update;
            List invIdList = entity.getDetailList().stream().map(SubInvoiceDetailEntity::getErpId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(ErpInvoiceEntity::getSourceId, invIdList);
            List invoiceEntities = this.erpInvoiceService.list((Wrapper)queryWrapper);
            List quoteList = invoiceEntities.stream().filter(item -> "1".equals(item.getErpQuoteFlag())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(quoteList)) {
                return CommonResponse.error((String)("\u64cd\u4f5c\u5931\u8d25\uff0c\u53f7\u7801\u4e3a[" + quoteList.stream().map(ErpInvoiceEntity::getNumber).collect(Collectors.joining(",")) + "]\u7684\u53d1\u7968\u5df2\u88ab\u5f15\u7528"));
            }
            HashSet<String> rightSet = new HashSet<String>();
            HashSet<String> errSet = new HashSet<String>();
            if (CollectionUtils.isNotEmpty((Collection)invoiceEntities)) {
                for (ErpInvoiceEntity invoiceEntity : invoiceEntities) {
                    if ("0".equals(invoiceEntity.getStatusCode())) {
                        rightSet.add(invoiceEntity.getSourceId());
                        continue;
                    }
                    errSet.add(invoiceEntity.getSourceId());
                }
            }
            for (String id : invIdList) {
                if (rightSet.contains(id)) continue;
                errSet.add(id);
            }
            if (CollectionUtils.isNotEmpty(rightSet)) {
                update = new LambdaUpdateWrapper();
                update.in(SubInvoiceDetailEntity::getErpId, new ArrayList(rightSet));
                update.set(SubInvoiceDetailEntity::getInvoiceState, (Object)"\u6b63\u5e38");
                this.subInvoiceDetailService.update((Wrapper)update);
            }
            if (CollectionUtils.isNotEmpty(errSet)) {
                update = new LambdaUpdateWrapper();
                update.in(SubInvoiceDetailEntity::getErpId, new ArrayList(errSet));
                update.set(SubInvoiceDetailEntity::getInvoiceState, (Object)"\u5f02\u5e38");
                this.subInvoiceDetailService.update((Wrapper)update);
                return CommonResponse.error((String)"\u8868\u4f53\u542b\u6709\u5f02\u5e38\u72b6\u6001\u7684\u53d1\u7968!");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)billId);
        updateWrapper.set(SubInvoiceEntity::getSignState, (Object)"0");
        this.subInvoiceService.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(state)) {
            return this.checkInvoiceState(billId);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.subInvoiceService.syncToErp(billId);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

