/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.settle.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleEntity;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleFileEntity;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleRecordEntity;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleTemplateEntity;
import com.ejianc.business.zdsmaterial.sub.settle.mapper.SubSettleMapper;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleFileService;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleRecordService;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleService;
import com.ejianc.business.zdsmaterial.sub.settle.utils.HttpTookit;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="subSettleService")
public class SubSettleServiceImpl
extends BaseServiceImpl<SubSettleMapper, SubSettleEntity>
implements ISubSettleService {
    private final String BILL_PUSH_PM_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/subSettle/subSettleSyncBill";
    private final String BILL_PUSH_PM_SERVER_APPROVE_URL = "/ejc-zdssupbusiness-web/openapi/subSettle/syncApproveStatus";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String OPERATE = "SubSettleBill";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IUserApi usersApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private static final String BILL_TYPE_CODE = "EJCBT202403000002";
    @Autowired
    private ISubSettleRecordService subSettleRecordService;
    @Autowired
    private ISubSettleFileService subSettleFileService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private SubSettleMapper mapper;
    @Value(value="${zds.erp.appId:859f0363d7dcc01cc4275a6cad2a0001}")
    private String appId;
    @Value(value="${zds.erp.secret:11658934fd26400985e1e9d83f6ac7cf}")
    private String secret;
    @Value(value="${zds.erp.reqHost:http://192.168.201.55:8001}")
    private String reqHost;
    private Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    @Autowired
    private EnvironmentTools environmentTools;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String pushSubSettleBill(SubSettleEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "SubSettleBill::" + entity.getId().toString() + "::sup";
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"SubSettleBill", (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, "SubSettleBill");
                String string = "\u5206\u5305\u7ed3\u7b97\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff0c\u52a0\u9501\u5931\u8d25\uff01";
                return string;
            }
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                this.logger.error("\u63a8\u9001\u5206\u5305\u7ed3\u7b97\u5355-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
                String string = "\u63a8\u9001\u5206\u5305\u7ed3\u7b97\u5355\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25";
                return string;
            }
            entity.setSourceSystemId((String)ejcCloudSystemCode.getData());
            HashMap<String, String> params = new HashMap<String, String>();
            HashMap<String, Integer> fileNames = new HashMap<String, Integer>();
            HashMap files = new HashMap();
            if (entity.getSubSettleTemplateList() != null && entity.getSubSettleTemplateList().size() > 0) {
                HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
                for (SubSettleTemplateEntity detail : entity.getSubSettleTemplateList()) {
                    CommonResponse fileResp = this.attachmentApi.queryListBySourceId(detail.getId(), null, null, null);
                    if (!fileResp.isSuccess()) continue;
                    List fileList = (List)fileResp.getData();
                    ArrayList<Long> fileIds = new ArrayList<Long>();
                    for (AttachmentVO attach : fileList) {
                        fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                        fileIds.add(attach.getId());
                        String filName = "";
                        if (fileNames.get(attach.getFileName()) != null) {
                            filName = attach.getFileName().replace(".", "(" + fileNames.get(attach.getFileName()) + ").");
                            fileNames.put(attach.getFileName(), (Integer)fileNames.get(attach.getFileName()) + 1);
                        } else {
                            filName = attach.getFileName();
                            fileNames.put(attach.getFileName(), 1);
                        }
                        detail.setAttachmentName(filName);
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)fileList)) continue;
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
                params.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
            }
            params.put("transData", JSONObject.toJSONString((Object)((Object)entity)));
            this.logger.info("\u5206\u5305\u7ed3\u7b97\u5355\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0: url-{}, \u5206\u5305\u7ed3\u7b97\u5355\uff1a{}", (Object)"/ejc-zdssupbusiness-web/openapi/subSettle/subSettleSyncBill", (Object)JSONObject.toJSONString((Object)((Object)entity)));
            CommonResponse writeBackResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/subSettle/subSettleSyncBill", params, entity.getSupplierId().toString(), files);
            this.logger.error("\u5206\u5305\u7ed3\u7b97\u5355\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)JSONObject.toJSONString((Object)writeBackResp));
            if (!writeBackResp.isSuccess()) {
                this.releaseLock(jedis, true, key, "SubSettleBill");
                this.logger.error("\u5206\u5305\u7ed3\u7b97\u5355id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)writeBackResp.getMsg());
                String string = "\u5206\u5305\u7ed3\u7b97\u5355\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                return string;
            }
            String operateRespStr = (String)writeBackResp.getData();
            CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                this.logger.error("\u5206\u5305\u7ed3\u7b97\u5355id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\uff0c\u5e73\u53f0\u5904\u7406\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)operateResp.getMsg());
                this.releaseLock(jedis, true, key, "SubSettleBill");
                String string = "\u5206\u5305\u7ed3\u7b97\u5355\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                return string;
            }
        }
        catch (Exception e) {
            this.logger.error("\u5206\u5305\u7ed3\u7b97\u5355id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u5206\u5305\u7ed3\u7b97\u5355\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "SubSettleBill");
        }
        return msg;
    }

    @Override
    @Transactional
    public CommonResponse<String> subSettleCommitSyncBill(HttpServletRequest request) {
        List attachmentVOS;
        Object msg = null;
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        this.logger.info("\u63a5\u6536\u5230\u540c\u6b65\u4f9b\u65b9\u5206\u5305\u7ed3\u7b97\u5355\u4fe1\u606f: {}, \u5f53\u524d\u4e0a\u4e0b\u6587: {}", (Object)transData, (Object)authority);
        if (StringUtils.isBlank((CharSequence)transData)) {
            return CommonResponse.error((String)"\u5355\u636e\u540c\u6b65\u5931\u8d25\uff0c\u5355\u636e\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        SubSettleEntity entity = (SubSettleEntity)((Object)JSONObject.parseObject((String)transData, SubSettleEntity.class));
        Long sourceId = Long.parseLong(entity.getSourceId());
        SubSettleEntity subSettleEntity = (SubSettleEntity)((Object)super.selectById((Serializable)sourceId));
        subSettleEntity.setSourceId(entity.getId().toString());
        subSettleEntity.setFillStatus(ZDSMaterialCommonEnums.\u586b\u62a5\u72b6\u6001_\u5df2\u4e0a\u4f20\u8d44\u6599.getCode());
        subSettleEntity.setSettleMny(entity.getSettleMny());
        super.updateById((Object)subSettleEntity);
        Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE_CODE, authority, entity.getId().toString());
        ArrayList attchIdsList = new ArrayList();
        for (List attachIds : attachIdsMap.values()) {
            if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
            attchIdsList.addAll(attachIds);
        }
        Map<Object, Object> collect = new HashMap();
        CommonResponse listCommonResponse = this.attachmentApi.queryListBySourceId(entity.getId(), null, null, null);
        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(attachmentVOS = (List)listCommonResponse.getData()))) {
            collect = attachmentVOS.stream().collect(Collectors.toMap(e -> e.getFileName(), e -> e.getId()));
        }
        entity.setAttachIds(attchIdsList);
        entity.setVersion(null);
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        entity.setSourceId(entity.getId().toString());
        Map<Object, Object> finalCollect = collect;
        entity.getSubSettleFileList().stream().forEach(detail -> {
            if (finalCollect.containsKey(detail.getAttachmentName())) {
                detail.setAttachmentId((Long)finalCollect.get(detail.getAttachmentName()));
            }
            detail.setCreateTime(null);
            detail.setUpdateTime(null);
            detail.setUpdateUserCode(null);
            detail.setCreateUserCode(null);
            detail.setCreateUserCode(null);
            detail.setVersion(null);
            detail.setId(null);
            detail.setSettleId(sourceId);
        });
        this.subSettleFileService.saveBatch(entity.getSubSettleFileList());
        SubSettleRecordEntity subSettleRecordEntity = new SubSettleRecordEntity();
        subSettleRecordEntity.setSettleStatus(ZDSMaterialCommonEnums.\u4e1a\u52a1\u73af\u8282_\u4f9b\u65b9\u4e0a\u4f20\u8d44\u6599.getCode());
        subSettleRecordEntity.setSettleId(subSettleEntity.getId());
        subSettleRecordEntity.setEmployeeId(entity.getSubLinkId());
        subSettleRecordEntity.setEmployeeName(entity.getSubLinkName());
        subSettleRecordEntity.setEmployeeCode(entity.getSubLinkCode());
        PushMsgParameter pushMsgParameter = new PushMsgParameter();
        String subject = "\u3010\u7ed3\u7b97\u7533\u8bf7\u3011\uff0c\u3010" + subSettleEntity.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u9700\u8981\u60a8\u5ba1\u6838\uff01";
        pushMsgParameter.setSubject(subject);
        String content = "\u3010" + subSettleEntity.getBillCode() + "\u3011\uff0c\u3010" + subSettleEntity.getProjectName() + "\u3011\uff0c\u3010" + subSettleEntity.getSubContractName() + "\u3011\uff0c\u3010" + subSettleEntity.getSupplierName() + "\u3011\u63d0\u4ea4\u4e86\u7ed3\u7b97\u7533\u8bf7\uff0c\u8bf7\u60a8\u5ba1\u6838\uff01";
        pushMsgParameter.setContent(content);
        pushMsgParameter.setPcUrl(this.baseHost + "ejc-zdsmaterial-frontend/#/preview/card?id=" + entity.getId().toString());
        String[] recId = new String[]{entity.getMatWorkerId().toString()};
        pushMsgParameter.setReceivers(recId);
        CommonResponse userByUserId = this.usersApi.findUserByUserId(entity.getMatWorkerId());
        if (!userByUserId.isSuccess()) {
            this.logger.info("\u67e5\u8be2\u91c7\u8d2d\u5de5\u7a0b\u5e08\u7f51\u7edc\u5f02\u5e38", (Object)userByUserId.getMsg());
            throw new BusinessException("\u67e5\u8be2\u91c7\u8d2d\u5de5\u7a0b\u5e08\u7f51\u7edc\u5f02\u5e38!");
        }
        UserVO data = (UserVO)userByUserId.getData();
        JSONObject params = new JSONObject();
        params.put("userEmails", (Object)data.getUserEmail());
        params.put("userNames", (Object)data.getUserName());
        pushMsgParameter.setZdsExtEmailParams(params);
        this.sendMsg(pushMsgParameter, entity.getId(), "\u7ed3\u7b97\u6307\u4ee4\u5355\u5411\u5206\u5305\u8054\u7cfb\u4eba\u53d1\u9001\u90ae\u4ef6");
        ArrayList<String> userId = new ArrayList<String>();
        userId.add(entity.getMatWorkerId().toString());
        this.sendTodo(userId, entity.getId().toString(), entity.getId().toString(), entity.getId().toString(), "\u5206\u5305\u7ed3\u7b97", entity.getMatWorkerId().toString(), this.baseHost + "ejc-zdsmaterial-frontend/#/preview/card?id=" + entity.getId().toString(), null, "\u5206\u5305\u65b9\u5df2\u4e0a\u4f20\u7ed3\u7b97\u5ba1\u6838\u8d44\u6599");
        return CommonResponse.success((String)"\u5355\u636e\u540c\u6b65\u6210\u529f\uff01", null);
    }

    public boolean sendTodo(List<String> userId, String billId, String taskId, String bpmId, String title, String startUserId, String formUrl, String maUrl, String taskName) {
        if (userId == null || userId.size() == 0) {
            this.logger.info("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a--------");
            return false;
        }
        try {
            this.logger.info("\u8c03\u7528\u4e2d\u7535\u56dbERP \u63a5\u53e3\uff1a\u53d1\u9001\u6d88\u606f\u63a5\u53e3start------------------");
            if (taskId.length() > 19) {
                taskId = taskId.substring(taskId.length() - 19, taskId.length());
            }
            String serverUrl = this.reqHost + "/cefoc/yql/getTaskTicket";
            String[] userIds = new String[userId.size()];
            JSONObject json = this.getUser(startUserId);
            String startUserCode = startUserId;
            String startUserName = startUserId;
            if (json != null) {
                startUserCode = json.get((Object)"code").toString();
                startUserName = json.get((Object)"name").toString();
            }
            JSONArray data = new JSONArray();
            formUrl = URLEncoder.encode(formUrl, "utf-8");
            CommonResponse userBack = this.usersApi.queryListByIds(userId.toArray(userIds));
            if (userBack.isSuccess()) {
                if (userBack.getData() != null && ((List)userBack.getData()).size() > 0) {
                    List userList = (List)userBack.getData();
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    for (UserVO userVO : userList) {
                        String modelId = billId + '-' + userVO.getUserCode() + "-" + taskId + "-" + bpmId;
                        this.logger.info("\u53d1\u9001\u4ee3\u529e\uff1a" + userVO.getUserName() + "-----------" + modelId);
                        String ApprovalURL = maUrl + "&userid=" + userVO.getId();
                        String jumpUrl = this.environmentTools.getBaseHost() + "portal/sso/index?usercode=" + userVO.getUserCode() + "&targeturl=" + formUrl;
                        JSONObject param = new JSONObject();
                        param.put("YQLTaskTicketOID", (Object)modelId);
                        param.put("InstanceID", (Object)modelId);
                        param.put("BusiField", (Object)title);
                        param.put("ProcessState", (Object)"\u5f85\u529e");
                        param.put("ProcessStateCode", (Object)"0");
                        param.put("ActivityChineseName", (Object)taskName);
                        param.put("Sys_Created", (Object)new Date());
                        param.put("Sys_LAST_UPD", (Object)new Date());
                        param.put("PersonName", (Object)userVO.getUserName());
                        param.put("PersonOID", (Object)userVO.getSourceId());
                        param.put("WorkCode", (Object)userVO.getUserCode());
                        param.put("ApprovalURL", (Object)ApprovalURL);
                        param.put("WebApprovalURL", (Object)jumpUrl);
                        param.put("OriginatorName", (Object)startUserName);
                        param.put("OriginatorCode", (Object)startUserCode);
                        param.put("OriginatorTime", (Object)new Date());
                        param.put("Idea", (Object)"");
                        param.put("IdeaCode", (Object)"0");
                        param.put("SYS_Deleted", (Object)0);
                        param.put("YQL_SID", (Object)modelId);
                        data.add((Object)param);
                    }
                } else {
                    this.logger.info("\u6839\u636eid\uff1a" + userId.toString() + "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u8be5\u7528\u6237\u6570\u636e");
                }
            } else {
                this.logger.info("\u6839\u636eid\uff1a" + userId.toString() + "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8c03\u7528\u63a5\u53e3userApi.queryListByIds\u5931\u8d25");
            }
            if (data != null && data.size() > 0) {
                this.logger.info("\u4f20\u9012\u7684\u53c2\u6570\uff1a---------------" + data.toJSONString());
                String paramterStr = this.gson.toJson((Object)data);
                Map<String, String> header = this.getErpHeaders();
                String result = HttpTookit.postByJson(serverUrl, paramterStr, header);
                this.logger.info(result);
                this.logger.info("\u53d1\u9001\u4ee3\u529e\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff01\uff01\uff01++++++++++++");
            }
            this.logger.info("\u8c03\u7528\u4e2d\u7535\u56dbERP \u63a5\u53e3\uff1a\u53d1\u9001\u6d88\u606f\u63a5\u53e3end------------------");
            return true;
        }
        catch (Exception e) {
            this.logger.info("\u9519\u8bef\uff1a{}", (Throwable)e);
            this.logger.info("\u8c03\u7528\u4e2d\u7535\u56dbERP \u63a5\u53e3\uff1a\u53d1\u9001\u6d88\u606f\u63a5\u53e3\u5931\u8d25\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
            return false;
        }
    }

    public Map<String, String> getErpHeaders() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        String nowStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        this.logger.info("-------------appId:{},secret:{}", (Object)this.appId, (Object)this.secret);
        headers.put("appid", this.toMD5(this.appId));
        headers.put("ticket", nowStr);
        headers.put("sign", this.toMD5(this.secret + this.toMD5(this.appId) + this.toMD5(nowStr)));
        return headers;
    }

    public JSONObject getUser(String userId) {
        try {
            JSONArray jArray;
            if (userId != null && (jArray = ReferObjectUtil.getReferEntityValue((String)userId, (String)"idm-user")) != null && jArray.size() > 0) {
                JSONObject json = (JSONObject)jArray.get(0);
                return json;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String toMD5(String plainText) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(plainText.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString().toLowerCase();
    }

    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{"email"});
        CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("{}-\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u5355\u636eId-{}\uff0c\u53d1\u9001\u90ae\u4ef6\u7ed3\u679c-{}", new Object[]{oprMsg, billId, JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        } else {
            this.logger.info("{}-\u53d1\u9001\u90ae\u4ef6\u6210\u529f\uff01", (Object)oprMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public String updateApproveStatus(Long id, Integer fillStatus, String rejectCause) {
        SubSettleEntity subSettleEntity = (SubSettleEntity)((Object)super.selectById((Serializable)id));
        subSettleEntity.setFillStatus(fillStatus);
        if (null != rejectCause) {
            subSettleEntity.setRejectCause(rejectCause);
        }
        if (fillStatus == 1) {
            List<SubSettleFileEntity> subSettleFileList = subSettleEntity.getSubSettleFileList();
            List collect = subSettleFileList.stream().map(SubSettleFileEntity::getAttachmentId).collect(Collectors.toList());
            List subFileListIds = subSettleFileList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            String ids = StringUtils.join((Object[])collect.toArray(), (String)",");
            this.attachmentApi.delete(ids);
            this.subSettleFileService.removeByIds(subFileListIds);
            subSettleEntity.setSettleMny(null);
        }
        super.updateById((Object)subSettleEntity);
        SubSettleRecordEntity subSettleRecordEntity = new SubSettleRecordEntity();
        if (fillStatus == 1) {
            subSettleRecordEntity.setSettleStatus(ZDSMaterialCommonEnums.\u4e1a\u52a1\u73af\u8282_\u9a73\u56de\u8d44\u6599.getCode());
        }
        if (fillStatus == 3) {
            subSettleRecordEntity.setSettleStatus(ZDSMaterialCommonEnums.\u4e1a\u52a1\u73af\u8282_\u540c\u610f\u63d0\u4ea4.getCode());
        }
        subSettleRecordEntity.setSettleId(id);
        UserContext userContextCache = this.sessionManager.getUserContext();
        subSettleRecordEntity.setEmployeeId(userContextCache.getUserId());
        subSettleRecordEntity.setEmployeeName(userContextCache.getUserName());
        subSettleRecordEntity.setEmployeeCode(userContextCache.getUserCode());
        this.subSettleRecordService.save((Object)subSettleRecordEntity);
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "SubSettleBill::" + subSettleEntity.getId().toString() + "::sup";
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"SubSettleBill", (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, "SubSettleBill");
                String string = "\u5206\u5305\u7ed3\u7b97\u72b6\u6001\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff0c\u52a0\u9501\u5931\u8d25\uff01";
                return string;
            }
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                this.logger.error("\u63a8\u9001\u5206\u5305\u7ed3\u7b97\u5355-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)subSettleEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
                String string = "\u63a8\u9001\u5206\u5305\u7ed3\u7b97\u5355\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25";
                return string;
            }
            subSettleEntity.setSourceSystemId((String)ejcCloudSystemCode.getData());
            HashMap<String, String> params = new HashMap<String, String>();
            HashMap files = new HashMap();
            params.put("transData", JSONObject.toJSONString((Object)((Object)subSettleEntity)));
            this.logger.info("\u5206\u5305\u7ed3\u7b97\u5355\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0: url-{}, \u5206\u5305\u7ed3\u7b97\u5355\uff1a{}", (Object)"/ejc-zdssupbusiness-web/openapi/subSettle/syncApproveStatus", (Object)JSONObject.toJSONString((Object)((Object)subSettleEntity)));
            CommonResponse writeBackResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/subSettle/syncApproveStatus", params, subSettleEntity.getSupplierId().toString(), null);
            this.logger.error("\u5206\u5305\u7ed3\u7b97\u5355\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)JSONObject.toJSONString((Object)writeBackResp));
            if (!writeBackResp.isSuccess()) {
                this.releaseLock(jedis, true, key, "SubSettleBill");
                this.logger.error("\u5206\u5305\u7ed3\u7b97\u5355id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", (Object)subSettleEntity.getId(), (Object)writeBackResp.getMsg());
                String string = "\u5206\u5305\u7ed3\u7b97\u5355\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                return string;
            }
            String operateRespStr = (String)writeBackResp.getData();
            CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                this.logger.error("\u5206\u5305\u7ed3\u7b97\u5355id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\uff0c\u5e73\u53f0\u5904\u7406\u5931\u8d25\uff0c{}", (Object)subSettleEntity.getId(), (Object)operateResp.getMsg());
                this.releaseLock(jedis, true, key, "SubSettleBill");
                String string = "\u5206\u5305\u7ed3\u7b97\u5355\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                return string;
            }
        }
        catch (Exception e) {
            this.logger.error("\u5206\u5305\u7ed3\u7b97\u5355id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff0c", (Object)subSettleEntity.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u5206\u5305\u7ed3\u7b97\u5355\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "SubSettleBill");
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public int pageCount(Map<String, Object> queryParam) {
        return this.mapper.pageCount(queryParam);
    }

    @Override
    public List<JSONObject> pageList(Map<String, Object> queryParam) {
        return this.mapper.pageList(queryParam);
    }
}

