/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.accept.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.accept.AcceptVO;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.accept.service.IAcceptService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"accept"})
public class AcceptController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZDS-ACC";
    @Autowired
    private IAcceptService service;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_TYPE_CODE = "EJCBT202312000001";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AcceptVO> saveOrUpdate(@RequestBody AcceptVO saveOrUpdateVO) {
        AcceptVO acceptVO = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)acceptVO);
    }

    @RequestMapping(value={"/updateCloeState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AcceptVO> updateCloeState(@RequestBody AcceptVO saveOrUpdateVO) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"close_delivery", (Object)saveOrUpdateVO.getCloseDelivery());
        updateWrapper.eq((Object)"id", (Object)saveOrUpdateVO.getId());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AcceptVO> queryDetail(Long id) {
        AcceptEntity entity = (AcceptEntity)((Object)this.service.selectById(id));
        AcceptVO vo = (AcceptVO)BeanMapper.map((Object)((Object)entity), AcceptVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/pushSubAccept"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AcceptVO> pushSubAccept(Long id) {
        AcceptEntity entity = (AcceptEntity)((Object)this.service.selectById(id));
        String s = this.service.pushSubAccept(entity);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            throw new BusinessException(s);
        }
        AcceptVO vo = (AcceptVO)BeanMapper.map((Object)((Object)entity), AcceptVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AcceptVO> vos) {
        this.service.delete(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AcceptVO>> queryList(@RequestBody QueryParam param) {
        Page pageData;
        IPage page;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("carCode");
        fuzzyFields.add("supplierName");
        if (param.getParams().containsKey("queryCoverage")) {
            if ("1".equals(((Parameter)param.getParams().get("queryCoverage")).getValue())) {
                param.getParams().put("siteAcceptorId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
            }
            param.getParams().remove("queryCoverage");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            List orgVOList = null;
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(page = this.service.queryPage(param, false)).getRecords())) {
            pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            List acceptVOS = BeanMapper.mapList((Iterable)page.getRecords(), AcceptVO.class);
            Iterator iterator = acceptVOS.iterator();
            while (iterator.hasNext()) {
                AcceptVO vo;
                vo.setAcceptTypeStr((vo = (AcceptVO)iterator.next()).getAcceptType() == 1 ? "\u76f4\u5165\u76f4\u51fa" : "\u6b63\u5e38\u9a8c\u6536");
                if (vo.getStoreType() == 1) {
                    vo.setStoreTypeStr("\u4e3b\u6750\u5e93");
                } else if (vo.getStoreType() == 2) {
                    vo.setStoreTypeStr("\u4e34\u5efa\u6750\u6599");
                } else {
                    vo.setStoreTypeStr("\u7532\u4f9b\u6750");
                }
                if (vo.getSourceType() == 1) {
                    vo.setSourceTypeStr("\u81ea\u5236");
                } else if (vo.getSourceType() == 2) {
                    vo.setSourceTypeStr("\u5176\u4ed6\u9a8c\u6536");
                } else {
                    vo.setSourceTypeStr("\u53d1\u8d27\u5355");
                }
                if (vo.getSourceType() == 0 || vo.getSourceType() == 1) {
                    vo.setSignatureStatusStr(vo.getSignatureStatus() == 1 ? "\u5df2\u7b7e\u5b57" : "\u672a\u7b7e\u5b57");
                }
                if (vo.getAcceptType() == 1) {
                    if (null != vo.getSubSignatureStatus()) {
                        vo.setSubSignatureStatusStr(vo.getSubSignatureStatus() == 1 ? "\u5df2\u7b7e\u5b57" : "\u672a\u7b7e\u5b57");
                    } else {
                        vo.setSubSignatureStatusStr("\u672a\u7b7e\u5b57");
                    }
                }
                if (null != vo.getMaterialSignatureStatus()) {
                    vo.setMaterialSignatureStatusStr(vo.getMaterialSignatureStatus() == 1 ? "\u5df2\u7b7e\u5b57" : "\u672a\u7b7e\u5b57");
                    continue;
                }
                vo.setMaterialSignatureStatusStr("\u672a\u7b7e\u5b57");
            }
            pageData.setRecords(acceptVOS);
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(null);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List records = new ArrayList();
        CommonResponse<IPage<AcceptVO>> iPageCommonResponse = this.queryList(param);
        if (iPageCommonResponse.isSuccess()) {
            records = ((IPage)iPageCommonResponse.getData()).getRecords();
        }
        HashMap beans = new HashMap();
        records.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        beans.put("records", records);
        if (records.size() > 0) {
            Integer sourceType = ((AcceptVO)records.get(0)).getSourceType();
            if (sourceType == 2) {
                ExcelExport.getInstance().export("Accept-other-export.xlsx", beans, response);
            } else {
                ExcelExport.getInstance().export("Accept-export.xlsx", beans, response);
            }
        }
    }

    @RequestMapping(value={"/refAcceptData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AcceptVO>> refAcceptData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AcceptVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"pushAccept"})
    public CommonResponse<String> pushAccept(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        this.logger.info("\u63a5\u6536\u5230\u63a8\u9001\u9a8c\u6536\u5355\u636e: {}, \u5f53\u524d\u4e0a\u4e0b\u6587: {}", (Object)transData, (Object)authority);
        if (StringUtils.isBlank((CharSequence)transData)) {
            return CommonResponse.error((String)"\u5355\u636e\u540c\u6b65\u5931\u8d25\uff0c\u5355\u636e\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        Long acceptId = (Long)JSONObject.parseObject((String)transData, Long.class);
        Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE_CODE, authority, null);
        this.service.updateSignatureStatus(acceptId);
        return CommonResponse.success((String)"\u5355\u636e\u540c\u6b65\u6210\u529f\uff01");
    }

    @PostMapping(value={"supSignSync"})
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String s = this.service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            return CommonResponse.error((String)s);
        }
        return CommonResponse.success((String)"\u5355\u636e\u540c\u6b65\u6210\u529f\uff01");
    }
}

