/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.cloudstore.order.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.cloudstore.apply.vo.AllotApplyDetailVO;
import com.ejianc.business.zdsmaterial.cloudstore.apply.vo.AllotApplyVO;
import com.ejianc.business.zdsmaterial.cloudstore.constants.AllotOrderBusinessStatusEnums;
import com.ejianc.business.zdsmaterial.cloudstore.constants.CommonConstants;
import com.ejianc.business.zdsmaterial.cloudstore.order.bean.AllotOrderDetailEntity;
import com.ejianc.business.zdsmaterial.cloudstore.order.bean.AllotOrderEntity;
import com.ejianc.business.zdsmaterial.cloudstore.order.mapper.AllotOrderMapper;
import com.ejianc.business.zdsmaterial.cloudstore.order.service.IAllotOrderDetailService;
import com.ejianc.business.zdsmaterial.cloudstore.order.service.IAllotOrderService;
import com.ejianc.business.zdsmaterial.cloudstore.order.vo.AllotOrderVO;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.bean.GoodsEntity;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IGoodsService;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.GoodsVO;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsstore.api.IIdleManageApi;
import com.ejianc.business.zdsstore.api.IStoreFlowApi;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.IdleFlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.seata.spring.annotation.GlobalTransactional;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="allotOrderService")
public class AllotOrderServiceImpl
extends BaseServiceImpl<AllotOrderMapper, AllotOrderEntity>
implements IAllotOrderService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ALLOT_ORDER";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private AllotOrderMapper mapper;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IAllotOrderDetailService detailService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private IStoreFlowApi storeFlowApi;
    @Autowired
    private IIdleManageApi iIdleManageApi;
    @Autowired
    private IMaterialCategoryService categoryService;

    @Override
    public void saveNewOrderByApply(AllotApplyVO allotApplyVO) {
        ArrayList<AllotOrderEntity> newOrderList = new ArrayList<AllotOrderEntity>();
        ArrayList<AllotOrderDetailEntity> newOrderDetailList = new ArrayList<AllotOrderDetailEntity>();
        Map applyDetailMap = allotApplyVO.getDetailList().stream().collect(Collectors.groupingBy(AllotApplyDetailVO::getExceedOrgId, Collectors.toList()));
        List<Long> shelfDetailIds = allotApplyVO.getDetailList().stream().map(AllotApplyDetailVO::getSourceId).collect(Collectors.toList());
        List<GoodsEntity> goods = this.goodsService.getAllByIds(shelfDetailIds);
        Map<Long, GoodsEntity> shelfDetailMap = goods.stream().collect(Collectors.toMap(BaseEntity::getId, item -> item));
        AllotOrderEntity tmp = null;
        for (Long outOrgId : applyDetailMap.keySet()) {
            tmp = this.generateOrderByApply(allotApplyVO, applyDetailMap.get(outOrgId), shelfDetailMap);
            newOrderDetailList.addAll(tmp.getAllotOrderDetailList());
            newOrderList.add(tmp);
        }
        this.detailService.saveOrUpdateBatch(newOrderDetailList, newOrderDetailList.size(), false);
        super.saveOrUpdateBatch(newOrderList, newOrderList.size(), false);
        List<Long> projectIdS = newOrderList.stream().map(AllotOrderEntity::getOutProjectId).collect(Collectors.toList());
        Map<Long, Long> projectManagerIdS = this.getProjectManagerIdS(projectIdS);
        List<Long> categoryIds = newOrderDetailList.stream().map(AllotOrderDetailEntity::getMaterialTypeId).collect(Collectors.toList());
        List<MaterialCategoryVO> categtoryVOs = this.categoryService.queryCategoryListByChildren(categoryIds);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (AllotOrderEntity order : newOrderList) {
            Long projectManagerId = null;
            ArrayList<String> userIds = new ArrayList<String>();
            if (null != order.getOutProjectId() && projectManagerIdS.containsKey(order.getOutProjectId())) {
                projectManagerId = projectManagerIdS.get(order.getOutProjectId());
            }
            for (AllotOrderDetailEntity detail : order.getAllotOrderDetailList()) {
                if (userIds.contains(detail.getSellUserId().toString())) continue;
                userIds.add(detail.getSellUserId().toString());
            }
            PushMsgParameter parameter = new PushMsgParameter();
            StringBuilder content = new StringBuilder();
            content.append("\u3010").append(order.getBillCode()).append("\u3011");
            if (StringUtils.isNotEmpty((CharSequence)order.getCategoryNames())) {
                content.append("\uff0c\u3010").append(order.getCategoryNames()).append("\u3011");
            }
            content.append("\u5df2\u88ab\u3010").append(order.getInProjectName()).append("\u3011\u4e0b\u5355\u8c03\u8d27\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
            parameter.setContent(content.toString());
            parameter.setPcUrl(this.BASE_HOST + (null == order.getOutProjectId() ? CommonConstants.\u5927\u533a\u8c03\u51fa\u8ba2\u5355PC\u8be6\u60c5 : CommonConstants.\u4e91\u4ed3\u8c03\u51fa\u8ba2\u5355PC\u8be6\u60c5) + order.getId().toString());
            parameter.setSubject("\u3010\u7269\u8d44\u8c03\u62e8\u3011\uff0c\u3010" + order.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u95f2\u7f6e\u7269\u8d44\u88ab\u4e0b\u5355\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
            if (null != projectManagerId) {
                userIds.add(projectManagerId.toString());
            }
            String[] longs = userIds.toArray(new String[userIds.size()]);
            parameter.setReceivers(longs);
            this.sendMsg(parameter, order.getId(), "\u8c03\u62e8\u7533\u8bf7\u751f\u6548 \u5411\u9879\u76ee\u7ecf\u7406\u3001\u7269\u8d44\u53d1\u5e03\u4eba\u53d1\u9001\u6d88\u606f");
        }
    }

    @Override
    public void deleteOrderByApply(Long allotApplyId) {
        this.logger.info("\u6839\u636e\u8c03\u62e8\u5355Id-{}\u5220\u9664\u5bf9\u5e94\u8ba2\u5355\u4fe1\u606f", (Object)allotApplyId);
        QueryWrapper countQuery = new QueryWrapper();
        countQuery.eq((Object)"allot_apply_id", (Object)allotApplyId);
        countQuery.and(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.gt((Object)"business_status", (Object)AllotOrderBusinessStatusEnums.\u8c03\u5165\u65b9\u6d3d\u5546\u5df2\u786e\u8ba4.getCode())).or()).gt((Object)"edit_num", (Object)0));
        int count = super.count((Wrapper)countQuery);
        if (count > 0) {
            throw new BusinessException("\u8c03\u62e8\u8ba2\u5355\u5df2\u88ab\u4e0b\u6e38\u5f15\u7528");
        }
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"id"});
        query.eq((Object)"allot_apply_id", (Object)allotApplyId);
        List orderIds = super.listObjs((Wrapper)query, item -> Long.valueOf(item.toString()));
        super.removeByIds((Collection)orderIds);
    }

    @Override
    public void checkAllotableNum(List<AllotOrderDetailEntity> allotOrderDetailList) {
        Map<Long, BigDecimal> goodsAllotableNumMap = this.goodsService.getAllotableNum(allotOrderDetailList.stream().map(item -> item.getSourceId()).collect(Collectors.toList()));
        StringBuilder sp = new StringBuilder();
        for (AllotOrderDetailEntity detail : allotOrderDetailList) {
            if (detail.getAllotNum().compareTo(ComputeUtil.safeAdd((BigDecimal)goodsAllotableNumMap.get(detail.getSourceId()), (BigDecimal)detail.getInitialAllotNum())) <= 0) continue;
            sp.append("\u7f16\u7801\uff1a").append(detail.getMaterialCode()).append("-").append("\u54c1\u724c\uff1a").append(detail.getBrandName()).append("\u3001");
        }
        if (sp.length() > 0) {
            throw new BusinessException("\u7269\u8d44" + sp.substring(0, sp.length() - 1) + "\u8c03\u62e8\u91cf\u8d85\u51fa\u53ef\u4e0b\u5355\u91cf");
        }
    }

    @Override
    public AllotOrderVO saveEditAllotOrderInfo(AllotOrderEntity entity) {
        this.checkAllotableNum(entity.getAllotOrderDetailList());
        this.goodsService.updateAllotNum(this.getUpdateGoodList(entity.getAllotOrderDetailList(), "update", "allot"), true);
        entity.setEditNum(entity.getEditNum() + 1);
        entity.setEditUserId(InvocationInfoProxy.getUserid());
        entity.setEditUserName(this.sessionManager.getUserContext().getUserName());
        entity.setBusinessStatus(AllotOrderBusinessStatusEnums.\u8c03\u5165\u65b9\u6d3d\u5546\u5f85\u786e\u8ba4.getCode());
        super.saveOrUpdate((Object)entity, false);
        Long inProjetMgid = this.getProjectManagerId(entity.getInProjectId());
        ArrayList<String> recIds = new ArrayList<String>();
        if (null != inProjetMgid) {
            recIds.add(inProjetMgid.toString());
        }
        recIds.add(entity.getPurUserId().toString());
        StringBuilder content = new StringBuilder();
        content.append("\u60a8\u8ba2\u8d2d\u7684\u7269\u8d44\u3010").append(entity.getStoreType() == 1 ? "\u8c03\u51fa\u9879\u76ee\uff1a" + entity.getOutProjectName() : "\u8c03\u51fa\u5355\u4f4d" + entity.getOutParentOrgName()).append("\uff0c\u7269\u8d44\u5206\u7c7b\uff1a").append(entity.getCategoryNames()).append("\u3011\u8c03\u51fa\u65b9\u5df2\u4fee\u6539\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u5c3d\u5feb\u786e\u8ba4\u3002");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(recIds.toArray(new String[recIds.size()]));
        parameter.setPcUrl(this.BASE_HOST + CommonConstants.\u8c03\u5165\u8ba2\u5355PC\u8be6\u60c5 + entity.getId().toString());
        parameter.setSubject("\u3010\u8c03\u5165\u8ba2\u5355\u3011\u3010" + entity.getBillCode() + "\u3011\u3010" + sdf.format(entity.getCreateTime()) + "\u3011");
        parameter.setContent(content.toString());
        parameter.setSubject(parameter.getContent());
        this.sendMsg(parameter, entity.getId(), "\u8c03\u51fa\u65b9\u4fee\u6539\uff0c\u5411\u8c03\u5165\u65b9\u9884\u8ba2\u4eba");
        return (AllotOrderVO)BeanMapper.map((Object)((Object)entity), AllotOrderVO.class);
    }

    @Override
    public List<GoodsVO> getUpdateGoodList(List<AllotOrderDetailEntity> allotOrderDetailList, String oprType, String allotType) {
        ArrayList<GoodsVO> resp = new ArrayList<GoodsVO>();
        allotOrderDetailList.stream().forEach(detail -> {
            GoodsVO g = new GoodsVO();
            g.setId(detail.getSourceId());
            if ("alloted".equals(allotType)) {
                g.setAllotedNum(detail.getAllotNum());
            } else if ("update".equals(oprType)) {
                g.setAllotNum(ComputeUtil.safeSub((BigDecimal)detail.getAllotNum(), (BigDecimal)detail.getInitialAllotNum()));
            } else {
                g.setAllotNum(detail.getAllotNum());
            }
            resp.add(g);
        });
        return resp;
    }

    @Override
    public void sendMsg(PushMsgParameter parameter, Long allotOrderId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{"sys", "email"});
        CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("\u8c03\u62e8\u8ba2\u5355id-{},{}\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c{}", new Object[]{allotOrderId, oprMsg, JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        } else {
            this.logger.info("\u8c03\u62e8\u8ba2\u5355id-{},{}\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01", (Object)allotOrderId, (Object)oprMsg);
        }
    }

    public void sendEmail(PushMsgParameter parameter, Long allotOrderId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{"email"});
        CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("\u8c03\u62e8\u8ba2\u5355id-{},{}\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c{}", new Object[]{allotOrderId, oprMsg, JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        } else {
            this.logger.info("\u8c03\u62e8\u8ba2\u5355id-{},{}\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01", (Object)allotOrderId, (Object)oprMsg);
        }
    }

    @Override
    @GlobalTransactional(name="AllotOrderServiceImpl_saveOrderInStore", rollbackFor={Exception.class})
    public AllotOrderVO saveOrderInStore(AllotOrderEntity entity) {
        List detailList = entity.getAllotOrderDetailList().stream().filter(item -> null == item.getInStoreId()).collect(Collectors.toList());
        if (detailList.size() > 0) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u5b58\u5728\u7269\u8d44\u672a\u8bbe\u7f6e\u5165\u5e93\u4ed3\u5e93\uff01");
        }
        this.goodsService.updateAllotNum(this.getUpdateGoodList(entity.getAllotOrderDetailList(), "release", "allot"), false);
        this.goodsService.updateAllotedNum(this.getUpdateGoodList(entity.getAllotOrderDetailList(), "release", "alloted"), true);
        entity.setBusinessStatus(AllotOrderBusinessStatusEnums.\u4ea4\u6613\u5b8c\u6210.getCode());
        super.saveOrUpdate((Object)entity, false);
        this.sendInStoreData(entity);
        this.logger.info("\u8c03\u62e8\u8ba2\u5355-{}\u751f\u6210\u8c03\u5165\u65b9\u8c03\u5165\u6d41\u6c34\u6210\u529f\uff01", (Object)entity.getId());
        StringBuilder content = new StringBuilder();
        StringBuilder subject = new StringBuilder();
        subject.append("\u3010\u7269\u8d44\u8c03\u62e8\u3011\uff0c\u3010").append(entity.getBillCode()).append("\u3011").append("\uff0c\u3010").append(entity.getBillCode()).append("\u3011\uff0c\u3010").append(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date())).append("\u3011\u8ba2\u5355\u5b8c\u6210\u4ea4\u6613\uff01");
        content.append("\u3010").append(entity.getBillCode()).append("\u3011\uff0c\u8c03\u5165\u9879\u76ee\u3010").append(entity.getInProjectName()).append("\u3011\uff0c\u5df2\u5b8c\u6210\u4ea4\u6613\uff0c\u5e76\u6536\u8d27\u5165\u5e93\uff01");
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(new String[]{entity.getPurUserId().toString()});
        parameter.setPcUrl(this.BASE_HOST + (entity.getStoreType() == 1 ? CommonConstants.\u4e91\u4ed3\u8c03\u51fa\u8ba2\u5355PC\u8be6\u60c5 : CommonConstants.\u5927\u533a\u8c03\u51fa\u8ba2\u5355PC\u8be6\u60c5) + entity.getId().toString());
        parameter.setContent(content.toString());
        parameter.setSubject(parameter.getContent());
        this.sendMsg(parameter, entity.getId(), "\u8c03\u5165\u65b9\u6536\u8d27\u5165\u5e93\u5b8c\u6210\uff0c\u5411\u8c03\u5165\u65b9\u8054\u7cfb\u4eba");
        return (AllotOrderVO)BeanMapper.map((Object)((Object)entity), AllotOrderVO.class);
    }

    @Override
    public AllotOrderVO saveOrderInStoreEdit(AllotOrderEntity entity) {
        super.saveOrUpdate((Object)entity, false);
        return (AllotOrderVO)BeanMapper.map((Object)((Object)entity), AllotOrderVO.class);
    }

    @Override
    @GlobalTransactional(name="AllotOrderServiceImpl_saveOrderOutStore", rollbackFor={Exception.class})
    public void saveOrderOutStore(AllotOrderEntity entity) {
        this.sendOutStoreData(entity, false);
        this.logger.info("\u8c03\u62e8\u8ba2\u5355-{}\u751f\u6210\u8c03\u51fa\u65b9\u51fa\u5e93\u6d41\u6c34\u6210\u529f\uff01", (Object)entity.getId());
        this.sendIdleStoreData(entity, false);
        this.logger.info("\u8c03\u62e8\u8ba2\u5355-{}\u751f\u6210\u8c03\u51fa\u65b9\u95f2\u7f6e\u6d41\u6c34\u6210\u529f\uff01", (Object)entity.getId());
        super.saveOrUpdate((Object)entity, false);
    }

    @Override
    public void sendIdleStoreData(AllotOrderEntity entity, boolean isRollBack) {
        if (isRollBack) {
            CommonResponse idleStoreResp = this.iIdleManageApi.inOutStoreRollback(entity.getId());
            this.logger.info("\u4e91\u4ed3\u95f2\u7f6e\u64a4\u56de\u53c2\u6570\uff1a{}, \u7ed3\u679c: {}", (Object)entity.getId(), (Object)JSONObject.toJSONString((Object)idleStoreResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            if (!idleStoreResp.isSuccess()) {
                this.logger.error("\u8c03\u62e8\u8ba2\u5355-{}\u751f\u6210\u8c03\u51fa\u65b9\u95f2\u7f6e\u64a4\u56de\u5931\u8d25\uff0c\u6570\u636e\uff1a{}, \u7ed3\u679c\uff1a{}", new Object[]{entity.getId(), entity.getId(), JSONObject.toJSONString((Object)idleStoreResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u751f\u6210\u8c03\u51fa\u65b9\u95f2\u7f6e\u64a4\u56de\u5931\u8d25\uff01");
            }
        } else {
            Map storeMap = entity.getAllotOrderDetailList().stream().collect(Collectors.groupingBy(item -> item.getOutStoreId(), Collectors.toList()));
            ArrayList<IdleFlowVO> vos = new ArrayList<IdleFlowVO>();
            IdleFlowVO flowVO = null;
            for (Long inStoreId : storeMap.keySet()) {
                for (AllotOrderDetailEntity orderDetail : storeMap.get(inStoreId)) {
                    flowVO = (IdleFlowVO)BeanMapper.map((Object)StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u4e91\u4ed3\u51fa\u5e93, (Integer)0), IdleFlowVO.class);
                    this.setIdleFlowData(flowVO, orderDetail, InOutTypeEnum.\u4e91\u4ed3\u51fa\u5e93, entity);
                    vos.add(flowVO);
                }
            }
            CommonResponse idleStoreResp = this.iIdleManageApi.inOutStore(vos);
            this.logger.info("\u4e91\u4ed3\u95f2\u7f6e\u53c2\u6570\uff1a{}, \u7ed3\u679c: {}", (Object)JSONObject.toJSONString(vos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), (Object)JSONObject.toJSONString((Object)idleStoreResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            if (!idleStoreResp.isSuccess()) {
                this.logger.error("\u8c03\u62e8\u8ba2\u5355-{}\u751f\u6210\u8c03\u51fa\u65b9\u51fa\u5e93\u6d41\u6c34\u5931\u8d25\uff0c\u6570\u636e\uff1a{}, \u7ed3\u679c\uff1a{}", new Object[]{entity.getId(), JSONObject.toJSONString(vos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)idleStoreResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u751f\u6210\u8c03\u51fa\u65b9\u51fa\u5e93\u6d41\u6c34\u5931\u8d25\uff01");
            }
        }
    }

    @Override
    public void sendOutStoreData(AllotOrderEntity entity, boolean isRollBack) {
        CommonResponse outStoreResp;
        Map storeMap = entity.getAllotOrderDetailList().stream().collect(Collectors.groupingBy(item -> item.getOutStoreId(), Collectors.toList()));
        ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
        ArrayList<StoreManageVO> vos = new ArrayList<StoreManageVO>();
        StoreManageVO outStoreVo = null;
        FlowVO flowVO = null;
        ArrayList<Long> sourceIdsForRollBack = null;
        for (Long inStoreId : storeMap.keySet()) {
            outStoreVo = new StoreManageVO();
            outStoreVo.setFlowVOList(new ArrayList());
            outStoreVo.setSourceId(entity.getId());
            outStoreVo.setStoreId(inStoreId);
            outStoreVo.setInOutTypeEnum(InOutTypeEnum.\u4e91\u4ed3\u51fa\u5e93);
            outStoreVo.setOutEffectiveON(Boolean.valueOf(true));
            sourceIdsForRollBack = new ArrayList<Long>();
            sourceIdsForRollBack.add(entity.getId());
            outStoreVo.setSourceIdsForRollBack(sourceIdsForRollBack);
            outStoreVo.setInOutTypeEnum(InOutTypeEnum.\u4e91\u4ed3\u51fa\u5e93);
            for (AllotOrderDetailEntity orderDetail : storeMap.get(inStoreId)) {
                flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u4e91\u4ed3\u51fa\u5e93, (Integer)0);
                this.setFlowData(flowVO, orderDetail, InOutTypeEnum.\u4e91\u4ed3\u51fa\u5e93, entity);
                flowVOS.add(flowVO);
                outStoreVo.getFlowVOList().add(flowVO);
            }
            vos.add(outStoreVo);
        }
        CommonResponse priceResp = this.storeFlowApi.getNewPrice(flowVOS);
        if (!priceResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u7269\u8d44\u5e93\u5b58\u5747\u4ef7\u5931\u8d25,{}", (Object)JSONObject.toJSONString((Object)priceResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            throw new BusinessException("\u83b7\u53d6\u7269\u8d44\u5e93\u5b58\u5747\u4ef7\u5931\u8d25");
        }
        HashMap flowMap = new HashMap();
        ((List)priceResp.getData()).stream().forEach(item -> flowMap.put(item.getStoreId().toString() + item.getMaterialId().toString() + item.getBrandId().toString(), item));
        for (FlowVO f : flowVOS) {
            flowVO = (FlowVO)flowMap.get(f.getStoreId().toString() + f.getMaterialId().toString() + f.getBrandId().toString());
            if (null != flowVO && null != flowVO.getTaxRate()) {
                f.setTaxRate(flowVO.getTaxRate());
                f.setPrice(ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)f.getTaxPrice(), (BigDecimal)f.getTaxRate()), (BigDecimal)new BigDecimal("100")));
                f.setMny(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)f.getPrice(), (BigDecimal)f.getNum())));
                f.setTax(ComputeUtil.safeSub((BigDecimal)f.getTaxMny(), (BigDecimal)f.getMny()));
                continue;
            }
            f.setTaxRate(BigDecimal.ZERO);
            f.setPrice(f.getTaxPrice());
            f.setMny(f.getTaxMny());
            f.setTax(BigDecimal.ZERO);
        }
        if (isRollBack) {
            outStoreResp = this.storeManageApi.inOutStoreRollbackBatch(vos);
            this.logger.info("\u4e91\u4ed3\u51fa\u5e93\u6d41\u6c34\u64a4\u56de\u53c2\u6570\uff1a{}, \u7ed3\u679c: {}", (Object)JSONObject.toJSONString(vos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), (Object)JSONObject.toJSONString((Object)outStoreResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            if (!outStoreResp.isSuccess()) {
                this.logger.error("\u8c03\u62e8\u8ba2\u5355-{}\u751f\u6210\u8c03\u51fa\u65b9\u51fa\u5e93\u6d41\u6c34\u64a4\u56de\u5931\u8d25\uff0c\u6570\u636e\uff1a{}, \u7ed3\u679c\uff1a{}", new Object[]{entity.getId(), JSONObject.toJSONString((Object)outStoreVo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)outStoreResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u751f\u6210\u8c03\u51fa\u65b9\u51fa\u5e93\u6d41\u6c34\u64a4\u56de\u5931\u8d25\uff01");
            }
        } else {
            outStoreResp = this.storeManageApi.inOutStoreBatch(vos);
            this.logger.info("\u4e91\u4ed3\u51fa\u5e93\u53c2\u6570\uff1a{}, \u7ed3\u679c: {}", (Object)JSONObject.toJSONString(vos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), (Object)JSONObject.toJSONString((Object)outStoreResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            if (!outStoreResp.isSuccess()) {
                this.logger.error("\u8c03\u62e8\u8ba2\u5355-{}\u751f\u6210\u8c03\u51fa\u65b9\u51fa\u5e93\u6d41\u6c34\u5931\u8d25\uff0c\u6570\u636e\uff1a{}, \u7ed3\u679c\uff1a{}", new Object[]{entity.getId(), JSONObject.toJSONString((Object)outStoreVo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)outStoreResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u751f\u6210\u8c03\u51fa\u65b9\u51fa\u5e93\u6d41\u6c34\u5931\u8d25\uff01");
            }
        }
    }

    private void sendInStoreData(AllotOrderEntity entity) {
        Map storeMap = entity.getAllotOrderDetailList().stream().collect(Collectors.groupingBy(item -> item.getInStoreId(), Collectors.toList()));
        ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
        ArrayList<StoreManageVO> vos = new ArrayList<StoreManageVO>();
        StoreManageVO inStoreVo = null;
        FlowVO flowVO = null;
        for (Long inStoreId : storeMap.keySet()) {
            inStoreVo = new StoreManageVO();
            inStoreVo.setFlowVOList(new ArrayList());
            inStoreVo.setStoreId(inStoreId);
            inStoreVo.setSourceId(entity.getId());
            inStoreVo.setInOutTypeEnum(InOutTypeEnum.\u4e91\u4ed3\u5165\u5e93);
            for (AllotOrderDetailEntity orderDetail : storeMap.get(inStoreId)) {
                flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u4e91\u4ed3\u5165\u5e93, (Integer)0);
                this.setFlowData(flowVO, orderDetail, InOutTypeEnum.\u4e91\u4ed3\u5165\u5e93, entity);
                flowVOS.add(flowVO);
                inStoreVo.getFlowVOList().add(flowVO);
            }
            vos.add(inStoreVo);
        }
        CommonResponse priceResp = this.storeFlowApi.getNewPrice(flowVOS);
        if (!priceResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u7269\u8d44\u5e93\u5b58\u5747\u4ef7\u5931\u8d25,{}", (Object)JSONObject.toJSONString((Object)priceResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            throw new BusinessException("\u83b7\u53d6\u7269\u8d44\u5e93\u5b58\u5747\u4ef7\u5931\u8d25");
        }
        HashMap flowMap = new HashMap();
        ((List)priceResp.getData()).stream().forEach(item -> flowMap.put(item.getStoreId().toString() + item.getMaterialId().toString() + item.getBrandId().toString(), item));
        for (FlowVO f : flowVOS) {
            flowVO = (FlowVO)flowMap.get(f.getStoreId().toString() + f.getMaterialId().toString() + f.getBrandId().toString());
            if (null != flowVO && null != flowVO.getTaxRate()) {
                f.setTaxRate(flowVO.getTaxRate());
                f.setPrice(ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)f.getTaxPrice(), (BigDecimal)f.getTaxRate()), (BigDecimal)new BigDecimal("100")));
                f.setMny(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)f.getPrice(), (BigDecimal)f.getNum())));
                f.setTax(ComputeUtil.safeSub((BigDecimal)f.getTaxMny(), (BigDecimal)f.getMny()));
                continue;
            }
            f.setTaxRate(BigDecimal.ZERO);
            f.setPrice(f.getTaxPrice());
            f.setMny(f.getTaxMny());
            f.setTax(BigDecimal.ZERO);
        }
        CommonResponse inStoreResp = this.storeManageApi.inOutStoreBatch(vos);
        this.logger.info("\u4e91\u4ed3\u5165\u5e93\u53c2\u6570\uff1a{}, \u7ed3\u679c: {}", (Object)JSONObject.toJSONString(vos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), (Object)JSONObject.toJSONString((Object)inStoreResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        if (!inStoreResp.isSuccess()) {
            this.logger.error("\u8c03\u62e8\u8ba2\u5355-{}\u751f\u6210\u8c03\u5165\u65b9\u5165\u5e93\u6d41\u6c34\u5931\u8d25\uff0c\u6570\u636e\uff1a{}, \u7ed3\u679c\uff1a{}", new Object[]{entity.getId(), JSONObject.toJSONString((Object)inStoreVo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)inStoreResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u751f\u6210\u8c03\u5165\u65b9\u5165\u5e93\u6d41\u6c34\u5931\u8d25\uff01");
        }
    }

    private void setIdleFlowData(IdleFlowVO flowVO, AllotOrderDetailEntity orderDetail, InOutTypeEnum inOutTypeEnum, AllotOrderEntity order) {
        flowVO.setSourceBillTypeName(inOutTypeEnum.getInOutTypeName());
        flowVO.setStoreId(orderDetail.getOutStoreId());
        flowVO.setStoreName(orderDetail.getOutStoreName());
        flowVO.setSourceId(orderDetail.getOrderId());
        flowVO.setSourceDetailId(orderDetail.getId());
        flowVO.setProjectId(order.getOutProjectId());
        flowVO.setProjectName(order.getOutProjectName());
        flowVO.setOrgId(order.getOutOrgId());
        flowVO.setOrgName(order.getOutOrgName());
        flowVO.setParentOrgId(order.getOutParentOrgId());
        flowVO.setParentOrgCode(order.getOutParentOrgCode());
        flowVO.setParentOrgName(order.getOutParentOrgName());
        flowVO.setMaterialCategoryId(orderDetail.getMaterialTypeId());
        flowVO.setMaterialCategoryName(orderDetail.getMaterialTypeName());
        flowVO.setMaterialCategoryCode(orderDetail.getMaterialTypeCode());
        flowVO.setMaterialId(orderDetail.getMaterialId());
        flowVO.setMaterialName(orderDetail.getMaterialName());
        flowVO.setMaterialCode(orderDetail.getMaterialCode());
        flowVO.setMaterialSpec(orderDetail.getPropertyValue());
        flowVO.setBrandId(orderDetail.getBrandId());
        flowVO.setBrandName(orderDetail.getBrandName());
        flowVO.setMaterialUnitName(orderDetail.getUnitName());
        flowVO.setNum(orderDetail.getAllotNum().negate());
        flowVO.setProductCode(orderDetail.getProductCode());
        flowVO.setMaterialUnitId(orderDetail.getUnitId());
        flowVO.setMaterialUnitName(orderDetail.getUnitName());
        flowVO.setSourceId(order.getId());
        flowVO.setSourceDetailId(orderDetail.getId());
        flowVO.setSourceBillCode(order.getBillCode());
        flowVO.setSourceBillDate(order.getPurTime());
    }

    private void setFlowData(FlowVO flowVO, AllotOrderDetailEntity orderDetail, InOutTypeEnum inOutTypeEnum, AllotOrderEntity order) {
        flowVO.setSourceType(StoreCommonConsts.ZERO);
        flowVO.setSourceBillTypeName(inOutTypeEnum.getInOutTypeName());
        flowVO.setStoreId(inOutTypeEnum.getInOutType() == 15 ? orderDetail.getInStoreId() : orderDetail.getOutStoreId());
        flowVO.setStoreName(inOutTypeEnum.getInOutType() == 15 ? orderDetail.getInStoreName() : orderDetail.getOutStoreName());
        flowVO.setProjectId(inOutTypeEnum.getInOutType() == 15 ? order.getInProjectId() : order.getOutProjectId());
        flowVO.setProjectName(inOutTypeEnum.getInOutType() == 15 ? order.getInProjectName() : order.getOutProjectName());
        flowVO.setOrgId(inOutTypeEnum.getInOutType() == 15 ? order.getInOrgId() : order.getOutOrgId());
        flowVO.setOrgName(inOutTypeEnum.getInOutType() == 15 ? order.getInOrgName() : order.getOutOrgName());
        flowVO.setParentOrgId(inOutTypeEnum.getInOutType() == 15 ? order.getInParentOrgId() : order.getOutParentOrgId());
        flowVO.setParentOrgCode(inOutTypeEnum.getInOutType() == 15 ? order.getInParentOrgCode() : order.getOutParentOrgCode());
        flowVO.setParentOrgName(inOutTypeEnum.getInOutType() == 15 ? order.getInParentOrgName() : order.getOutParentOrgName());
        flowVO.setEmployeeId(inOutTypeEnum.getInOutType() == 15 ? order.getPurUserId() : orderDetail.getSellUserId());
        flowVO.setEmployeeName(inOutTypeEnum.getInOutType() == 15 ? order.getPurUserName() : orderDetail.getSellUserName());
        flowVO.setMaterialCategoryId(orderDetail.getMaterialTypeId());
        flowVO.setMaterialCategoryName(orderDetail.getMaterialTypeName());
        flowVO.setMaterialCategoryCode(orderDetail.getMaterialTypeCode());
        flowVO.setMaterialId(orderDetail.getMaterialId());
        flowVO.setMaterialName(orderDetail.getMaterialName());
        flowVO.setMaterialCode(orderDetail.getMaterialCode());
        flowVO.setMaterialSpec(orderDetail.getPropertyValue());
        flowVO.setBrandId(orderDetail.getBrandId());
        flowVO.setBrandName(orderDetail.getBrandName());
        flowVO.setMaterialUnitName(orderDetail.getUnitName());
        flowVO.setNum(orderDetail.getAllotNum());
        flowVO.setProductCode(orderDetail.getProductCode());
        flowVO.setMaterialUnitId(orderDetail.getUnitId());
        flowVO.setMaterialUnitName(orderDetail.getUnitName());
        flowVO.setSourceId(orderDetail.getOrderId());
        flowVO.setSourceDetailId(orderDetail.getId());
        flowVO.setTaxMny(orderDetail.getDetailAssetTaxMny());
        flowVO.setTaxPrice(ComputeUtil.safeDiv((BigDecimal)orderDetail.getDetailAssetTaxMny(), (BigDecimal)orderDetail.getAllotNum()));
        flowVO.setSourceId(order.getId());
        flowVO.setSourceDetailId(orderDetail.getId());
        flowVO.setSourceBillCode(order.getBillCode());
        flowVO.setSourceBillDate(order.getPurTime());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelOrder(AllotOrderEntity order) {
        CommonResponse empResp = this.employeeApi.getById(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        if (!empResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u7528\u6237id-{}\u5931\u8d25\uff0c{}", (Object)InvocationInfoProxy.getEmployeeId(), (Object)JSONObject.toJSONString((Object)empResp));
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        EmployeeVO emp = (EmployeeVO)empResp.getData();
        order.setCancelTime(new Date());
        order.setCancelUserCode(emp.getCode());
        order.setCancelUserId(emp.getId());
        order.setCancelUserName(emp.getUserName());
        StringBuilder content = new StringBuilder();
        StringBuilder subject = new StringBuilder();
        String pcUrl = null;
        String oprMsg = null;
        String[] receivers = null;
        Set<String> receiverList = null;
        Long projectManagerId = null;
        switch (order.getBusinessStatus()) {
            case 1: 
            case 3: {
                String[] stringArray;
                order.setBusinessStatus(AllotOrderBusinessStatusEnums.\u8c03\u51fa\u65b9\u53d6\u6d88.getCode());
                projectManagerId = this.getProjectManagerId(order.getInProjectId());
                if (null != projectManagerId) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = order.getPurUserId().toString();
                    stringArray = stringArray2;
                    stringArray2[1] = projectManagerId.toString();
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = order.getPurUserId().toString();
                }
                receivers = stringArray;
                subject.append("\u3010\u7269\u8d44\u8c03\u62e8\u3011,\u3010").append(order.getBillCode()).append("\u3011\uff0c\u3010").append(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date())).append("\u3011\u8ba2\u5355\u88ab\u8c03\u51fa\u65b9\u53d6\u6d88\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
                content.append("\u3010").append(order.getBillCode()).append("\u3011\uff0c\u3010").append(order.getInProjectName()).append("\u3011\u7533\u8bf7\u8c03\u62e8\u7684\u7269\u8d44\u5df2\u88ab\u8c03\u51fa\u65b9\u53d6\u6d88\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
                oprMsg = "\u8ba2\u5355\u8c03\u51fa\u65b9\u53d6\u6d88\uff0c\u5411\u8c03\u5165\u65b9\u8054\u7cfb\u4eba";
                pcUrl = this.BASE_HOST + CommonConstants.\u8c03\u5165\u8ba2\u5355PC\u8be6\u60c5 + order.getId().toString();
                break;
            }
            case 2: {
                order.setBusinessStatus(AllotOrderBusinessStatusEnums.\u8c03\u5165\u65b9\u53d6\u6d88.getCode());
                receiverList = order.getAllotOrderDetailList().stream().map(item -> item.getSellUserId().toString()).collect(Collectors.toSet());
                receiverList.add(order.getEditUserId().toString());
                projectManagerId = this.getProjectManagerId(order.getOutProjectId());
                if (null != projectManagerId) {
                    receiverList.add(projectManagerId.toString());
                }
                subject.append("\u3010\u7269\u8d44\u8c03\u62e8\u3011,\u3010").append(order.getBillCode()).append("\u3011\uff0c\u3010").append(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date())).append("\u3011\u8ba2\u5355\u88ab\u8c03\u5165\u65b9\u53d6\u6d88\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
                receivers = receiverList.toArray(new String[receiverList.size()]);
                content.append("\u8ba2\u5355\u7f16\u53f7\u3010").append(order.getBillCode()).append("\u3011\uff0c\u8c03\u5165\u9879\u76ee\u3010").append(order.getInProjectName()).append("\u3011\uff0c\u7269\u8d44\u5206\u7c7b\u3010").append(order.getCategoryNames()).append("\u3011\u8c03\u5165\u65b9\u5df2\u53d6\u6d88\u8ba2\u5355\uff0c\u8bf7\u67e5\u770b\u3002");
                oprMsg = "\u8ba2\u5355\u8c03\u5165\u65b9\u65b9\u53d6\u6d88\uff0c\u5411\u8c03\u6d3d\u5546\u4fee\u6539\u4eba\u3001\u8c03\u51fa\u65b9\u4e0a\u67b6\u4eba\u3001\u9879\u76ee\u7ecf\u7406";
                pcUrl = this.BASE_HOST + (order.getStoreType() == 1 ? CommonConstants.\u4e91\u4ed3\u8c03\u51fa\u8ba2\u5355PC\u8be6\u60c5 : CommonConstants.\u5927\u533a\u8c03\u51fa\u8ba2\u5355PC\u8be6\u60c5) + order.getId().toString();
                break;
            }
            case 5: {
                order.setBusinessStatus(AllotOrderBusinessStatusEnums.\u8c03\u5165\u65b9\u53d6\u6d88.getCode());
                subject.append("\u3010\u7269\u8d44\u8c03\u62e8\u3011,\u3010").append(order.getBillCode()).append("\u3011\uff0c\u3010").append(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date())).append("\u3011\u8c03\u5165\u65b9\u62d2\u7edd\u5165\u5e93\uff0c\u4ea4\u6613\u7ed3\u675f\uff01");
                receiverList = order.getAllotOrderDetailList().stream().map(item -> item.getSellUserId().toString()).collect(Collectors.toSet());
                projectManagerId = this.getProjectManagerId(order.getOutProjectId());
                if (null != projectManagerId) {
                    receiverList.add(projectManagerId.toString());
                }
                receivers = receiverList.toArray(new String[receiverList.size()]);
                content.append("\u3010").append(order.getBillCode()).append("\u3011\uff0c\u3010").append(order.getInProjectName()).append("\u3011\u8c03\u5165\u65b9\u62d2\u7edd\u5165\u5e93\uff0c\u4ea4\u6613\u7ed3\u675f\uff01");
                oprMsg = "\u8ba2\u5355\u8c03\u5165\u65b9\u8c03\u62e8\u62d2\u7edd\u5165\u5e93\uff0c\u5411\u8c03\u51fa\u65b9\u4e0a\u67b6\u4eba\u3001\u9879\u76ee\u7ecf\u7406";
                pcUrl = this.BASE_HOST + (order.getStoreType() == 1 ? CommonConstants.\u4e91\u4ed3\u8c03\u51fa\u8ba2\u5355PC\u8be6\u60c5 : CommonConstants.\u5927\u533a\u8c03\u51fa\u8ba2\u5355PC\u8be6\u60c5) + order.getId().toString();
                this.sendOutStoreData(order, true);
                this.logger.info("\u8c03\u62e8\u8ba2\u5355-{}\u64a4\u56de\u8c03\u51fa\u65b9\u51fa\u5e93\u6d41\u6c34\u6210\u529f\uff01", (Object)order.getId());
                this.sendIdleStoreData(order, true);
                this.logger.info("\u8c03\u62e8\u8ba2\u5355-{}\u64a4\u56de\u8c03\u51fa\u65b9\u95f2\u7f6e\u6d41\u6c34\u6210\u529f\uff01", (Object)order.getId());
                break;
            }
            default: {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8ba2\u5355\u72b6\u6001\u4e3a\u3010" + AllotOrderBusinessStatusEnums.getNameByCode((Integer)order.getBusinessStatus()) + "\u3011\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
            }
        }
        this.goodsService.updateAllotNum(this.getUpdateGoodList(order.getAllotOrderDetailList(), "release", "allot"), false);
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);
        parameter.setPcUrl(pcUrl);
        parameter.setContent(content.toString());
        parameter.setSubject(subject.toString());
        this.sendMsg(parameter, order.getId(), oprMsg);
        super.saveOrUpdate((Object)order, false);
    }

    private Long getProjectManagerId(Long projectId) {
        CommonResponse projectResp = this.projectPoolApi.queryProjectPoolById(projectId);
        this.logger.error("\u6839\u636e\u9879\u76eeId-{}\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u7ed3\u679c\uff0c{}", (Object)projectId, (Object)JSONObject.toJSONString((Object)projectResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (!projectResp.isSuccess() || ((JSONArray)projectResp.getData()).size() == 0) {
            return null;
        }
        ProjectPoolSetVO p = (ProjectPoolSetVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((JSONArray)projectResp.getData()).get(0)), ProjectPoolSetVO.class);
        return p.getProjectManagementId();
    }

    private Map<Long, Long> getProjectManagerIdS(List<Long> projectId) {
        CommonResponse projectResp = this.projectPoolApi.queryProjectsByIds(projectId);
        if (!projectResp.isSuccess() || ((List)projectResp.getData()).size() == 0) {
            return null;
        }
        List list = (List)projectResp.getData();
        Map<Long, Long> collect = list.stream().filter(e -> null != e.getProjectManagementId()).collect(Collectors.toMap(ProjectPoolSetVO::getProjectId, ProjectPoolSetVO::getProjectManagementId));
        return collect;
    }

    @Override
    public void confirmOrder(Long id) {
        AllotOrderEntity order = (AllotOrderEntity)((Object)super.selectById((Serializable)id));
        order.setBusinessStatus(AllotOrderBusinessStatusEnums.\u8c03\u5165\u65b9\u6d3d\u5546\u5df2\u786e\u8ba4.getCode());
        Set<String> receiverList = order.getAllotOrderDetailList().stream().map(item -> item.getSellUserId().toString()).collect(Collectors.toSet());
        receiverList.add(order.getEditUserId().toString());
        Long projectManagerId = this.getProjectManagerId(order.getOutProjectId());
        if (null != projectManagerId) {
            receiverList.add(projectManagerId.toString());
        }
        String[] receivers = receiverList.toArray(new String[receiverList.size()]);
        StringBuilder subject = new StringBuilder();
        StringBuilder content = new StringBuilder();
        subject.append("\u3010\u7269\u8d44\u8c03\u62e8\u3011\uff0c\u3010").append(order.getBillCode()).append("\u3011\uff0c\u3010").append(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date())).append("\u3011\u8c03\u5165\u65b9\u5df2\u786e\u8ba4\u8ba2\u5355\uff0c\u8bf7\u67e5\u770b\u3002");
        content.append("\u8ba2\u5355\u7f16\u53f7\u3010").append(order.getBillCode()).append("\u3011\uff0c\u8c03\u5165\u9879\u76ee\u3010").append(order.getInProjectName()).append("\u3011\uff0c\u7269\u8d44\u5206\u7c7b\u3010").append(order.getCategoryNames()).append("\u3011\u8c03\u5165\u65b9\u5df2\u786e\u8ba4\u8ba2\u5355\uff0c\u8bf7\u67e5\u770b\u3002");
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);
        parameter.setPcUrl(this.BASE_HOST + (order.getStoreType() == 1 ? CommonConstants.\u4e91\u4ed3\u8c03\u51fa\u8ba2\u5355PC\u8be6\u60c5 : CommonConstants.\u5927\u533a\u8c03\u51fa\u8ba2\u5355PC\u8be6\u60c5) + order.getId().toString());
        parameter.setContent(content.toString());
        parameter.setSubject(subject.toString());
        this.sendMsg(parameter, order.getId(), "\u8ba2\u5355\u8c03\u5165\u65b9\u786e\u8ba4\u8ba2\u5355\uff0c\u5411\u8c03\u6d3d\u5546\u4fee\u6539\u4eba\u3001\u8c03\u51fa\u65b9\u4e0a\u67b6\u4eba\u3001\u9879\u76ee\u7ecf\u7406");
        super.saveOrUpdate((Object)order, false);
    }

    private List<AllotOrderDetailEntity> generateOrderDetailByApply(List<AllotApplyDetailVO> allotApplyDetailVOS, AllotOrderEntity order, Map<Long, GoodsEntity> shelfDetailMap) {
        List resp = BeanMapper.mapList(allotApplyDetailVOS, AllotOrderDetailEntity.class);
        BigDecimal totalAllotMny = BigDecimal.ZERO;
        BigDecimal totalAllotTaxMny = BigDecimal.ZERO;
        HashMap<Long, String> categoryMap = new HashMap<Long, String>();
        for (AllotOrderDetailEntity orderDetail : resp) {
            orderDetail.setAllotApplyDetailId(orderDetail.getId());
            this.clearBaseField(orderDetail);
            orderDetail.setOrderId(order.getId());
            orderDetail.setSellNum(shelfDetailMap.get(orderDetail.getSourceId()).getNum());
            orderDetail.setDetailAllotTaxMny(orderDetail.getAllotTaxMny());
            orderDetail.setDetailAllotMny(orderDetail.getAllotMny());
            orderDetail.setInitialAllotMny(orderDetail.getAllotMny());
            orderDetail.setInitialAllotTaxMny(orderDetail.getDetailAllotTaxMny());
            orderDetail.setAllotApplyDetailId(orderDetail.getId());
            orderDetail.setDetailAssetTaxMny(orderDetail.getDetailAllotTaxMny());
            orderDetail.setDetailAssetMny(orderDetail.getDetailAllotMny());
            orderDetail.setInitialAssetTaxMny(orderDetail.getDetailAssetTaxMny());
            orderDetail.setInitialAssetMny(orderDetail.getDetailAssetMny());
            orderDetail.setInitialSellPrice(orderDetail.getSellPrice());
            orderDetail.setInitialSellTaxPrice(orderDetail.getSellTaxPrice());
            orderDetail.setInitialAllotNum(orderDetail.getAllotNum());
            orderDetail.setMemo(null);
            categoryMap.put(orderDetail.getMaterialTypeId(), orderDetail.getMaterialTypeName());
            totalAllotMny = ComputeUtil.safeAdd((BigDecimal)totalAllotMny, (BigDecimal)orderDetail.getDetailAllotMny());
            totalAllotTaxMny = ComputeUtil.safeAdd((BigDecimal)totalAllotTaxMny, (BigDecimal)orderDetail.getDetailAllotTaxMny());
        }
        order.setTotalAssetTaxMny(totalAllotTaxMny);
        order.setTotalAllotTaxMny(totalAllotTaxMny);
        order.setTotalAllotMny(totalAllotMny);
        order.setTotalAssetMny(totalAllotMny);
        order.setCategoryNames(StringUtils.join(categoryMap.values(), (String)","));
        return resp;
    }

    private void clearBaseField(BaseEntity base) {
        base.setId(null);
        base.setCreateTime(null);
        base.setCreateUserCode(null);
        base.setUpdateUserCode(null);
        base.setUpdateTime(null);
        base.setVersion(Integer.valueOf(0));
    }

    private AllotOrderEntity generateOrderByApply(AllotApplyVO allotApplyVO, List<AllotApplyDetailVO> allotApplyDetailVOs, Map<Long, GoodsEntity> shelfDetailMap) {
        AllotOrderEntity order = new AllotOrderEntity();
        AllotApplyDetailVO tmpApplyDetail = allotApplyDetailVOs.get(0);
        order.setId(IdWorker.getId());
        order.setAllotApplyId(allotApplyVO.getId());
        order.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        order.setEditNum(0);
        order.setBusinessStatus(AllotOrderBusinessStatusEnums.\u8c03\u51fa\u65b9\u5f85\u786e\u8ba4.getCode());
        order.setInProjectCode(allotApplyVO.getInProjectCode());
        order.setInProjectId(allotApplyVO.getInProjectId());
        order.setInProjectName(allotApplyVO.getInProjectName());
        order.setInProjectAddress(allotApplyVO.getInProjectAddress());
        order.setInOrgId(allotApplyVO.getInOrgId());
        order.setInOrgCode(allotApplyVO.getInOrgCode());
        order.setInOrgName(allotApplyVO.getInOrgName());
        order.setInParentOrgCode(allotApplyVO.getInParentOrgCode());
        order.setInParentOrgId(allotApplyVO.getInParentOrgId());
        order.setInParentOrgName(allotApplyVO.getInParentOrgName());
        order.setInCorpCode(allotApplyVO.getCorpCode());
        order.setInCorpId(allotApplyVO.getCorpId());
        order.setInCorpName(allotApplyVO.getCorpName());
        order.setPurTime(allotApplyVO.getEffectDate());
        order.setPurUserCode(allotApplyVO.getPurUserCode());
        order.setPurUserId(allotApplyVO.getPurUserId());
        order.setPurUserName(allotApplyVO.getPurUserName());
        order.setPurUserPhone(allotApplyVO.getPurUserPhone());
        order.setOutProjectId(tmpApplyDetail.getOutProjectId());
        order.setOutProjectCode(tmpApplyDetail.getOutProjectCode());
        order.setOutProjectName(tmpApplyDetail.getOutProjectName());
        order.setOutOrgId(tmpApplyDetail.getOutOrgId());
        order.setOutOrgCode(tmpApplyDetail.getOutOrgCode());
        order.setOutOrgName(tmpApplyDetail.getOutOrgName());
        order.setOutParentOrgId(tmpApplyDetail.getOutParentOrgId());
        order.setOutParentOrgCode(tmpApplyDetail.getOutParentOrgCode());
        order.setOutParentOrgName(tmpApplyDetail.getOutParentOrgName());
        order.setStoreType(tmpApplyDetail.getStoreType());
        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)order), AllotOrderVO.class)));
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        order.setBillCode((String)billCode.getData());
        order.setAllotOrderDetailList(this.generateOrderDetailByApply(allotApplyDetailVOs, order, shelfDetailMap));
        return order;
    }
}

