/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.BrandRelationEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBrandRelationService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.vo.BrandRelationQueryVO;
import com.ejianc.business.zdsmaterial.erp.vo.BrandRelationVO;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.business.zdsmaterial.erp.vo.DataPushErpParam;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"brandRelation"})
public class BrandRelationController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBrandRelationService service;
    @Autowired
    private IBrandService brandService;
    @Autowired
    private IMaterialCategoryService categoryService;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<BrandRelationVO> queryDetail(Long id) {
        BrandRelationEntity entity = (BrandRelationEntity)((Object)this.service.selectById(id));
        BrandRelationVO vo = (BrandRelationVO)BeanMapper.map((Object)((Object)entity), BrandRelationVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<BrandRelationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BrandRelationVO brandRelationVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<BrandRelationVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("materialTypeId")) {
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            categoryIds.add(Long.valueOf(((Parameter)param.getParams().get("materialTypeId")).getValue().toString()));
            List<MaterialCategoryEntity> leafCategorys = this.categoryService.getAllLeafByPids(categoryIds, PlanConstant.INTEGER_YES);
            List<Long> leafCategoryIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(leafCategorys)) {
                leafCategoryIds = leafCategorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            } else {
                leafCategoryIds.add(-99L);
            }
            param.getParams().put("materialTypeId", new Parameter("in", leafCategoryIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BrandRelationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"pushRelation"})
    @ResponseBody
    public CommonResponse<String> pushRelation(@RequestBody List<Long> relationIds) {
        List<BrandRelationEntity> relations = this.service.getAllByIds(relationIds);
        DataPushErpParam p = new DataPushErpParam();
        p.setBillType("EJCBT202403000012");
        p.setOperatorId(Long.valueOf(1778837995772710913L));
        p.setPushData(BeanMapper.mapList(relations, BrandRelationVO.class));
        this.service.syncRelationToErp(p);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/refBrandRelationData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<BrandRelationVO>> refBrandRelationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"materialTypeId")) {
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            categoryIds.add(Long.valueOf(((Parameter)param.getParams().get("materialTypeId")).getValue().toString()));
            List<MaterialCategoryEntity> leafCategorys = this.categoryService.getAllLeafByPids(categoryIds, PlanConstant.INTEGER_YES);
            List<Long> leafCategoryIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(leafCategorys)) {
                leafCategoryIds = leafCategorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            } else {
                leafCategoryIds.add(-99L);
            }
            param.getParams().put("materialTypeId", new Parameter("in", leafCategoryIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BrandRelationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"updateBrandLabel"})
    public CommonResponse<String> updateBrandLabel(@RequestBody List<BrandRelationVO> relations) {
        List<BrandRelationEntity> relationList = this.service.getAllByIds(relations.stream().map(BaseVO::getId).collect(Collectors.toList()));
        String lable = relations.get(0).getBrandLabel();
        String memo = relations.get(0).getMemo();
        relationList.stream().forEach(r -> {
            r.setBrandLabel(lable);
            r.setMemo(memo);
        });
        this.service.saveOrUpdateBatch(relationList, relationList.size(), false);
        this.brandService.pushBrandToErp(new DataPushErpParam(BeanMapper.mapList(relationList, BrandRelationVO.class), InvocationInfoProxy.getUserid(), "brandChange", "EJCBT202408000002"));
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"test"})
    public CommonResponse<String> test(@RequestBody DataPushErpParam pushErpParam) {
        this.service.syncRelationToErp(pushErpParam);
        return CommonResponse.success((String)"\u6210\u529f\uff01");
    }

    @PostMapping(value={"updateEnable"})
    public CommonResponse<String> updateEnable(@RequestBody BrandRelationVO relation) {
        BrandRelationEntity dbRelation = (BrandRelationEntity)((Object)this.service.selectById(relation.getId()));
        dbRelation.setRelationEnabled(relation.getRelationEnabled());
        this.service.saveOrUpdate((Object)dbRelation, false);
        ArrayList<BrandRelationEntity> pushList = new ArrayList<BrandRelationEntity>();
        pushList.add(dbRelation);
        this.brandService.pushBrandToErp(new DataPushErpParam(BeanMapper.mapList(pushList, BrandRelationVO.class), InvocationInfoProxy.getUserid(), "brandChange", "EJCBT202408000002"));
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"pageList"})
    public CommonResponse<IPage<BrandRelationQueryVO>> pageList(@RequestBody QueryParam queryParam) {
        String brandName = null;
        String supplierName = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        if (null != queryParam.getParams().get("materialTypeName")) {
            query.like((Object)"material_type_name", (Object)((Parameter)queryParam.getParams().get("materialTypeName")).getValue().toString());
        }
        if (null != queryParam.getParams().get("brandName")) {
            brandName = ((Parameter)queryParam.getParams().get("brandName")).getValue().toString();
            query.like((Object)"brand_name", (Object)brandName);
        }
        if (null != queryParam.getParams().get("supplierName")) {
            supplierName = ((Parameter)queryParam.getParams().get("supplierName")).getValue().toString();
            query.like((Object)"supplier_name", (Object)supplierName);
        }
        List list = this.service.list((Wrapper)query);
        QueryParam categoryQuery = new QueryParam();
        categoryQuery.setPageIndex(queryParam.getPageIndex());
        categoryQuery.setPageSize(queryParam.getPageSize());
        categoryQuery.getParams().put("propertyFlag", new Parameter("eq", (Object)1));
        categoryQuery.getParams().put("id", new Parameter("in", list.stream().map(BrandRelationEntity::getMaterialTypeId).collect(Collectors.toList())));
        categoryQuery.getOrderMap().put("code", "asc");
        ArrayList<BrandRelationQueryVO> records = new ArrayList<BrandRelationQueryVO>();
        IPage pageCategory = this.categoryService.queryPage(categoryQuery);
        List categoryList = pageCategory.getRecords();
        if (CollectionUtils.isEmpty((Collection)categoryList)) {
            Page result = new Page(pageCategory.getCurrent(), pageCategory.getSize(), pageCategory.getTotal());
            result.setRecords(records);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
        }
        List<Long> categoryIds = categoryList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<BrandRelationEntity> relations = this.service.getAllByCategoryIds(categoryIds, brandName, supplierName);
        if (CollectionUtils.isNotEmpty(relations)) {
            Map<Long, List<BrandRelationEntity>> mapByCategoryId = relations.stream().collect(Collectors.groupingBy(BrandRelationEntity::getMaterialTypeId));
            ArrayList<Long> brandIds = new ArrayList<Long>(relations.stream().map(BrandRelationEntity::getBrandId).collect(Collectors.toSet()));
            List<BrandVO> brandvos = this.brandService.getAllByIds(brandIds);
            Map<Long, BrandVO> brandVOMap = brandvos.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            BrandRelationQueryVO item2 = null;
            List<BrandRelationEntity> categoryNestList = null;
            List brandNestList = null;
            BrandVO brand = null;
            int suppilerIdx = 0;
            int categoryTotal = 0;
            int brandTotal = 0;
            int brandIdx = 1;
            Integer startLine = (queryParam.getPageIndex() - 1) * queryParam.getPageSize() + 1;
            for (MaterialCategoryEntity category : categoryList) {
                categoryNestList = mapByCategoryId.get(category.getId());
                if (CollectionUtils.isNotEmpty(categoryNestList)) {
                    Map brandRelationMap = categoryNestList.stream().collect(Collectors.groupingBy(BrandRelationEntity::getBrandId, LinkedHashMap::new, Collectors.toList()));
                    categoryTotal = categoryNestList.size();
                    brandIdx = 1;
                    for (Long brandId : brandRelationMap.keySet()) {
                        brandNestList = (List)brandRelationMap.get(brandId);
                        brand = brandVOMap.get(brandId);
                        suppilerIdx = 1;
                        brandTotal = brandNestList.size();
                        for (BrandRelationEntity r : brandNestList) {
                            item2 = new BrandRelationQueryVO();
                            item2.setId(r.getId());
                            item2.setMaterialTypeCode(category.getCode());
                            item2.setMaterialTypeName(category.getName());
                            item2.setBrandControlFlag(category.getBrandControlFlag());
                            item2.setCategoryTotal(Integer.valueOf(categoryTotal == categoryNestList.size() ? categoryTotal-- : 0));
                            item2.setCategorySeq(startLine.toString());
                            item2.setBrandSeq(item2.getCategorySeq() + "." + brandIdx);
                            item2.setBrandId(brandId);
                            item2.setBrandName(r.getBrandName());
                            item2.setBrandEnabled(null != brand ? String.valueOf(brand.getEnabled()) : "1");
                            item2.setBrandTotal(String.valueOf(brandTotal == brandNestList.size() ? brandTotal-- : 0));
                            item2.setSupplierCharacter(r.getSupplierCharacter());
                            item2.setSupplierId(r.getSupplierId());
                            item2.setSupplierName(r.getSupplierName());
                            item2.setSupplierSeq(item2.getBrandSeq() + "." + suppilerIdx);
                            item2.setRelationEnabled(item2.getRelationEnabled());
                            ++suppilerIdx;
                            ++brandIdx;
                            records.add(item2);
                        }
                    }
                } else {
                    item2 = new BrandRelationQueryVO();
                    item2.setId(category.getId());
                    item2.setMaterialTypeCode(category.getCode());
                    item2.setMaterialTypeName(category.getName());
                    item2.setBrandControlFlag(category.getBrandControlFlag());
                    item2.setCategorySeq(startLine.toString());
                    item2.setCategoryTotal(Integer.valueOf(1));
                    item2.setCategoryId(category.getId());
                    records.add(item2);
                }
                startLine = startLine + 1;
            }
        }
        Page result = new Page(pageCategory.getCurrent(), pageCategory.getSize(), pageCategory.getTotal());
        result.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<Long> categoryIds;
        List<BrandRelationEntity> relations;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List list = this.service.list((Wrapper)query);
        QueryParam categoryQuery = new QueryParam();
        categoryQuery.setPageIndex(1);
        categoryQuery.setPageSize(-1);
        categoryQuery.getParams().put("propertyFlag", new Parameter("eq", (Object)1));
        categoryQuery.getParams().put("id", new Parameter("in", list.stream().map(BrandRelationEntity::getMaterialTypeId).collect(Collectors.toList())));
        categoryQuery.getOrderMap().put("code", "asc");
        ArrayList<BrandRelationQueryVO> records = new ArrayList<BrandRelationQueryVO>();
        IPage pageCategory = this.categoryService.queryPage(categoryQuery);
        List categoryList = pageCategory.getRecords();
        if (!CollectionUtils.isEmpty((Collection)categoryList) && CollectionUtils.isNotEmpty(relations = this.service.getAllByCategoryIds(categoryIds = categoryList.stream().map(BaseEntity::getId).collect(Collectors.toList()), null, null))) {
            Map<Long, List<BrandRelationEntity>> mapByCategoryId = relations.stream().collect(Collectors.groupingBy(BrandRelationEntity::getMaterialTypeId));
            ArrayList<Long> brandIds = new ArrayList<Long>(relations.stream().map(BrandRelationEntity::getBrandId).collect(Collectors.toSet()));
            List<BrandVO> brandvos = this.brandService.getAllByIds(brandIds);
            Map<Long, BrandVO> brandVOMap = brandvos.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            BrandRelationQueryVO item2 = null;
            List<BrandRelationEntity> categoryNestList = null;
            List brandNestList = null;
            BrandVO brand = null;
            int suppilerIdx = 0;
            int categoryTotal = 0;
            int brandTotal = 0;
            int brandIdx = 1;
            Integer startLine = (queryParam.getPageIndex() - 1) * queryParam.getPageSize() + 1;
            for (MaterialCategoryEntity category : categoryList) {
                categoryNestList = mapByCategoryId.get(category.getId());
                if (CollectionUtils.isNotEmpty(categoryNestList)) {
                    Map brandRelationMap = categoryNestList.stream().collect(Collectors.groupingBy(BrandRelationEntity::getBrandId, LinkedHashMap::new, Collectors.toList()));
                    categoryTotal = categoryNestList.size();
                    brandIdx = 1;
                    for (Long brandId : brandRelationMap.keySet()) {
                        brandNestList = (List)brandRelationMap.get(brandId);
                        brand = brandVOMap.get(brandId);
                        suppilerIdx = 1;
                        brandTotal = brandNestList.size();
                        for (BrandRelationEntity r : brandNestList) {
                            item2 = new BrandRelationQueryVO();
                            item2.setId(r.getId());
                            item2.setMaterialTypeCode(category.getCode());
                            item2.setMaterialTypeName(category.getName());
                            item2.setBrandControlFlag(StringUtils.isNotBlank((CharSequence)category.getBrandControlFlag()) ? ("1".equals(category.getBrandControlFlag()) ? "\u662f" : "\u5426") : "\u662f");
                            item2.setCategoryTotal(Integer.valueOf(categoryTotal == categoryNestList.size() ? categoryTotal-- : 0));
                            item2.setCategorySeq(startLine.toString());
                            item2.setBrandSeq(item2.getCategorySeq() + "." + brandIdx);
                            item2.setBrandId(brandId);
                            item2.setBrandName(r.getBrandName());
                            item2.setBrandEnabled(null != brand ? ("1".equals(String.valueOf(brand.getEnabled())) ? "\u662f" : "\u5426") : "\u662f");
                            item2.setBrandTotal(String.valueOf(brandTotal == brandNestList.size() ? brandTotal-- : 0));
                            item2.setSupplierCharacter(StringUtils.isNotBlank((CharSequence)r.getSupplierCharacter()) ? ("0".equals(r.getSupplierCharacter()) ? "\u751f\u4ea7\u5546" : "\u4f9b\u5e94\u5546") : "");
                            item2.setSupplierId(r.getSupplierId());
                            item2.setSupplierName(r.getSupplierName());
                            item2.setSupplierSeq(item2.getBrandSeq() + "." + suppilerIdx);
                            item2.setRelationEnabled(StringUtils.isNotBlank((CharSequence)item2.getRelationEnabled()) ? ("1".equals(item2.getRelationEnabled()) ? "\u662f" : "\u5426") : "\u662f");
                            ++suppilerIdx;
                            ++brandIdx;
                            records.add(item2);
                        }
                    }
                } else {
                    item2 = new BrandRelationQueryVO();
                    item2.setId(category.getId());
                    item2.setMaterialTypeCode(category.getCode());
                    item2.setMaterialTypeName(category.getName());
                    item2.setBrandControlFlag(category.getBrandControlFlag());
                    item2.setCategorySeq(startLine.toString());
                    item2.setCategoryTotal(Integer.valueOf(1));
                    item2.setCategoryId(category.getId());
                    records.add(item2);
                }
                startLine = startLine + 1;
            }
        }
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", records);
        HashMap<String, MergeField> mergeFields = new HashMap<String, MergeField>();
        mergeFields.put("categorySeq", new MergeField(0, "categoryTotal"));
        mergeFields.put("materialTypeName", new MergeField(1, "categoryTotal"));
        mergeFields.put("brandControlFlag", new MergeField(2, "categoryTotal"));
        mergeFields.put("brandSeq", new MergeField(3, "brandTotal"));
        mergeFields.put("brandName", new MergeField(4, "brandTotal"));
        mergeFields.put("brandEnabled", new MergeField(5, "brandTotal"));
        this.export("BrandRelation-export.xlsx", beans, response, null, mergeFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String exitsName, Map<String, Object> data, HttpServletResponse response, String excelExportTitle, Map<String, MergeField> mergeFields) {
        XLSTransformer transformer = new XLSTransformer();
        ServletOutputStream outputStream = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            data.put("dateFormat", dateFormat);
            data.put("timeFormat", timeFormat);
            ClassPathResource resource = new ClassPathResource("excel/" + exitsName);
            outputStream = response.getOutputStream();
            File f = File.createTempFile("tmpExcel", "xlsx");
            Workbook workbook = transformer.transformXLS(resource.getInputStream(), data);
            if (StringUtils.isNotBlank((CharSequence)excelExportTitle)) {
                workbook.getSheetAt(0).getRow(0).getCell(0).setCellValue(excelExportTitle);
            }
            if (MapUtils.isNotEmpty(mergeFields)) {
                Sheet sheet = workbook.getSheetAt(0);
                JSONArray dateArr = JSONArray.parseArray((String)JSONObject.toJSONString((Object)data.get("records")));
                Map rowData = null;
                int rowNum = 2;
                CellRangeAddress cellRangeAddress = null;
                MergeField mergeField = null;
                for (Object obj : dateArr) {
                    rowData = (Map)JSONObject.parseObject((String)JSONObject.toJSONString(obj), Map.class);
                    if (Integer.valueOf(rowData.get("brandTotal").toString()) > 0 || Integer.valueOf(rowData.get("categoryTotal").toString()) > 0) {
                        for (String field : rowData.keySet()) {
                            if (!mergeFields.containsKey(field) || Integer.valueOf(rowData.get((mergeField = mergeFields.get(field)).getMergeNumField()).toString()) <= 0) continue;
                            this.logger.info("{}", rowData.get(mergeField.getMergeNumField()));
                            this.logger.info("{}:{},{},{},{}", new Object[]{field, rowNum, rowNum + Integer.valueOf(rowData.get(mergeField.getMergeNumField()).toString()) - 1, mergeField.getFieldIndex(), mergeField.getFieldIndex()});
                            cellRangeAddress = new CellRangeAddress(rowNum, rowNum + Integer.valueOf(rowData.get(mergeField.getMergeNumField()).toString()) - 1, mergeField.getFieldIndex().intValue(), mergeField.getFieldIndex().intValue());
                            sheet.addMergedRegion(cellRangeAddress);
                        }
                    }
                    ++rowNum;
                }
            }
            workbook.write((OutputStream)outputStream);
        }
        catch (Exception var19) {
            var19.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException var18) {
                    var18.printStackTrace();
                }
            }
        }
    }

    class MergeField {
        private Integer fieldIndex;
        private String mergeNumField;

        public MergeField(Integer fieldIndex, String mergeNumField) {
            this.fieldIndex = fieldIndex;
            this.mergeNumField = mergeNumField;
        }

        public Integer getFieldIndex() {
            return this.fieldIndex;
        }

        public void setFieldIndex(Integer fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        public String getMergeNumField() {
            return this.mergeNumField;
        }

        public void setMergeNumField(String mergeNumField) {
            this.mergeNumField = mergeNumField;
        }
    }
}

